/*
 * Decompiled with CFR 0.152.
 */
package com.arcazoid.util.hirestimer;

import com.arcazoid.util.hirestimer.AdvancedTimer;

public class DurationTimer {
    private AdvancedTimer timer = new AdvancedTimer();
    private long duration;
    private boolean paused = false;
    private long adjust;
    private long pausetime;

    public DurationTimer(long duration) {
        this.duration = duration;
    }

    public static long getTicksPerSecond() {
        return AdvancedTimer.getTicksPerSecond();
    }

    public void start() {
        this.timer.start();
    }

    public void reset() {
        this.reset(this.duration);
    }

    public void reset(long duration) {
        this.stop();
        this.duration = duration;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.pausetime = this.timer.getClockTicks();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        this.adjust += this.timer.getClockTicks() - this.pausetime;
        this.paused = false;
    }

    public void stop() {
        this.timer.stop();
    }

    public long getTicksRemaining() {
        if (this.paused) {
            return this.duration - this.pausetime;
        }
        return Math.max(0L, this.duration + this.adjust - this.timer.getClockTicks());
    }

    public long getSecondsRemaining() {
        return this.getTicksRemaining() / DurationTimer.getTicksPerSecond();
    }

    public int getPercentRemaining() {
        return (int)(this.getTicksRemaining() * 100L / this.duration);
    }

    public long getTicksElapsed() {
        if (this.paused) {
            return this.pausetime;
        }
        return Math.min(this.duration, this.timer.getClockTicks() - this.adjust);
    }

    public long getSecondsElapsed() {
        return this.getTicksElapsed() / DurationTimer.getTicksPerSecond();
    }

    public int getPercentElapsed() {
        return (int)(this.getTicksElapsed() * 100L / this.duration);
    }

    public long getDuration() {
        return this.duration;
    }

    public long scaleToRemainingTime(int value) {
        return this.getTicksRemaining() * (long)value / this.getDuration();
    }

    public long scaleToElapsedTime(int value) {
        return this.getTicksElapsed() * (long)value / this.getDuration();
    }
}

