/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.IFace3D;
import net.dzzd.access.IFace3DList;
import net.dzzd.access.IHeightMap;
import net.dzzd.access.IHeightMap3D;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IVertex3D;
import net.dzzd.core.Face3D;
import net.dzzd.core.Face3DList;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Point3D;
import net.dzzd.core.Vertex3D;

public class HeightMap3D
implements IHeightMap3D {
    private IHeightMap hMap;
    private FaceNode leftRootNode;
    private FaceNode rightRootNode;
    private double[] lVariance;
    private double[] rVariance;
    private int minVarianceDepth;
    private int maxVarianceDepth;
    private double generateVariance;
    private double tesselateVariance;
    private int nbGenerateFace;
    private int nbTesselateFace;
    private double generateClipNear;
    private double generateClipFar;
    private int idGenerate;
    private double xMin = 0.0;
    private double xMax = 1.0;
    private double yMin = 0.0;
    private double yMax = 1.0;
    private double size3DX = 1.0;
    private double size3DY = 1.0;
    private double size3DZ = 1.0;
    private double min3DX;
    private double min3DY;
    private double min3DZ;
    private int nbTesselateVertices;
    private VertexNode firstTesselateVertexNode;
    private Vertex3D[] tesselateVertexArray;
    private Face3D[] tesselateFaceArray;
    private Face3DList tesselatedFaceList;
    private Face3DList generatedFaceList;
    private Face3DList generatedCollisionFaceList;
    private int nbGenerateCollisionFace;

    public IVertex3D[] getVertex3D() {
        return this.tesselateVertexArray;
    }

    public HeightMap3D(int n, int n2) {
        this.init(n, n2);
        this.generateVariance = 0.0;
        this.tesselateVariance = 0.0;
    }

    public IFace3D[] getFace3D() {
        return this.tesselateFaceArray;
    }

    public IFace3DList getViewFace3DList() {
        return this.generatedFaceList;
    }

    public IFace3DList getCollisionFace3DList() {
        return this.generatedCollisionFaceList;
    }

    public void setMesh3DBounds(double d, double d2, double d3, double d4, double d5, double d6) {
        this.min3DX = d;
        this.min3DY = d2;
        this.min3DZ = d3;
        this.size3DX = d4 - d;
        this.size3DY = d5 - d2;
        this.size3DZ = d6 - d3;
    }

    public void setHeightMapBounds(double d, double d2, double d3, double d4) {
        this.xMin = d;
        this.yMin = d2;
        this.xMax = d3;
        this.yMax = d4;
    }

    public void setMesh3DViewGeneratorQuality(double d) {
        this.generateVariance = d;
    }

    public double getMesh3DViewGeneratorQuality() {
        return this.generateVariance;
    }

    public void setMesh3DGeneratorQuality(double d) {
        this.tesselateVariance = d;
    }

    public double getMesh3DGeneratorQuality() {
        return this.tesselateVariance;
    }

    public int getNbViewFaces() {
        return this.nbGenerateFace;
    }

    public int getNbCollisionFaces() {
        return this.nbGenerateCollisionFace;
    }

    public int getNbFace3D() {
        return this.nbTesselateFace;
    }

    public int getNbVertex3D() {
        return this.nbTesselateVertices;
    }

    public void setHeightMap(IHeightMap iHeightMap) {
        this.hMap = iHeightMap;
        if (this.hMap != null) {
            this.updateHeightMap();
        }
    }

    public void updateHeightMap() {
        this.computeHeightMapVariance();
    }

    public IMesh3D generate() {
        this.nbTesselateVertices = 0;
        this.firstTesselateVertexNode = null;
        this.nbTesselateFace = 0;
        this.tesselatedFaceList = null;
        this.resetTesselate();
        this.rTessellate(this.leftRootNode, this.xMin, this.yMax, this.xMax, this.yMin, this.xMin, this.yMin, 1, this.lVariance);
        this.rTessellate(this.rightRootNode, this.xMax, this.yMin, this.xMin, this.yMax, this.xMax, this.yMax, 1, this.rVariance);
        this.tesselatePostProcess();
        this.createTesselateVertex3DArray();
        this.createTesselateFace3DArray();
        Mesh3D mesh3D = new Mesh3D(this.getVertex3D(), this.getFace3D());
        mesh3D.setMesh3DViewGenerator(this);
        mesh3D.setMesh3DCollisionGenerator(this);
        return mesh3D;
    }

    public void generateForSolidSphere3DCollision(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.generatedCollisionFaceList = null;
        this.nbGenerateCollisionFace = 0;
        double d8 = d4 - d;
        double d9 = d5 - d2;
        double d10 = d6 - d3;
        double d11 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        this.rGenerateCollision(this.leftRootNode, d, d2, d3, d4, d5, d6, d7, d11);
        this.rGenerateCollision(this.rightRootNode, d, d2, d3, d4, d5, d6, d7, d11);
    }

    public void generateForView(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.generatedFaceList = null;
        this.nbGenerateFace = 0;
        ++this.idGenerate;
        double d9 = d4;
        double d10 = d5;
        double d11 = d6;
        double d12 = this.norme(d9 -= d, d10 -= d2, d11 -= d3);
        double d13 = -((d9 /= d12) * d + (d10 /= d12) * d2 + (d11 /= d12) * d3);
        double d14 = d10;
        double d15 = -d9;
        double d16 = 0.0;
        if (d4 == d && d5 == d2) {
            d14 = 1.0;
            d15 = 0.0;
        }
        double d17 = this.norme(d14, d15, d16);
        double d18 = -((d14 /= d17) * d + (d15 /= d17) * d2 + (d16 /= d17) * d3);
        double d19 = d15 * d11 - d16 * d10;
        double d20 = d16 * d9 - d14 * d11;
        double d21 = d14 * d10 - d15 * d9;
        double d22 = this.norme(d19, d20, d21);
        double d23 = -((d19 /= d22) * d + (d20 /= d22) * d2 + (d21 /= d22) * d3);
        double d24 = 0.4142 * d9 + d14;
        double d25 = 0.4142 * d10 + d15;
        double d26 = 0.4142 * d11 + d16;
        double d27 = this.norme(d24, d25, d26);
        double d28 = -((d24 /= d27) * d + (d25 /= d27) * d2 + (d26 /= d27) * d3);
        double d29 = 0.4142 * d9 - d14;
        double d30 = 0.4142 * d10 - d15;
        double d31 = 0.4142 * d11 - d16;
        double d32 = this.norme(d29, d30, d31);
        double d33 = -((d29 /= d32) * d + (d30 /= d32) * d2 + (d31 /= d32) * d3);
        double d34 = 0.4142 * d9 + d19;
        double d35 = 0.4142 * d10 + d20;
        double d36 = 0.4142 * d11 + d21;
        double d37 = this.norme(d34, d35, d36);
        double d38 = -((d34 /= d37) * d + (d35 /= d37) * d2 + (d36 /= d37) * d3);
        double d39 = 0.4142 * d9 - d19;
        double d40 = 0.4142 * d10 - d20;
        double d41 = 0.4142 * d11 - d21;
        double d42 = this.norme(d39, d40, d41);
        double d43 = -((d39 /= d42) * d + (d40 /= d42) * d2 + (d41 /= d42) * d3);
        this.rGenerate(this.leftRootNode, d, d2, d3, d9, d10, d11, d13, d24, d25, d26, d28, d29, d30, d31, d33, d34, d35, d36, d38, d39, d40, d41, d43, d7, d8);
        this.rGenerate(this.rightRootNode, d, d2, d3, d9, d10, d11, d13, d24, d25, d26, d28, d29, d30, d31, d33, d34, d35, d36, d38, d39, d40, d41, d43, d7, d8);
        this.generatePostProcess();
    }

    public void setFarClip(double d) {
        this.generateClipFar = d;
    }

    public void setNearClip(double d) {
        this.generateClipNear = d;
    }

    private void removeHeightMap() {
        this.lVariance = null;
        this.rVariance = null;
        this.hMap = null;
    }

    private void createTesselateVertex3DArray() {
        Vertex3D[] vertex3DArray = new Vertex3D[this.nbTesselateVertices];
        int n = this.nbTesselateVertices;
        VertexNode vertexNode = this.firstTesselateVertexNode;
        while (vertexNode != null) {
            Vertex3D vertex3D = new Vertex3D(vertexNode.x, vertexNode.y, vertexNode.z);
            vertex3DArray[--n] = vertex3D;
            vertexNode = vertexNode.nextTesselateVertexNode;
        }
        this.tesselateVertexArray = vertex3DArray;
    }

    private void rCreateTesselateFace3DArray(FaceNode faceNode) {
        if (faceNode == null) {
            return;
        }
        Face3D face3D = faceNode.tesselatedFaceList.face;
        face3D.p0 = this.tesselateVertexArray[faceNode.p0];
        face3D.p1 = this.tesselateVertexArray[faceNode.p1];
        face3D.p2 = this.tesselateVertexArray[faceNode.p2];
        face3D.setNormal();
        this.rCreateTesselateFace3DArray(faceNode.leftChild);
        this.rCreateTesselateFace3DArray(faceNode.rightChild);
    }

    private void createTesselateFace3DArray() {
        Vertex3D vertex3D;
        Vertex3D vertex3D2;
        Vertex3D vertex3D3;
        int n;
        Serializable serializable;
        this.rCreateTesselateFace3DArray(this.leftRootNode);
        this.rCreateTesselateFace3DArray(this.rightRootNode);
        this.tesselateFaceArray = new Face3D[this.nbTesselateFace];
        int n2 = 0;
        Face3DList face3DList = this.tesselatedFaceList;
        while (face3DList != null) {
            serializable = face3DList.face;
            this.tesselateFaceArray[n2++] = serializable;
            face3DList = face3DList.nextFaceList;
        }
        for (n = 0; n < this.tesselateFaceArray.length; ++n) {
            serializable = this.tesselateFaceArray[n];
            vertex3D3 = serializable.p0;
            vertex3D2 = serializable.p1;
            vertex3D = serializable.p2;
            serializable.u0 = (float)vertex3D3.x;
            serializable.u1 = (float)vertex3D2.x;
            serializable.u2 = (float)vertex3D.x;
            serializable.v0 = (float)vertex3D3.y;
            serializable.v1 = (float)vertex3D2.y;
            serializable.v2 = (float)vertex3D.y;
        }
        for (n = 0; n < this.tesselateVertexArray.length; ++n) {
            serializable = this.tesselateVertexArray[n];
            ((Point3D)serializable).x -= this.xMin;
            ((Point3D)serializable).x /= this.xMax - this.xMin;
            ((Point3D)serializable).x *= this.size3DX;
            ((Point3D)serializable).x += this.min3DX;
            ((Point3D)serializable).y -= this.yMin;
            ((Point3D)serializable).y /= this.yMax - this.yMin;
            ((Point3D)serializable).y *= this.size3DY;
            ((Point3D)serializable).y += this.min3DY;
            ((Point3D)serializable).z *= this.size3DZ;
            ((Point3D)serializable).z += this.min3DZ;
        }
        for (n = 0; n < this.tesselateFaceArray.length; ++n) {
            serializable = this.tesselateFaceArray[n];
            vertex3D3 = serializable.p0;
            vertex3D2 = serializable.p1;
            vertex3D = serializable.p2;
            serializable.sphereBox = (float)this.norme(vertex3D3.x - vertex3D.x, vertex3D3.y - vertex3D.y, vertex3D3.z - vertex3D.z);
            float f = (float)this.norme(vertex3D2.x - vertex3D.x, vertex3D2.y - vertex3D.y, vertex3D2.z - vertex3D.z);
            if (!(f > serializable.sphereBox)) continue;
            serializable.sphereBox = f;
        }
    }

    private int newVertexNode(double d, double d2, double d3) {
        VertexNode vertexNode = new VertexNode();
        vertexNode.x = d;
        vertexNode.y = d2;
        vertexNode.z = d3;
        this.pushTesselateVertexNode(vertexNode);
        return this.nbTesselateVertices++;
    }

    private double norme(double d, double d2, double d3) {
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    private void computeHeightMapVariance() {
        this.rComputeVariance(this.xMin, this.yMax, this.hMap.getAt(0.0, this.yMax), this.xMax, this.yMin, this.hMap.getAt(this.xMax, 0.0), this.xMin, this.yMin, this.hMap.getAt(0.0, 0.0), 1, this.lVariance, 1.0);
        this.rComputeVariance(this.xMax, this.yMin, this.hMap.getAt(this.xMax, 0.0), this.xMin, this.yMax, this.hMap.getAt(0.0, this.yMax), this.xMax, this.yMax, this.hMap.getAt(this.xMax, this.yMax), 1, this.rVariance, 1.0);
    }

    private void init(int n, int n2) {
        this.hMap = null;
        this.leftRootNode = new FaceNode();
        this.rightRootNode = new FaceNode();
        this.idGenerate = 0;
        this.nbGenerateFace = 0;
        this.nbTesselateFace = 0;
        this.nbTesselateVertices = 0;
        this.tesselateVertexArray = null;
        this.tesselateFaceArray = null;
        this.tesselatedFaceList = null;
        this.generatedFaceList = null;
        this.firstTesselateVertexNode = null;
        this.maxVarianceDepth = n2;
        this.minVarianceDepth = n;
        this.lVariance = new double[1 << this.maxVarianceDepth];
        this.rVariance = new double[1 << this.maxVarianceDepth];
        this.generateClipNear = Double.MIN_VALUE;
        this.generateClipFar = Double.MAX_VALUE;
    }

    private void resetTesselate() {
        this.leftRootNode.left = null;
        this.leftRootNode.right = null;
        this.leftRootNode.base = null;
        this.leftRootNode.leftChild = null;
        this.leftRootNode.rightChild = null;
        this.rightRootNode.left = null;
        this.rightRootNode.right = null;
        this.rightRootNode.base = null;
        this.rightRootNode.leftChild = null;
        this.rightRootNode.rightChild = null;
        this.rightRootNode.base = null;
        this.leftRootNode.base = null;
        this.rightRootNode.base = this.leftRootNode;
        this.leftRootNode.base = this.rightRootNode;
    }

    private FaceNode newFaceNode() {
        FaceNode faceNode = new FaceNode();
        faceNode.left = null;
        faceNode.right = null;
        faceNode.base = null;
        faceNode.leftChild = null;
        faceNode.rightChild = null;
        faceNode.idGenerate = -1;
        faceNode.idGenerateSplit = -1;
        faceNode.parent = null;
        return faceNode;
    }

    private void pushGenerateFace(FaceNode faceNode) {
        ++this.nbGenerateFace;
        faceNode.tesselatedFaceList.nextFaceList = this.generatedFaceList;
        this.generatedFaceList = faceNode.tesselatedFaceList;
    }

    private void pushGenerateCollisionFace(FaceNode faceNode) {
        ++this.nbGenerateCollisionFace;
        faceNode.tesselatedFaceList.nextFaceList = this.generatedCollisionFaceList;
        this.generatedCollisionFaceList = faceNode.tesselatedFaceList;
    }

    private void pushTesselateFace(FaceNode faceNode) {
        ++this.nbTesselateFace;
        faceNode.tesselatedFaceList.nextFaceList = this.tesselatedFaceList;
        this.tesselatedFaceList = faceNode.tesselatedFaceList;
    }

    private void pushTesselateVertexNode(VertexNode vertexNode) {
        vertexNode.nextTesselateVertexNode = this.firstTesselateVertexNode;
        this.firstTesselateVertexNode = vertexNode;
    }

    private void split(FaceNode faceNode) {
        if (faceNode.leftChild != null) {
            return;
        }
        faceNode.leftChild = this.newFaceNode();
        faceNode.rightChild = this.newFaceNode();
        if (faceNode.rightChild == null) {
            faceNode.leftChild = null;
            return;
        }
        faceNode.leftChild.parent = faceNode;
        faceNode.rightChild.parent = faceNode;
        if (faceNode.base != null && faceNode.base.base != faceNode) {
            this.split(faceNode.base);
        }
        faceNode.leftChild.base = faceNode.left;
        faceNode.leftChild.left = faceNode.rightChild;
        faceNode.rightChild.base = faceNode.right;
        faceNode.rightChild.right = faceNode.leftChild;
        if (faceNode.left != null) {
            if (faceNode.left.base == faceNode) {
                faceNode.left.base = faceNode.leftChild;
            } else if (faceNode.left.left == faceNode) {
                faceNode.left.left = faceNode.leftChild;
            } else if (faceNode.left.right == faceNode) {
                faceNode.left.right = faceNode.leftChild;
            }
        }
        if (faceNode.right != null) {
            if (faceNode.right.base == faceNode) {
                faceNode.right.base = faceNode.rightChild;
            } else if (faceNode.right.right == faceNode) {
                faceNode.right.right = faceNode.rightChild;
            } else if (faceNode.right.left == faceNode) {
                faceNode.right.left = faceNode.rightChild;
            }
        }
        if (faceNode.base != null) {
            if (faceNode.base.leftChild != null) {
                faceNode.base.leftChild.right = faceNode.rightChild;
                faceNode.base.rightChild.left = faceNode.leftChild;
                faceNode.leftChild.right = faceNode.base.rightChild;
                faceNode.rightChild.left = faceNode.base.leftChild;
            } else {
                this.split(faceNode.base);
            }
        } else {
            faceNode.leftChild.right = null;
            faceNode.rightChild.left = null;
        }
    }

    private double rComputeVariance(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, double[] dArray, double d10) {
        if (n >= 1 << this.maxVarianceDepth) {
            return 0.0;
        }
        double d11 = (d + d4) * 0.5;
        double d12 = (d2 + d5) * 0.5;
        double d13 = this.hMap.getAt(d11, d12);
        double d14 = (d3 + d6) * 0.5;
        double d15 = Math.abs(d13 - d14) * d10;
        d15 = Math.max(d15, this.rComputeVariance(d7, d8, d9, d, d2, d3, d11, d12, d13, n << 1, dArray, d10 * 0.5));
        dArray[n] = d15 = Math.max(d15, this.rComputeVariance(d4, d5, d6, d7, d8, d9, d11, d12, d13, 1 + (n << 1), dArray, d10 * 0.5));
        return d15;
    }

    private void generatePostProcess() {
        this.generatedFaceList = null;
        this.nbGenerateFace = 0;
        this.rGeneratePostProcess(this.leftRootNode);
        this.rGeneratePostProcess(this.rightRootNode);
    }

    private void rGeneratePostProcess(FaceNode faceNode) {
        if (faceNode == null) {
            return;
        }
        if (faceNode.idGenerateSplit == this.idGenerate) {
            this.rGeneratePostProcess(faceNode.leftChild);
            this.rGeneratePostProcess(faceNode.rightChild);
            return;
        }
        this.pushGenerateFace(faceNode);
    }

    private void rGenerateCollision(FaceNode faceNode, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Face3D face3D = faceNode.tesselatedFaceList.face;
        Vertex3D vertex3D = face3D.p0;
        Vertex3D vertex3D2 = face3D.p1;
        Vertex3D vertex3D3 = face3D.p2;
        double d9 = vertex3D.x;
        double d10 = vertex3D.y;
        double d11 = vertex3D.z;
        double d12 = vertex3D2.x;
        double d13 = vertex3D2.y;
        double d14 = vertex3D2.z;
        double d15 = vertex3D3.x;
        double d16 = d15;
        double d17 = d16 - d;
        double d18 = vertex3D3.y;
        double d19 = d18;
        double d20 = d19 - d2;
        double d21 = vertex3D3.z;
        double d22 = d21;
        double d23 = d22 - d3;
        double d24 = face3D.sphereBox;
        double d25 = d7 + d8 + d24;
        if (d17 * d17 + d20 * d20 + d23 * d23 > d25 * d25) {
            return;
        }
        if (faceNode.leftChild != null) {
            this.rGenerateCollision(faceNode.leftChild, d, d2, d3, d4, d5, d6, d7, d8);
            this.rGenerateCollision(faceNode.rightChild, d, d2, d3, d4, d5, d6, d7, d8);
        } else {
            this.pushGenerateCollisionFace(faceNode);
        }
    }

    private void rGenerate(FaceNode faceNode, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20, double d21, double d22, double d23, double d24, double d25) {
        Face3D face3D = faceNode.tesselatedFaceList.face;
        Vertex3D vertex3D = face3D.p0;
        Vertex3D vertex3D2 = face3D.p1;
        Vertex3D vertex3D3 = face3D.p2;
        double d26 = vertex3D.x;
        double d27 = vertex3D.y;
        double d28 = vertex3D.z;
        double d29 = vertex3D2.x;
        double d30 = vertex3D2.y;
        double d31 = vertex3D2.z;
        double d32 = vertex3D3.x;
        double d33 = d32;
        double d34 = vertex3D3.y;
        double d35 = d34;
        double d36 = vertex3D3.z;
        double d37 = d36;
        double d38 = d4 * d33 + d5 * d35 + d6 * d37 + d7;
        double d39 = face3D.sphereBox;
        if (d38 < this.generateClipNear - d39) {
            return;
        }
        if (d38 > this.generateClipFar + d39) {
            return;
        }
        double d40 = d8 * d33 + d9 * d35 + d10 * d37 + d11;
        if (d40 < -d39) {
            return;
        }
        double d41 = d12 * d33 + d13 * d35 + d14 * d37 + d15;
        if (d41 < -d39) {
            return;
        }
        double d42 = d16 * d33 + d17 * d35 + d18 * d37 + d19;
        if (d42 < -d39) {
            return;
        }
        double d43 = d20 * d33 + d21 * d35 + d22 * d37 + d23;
        if (d43 < -d39) {
            return;
        }
        double d44 = (double)face3D.pa * d4 + (double)face3D.pb * d5 + (double)face3D.pc * d6;
        d44 = d44 >= 0.0 ? d44 : -d44;
        d44 = 1.0 - d44;
        double d45 = d38;
        if (d45 < d39 && d45 > -d39) {
            d45 = 0.0;
        }
        double d46 = 0.0;
        d46 = d45 == 0.0 ? Double.MAX_VALUE : this.size3DZ * d44 * faceNode.variance / d45;
        if (faceNode.leftChild != null && d46 > this.generateVariance) {
            this.rGenerate(faceNode.leftChild, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19, d20, d21, d22, d23, d24, d25);
            this.rGenerate(faceNode.rightChild, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19, d20, d21, d22, d23, d24, d25);
        } else {
            this.updateIdGenerateSplit(faceNode.parent);
        }
    }

    private void updateIdGenerateSplit(FaceNode faceNode) {
        if (faceNode == null) {
            return;
        }
        if (faceNode.idGenerateSplit == this.idGenerate) {
            return;
        }
        FaceNode faceNode2 = faceNode;
        if (faceNode2.leftChild == null) {
            faceNode2 = faceNode2.parent;
        }
        while (faceNode2 != null && faceNode2.idGenerateSplit != this.idGenerate) {
            faceNode2.idGenerateSplit = this.idGenerate;
            if (faceNode2.base != null) {
                this.updateIdGenerateSplit(faceNode2.base);
            }
            faceNode2 = faceNode2.parent;
        }
    }

    private void tesselatePostProcess() {
        this.nbTesselateVertices = 0;
        this.firstTesselateVertexNode = null;
        this.nbTesselateFace = 0;
        this.tesselatedFaceList = null;
        this.rTesselatePostProcess(this.leftRootNode, this.xMin, this.yMax, this.xMax, this.yMin, this.xMin, this.yMin, 1, -1, -1, -1, this.lVariance);
        this.rTesselatePostProcess(this.rightRootNode, this.xMax, this.yMin, this.xMin, this.yMax, this.xMax, this.yMax, 1, -1, -1, -1, this.rVariance);
    }

    private void rTesselatePostProcess(FaceNode faceNode, double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, int n3, int n4, double[] dArray) {
        double d7 = 0.0;
        if (n < 1 << this.maxVarianceDepth) {
            d7 = dArray[n];
        }
        double d8 = this.hMap.getAt(d, d2);
        double d9 = this.hMap.getAt(d3, d4);
        double d10 = this.hMap.getAt(d5, d6);
        double d11 = (d + d3) * 0.5;
        double d12 = (d2 + d4) * 0.5;
        double d13 = (d8 + d9) * 0.5;
        Face3D face3D = new Face3D();
        if (n2 == -1) {
            n2 = this.newVertexNode(d, d2, d8);
        }
        if (n3 == -1) {
            n3 = this.newVertexNode(d3, d4, d9);
        }
        if (n4 == -1) {
            n4 = this.newVertexNode(d5, d6, d10);
        }
        faceNode.p0 = n2;
        faceNode.p1 = n3;
        faceNode.p2 = n4;
        faceNode.variance = d7;
        faceNode.tesselatedFaceList = new Face3DList();
        faceNode.tesselatedFaceList.face = face3D;
        this.pushTesselateFace(faceNode);
        if (faceNode.leftChild != null) {
            int n5 = this.newVertexNode(d11, d12, this.hMap.getAt(d11, d12));
            this.rTesselatePostProcess(faceNode.leftChild, d5, d6, d, d2, d11, d12, n << 1, n4, n2, n5, dArray);
            this.rTesselatePostProcess(faceNode.rightChild, d3, d4, d5, d6, d11, d12, 1 + (n << 1), n3, n4, n5, dArray);
        }
    }

    private void rTessellate(FaceNode faceNode, double d, double d2, double d3, double d4, double d5, double d6, int n, double[] dArray) {
        if (n >= 1 << this.maxVarianceDepth) {
            return;
        }
        double d7 = dArray[n];
        if (n <= 1 << this.minVarianceDepth || d7 > this.tesselateVariance && d7 > 0.0) {
            if (faceNode.leftChild == null) {
                this.split(faceNode);
            }
            if (faceNode.leftChild != null) {
                double d8 = (d + d3) * 0.5;
                double d9 = (d2 + d4) * 0.5;
                this.rTessellate(faceNode.leftChild, d5, d6, d, d2, d8, d9, n << 1, dArray);
                this.rTessellate(faceNode.rightChild, d3, d4, d5, d6, d8, d9, 1 + (n << 1), dArray);
            }
        }
    }

    private class FaceNode {
        FaceNode leftChild;
        FaceNode rightChild;
        FaceNode base;
        FaceNode left;
        FaceNode right;
        FaceNode parent;
        Face3DList tesselatedFaceList;
        int idGenerate;
        int idGenerateSplit;
        double variance;
        int p0;
        int p1;
        int p2;

        private FaceNode() {
        }
    }

    private class VertexNode {
        private VertexNode nextTesselateVertexNode;
        private double x;
        private double y;
        private double z;

        private VertexNode() {
        }
    }
}

