/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.ITimer;
import net.dzzd.access.ITrack3D;
import net.dzzd.core.Point3D;
import net.dzzd.core.Timer;

public class Track3D
extends Point3D
implements ITrack3D,
Serializable {
    private int defaultInterpolation = 3;
    private int nbKey = 0;
    private long startTime = -1L;
    private long loopTime = -1L;
    private long pauseTime = -1L;
    private ITimer timer = new Timer();
    private Track3DKey firstKey = null;

    public int getNbKey() {
        return this.nbKey;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public void setDefaultInterpolation(int n) {
        this.defaultInterpolation = n;
    }

    public void setTimer(ITimer iTimer) {
        this.timer = iTimer;
    }

    public void setLoop(long l) {
        this.loopTime = l;
    }

    public void pause() {
        if (this.pauseTime != -1L) {
            return;
        }
        this.pauseTime = this.timer.getTime() - this.startTime;
        this.playAt(this.pauseTime);
    }

    public void resume() {
        if (this.pauseTime == -1L) {
            return;
        }
        this.startTime = this.timer.getTime() - this.pauseTime;
        this.pauseTime = 0L;
    }

    public int addKey(double d, double d2, double d3, long l) {
        return this.addKey(d, d2, d3, l, this.defaultInterpolation);
    }

    public int addKey(double d, double d2, double d3, long l, int n) {
        Track3DStaticKey track3DStaticKey = new Track3DStaticKey();
        track3DStaticKey.time = l;
        track3DStaticKey.x = d;
        track3DStaticKey.y = d2;
        track3DStaticKey.z = d3;
        track3DStaticKey.interpolation = n;
        return this.addKey(track3DStaticKey);
    }

    public int addKey(IPoint3D iPoint3D, long l) {
        return this.addKey(iPoint3D, l, this.defaultInterpolation);
    }

    public int addKey(IPoint3D iPoint3D, long l, int n) {
        Track3DLinkedKey track3DLinkedKey = new Track3DLinkedKey();
        track3DLinkedKey.setSource(iPoint3D);
        track3DLinkedKey.time = l;
        track3DLinkedKey.interpolation = n;
        return this.addKey(track3DLinkedKey);
    }

    public void removeKey(int n) {
        if (n >= this.nbKey) {
            return;
        }
        if (this.firstKey == null) {
            return;
        }
        Track3DKey track3DKey = null;
        Track3DKey track3DKey2 = this.firstKey;
        for (int i = 0; track3DKey2 != null && i != n; ++i) {
            track3DKey = track3DKey2;
            track3DKey2 = track3DKey2.nextKey;
        }
        if (track3DKey == null) {
            this.firstKey = this.firstKey.nextKey;
        } else {
            track3DKey.nextKey = track3DKey2.nextKey;
        }
        --this.nbKey;
    }

    public void start() {
        this.pauseTime = -1L;
        this.startTime = this.timer.getTime();
    }

    public void start(long l) {
        this.pauseTime = -1L;
        this.startTime = this.timer.getTime() + l;
    }

    public void play() {
        if (this.startTime == -1L) {
            return;
        }
        long l = this.timer.getTime() - this.startTime;
        if (this.pauseTime != -1L) {
            l = this.pauseTime;
        }
        this.playAt(l);
    }

    public void stop() {
        this.startTime = -1L;
        this.pauseTime = -1L;
    }

    public void playAt(long l) {
        if (this.loopTime != -1L) {
            l %= this.loopTime;
        }
        if (this.firstKey == null) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            return;
        }
        Point3D point3D = null;
        Point3D point3D2 = null;
        Track3DKey track3DKey = this.firstKey;
        while (track3DKey != null && track3DKey.time <= l) {
            point3D = point3D2;
            point3D2 = track3DKey;
            track3DKey = track3DKey.nextKey;
        }
        if (point3D2 == null) {
            this.x = track3DKey.getX();
            this.y = track3DKey.getY();
            this.z = track3DKey.getZ();
            return;
        }
        if (track3DKey == null) {
            this.x = point3D2.getX();
            this.y = point3D2.getY();
            this.z = point3D2.getZ();
            return;
        }
        double d = track3DKey.time - ((Track3DKey)point3D2).time;
        double d2 = l - ((Track3DKey)point3D2).time;
        double d3 = d2 / d;
        switch (track3DKey.interpolation) {
            case 0: {
                this.x = track3DKey.getX();
                this.y = track3DKey.getY();
                this.z = track3DKey.getZ();
                break;
            }
            case 1: {
                this.x = point3D2.getX() * (1.0 - d3) + track3DKey.getX() * d3;
                this.y = point3D2.getY() * (1.0 - d3) + track3DKey.getY() * d3;
                this.z = point3D2.getZ() * (1.0 - d3) + track3DKey.getZ() * d3;
                break;
            }
            case 2: {
                double d4 = d3 * Math.PI;
                double d5 = (1.0 - Math.cos(d4)) * 0.5;
                this.x = point3D2.getX() * (1.0 - d5) + track3DKey.getX() * d5;
                this.y = point3D2.getY() * (1.0 - d5) + track3DKey.getY() * d5;
                this.z = point3D2.getZ() * (1.0 - d5) + track3DKey.getZ() * d5;
                break;
            }
            case 3: {
                double d6 = d3;
                double d7 = d6 * d6;
                double d8 = d7 * d6;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                double d13 = 0.0;
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 0.0;
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = 0.0;
                double d20 = 0.0;
                d9 = d10 = point3D2.getX();
                d13 = d14 = point3D2.getY();
                d17 = d18 = point3D2.getZ();
                d12 = d11 = track3DKey.getX();
                d16 = d15 = track3DKey.getY();
                d20 = d19 = track3DKey.getZ();
                if (point3D != null) {
                    d9 = point3D.getX();
                    d13 = point3D.getY();
                    d17 = point3D.getZ();
                }
                if (track3DKey.nextKey != null) {
                    d12 = track3DKey.nextKey.getX();
                    d16 = track3DKey.nextKey.getY();
                    d20 = track3DKey.nextKey.getZ();
                }
                double d21 = d12 - d11 - (d9 - d10);
                double d22 = d9 - d10 - d21;
                double d23 = d11 - d9;
                double d24 = d10;
                double d25 = d16 - d15 - (d13 - d14);
                double d26 = d13 - d14 - d25;
                double d27 = d15 - d13;
                double d28 = d14;
                double d29 = d20 - d19 - (d17 - d18);
                double d30 = d17 - d18 - d29;
                double d31 = d19 - d17;
                double d32 = d18;
                this.x = d21 * d8 + d22 * d7 + d23 * d6 + d24;
                this.y = d25 * d8 + d26 * d7 + d27 * d6 + d28;
                this.z = d29 * d8 + d30 * d7 + d31 * d6 + d32;
            }
        }
    }

    public String toString() {
        String string = "";
        Track3DKey track3DKey = this.firstKey;
        int n = 0;
        while (track3DKey != null) {
            string = string + "Key " + n + " : " + track3DKey.getX() + "," + track3DKey.getY() + "," + track3DKey.getZ() + ") at " + track3DKey.time + "\r\n";
            track3DKey = track3DKey.nextKey;
            ++n;
        }
        return string;
    }

    private int addKey(Track3DKey track3DKey) {
        if (this.firstKey == null) {
            this.firstKey = track3DKey;
            ++this.nbKey;
            return 0;
        }
        Track3DKey track3DKey2 = null;
        Track3DKey track3DKey3 = this.firstKey;
        int n = 0;
        while (track3DKey3 != null && track3DKey3.time <= track3DKey.time) {
            track3DKey2 = track3DKey3;
            track3DKey3 = track3DKey3.nextKey;
            ++n;
        }
        if (track3DKey2 == null) {
            this.firstKey = track3DKey;
        } else {
            track3DKey2.nextKey = track3DKey;
        }
        track3DKey.nextKey = track3DKey3;
        ++this.nbKey;
        return n;
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    private class Track3DLinkedKey
    extends Track3DKey {
        private IPoint3D source;

        Track3DLinkedKey() {
            this.nextKey = null;
            this.time = 0L;
            this.interpolation = 0;
        }

        public void setSource(IPoint3D iPoint3D) {
            this.source = iPoint3D;
        }

        public double getX() {
            return this.source.getX();
        }

        public double getY() {
            return this.source.getY();
        }

        public double getZ() {
            return this.source.getZ();
        }
    }

    private class Track3DStaticKey
    extends Track3DKey {
        Track3DStaticKey() {
            this.nextKey = null;
            this.time = 0L;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.interpolation = 0;
        }
    }

    private abstract class Track3DKey
    extends Point3D {
        protected Track3DKey nextKey;
        protected long time;
        protected int interpolation;

        private Track3DKey() {
        }
    }
}

