/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.visitor.CpInfoVisitor;

class ComparableCpInfo
implements Comparable,
CpInfoVisitor {
    private static int[] PRIORITIES = new int[13];
    private ClassFile classFile;
    private int thisIndex;
    private CpInfo thisCpInfo;
    private CpInfo otherCpInfo;
    private int result;

    public ComparableCpInfo(ClassFile classFile, int n, CpInfo cpInfo) {
        this.classFile = classFile;
        this.thisIndex = n;
        this.thisCpInfo = cpInfo;
    }

    public int getIndex() {
        return this.thisIndex;
    }

    public CpInfo getCpInfo() {
        return this.thisCpInfo;
    }

    public int compareTo(Object object) {
        int n;
        ComparableCpInfo comparableCpInfo = (ComparableCpInfo)object;
        this.otherCpInfo = comparableCpInfo.thisCpInfo;
        if (this.thisCpInfo == this.otherCpInfo) {
            int n2 = comparableCpInfo.thisIndex;
            return this.thisIndex < n2 ? -1 : (this.thisIndex == n2 ? 0 : 1);
        }
        int n3 = this.thisCpInfo.getTag();
        if (n3 != (n = this.otherCpInfo.getTag())) {
            return PRIORITIES[n3] < PRIORITIES[n] ? -1 : 1;
        }
        this.thisCpInfo.accept(this.classFile, this);
        return this.result;
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
        this.result = new Integer(integerCpInfo.getValue()).compareTo(new Integer(((IntegerCpInfo)this.otherCpInfo).getValue()));
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
        this.result = new Long(longCpInfo.getValue()).compareTo(new Long(((LongCpInfo)this.otherCpInfo).getValue()));
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
        this.result = new Float(floatCpInfo.getValue()).compareTo(new Float(((FloatCpInfo)this.otherCpInfo).getValue()));
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
        this.result = new Double(doubleCpInfo.getValue()).compareTo(new Double(((DoubleCpInfo)this.otherCpInfo).getValue()));
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        this.result = stringCpInfo.getString(classFile).compareTo(((StringCpInfo)this.otherCpInfo).getString(classFile));
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
        this.result = utf8CpInfo.getString().compareTo(((Utf8CpInfo)this.otherCpInfo).getString());
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        this.result = fieldrefCpInfo.getName(classFile).compareTo(((FieldrefCpInfo)this.otherCpInfo).getName(classFile));
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.result = interfaceMethodrefCpInfo.getName(classFile).compareTo(((InterfaceMethodrefCpInfo)this.otherCpInfo).getName(classFile));
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.result = methodrefCpInfo.getName(classFile).compareTo(((MethodrefCpInfo)this.otherCpInfo).getName(classFile));
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        this.result = classCpInfo.getName(classFile).compareTo(((ClassCpInfo)this.otherCpInfo).getName(classFile));
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
        this.result = nameAndTypeCpInfo.getName(classFile).compareTo(((NameAndTypeCpInfo)this.otherCpInfo).getName(classFile));
    }

    static {
        ComparableCpInfo.PRIORITIES[7] = 0;
        ComparableCpInfo.PRIORITIES[9] = 1;
        ComparableCpInfo.PRIORITIES[10] = 2;
        ComparableCpInfo.PRIORITIES[11] = 3;
        ComparableCpInfo.PRIORITIES[8] = 4;
        ComparableCpInfo.PRIORITIES[3] = 5;
        ComparableCpInfo.PRIORITIES[4] = 6;
        ComparableCpInfo.PRIORITIES[5] = 7;
        ComparableCpInfo.PRIORITIES[6] = 8;
        ComparableCpInfo.PRIORITIES[12] = 9;
        ComparableCpInfo.PRIORITIES[1] = 10;
    }
}

