/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import net.dzzd.access.IURLTexture;
import net.dzzd.core.ImageTexture;
import net.dzzd.utils.Log;

public final class URLTexture
extends ImageTexture
implements IURLTexture,
Runnable,
ImageObserver {
    public static final long serialVersionUID = 1L;
    String baseURL = null;
    String sourceFile = null;
    private boolean reload = true;

    public void build() {
        if (this.reload) {
            this.load();
        } else {
            super.build();
        }
    }

    public void run() {
        if (this.sourceFile == null) {
            return;
        }
        if (this.baseURL == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            this.image = toolkit.getImage(new URL(this.baseURL + this.sourceFile.replace(' ', '+')));
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(malformedURLException);
            this.endLoading(true);
            return;
        }
        if (this.image == null) {
            this.endLoading(true);
            return;
        }
        if (toolkit.prepareImage(this.image, -1, -1, this)) {
            this.endLoading(false);
            return;
        }
        int n = 0;
        do {
            try {
                Thread.sleep(20L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                this.endLoading(false);
            }
        } while (((n = toolkit.checkImage(this.image, -1, -1, this)) & 0xE0) == 0);
        if ((n & 0x20) != 0) {
            this.endLoading(false);
        } else {
            this.endLoading(true);
        }
    }

    void endLoading(boolean bl) {
        if (!bl) {
            this.setImage(this.image);
            this.setError(false);
            this.setFinished(true);
            this.build();
            return;
        }
        this.setError(true);
        this.setFinished(true);
        Log.log("Loading error (" + this.baseURL + this.sourceFile + ")");
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 3: {
                this.setMaximumProgress(n4 * n5);
                return true;
            }
            case 8: {
                this.setProgress(n2 + n3 * n4);
                return true;
            }
            case 4: {
                return true;
            }
            case 16: {
                return false;
            }
            case 32: {
                this.setProgress(this.getMaximumProgress());
                return false;
            }
            case 64: {
                return false;
            }
            case 128: {
                return false;
            }
        }
        return false;
    }

    public void setSourceFile(String string) {
        this.reload = true;
        this.sourceFile = string;
        this.setName(string);
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setBaseURL(String string) {
        this.reload = true;
        this.baseURL = string;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void load(String string, String string2) {
        this.setBaseURL(string);
        this.setSourceFile(string2);
        this.load();
    }

    public void load(String string, String string2, boolean bl) {
        this.setBaseURL(string);
        this.setSourceFile(string2);
        this.load();
    }

    public void load() {
        this.reset();
        this.setAction(0);
        this.reload = false;
        Thread thread = new Thread(this);
        thread.start();
    }
}

