/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.extension.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class JOGLShader {
    private String[] source = null;
    private int shaderId = -1;
    private GL gl;
    private GLU glu = new GLU();
    private boolean compiled = false;
    private int shaderType;

    public JOGLShader(GL gL, int n) {
        this.gl = gL;
        this.shaderType = n;
    }

    public int getId() {
        return this.shaderId;
    }

    public void setSourceCode(String[] stringArray) {
        this.source = stringArray;
        this.compiled = false;
    }

    protected boolean compile() {
        int[] nArray = new int[]{this.source[0].length()};
        this.shaderId = this.gl.glCreateShaderObjectARB(this.shaderType);
        this.gl.glShaderSourceARB(this.shaderId, this.source.length, this.source, nArray, 0);
        this.gl.glCompileShaderARB(this.shaderId);
        String string = this.getGLError(this.gl);
        if (string != null) {
            System.out.println("Shader compilation error :\n" + string);
        }
        this.compiled = true;
        return true;
    }

    private String getGLError(GL gL) {
        boolean bl = false;
        String string = "";
        int n = gL.glGetError();
        while (n != 0) {
            string = string + (bl ? "\n" : "") + this.glu.gluErrorString(n);
            bl = true;
            n = gL.glGetError();
        }
        return bl ? string : null;
    }
}

