/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.IFace3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DCollisionGenerator;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.access.IMesh3DViewGenerator;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene3DObject;
import net.dzzd.access.IVertex3D;
import net.dzzd.core.Face3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3DOctree;
import net.dzzd.core.Scene3DObject;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;

public class Mesh3D
extends Scene3DObject
implements IMesh3D {
    Vertex3D[] vertices3D;
    Face3D[] faces3D;
    Mesh3DOctree octree;
    public IMesh3DViewGenerator meshViewGenerator;
    public IMesh3DCollisionGenerator meshCollisionGenerator;
    boolean castShadowFlag = true;
    boolean recvShadowFlag = true;

    public Mesh3D() {
        this.vertices3D = new Vertex3D[0];
        this.faces3D = new Face3D[0];
        this.meshViewGenerator = null;
        this.meshCollisionGenerator = null;
        this.octree = null;
    }

    public Mesh3D(IVertex3D[] iVertex3DArray, IFace3D[] iFace3DArray) {
        this.vertices3D = (Vertex3D[])iVertex3DArray;
        this.faces3D = (Face3D[])iFace3DArray;
        this.meshViewGenerator = null;
        this.meshCollisionGenerator = null;
        this.octree = null;
        this.buildVertexId();
        this.buildFaceId();
    }

    public void build() {
        super.build();
        this.buildVertexId();
        this.buildFaceId();
        this.removeDuplicateVertices();
        this.buildFacesNormals();
        this.buildSphereBoxAndCenter();
        if (this.meshViewGenerator == null) {
            this.buildMesh3DOctree();
        }
    }

    public void buildVertexId() {
        super.build();
        for (int i = 0; i < this.vertices3D.length; ++i) {
            this.vertices3D[i].id = i;
        }
    }

    public void buildFaceId() {
        super.build();
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].id = i;
        }
    }

    public void buildSphereBoxAndCenter() {
        double d;
        super.build();
        this.sphereBox = 0.0;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = Double.MAX_VALUE;
        double d5 = -1.7976931348623157E308;
        double d6 = Double.MAX_VALUE;
        double d7 = -1.7976931348623157E308;
        for (int i = 0; i < this.vertices3D.length; ++i) {
            Vertex3D vertex3D = this.vertices3D[i];
            if (vertex3D.x > d3) {
                d3 = vertex3D.x;
            }
            if (vertex3D.x < d2) {
                d2 = vertex3D.x;
            }
            if (vertex3D.y > d5) {
                d5 = vertex3D.y;
            }
            if (vertex3D.y < d4) {
                d4 = vertex3D.y;
            }
            if (vertex3D.z > d7) {
                d7 = vertex3D.z;
            }
            if (!(vertex3D.z < d6)) continue;
            d6 = vertex3D.z;
        }
        double d8 = (d3 + d2) / 2.0;
        double d9 = (d5 + d4) / 2.0;
        double d10 = (d7 + d6) / 2.0;
        this.center.set(d8, d9, d10);
        for (int i = 0; i < this.vertices3D.length; ++i) {
            Vertex3D vertex3D = this.vertices3D[i];
            d = this.center.dist(vertex3D);
            if (!(d > this.sphereBox)) continue;
            this.sphereBox = d;
        }
        double d11 = d3 / 2.0 - d2 / 2.0;
        d = d5 / 2.0 - d4 / 2.0;
        double d12 = d7 / 2.0 - d6 / 2.0;
        double d13 = d11 * d11 + d * d + d12 * d12;
        this.sphereBox = Math.sqrt(d13);
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].initSphereBox();
        }
    }

    public void removeInvalideFaces() {
        Face3D[] face3DArray;
        int n;
        int n2;
        super.build();
        int[] nArray = new int[this.faces3D.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 1;
        }
        n2 = 0;
        for (n = 0; n < this.faces3D.length; ++n) {
            face3DArray = this.faces3D[n];
            if (face3DArray.p0.equals(face3DArray.p1)) {
                nArray[n] = 0;
            } else if (face3DArray.p0.equals(face3DArray.p2)) {
                nArray[n] = 0;
            } else if (face3DArray.p1.equals(face3DArray.p2)) {
                nArray[n] = 0;
            } else {
                ++n2;
            }
            if (nArray[n] != 0) continue;
            System.out.println("*********************\n*********\nremove face :" + n);
        }
        Log.log("Object name " + this.nom);
        Log.log("Valide Faces " + n2 + "/" + this.faces3D.length);
        n = 0;
        face3DArray = new Face3D[n2];
        for (int i = 0; i < this.faces3D.length; ++i) {
            if (nArray[i] != 1) continue;
            face3DArray[n++] = this.faces3D[i];
        }
        this.faces3D = face3DArray;
        this.buildFaceId();
    }

    public void removeDuplicateVertices() {
        Object object;
        int n;
        int n2;
        this.buildVertexId();
        Vertex3D[] vertex3DArray = new Vertex3D[this.vertices3D.length];
        int[] nArray = new int[this.vertices3D.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = -1;
        }
        n2 = 0;
        for (n = 0; n < this.vertices3D.length; ++n) {
            object = this.vertices3D[n];
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (!vertex3DArray[i].equals((IPoint3D)object)) continue;
                bl = true;
                nArray[((Vertex3D)object).id] = i;
                break;
            }
            if (bl) continue;
            nArray[((Vertex3D)object).id] = n2;
            vertex3DArray[n2++] = object;
        }
        this.vertices3D = new Vertex3D[n2];
        for (n = 0; n < n2; ++n) {
            this.vertices3D[n] = vertex3DArray[n];
        }
        for (n = 0; n < this.faces3D.length; ++n) {
            object = this.faces3D[n];
            ((Face3D)object).p0 = this.vertices3D[nArray[((Face3D)object).p0.id]];
            ((Face3D)object).p1 = this.vertices3D[nArray[((Face3D)object).p1.id]];
            ((Face3D)object).p2 = this.vertices3D[nArray[((Face3D)object).p2.id]];
        }
        this.buildVertexId();
    }

    public void buildFacesNormals() {
        int n;
        super.build();
        int[] nArray = new int[this.vertices3D.length];
        for (n = 0; n < this.faces3D.length; ++n) {
            Face3D face3D = this.faces3D[n];
            face3D.object = this;
            face3D.setNormal();
        }
        for (n = 1; n < 32; ++n) {
            double d;
            Object object;
            int n2 = 0;
            n2 = 1 << n - 1;
            int n3 = 0;
            while (n3 < this.vertices3D.length) {
                nArray[n3] = 0;
                object = this.vertices3D[n3];
                ((Vertex3D)object).id = n3++;
                ((Vertex3D)object).tX = 0.0;
                ((Vertex3D)object).tY = 0.0;
                ((Vertex3D)object).tZ = 0.0;
            }
            for (n3 = 0; n3 < this.faces3D.length; ++n3) {
                object = this.faces3D[n3];
                if (((Face3D)object).smoothGroupMask != n2 && (((Face3D)object).smoothGroupMask & n2) == 0) continue;
                d = ((Face3D)object).pa;
                double d2 = ((Face3D)object).pb;
                double d3 = ((Face3D)object).pc;
                Vertex3D vertex3D = null;
                Vertex3D vertex3D2 = null;
                Vertex3D vertex3D3 = null;
                for (int i = 0; i < 3; ++i) {
                    switch (i) {
                        case 0: {
                            vertex3D = ((Face3D)object).p1;
                            vertex3D2 = ((Face3D)object).p0;
                            vertex3D3 = ((Face3D)object).p2;
                            break;
                        }
                        case 1: {
                            vertex3D = ((Face3D)object).p2;
                            vertex3D2 = ((Face3D)object).p1;
                            vertex3D3 = ((Face3D)object).p0;
                            break;
                        }
                        case 2: {
                            vertex3D = ((Face3D)object).p0;
                            vertex3D2 = ((Face3D)object).p2;
                            vertex3D3 = ((Face3D)object).p1;
                        }
                    }
                    double d4 = vertex3D2.x - vertex3D.x;
                    double d5 = vertex3D2.y - vertex3D.y;
                    double d6 = vertex3D2.z - vertex3D.z;
                    double d7 = vertex3D3.x - vertex3D.x;
                    double d8 = vertex3D3.y - vertex3D.y;
                    double d9 = vertex3D3.z - vertex3D.z;
                    double d10 = d4 * d7 + d5 * d8 + d6 * d9;
                    double d11 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
                    double d12 = Math.sqrt(d7 * d7 + d8 * d8 + d9 * d9);
                    if (d11 * d12 == 0.0) continue;
                    if ((d10 /= d11 * d12) > 1.0) {
                        d10 = 1.0;
                    }
                    if (d10 < -1.0) {
                        d10 = -1.0;
                    }
                    double d13 = Math.acos(d10);
                    vertex3D.tX += d * d13;
                    vertex3D.tY += d2 * d13;
                    vertex3D.tZ += d3 * d13;
                    int n4 = vertex3D.id;
                    nArray[n4] = nArray[n4] + 1;
                }
            }
            for (n3 = 0; n3 < this.vertices3D.length; ++n3) {
                object = this.vertices3D[n3];
                d = Math.sqrt(((Vertex3D)object).tX * ((Vertex3D)object).tX + ((Vertex3D)object).tY * ((Vertex3D)object).tY + ((Vertex3D)object).tZ * ((Vertex3D)object).tZ);
                ((Vertex3D)object).tX /= d;
                ((Vertex3D)object).tY /= d;
                ((Vertex3D)object).tZ /= d;
            }
            for (n3 = 0; n3 < this.faces3D.length; ++n3) {
                object = this.faces3D[n3];
                if ((((Face3D)object).smoothGroupMask & n2) == 0) continue;
                Vertex3D vertex3D = ((Face3D)object).p0;
                Vertex3D vertex3D4 = ((Face3D)object).p1;
                Vertex3D vertex3D5 = ((Face3D)object).p2;
                ((Face3D)object).p0nx = (float)vertex3D.tX;
                ((Face3D)object).p0ny = (float)vertex3D.tY;
                ((Face3D)object).p0nz = (float)vertex3D.tZ;
                ((Face3D)object).p1nx = (float)vertex3D4.tX;
                ((Face3D)object).p1ny = (float)vertex3D4.tY;
                ((Face3D)object).p1nz = (float)vertex3D4.tZ;
                ((Face3D)object).p2nx = (float)vertex3D5.tX;
                ((Face3D)object).p2ny = (float)vertex3D5.tY;
                ((Face3D)object).p2nz = (float)vertex3D5.tZ;
            }
        }
    }

    public void buildMesh3DOctree() {
        super.build();
        if (this.meshViewGenerator != null) {
            return;
        }
        double d = Math.sqrt(this.sphereBox * this.sphereBox / 3.0) * 2.0;
        int[] nArray = new int[this.faces3D.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        long l = System.currentTimeMillis();
        this.octree = new Mesh3DOctree(this, 0, this.center.x, this.center.y, this.center.z, this.sphereBox, d, this.faces3D, nArray, null);
        l = System.currentTimeMillis();
        this.octree.generate();
        l = System.currentTimeMillis();
        this.octree.generateFaces();
        l = System.currentTimeMillis();
        int n = this.octree.initMesh3DOctreeId(0);
    }

    public void flipNormals() {
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].flipNormal();
        }
    }

    public void zoom(double d, double d2, double d3) {
        for (int i = 0; i < this.vertices3D.length; ++i) {
            this.vertices3D[i].sub(this.pivot);
            this.vertices3D[i].zoom(d, d2, d3);
            this.vertices3D[i].add(this.pivot);
        }
        super.zoom(d, d2, d3);
        this.buildFacesNormals();
        this.buildSphereBoxAndCenter();
        if (this.octree != null) {
            this.buildMesh3DOctree();
        }
    }

    public int getNbFace3D() {
        return this.faces3D.length;
    }

    public int getNbVertex3D() {
        return this.vertices3D.length;
    }

    public IFace3D getFace3D(int n) {
        if (n >= this.faces3D.length || n < 0) {
            return null;
        }
        return this.faces3D[n];
    }

    public IFace3D[] getFaces3D() {
        return this.faces3D;
    }

    public IVertex3D getVertex3D(int n) {
        return this.vertices3D[n];
    }

    public IVertex3D[] getVertex3D() {
        return this.vertices3D;
    }

    public double getSphereBox() {
        return this.sphereBox;
    }

    public void copy(IMesh3D iMesh3D) {
        int n;
        Mesh3D mesh3D = (Mesh3D)iMesh3D;
        this.renderMode = mesh3D.renderMode;
        Face3D[] face3DArray = new Face3D[mesh3D.faces3D.length];
        Vertex3D[] vertex3DArray = new Vertex3D[mesh3D.vertices3D.length];
        for (n = 0; n < vertex3DArray.length; ++n) {
            vertex3DArray[n] = (Vertex3D)mesh3D.vertices3D[n].getClone();
            vertex3DArray[n].id = n;
        }
        iMesh3D.buildVertexId();
        for (n = 0; n < face3DArray.length; ++n) {
            Face3D face3D = mesh3D.faces3D[n];
            Vertex3D[] vertex3DArray2 = new Vertex3D[]{vertex3DArray[face3D.p0.id], vertex3DArray[face3D.p1.id], vertex3DArray[face3D.p2.id]};
            Face3D face3D2 = new Face3D(vertex3DArray2[0], vertex3DArray2[1], vertex3DArray2[2]);
            face3D2.id = n;
            face3D2.smoothGroupMask = face3D.smoothGroupMask;
            face3D2.material = face3D.material;
            face3D2.object = this;
            face3D2.pa = face3D.pa;
            face3D2.pb = face3D.pb;
            face3D2.pc = face3D.pc;
            face3D2.pd = face3D.pd;
            face3D2.u0 = face3D.u0;
            face3D2.v0 = face3D.v0;
            face3D2.u1 = face3D.u1;
            face3D2.v1 = face3D.v1;
            face3D2.u2 = face3D.u2;
            face3D2.v2 = face3D.v2;
            face3D2.p0nx = face3D.p0nx;
            face3D2.p0ny = face3D.p0ny;
            face3D2.p0nz = face3D.p0nz;
            face3D2.p1nx = face3D.p1nx;
            face3D2.p1ny = face3D.p1ny;
            face3D2.p1nz = face3D.p1nz;
            face3D2.p2nx = face3D.p2nx;
            face3D2.p2ny = face3D.p2ny;
            face3D2.p2nz = face3D.p2nz;
            face3DArray[n] = face3D2;
        }
        this.faces3D = face3DArray;
        this.vertices3D = vertex3DArray;
        super.copy(iMesh3D);
    }

    public IScene3DObject getClone(boolean bl) {
        Mesh3D mesh3D = new Mesh3D();
        mesh3D.copy(this);
        if (bl) {
            Scene3DObject scene3DObject = this.firstChild;
            while (scene3DObject != null) {
                mesh3D.addChild(scene3DObject.getClone(bl));
                scene3DObject = scene3DObject.nextChild;
            }
        }
        return mesh3D;
    }

    public IMesh3DViewGenerator getMesh3DViewGenerator() {
        return this.meshViewGenerator;
    }

    public void setMesh3DViewGenerator(IMesh3DViewGenerator iMesh3DViewGenerator) {
        this.meshViewGenerator = iMesh3DViewGenerator;
    }

    public IMesh3DCollisionGenerator getMesh3DCollisionGenerator() {
        return this.meshCollisionGenerator;
    }

    public void setMesh3DCollisionGenerator(IMesh3DCollisionGenerator iMesh3DCollisionGenerator) {
        this.meshCollisionGenerator = iMesh3DCollisionGenerator;
    }

    public void setMaterial(IMaterial iMaterial) {
        Material material = (Material)iMaterial;
        for (int i = 0; i < this.faces3D.length; ++i) {
            this.faces3D[i].material = material;
        }
    }

    public void setCastShadow(boolean bl) {
        this.castShadowFlag = bl;
    }

    public boolean getCastShadow() {
        return this.castShadowFlag;
    }

    public void setRecvShadow(boolean bl) {
        this.recvShadowFlag = bl;
    }

    public boolean getRecvShadow() {
        return this.recvShadowFlag;
    }

    public IMesh3DOctree getMesh3DOctree() {
        return this.octree;
    }
}

