/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.IPixelsDrawer2D;
import net.dzzd.core.Drawer2D;

public class PixelsDrawer2D
extends Drawer2D
implements IPixelsDrawer2D {
    private int[] pixels = null;
    private int pixelBufferWidth;
    private int bufferWidth;
    private int bufferHeight;
    private int[] buffer;
    private double[] minX;
    private double[] maxX;
    private double symin;
    private double symax;
    int lx = 0;
    int ly = 0;

    public void setPixelsTarget(int[] nArray, int n, int n2) {
        this.setPixelsTarget(nArray, n, n2, n);
    }

    public void setPixelsTarget(int[] nArray, int n, int n2, int n3) {
        this.pixels = nArray;
        this.setSize(n, n2);
        this.pixelBufferWidth = n3;
        this.setClip(0.0, 0.0, n - 1, n2 - 1);
        this.initShape2DBuffer(n, n2);
    }

    private void initShape2DBuffer(int n, int n2) {
        this.bufferWidth = n;
        this.bufferHeight = n2;
        if (this.buffer == null || this.buffer.length != n * n2) {
            this.minX = new double[this.bufferHeight];
            this.maxX = new double[this.bufferHeight];
            this.buffer = new int[this.bufferWidth * this.bufferHeight];
        }
    }

    public void moveTo(double d, double d2) {
        super.moveTo(d, d2);
        this.lx = (int)d;
        this.ly = (int)d2;
    }

    public void lineTo(double d, double d2) {
        if (!this.sFlag) {
            return;
        }
        int n = (int)d;
        int n2 = (int)d2;
        this.tracePixelTo(n, n2);
        this.lx = n;
        this.ly = n2;
        super.lineTo(d, d2);
    }

    private void tracePixelTo(int n, int n2) {
        int n3 = this.lx;
        int n4 = this.ly;
        int n5 = n - n3;
        int n6 = n2 - n4;
        if (n5 == 0 && n6 == 0) {
            return;
        }
        int n7 = n3;
        int n8 = n4;
        int n9 = 1;
        int n10 = 1;
        if (n5 < 0) {
            n5 = -n5;
            n9 = -1;
        }
        if (n6 < 0) {
            n6 = -n6;
            n10 = -1;
        }
        int n11 = ++n5 - ++n6;
        this.setPixel(n7, n8, this.color);
        while (n != n7 || n2 != n8) {
            if (n11 >= 0) {
                n7 += n9;
                n11 -= n6;
            }
            if (n11 < 0) {
                n8 += n10;
                n11 += n5;
            }
            this.setPixel(n7, n8, this.color);
        }
    }

    private void fillSolidCurrentShape2D() {
    }

    public void fillSolid() {
        int n = (int)this.yMin;
        int n2 = (int)this.yMax;
        int n3 = (int)this.xMin;
        int n4 = (int)this.xMax;
        int n5 = n * this.pixelBufferWidth;
        if (this.opacity == 255) {
            int n6 = 0xFF000000 | this.color;
            for (int i = n; i <= n2; ++i) {
                int n7 = n3 + n5;
                int n8 = n4 + n5;
                int n9 = n7;
                while (n9 <= n8) {
                    this.pixels[n9++] = n6;
                }
                n5 += this.pixelBufferWidth;
            }
        } else {
            int n10 = ((this.color & 0xFF00FF) * this.opacity & 0xFF00FF00 | (this.color & 0xFF00) * this.opacity & 0xFF0000) >> 8;
            int n11 = this.opacity ^ 0xFF;
            for (int i = n; i <= n2; ++i) {
                int n12 = n3 + n5;
                int n13 = n4 + n5;
                int n14 = n12;
                while (n14 <= n13) {
                    int n15 = this.pixels[n14];
                    n15 = ((n15 & 0xFF00FF) * n11 & 0xFF00FF00 | (n15 & 0xFF00) * n11 & 0xFF0000) >> 8;
                    this.pixels[n14++] = n10 + n15;
                }
                n5 += this.pixelBufferWidth;
            }
        }
    }

    public void line(double d, double d2, double d3, double d4) {
        if (d2 < this.yMin) {
            if (d4 < this.yMin) {
                return;
            }
            if (d4 != d2) {
                d += (this.yMin - d2) * (d3 - d) / (d4 - d2);
            }
            d2 = this.yMin;
        } else if (d2 > this.yMax) {
            if (d4 > this.yMax) {
                return;
            }
            if (d4 != d2) {
                d += (this.yMax - d2) * (d3 - d) / (d4 - d2);
            }
            d2 = this.yMax;
        }
        if (d4 < this.yMin) {
            if (d2 < this.yMin) {
                return;
            }
            if (d4 != d2) {
                d3 = d + (this.yMin - d2) * (d3 - d) / (d4 - d2);
            }
            d4 = this.yMin;
        } else if (d4 > this.yMax) {
            if (d2 > this.yMax) {
                return;
            }
            if (d4 != d2) {
                d3 += (this.yMax - d4) * (d3 - d) / (d4 - d2);
            }
            d4 = this.yMax;
        }
        if (d > this.xMax && d3 > this.xMax) {
            return;
        }
        if (d < this.xMin && d3 < this.xMin) {
            return;
        }
        if (d < this.xMin) {
            if (d3 < this.xMin) {
                return;
            }
            if (d3 != d) {
                d2 += (this.xMin - d) * (d4 - d2) / (d3 - d);
            }
            d = this.xMin;
        } else if (d > this.xMax) {
            if (d3 > this.xMax) {
                return;
            }
            if (d3 != d) {
                d2 += (this.xMax - d) * (d4 - d2) / (d3 - d);
            }
            d = this.xMax;
        }
        if (d3 < this.xMin) {
            if (d < this.xMin) {
                return;
            }
            if (d3 != d) {
                d4 = d2 + (this.xMin - d) * (d4 - d2) / (d3 - d);
            }
            d3 = this.xMin;
        } else if (d3 > this.xMax) {
            if (d > this.xMax) {
                return;
            }
            if (d3 != d) {
                d4 += (this.xMax - d3) * (d4 - d2) / (d3 - d);
            }
            d3 = this.xMax;
        }
        double d5 = d3 - d;
        double d6 = d4 - d2;
        int n = this.color;
        if (Math.abs(d5) > Math.abs(d6)) {
            int n2 = (int)d3;
            int n3 = (int)d;
            if (Math.abs(n2 - n3) > 0) {
                double d7 = d6 / d5;
                this.lineX(n3, n2, d2, d7);
                return;
            }
            this.setPixel((int)d, (int)d2, this.color);
            this.setPixel((int)d3, (int)d4, this.color);
        } else {
            int n4 = (int)d4;
            int n5 = (int)d2;
            if (Math.abs(n4 - n5) > 0) {
                double d8 = d5 / d6;
                this.lineY(n5, n4, d, d8);
                return;
            }
            this.setPixel((int)d, (int)d2, this.color);
            this.setPixel((int)d3, (int)d4, this.color);
        }
    }

    private void lineY(int n, int n2, double d, double d2) {
        int n3 = n;
        int n4 = n2 >= n ? 1 : -1;
        for (n3 = n; n3 != n2; n3 += n4) {
            this.setPixel((int)(d + (double)(n3 - n) * d2), n3, 0xFF0000);
        }
    }

    private void lineX(int n, int n2, double d, double d2) {
        int n3 = n;
        int n4 = n2 >= n ? 1 : -1;
        for (n3 = n; n3 != n2; n3 += n4) {
            this.setPixel(n3, (int)(d + (double)(n3 - n) * d2), 65280);
        }
    }

    public void setPixel(double d, double d2, int n) {
        int n2 = (int)d2;
        int n3 = (int)d;
        int n4 = n2 * this.pixelBufferWidth + n3;
        int n5 = n4 + 1;
        int n6 = n4 + this.pixelBufferWidth;
        int n7 = n6 + 1;
        int n8 = 256 - ((int)(d * 256.0) & 0xFF);
        int n9 = 256 - ((int)(d2 * 256.0) & 0xFF);
        int n10 = 256 - n8;
        int n11 = 256 - n9;
        int n12 = n8 * n9 >> 8;
        int n13 = n10 * n9 >> 8;
        int n14 = n8 * n11 >> 8;
        int n15 = n10 * n11 >> 8;
        int n16 = this.pixels[n4];
        int n17 = this.pixels[n5];
        int n18 = this.pixels[n6];
        int n19 = this.pixels[n7];
        int n20 = ((n & 0xFF00FF) * n12 & 0xFF00FF00 | (n & 0xFF00) * n12 & 0xFF0000) >> 8;
        int n21 = ((n & 0xFF00FF) * n13 & 0xFF00FF00 | (n & 0xFF00) * n13 & 0xFF0000) >> 8;
        int n22 = ((n & 0xFF00FF) * n14 & 0xFF00FF00 | (n & 0xFF00) * n14 & 0xFF0000) >> 8;
        int n23 = ((n & 0xFF00FF) * n15 & 0xFF00FF00 | (n & 0xFF00) * n15 & 0xFF0000) >> 8;
        n12 = 256 - n12;
        n14 = 256 - n14;
        n13 = 256 - n13;
        n15 = 256 - n15;
        n16 = ((n16 & 0xFF00FF) * n12 & 0xFF00FF00 | (n16 & 0xFF00) * n12 & 0xFF0000) >> 8;
        n17 = ((n17 & 0xFF00FF) * n13 & 0xFF00FF00 | (n17 & 0xFF00) * n13 & 0xFF0000) >> 8;
        n18 = ((n18 & 0xFF00FF) * n14 & 0xFF00FF00 | (n18 & 0xFF00) * n14 & 0xFF0000) >> 8;
        n19 = ((n19 & 0xFF00FF) * n15 & 0xFF00FF00 | (n19 & 0xFF00) * n15 & 0xFF0000) >> 8;
        this.pixels[n4] = n20 + n16;
        this.pixels[n5] = n21 + n17;
        this.pixels[n6] = n22 + n18;
        this.pixels[n7] = n23 + n19;
    }

    public void setPixel(int n, int n2, int n3) {
        int n4 = n2 * this.pixelBufferWidth + n;
        this.setPixel(n4, n3);
    }

    public int getPixel(int n, int n2) {
        int n3 = n2 * this.pixelBufferWidth + n;
        return this.getPixel(n3);
    }

    public void lineShape2D(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        if (d2 < this.yMin) {
            if (d4 < this.yMin) {
                return;
            }
            if (d4 != d2) {
                d += (this.yMin - d2) * (d3 - d) / (d4 - d2);
            }
            d2 = this.yMin;
        } else if (d2 > this.yMax) {
            if (d4 > this.yMax) {
                return;
            }
            if (d4 != d2) {
                d += (this.yMax - d2) * (d3 - d) / (d4 - d2);
            }
            d2 = this.yMax;
        }
        if (d4 < this.yMin) {
            if (d2 < this.yMin) {
                return;
            }
            if (d4 != d2) {
                d3 = d + (this.yMin - d2) * (d3 - d) / (d4 - d2);
            }
            d4 = this.yMin;
        } else if (d4 > this.yMax) {
            if (d2 > this.yMax) {
                return;
            }
            if (d4 != d2) {
                d3 += (this.yMax - d4) * (d3 - d) / (d4 - d2);
            }
            d4 = this.yMax;
        }
        if (d2 <= this.symin) {
            n3 = (int)d2;
            n2 = (int)Math.min(this.symin - 1.0, (double)(this.bufferHeight - 1));
            for (n = n3; n <= n2; ++n) {
                this.buffer[n * this.bufferWidth] = this.bufferWidth;
                this.minX[n] = -1.7976931348623157E308;
                this.maxX[n] = Double.MAX_VALUE;
            }
            this.symin = d2;
        }
        if (d2 >= this.symax) {
            n3 = (int)Math.max(this.symax + 1.0, 0.0);
            n2 = (int)d2;
            for (n = n3; n <= n2; ++n) {
                this.buffer[n * this.bufferWidth] = this.bufferWidth;
                this.minX[n] = -1.7976931348623157E308;
                this.maxX[n] = Double.MAX_VALUE;
            }
            this.symax = d2;
        }
        if (d4 <= this.symin) {
            n3 = (int)d4;
            n2 = (int)Math.min(this.symin - 1.0, (double)(this.bufferHeight - 1));
            for (n = n3; n <= n2; ++n) {
                this.buffer[n * this.bufferWidth] = this.bufferWidth;
                this.minX[n] = -1.7976931348623157E308;
                this.maxX[n] = Double.MAX_VALUE;
            }
            this.symin = d4;
        }
        if (d4 >= this.symax) {
            n3 = (int)Math.max(this.symax + 1.0, 0.0);
            n2 = (int)d4;
            for (n = n3; n <= n2; ++n) {
                this.buffer[n * this.bufferWidth] = this.bufferWidth;
                this.minX[n] = -1.7976931348623157E308;
                this.maxX[n] = Double.MAX_VALUE;
            }
            this.symax = d4;
        }
        double d5 = d3 - d;
        double d6 = d4 - d2;
        int n4 = (int)d4;
        int n5 = (int)d2;
        if (n4 == n5) {
            return;
        }
        this.line(d, d2, d3, d4);
    }

    private void setStartSegment(double d, double d2) {
        int n = (int)(d * 256.0) & 0xFF;
        int n2 = (int)(d2 * 256.0) & 0xFF;
        int n3 = n ^ 0xFF;
        int n4 = n2 ^ 0xFF;
        int n5 = n3 * n4 >> 8;
        int n6 = (n3 ^ 0xFF) * n4 >> 8;
        int n7 = n3 * (n4 ^ 0xFF) >> 8;
        int n8 = (n3 ^ 0xFF) * (n4 ^ 0xFF) >> 8;
        int n9 = (int)d2;
        if (d > this.xMax) {
            if (d > this.maxX[n9]) {
                return;
            }
            this.maxX[n9] = d;
            d = (int)this.xMax;
        }
        if (d < this.xMin) {
            if (d < this.minX[n9]) {
                return;
            }
            this.minX[n9] = d;
            d = (int)this.xMin;
        }
        int n10 = (int)d;
        int n11 = n9 * this.bufferWidth;
        int n12 = 0;
        int n13 = this.buffer[n11] & 0xFFFF;
        while (true) {
            if (n10 >= n12 && n10 < n13) {
                int n14 = this.buffer[n11 + n12];
                n14 &= 0xC0000000;
                if (n10 != n12) {
                    this.buffer[n11 + n12] = n10 | n14;
                    this.buffer[n11 + n10] = n13 | Integer.MIN_VALUE;
                    break;
                }
                this.buffer[n11 + n12] = n13 | Integer.MIN_VALUE | n14;
                break;
            }
            n12 = n13;
            if (n12 == this.bufferWidth) break;
            n13 = this.buffer[n12 + n11] & 0xFFFF;
        }
    }

    private void setEndSegment(double d, double d2) {
        int n = (int)(d * 256.0) & 0xFF;
        int n2 = (int)(d2 * 256.0) & 0xFF;
        int n3 = n ^ 0xFF;
        int n4 = n2 ^ 0xFF;
        int n5 = n3 * n4 >> 8;
        int n6 = (n3 ^ 0xFF) * n4 >> 8;
        int n7 = n3 * (n4 ^ 0xFF) >> 8;
        int n8 = (n3 ^ 0xFF) * (n4 ^ 0xFF) >> 8;
        int n9 = (int)d2;
        if (d > this.xMax) {
            if (d > this.maxX[n9]) {
                return;
            }
            this.maxX[n9] = d;
            d = (int)this.xMax;
        }
        if (d < this.xMin) {
            if (d < this.minX[n9]) {
                return;
            }
            this.minX[n9] = d;
            d = (int)this.xMin;
        }
        int n10 = (int)d;
        int n11 = n9 * this.bufferWidth;
        int n12 = 0;
        int n13 = this.buffer[n11] & 0xFFFF;
        while (true) {
            if (n10 >= n12 && n10 < n13) {
                int n14 = this.buffer[n11 + n12];
                n14 &= 0xC0000000;
                if (n10 != n12) {
                    this.buffer[n11 + n12] = n10 | n14;
                    this.buffer[n11 + n10] = n13 | 0x40000000;
                    break;
                }
                this.pixels[n9 * this.bufferWidth + n10] = -256;
                this.buffer[n11 + n12] = n13 | 0x40000000 | n14;
                break;
            }
            n12 = n13;
            if (n12 == this.bufferWidth) break;
            n13 = this.buffer[n12 + n11] & 0xFFFF;
        }
    }

    private int getPixel(int n) {
        return this.pixels[n];
    }

    private void setPixel(int n, int n2) {
        this.pixels[n] = n2;
    }
}

