/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.ICamera3D;
import net.dzzd.access.IFace3D;
import net.dzzd.access.ILight3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.access.IScene;
import net.dzzd.access.IScene3D;
import net.dzzd.access.ITexture;
import net.dzzd.core.DirectInput;
import net.dzzd.core.Drawer;
import net.dzzd.core.Face3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Mesh3DOctree;
import net.dzzd.core.Render3D;
import net.dzzd.core.Scene3DObject;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;

public final class Render3DSW
extends Render3D {
    private int renderPixelWidth;
    private int renderPixelHeight;
    private double renderPixelWidthDiv2;
    private double renderPixelHeightDiv2;
    private int[] zBuffer;
    private double[] zBufferIzMin;
    private double[] zBufferIzInc;
    private int[] zBufferO;
    private int[] zBufferP;
    private int[] zBufferF;
    private double noFaceZ;
    private double noFaceIZ;
    private double noFaceX1;
    private int noFaceY1;
    private double noFaceX2;
    private int noFaceY2;
    private int nbRenderedFace;
    private int nbRenderedMesh;
    private int[] vLinesBufferMin;
    private double[] vLinesBufferMinX;
    private double[] vLinesBufferMinIncX;
    private double[] vLinesBufferMinIz;
    private double[] vLinesBufferMinIncIz;
    private int[] vLinesBufferMax;
    private double[] vLinesBufferMaxX;
    private double[] vLinesBufferMaxIncX;
    private double[] vLinesBufferMaxIz;
    private double[] vLinesBufferMaxIncIz;
    private int hLinesBufferMin;
    private int hLinesBufferMax;
    private int zBufferMode;
    static final int ZB_WRITE = 1;
    static final int ZB_ALPHA = 2;
    static final int ZB_TEST = 4;
    Drawer drawer;
    int lastRenderBackgroundOffset;
    int firstRenderBackgroundOffset;
    Face3D firstAlphaFace;
    Face3D lastAlphaFace;
    private CompiledMesh firstMeshToRender;
    private CompiledMesh[] compiledMeshes;
    private CompiledMaterial[] compiledMaterials;
    private boolean zBufferTest;
    double p21yd = 0.0;
    double coeffAX = 0.0;
    double coeffBX = 0.0;
    double coeffAZ = 0.0;
    double coeffBZ = 0.0;

    public Render3DSW() {
        this.directInput = new DirectInput(this.canvas);
        this.drawer = new Drawer();
        this.initCompiledBuffers();
    }

    private final void initCompiledBuffers() {
        this.compiledMeshes = new CompiledMesh[65536];
        this.compiledMaterials = new CompiledMaterial[1024];
        this.firstMeshToRender = null;
        this.firstRenderBackgroundOffset = -1;
        this.resetBuffers();
    }

    public final void clearScene(IScene iScene) {
        super.clearScene(iScene);
        this.initCompiledBuffers();
    }

    protected final void disposeMesh3D(IMesh3D iMesh3D) {
        int n = iMesh3D.getId();
        CompiledMesh compiledMesh = this.compiledMeshes[n + 1];
        do {
            this.compiledMeshes[n++] = compiledMesh;
        } while ((compiledMesh = this.compiledMeshes[n + 1]) != null);
    }

    protected final void disposeCamera3D(ICamera3D iCamera3D) {
    }

    protected final void disposeLight3D(ILight3D iLight3D) {
    }

    protected final void disposeTexture(ITexture iTexture) {
    }

    protected final void disposeMaterial(IMaterial iMaterial) {
        int n = iMaterial.getId();
        CompiledMaterial compiledMaterial = this.compiledMaterials[n + 1];
        do {
            this.compiledMaterials[n++] = compiledMaterial;
        } while ((compiledMaterial = this.compiledMaterials[n + 1]) != null);
    }

    protected final void compileMesh3D(IMesh3D iMesh3D) {
        super.compileMesh3D(iMesh3D);
        this.compiledMeshes[iMesh3D.getId()] = new CompiledMesh((Mesh3D)iMesh3D);
    }

    protected final void compileMaterial(IMaterial iMaterial) {
        CompiledMaterial compiledMaterial;
        super.compileMaterial(iMaterial);
        this.compiledMaterials[iMaterial.getId()] = compiledMaterial = new CompiledMaterial((Material)iMaterial);
    }

    public final void setSize(int n, int n2, int n3) {
        super.setSize(n, n2, n3);
        this.renderPixelWidth = this.viewPixelWidth;
        this.renderPixelHeight = this.viewPixelHeight;
        if ((this.antialias & 2) != 0) {
            this.renderPixelWidth <<= 1;
        }
        if ((this.antialias & 4) != 0) {
            this.renderPixelHeight <<= 1;
        }
        this.minXValue = 0;
        this.maxXValue = this.renderPixelWidth;
        this.minYValue = 0;
        this.maxYValue = this.renderPixelHeight - 1;
        this.renderPixelWidthDiv2 = this.renderPixelWidth >> 1;
        this.renderPixelHeightDiv2 = this.renderPixelHeight >> 1;
        this.initBuffers();
        this.resetBuffers();
    }

    protected final void startFrame(IScene3D iScene3D) {
        this.drawer.setRender3DSW(this);
        this.resetBuffers();
    }

    private final void renderFrameCoherence(IScene3D iScene3D) {
        this.zBufferTest = false;
        CompiledMesh compiledMesh = this.getFirstMeshToRender();
        while (compiledMesh != null) {
            Mesh3D mesh3D = compiledMesh.mesh;
            if (mesh3D.isVisible()) {
                if ((mesh3D.renderMode & 1) != 0) {
                    this.prepareMesh3DLocalLight3DBuffer(iScene3D, mesh3D);
                }
                if (mesh3D.getMesh3DViewGenerator() == null) {
                    this.setCurrentMesh3D(mesh3D);
                    CompiledFace compiledFace = compiledMesh.firstFaceToRender;
                    while (compiledFace != null) {
                        this.setFaces3DToZBuffer(mesh3D.faces3D, compiledFace.face.id);
                        compiledFace.lastZbufferImage = this.numImage;
                        compiledFace = compiledFace.nextFaceToRender;
                    }
                }
            }
            compiledMesh = this.getNextMeshToRender(compiledMesh);
        }
        this.zBufferTest = true;
    }

    protected final void renderFrame(IScene3D iScene3D) {
        this.zBufferMode = 1;
        this.firstAlphaFace = null;
        this.lastAlphaFace = null;
        this.renderFrameCoherence(iScene3D);
        super.renderFrame(iScene3D);
    }

    protected final void endFrame(IScene3D iScene3D) {
        if (!this.isPixelUpdateEnabled) {
            return;
        }
        this.prepareFaceBuffer(iScene3D);
        if (iScene3D.isBackgroundEnabled()) {
            this.renderBackground(iScene3D);
        }
        this.renderMesh3D(iScene3D);
        this.drawer.antialiasPixels();
        if (this.isScreenUpdateEnabled) {
            this.drawer.drawPixelsOnCanvas(this.canvas);
        }
    }

    private final void initBuffers() {
        this.zBuffer = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferIzMin = new double[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferIzInc = new double[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferO = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferP = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferF = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.vLinesBufferMin = new int[this.renderPixelHeight];
        this.vLinesBufferMinX = new double[this.renderPixelHeight];
        this.vLinesBufferMinIncX = new double[this.renderPixelHeight];
        this.vLinesBufferMinIz = new double[this.renderPixelHeight];
        this.vLinesBufferMinIncIz = new double[this.renderPixelHeight];
        this.vLinesBufferMax = new int[this.renderPixelHeight];
        this.vLinesBufferMaxX = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIncX = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIz = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIncIz = new double[this.renderPixelHeight];
        this.drawer.setBuffers(this, this.zBuffer, this.zBufferF);
    }

    private final void resetBuffers() {
        int n = 0;
        for (int i = 0; i < this.renderPixelHeight; ++i) {
            this.zBuffer[n] = this.renderPixelWidth;
            this.zBufferIzMin[n] = this.iZMax;
            this.zBufferIzInc[n] = 0.0;
            this.zBufferO[n] = -1;
            this.zBufferP[n] = -1;
            n += this.renderPixelWidth;
        }
    }

    public final void setAntialiasLevel(int n) {
        if (n == this.antialias) {
            return;
        }
        this.firstMeshToRender = null;
        this.firstRenderBackgroundOffset = -1;
        super.setAntialiasLevel(n);
    }

    protected final void renderBackground(IScene3D iScene3D) {
        if (this.firstRenderBackgroundOffset == -1) {
            return;
        }
        this.drawer.drawBackground(this.firstRenderBackgroundOffset, this.lastRenderBackgroundOffset, iScene3D.getBackgroundColor());
    }

    protected final void setMesh3DToZBuffer(IMesh3D iMesh3D) {
        this.setFaces3DToZBuffer(iMesh3D.getFaces3D(), -1);
    }

    protected final void setMesh3DOctreeToZBuffer(IMesh3DOctree iMesh3DOctree) {
        this.setFaces3DToZBuffer(iMesh3DOctree.getFaces3D(), -1);
    }

    protected final int isSphereVisible(double d, double d2, double d3, double d4) {
        int n = super.isSphereVisible(d, d2, d3, d4);
        if (!this.zBufferTest || n == 0) {
            return n;
        }
        n = this.isSphereVisibleInZBuffer(d, d2, d3, d4);
        return n;
    }

    private final int isSphereVisibleInZBuffer(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5 = this.ox + this.axx * d + this.ayx * d2 + this.azx * d3;
        double d6 = this.oy + this.axy * d + this.ayy * d2 + this.azy * d3;
        double d7 = this.oz + this.axz * d + this.ayz * d2 + this.azz * d3;
        if (d5 * d5 + d6 * d6 + d7 * d7 <= d4 * d4) {
            return 1;
        }
        double d8 = d7 - d4;
        if (d8 <= this.zMin) {
            return 1;
        }
        double d9 = d7 + d4;
        double d10 = 1.0 / d7;
        double d11 = 1.0 / d8;
        double d12 = 1.0 / d9;
        double d13 = d4 * this.screenZoomXFocus * d11;
        double d14 = d4 * this.screenZoomYFocus * d11;
        if (d13 > this.renderPixelWidthDiv2 && d14 > this.renderPixelHeightDiv2) {
            return 1;
        }
        int n4 = (int)((d5 - d4) * this.screenZoomXFocus * d11 + this.renderPixelWidthDiv2);
        int n5 = (int)((d5 + d4) * this.screenZoomXFocus * d11 + this.renderPixelWidthDiv2);
        int n6 = (int)((d5 - d4) * this.screenZoomXFocus * d12 + this.renderPixelWidthDiv2);
        int n7 = (int)((d5 + d4) * this.screenZoomXFocus * d12 + this.renderPixelWidthDiv2);
        int n8 = (int)((d6 - d4) * this.screenZoomXFocus * d11 + this.renderPixelHeightDiv2);
        int n9 = (int)((d6 + d4) * this.screenZoomXFocus * d11 + this.renderPixelHeightDiv2);
        int n10 = (int)((d6 - d4) * this.screenZoomXFocus * d12 + this.renderPixelHeightDiv2);
        int n11 = (int)((d6 + d4) * this.screenZoomXFocus * d12 + this.renderPixelHeightDiv2);
        int n12 = n4;
        if (n5 < n12) {
            n12 = n5;
        }
        if (n6 < n12) {
            n12 = n6;
        }
        if (n7 < n12) {
            n12 = n7;
        }
        if (n5 > (n3 = n4)) {
            n3 = n5;
        }
        if (n6 > n3) {
            n3 = n6;
        }
        if (n7 > n3) {
            n3 = n7;
        }
        if (n9 < (n2 = n8)) {
            n2 = n9;
        }
        if (n10 < n2) {
            n2 = n10;
        }
        if (n11 < n2) {
            n2 = n11;
        }
        if (n9 > (n = n8)) {
            n = n9;
        }
        if (n10 > n) {
            n = n10;
        }
        if (n11 > n) {
            n = n11;
        }
        if (this.minXValue > n3) {
            return 0;
        }
        if (this.maxXValue < n12) {
            return 0;
        }
        if (this.minYValue > n) {
            return 0;
        }
        if (this.maxYValue < n2) {
            return 0;
        }
        if (this.minXValue > n12) {
            n12 = this.minXValue;
        }
        if (this.maxXValue < n3) {
            n3 = this.maxXValue;
        }
        if (this.minYValue > n2) {
            n2 = this.minYValue;
        }
        if (this.maxYValue < n) {
            n = this.maxYValue;
        }
        return this.isSquareVisibleInZBuffer(n12, n2, n3, n, d11);
    }

    private final int isSquareVisibleInZBuffer(int n, int n2, int n3, int n4, double d) {
        this.hLinesBufferMin = n2;
        this.hLinesBufferMax = n4;
        this.vLinesBufferMin[n2] = n4;
        this.vLinesBufferMinX[n2] = n;
        this.vLinesBufferMinIncX[n2] = 0.0;
        this.vLinesBufferMinIz[n2] = d;
        this.vLinesBufferMinIncIz[n2] = 0.0;
        this.vLinesBufferMax[n2] = n4;
        this.vLinesBufferMaxX[n2] = n3;
        this.vLinesBufferMaxIncX[n2] = 0.0;
        this.vLinesBufferMaxIz[n2] = d;
        this.vLinesBufferMaxIncIz[n2] = 0.0;
        int n5 = this.zBufferMode;
        this.zBufferMode = 4;
        int n6 = this.pasteHLine(null);
        this.zBufferMode = n5;
        return n6;
    }

    private final CompiledFace getCompiledFace(int n, int n2) {
        return this.compiledMeshes[n].compiledFaces[n2];
    }

    protected final int setFaces3DToZBuffer(IFace3D[] iFace3DArray, int n) {
        int n2 = 0;
        Face3D[] face3DArray = (Face3D[])iFace3DArray;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = face3DArray.length;
        int n4 = 0;
        if (n >= 0) {
            n4 = n;
            n3 = n + 1;
        }
        while (n4 < n3) {
            block45: {
                CompiledFace compiledFace;
                Face3D face3D;
                block47: {
                    double d5;
                    double d6;
                    block46: {
                        double d7;
                        double d8;
                        double d9;
                        double d10;
                        double d11;
                        double d12;
                        double d13;
                        double d14;
                        double d15;
                        double d16;
                        double d17;
                        double d18;
                        double d19;
                        double d20;
                        double d21;
                        double d22;
                        double d23;
                        double d24;
                        double d25;
                        double d26;
                        block44: {
                            face3D = face3DArray[n4];
                            if ((this.zBufferMode & 2) != 0 || face3D.material == null || face3D.material.alphaLevel == 0) break block44;
                            face3D.nextAlphaFace = null;
                            if (this.firstAlphaFace == null) {
                                this.firstAlphaFace = face3D;
                                this.lastAlphaFace = face3D;
                            } else {
                                face3D.nextAlphaFace = this.firstAlphaFace;
                                this.firstAlphaFace = face3D;
                            }
                            break block45;
                        }
                        compiledFace = this.getCompiledFace(face3D.object.id, face3D.id);
                        if (compiledFace.lastZbufferImage == this.numImage) break block45;
                        compiledFace.lastZbufferImage = this.numImage;
                        if (compiledFace.lastRenderImage == this.numImage || (d26 = (double)face3D.pa * this.px + (double)face3D.pb * this.py + (double)face3D.pc * this.pz + (double)face3D.pd) < -0.0 || (d25 = (double)face3D.pa * (this.nx - this.px) + (double)face3D.pb * (this.ny - this.py) + (double)face3D.pc * (this.nz - this.pz)) > this.maxFaceViewAngleCos) break block45;
                        double d27 = this.maxYValue;
                        double d28 = this.minYValue;
                        double d29 = this.maxXValue;
                        double d30 = this.minXValue;
                        double d31 = this.zMax;
                        double d32 = this.zMin;
                        this.hLinesBufferMin = 0x7FFFFFFE;
                        this.hLinesBufferMax = -2147483646;
                        Vertex3D vertex3D = face3D.p2;
                        if (vertex3D.cameraPositionEvaluated != this.numImage) {
                            vertex3D.cameraPositionEvaluated = this.numImage;
                            d24 = vertex3D.x;
                            d23 = vertex3D.y;
                            d22 = vertex3D.z;
                            d21 = this.ox + this.axx * d24 + this.ayx * d23 + this.azx * d22;
                            d20 = this.oy + this.axy * d24 + this.ayy * d23 + this.azy * d22;
                            d19 = this.oz + this.axz * d24 + this.ayz * d23 + this.azz * d22;
                            d18 = 1.0 / d19;
                            d17 = d21 * this.screenZoomXFocus * d18 + this.renderPixelWidthDiv2;
                            d16 = d20 * this.screenZoomYFocus * d18 + this.renderPixelHeightDiv2;
                            if (d19 < 0.0) {
                                d17 = -d17;
                                d16 = -d16;
                            }
                            vertex3D.tX = d21;
                            vertex3D.tY = d20;
                            vertex3D.xs = d17;
                            vertex3D.ys = d16;
                            vertex3D.iZs = d18;
                            vertex3D.tZ = d19;
                        } else {
                            d17 = vertex3D.xs;
                            d16 = vertex3D.ys;
                            d19 = vertex3D.tZ;
                        }
                        d21 = vertex3D.tX;
                        d20 = vertex3D.tY;
                        d18 = vertex3D.tZ;
                        double d33 = face3D.sphereBox;
                        double d34 = d18 - d33;
                        double d35 = d18 + d33;
                        if (d35 <= this.zMin || d34 >= this.zMax || this.RA * d21 + this.RB * d20 + this.RC * d18 >= d33 || this.LA * d21 + this.LB * d20 + this.LC * d18 >= d33 || this.UA * d21 + this.UB * d20 + this.UC * d18 >= d33 || this.DA * d21 + this.DB * d20 + this.DC * d18 >= d33) break block45;
                        vertex3D = face3D.p0;
                        if (vertex3D.cameraPositionEvaluated != this.numImage) {
                            vertex3D.cameraPositionEvaluated = this.numImage;
                            d24 = vertex3D.x;
                            d23 = vertex3D.y;
                            d22 = vertex3D.z;
                            d15 = this.ox + this.axx * d24 + this.ayx * d23 + this.azx * d22;
                            d14 = this.oy + this.axy * d24 + this.ayy * d23 + this.azy * d22;
                            d13 = this.oz + this.axz * d24 + this.ayz * d23 + this.azz * d22;
                            d12 = 1.0 / d13;
                            d11 = d15 * this.screenZoomXFocus * d12 + this.renderPixelWidthDiv2;
                            d10 = d14 * this.screenZoomYFocus * d12 + this.renderPixelHeightDiv2;
                            if (d13 < 0.0) {
                                d11 = -d11;
                                d10 = -d10;
                            }
                            vertex3D.tX = d15;
                            vertex3D.tY = d14;
                            vertex3D.xs = d11;
                            vertex3D.ys = d10;
                            vertex3D.iZs = d12;
                            vertex3D.tZ = d13;
                        } else {
                            d11 = vertex3D.xs;
                            d10 = vertex3D.ys;
                            d13 = vertex3D.tZ;
                            d15 = vertex3D.tX;
                            d14 = vertex3D.tY;
                        }
                        vertex3D = face3D.p1;
                        if (vertex3D.cameraPositionEvaluated != this.numImage) {
                            vertex3D.cameraPositionEvaluated = this.numImage;
                            d24 = vertex3D.x;
                            d23 = vertex3D.y;
                            d22 = vertex3D.z;
                            d12 = this.ox + this.axx * d24 + this.ayx * d23 + this.azx * d22;
                            d6 = this.oy + this.axy * d24 + this.ayy * d23 + this.azy * d22;
                            d9 = this.oz + this.axz * d24 + this.ayz * d23 + this.azz * d22;
                            d5 = 1.0 / d9;
                            d8 = d12 * this.screenZoomXFocus * d5 + this.renderPixelWidthDiv2;
                            d7 = d6 * this.screenZoomYFocus * d5 + this.renderPixelHeightDiv2;
                            if (d9 < 0.0) {
                                d8 = -d8;
                                d7 = -d7;
                            }
                            vertex3D.tX = d12;
                            vertex3D.tY = d6;
                            vertex3D.xs = d8;
                            vertex3D.ys = d7;
                            vertex3D.iZs = d5;
                            vertex3D.tZ = d9;
                        } else {
                            d8 = vertex3D.xs;
                            d7 = vertex3D.ys;
                            d9 = vertex3D.tZ;
                        }
                        if (d13 > d32) {
                            d32 = d13;
                        }
                        if (d13 < d31) {
                            d31 = d13;
                        }
                        if (d9 > d32) {
                            d32 = d9;
                        }
                        if (d9 < d31) {
                            d31 = d9;
                        }
                        if (d19 > d32) {
                            d32 = d19;
                        }
                        if (d19 < d31) {
                            d31 = d19;
                        }
                        if (d32 <= this.zMin || d31 >= this.zMax) break block45;
                        if (d10 < d27) {
                            d27 = d10;
                        }
                        if (d10 > d28) {
                            d28 = d10;
                        }
                        if (d7 < d27) {
                            d27 = d7;
                        }
                        if (d7 > d28) {
                            d28 = d7;
                        }
                        if (d16 < d27) {
                            d27 = d16;
                        }
                        if (d16 > d28) {
                            d28 = d16;
                        }
                        if (d28 <= (double)this.minYValue || d27 >= (double)this.maxYValue || d28 <= d27 + 5.0E-4) break block45;
                        if (d11 < d29) {
                            d29 = d11;
                        }
                        if (d11 > d30) {
                            d30 = d11;
                        }
                        if (d8 < d29) {
                            d29 = d8;
                        }
                        if (d8 > d30) {
                            d30 = d8;
                        }
                        if (d17 < d29) {
                            d29 = d17;
                        }
                        if (d17 > d30) {
                            d30 = d17;
                        }
                        if (d30 <= (double)this.minXValue || d29 >= (double)this.maxXValue || d30 <= d29 + 5.0E-4) break block45;
                        if (!(d31 >= this.zMin)) break block46;
                        this.setHLigne(d11, d10, face3D.p0.iZs, d8, d7, face3D.p1.iZs);
                        this.setHLigne(d8, d7, face3D.p1.iZs, d17, d16, face3D.p2.iZs);
                        this.setHLigne(d17, d16, face3D.p2.iZs, d11, d10, face3D.p0.iZs);
                        break block47;
                    }
                    boolean bl = false;
                    Vertex3D vertex3D = face3D.p0;
                    Vertex3D vertex3D2 = face3D.p1;
                    for (int i = 0; i < 3; ++i) {
                        double d36;
                        double d37;
                        double d38;
                        double d39;
                        double d40;
                        double d41;
                        double d42;
                        double d43;
                        d6 = vertex3D.tZ;
                        d5 = vertex3D2.tZ;
                        if (d6 >= this.zMin && d5 >= this.zMin) {
                            this.setHLigne(vertex3D.xs, vertex3D.ys, vertex3D.iZs, vertex3D2.xs, vertex3D2.ys, vertex3D2.iZs);
                        } else if (d6 < this.zMin && d5 >= this.zMin) {
                            d43 = vertex3D.tX;
                            d42 = vertex3D.tY;
                            d41 = vertex3D2.tX - d43;
                            d40 = vertex3D2.tY - d42;
                            d39 = vertex3D2.tZ - d6;
                            d38 = 1.0 / d39;
                            d37 = (this.zMin - d6) * d41 * d38 + d43;
                            d36 = (this.zMin - d6) * d40 * d38 + d42;
                            d = d37 * this.screenZoomXFocus * this.iZMin + this.renderPixelWidthDiv2;
                            d2 = d36 * this.screenZoomYFocus * this.iZMin + this.renderPixelHeightDiv2;
                            this.setHLigne(d, d2, this.iZMin, vertex3D2.xs, vertex3D2.ys, vertex3D2.iZs);
                            bl = true;
                        } else if (d5 < this.zMin && d6 >= this.zMin) {
                            d43 = vertex3D2.tX;
                            d42 = vertex3D2.tY;
                            d41 = vertex3D.tX - d43;
                            d40 = vertex3D.tY - d42;
                            d39 = vertex3D.tZ - d5;
                            d38 = 1.0 / d39;
                            d37 = (this.zMin - d5) * d41 * d38 + d43;
                            d36 = (this.zMin - d5) * d40 * d38 + d42;
                            d3 = d37 * this.screenZoomXFocus * this.iZMin + this.renderPixelWidthDiv2;
                            d4 = d36 * this.screenZoomYFocus * this.iZMin + this.renderPixelHeightDiv2;
                            this.setHLigne(vertex3D.xs, vertex3D.ys, vertex3D.iZs, d3, d4, this.iZMin);
                            bl = true;
                        }
                        vertex3D = vertex3D2;
                        vertex3D2 = i == 0 ? face3D.p2 : face3D.p0;
                    }
                    if (!bl) break block45;
                    this.setHLigne(d3, d4, this.iZMin, d, d2, this.iZMin);
                }
                if (this.hLinesBufferMax > this.hLinesBufferMin) {
                    compiledFace.lastRenderOffset = -1;
                    compiledFace.firstRenderOffset = -1;
                    if (this.pasteHLine(compiledFace) != 0) {
                        n2 = 1;
                    }
                    if ((this.zBufferMode & 2) != 0 && compiledFace.firstRenderOffset != -1) {
                        this.drawer.setMesh3D(face3D.object);
                        if ((face3D.object.renderMode & 1) != 0) {
                            this.prepareMesh3DLocalLight3DBuffer(face3D.object.getScene3D(), face3D.object);
                        }
                        this.drawer.drawFace3D(this.compiledMeshes[face3D.object.id].compiledFaces[face3D.id], true);
                    }
                }
            }
            ++n4;
        }
        return n2;
    }

    private final void setHLigne(double d, double d2, double d3, double d4, double d5, double d6) {
        int n;
        int n2;
        boolean bl = true;
        if (d2 > d5) {
            bl = false;
            double d7 = d;
            double d8 = d2;
            double d9 = d3;
            d = d4;
            d2 = d5;
            d3 = d6;
            d4 = d7;
            d5 = d8;
            d6 = d9;
        }
        if (d2 > (double)this.maxYValue) {
            return;
        }
        if (d5 < (double)this.minYValue) {
            return;
        }
        if (d5 - d2 == 0.0) {
            return;
        }
        this.p21yd = 1.0 / (d5 - d2);
        this.coeffAX = (d4 - d) * this.p21yd;
        this.coeffBX = d - this.coeffAX * d2;
        this.coeffAZ = (d6 - d3) * this.p21yd;
        this.coeffBZ = d3 - this.coeffAZ * d2;
        if (d2 < (double)this.minYValue) {
            d = this.coeffAX * (double)this.minYValue + this.coeffBX;
            d3 = this.coeffAZ * (double)this.minYValue + this.coeffBZ;
            d2 = this.minYValue;
        }
        if (d5 > (double)this.maxYValue) {
            d4 = this.coeffAX * (double)this.maxYValue + this.coeffBX;
            d6 = this.coeffAZ * (double)this.maxYValue + this.coeffBZ;
            d5 = this.maxYValue;
        }
        if ((n2 = (int)d2) == (n = (int)d5)) {
            return;
        }
        if (n > this.hLinesBufferMax) {
            this.hLinesBufferMax = n;
        }
        if (n2 < this.hLinesBufferMin) {
            this.hLinesBufferMin = n2;
        }
        if (bl) {
            this.vLinesBufferMin[n2] = n;
            this.vLinesBufferMinX[n2] = d;
            this.vLinesBufferMinIncX[n2] = this.coeffAX;
            this.vLinesBufferMinIz[n2] = d3;
            this.vLinesBufferMinIncIz[n2] = this.coeffAZ;
        } else {
            this.vLinesBufferMax[n2] = n;
            this.vLinesBufferMaxX[n2] = d;
            this.vLinesBufferMaxIncX[n2] = this.coeffAX;
            this.vLinesBufferMaxIz[n2] = d3;
            this.vLinesBufferMaxIncIz[n2] = this.coeffAZ;
        }
    }

    private final int pasteHLine(CompiledFace compiledFace) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = this.hLinesBufferMin * this.renderPixelWidth;
        int n4 = this.vLinesBufferMin[this.hLinesBufferMin];
        double d3 = this.vLinesBufferMinX[this.hLinesBufferMin];
        double d4 = this.vLinesBufferMinIncX[this.hLinesBufferMin];
        double d5 = this.vLinesBufferMinIz[this.hLinesBufferMin];
        double d6 = this.vLinesBufferMinIncIz[this.hLinesBufferMin];
        int n5 = this.vLinesBufferMax[this.hLinesBufferMin];
        double d7 = this.vLinesBufferMaxX[this.hLinesBufferMin];
        double d8 = this.vLinesBufferMaxIncX[this.hLinesBufferMin];
        double d9 = this.vLinesBufferMaxIz[this.hLinesBufferMin];
        double d10 = this.vLinesBufferMaxIncIz[this.hLinesBufferMin];
        double d11 = d3;
        double d12 = d7;
        double d13 = d5;
        double d14 = d9;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.hLinesBufferMin;
        while (n8 < this.hLinesBufferMax) {
            block58: {
                if (n8 != this.hLinesBufferMin) {
                    n3 += this.renderPixelWidth;
                    d11 = d3 + d4 * (double)n6;
                    d12 = d7 + d8 * (double)n7;
                    d13 = d5 + d6 * (double)n6;
                    d14 = d9 + d10 * (double)n7;
                    if (n8 == n4) {
                        n4 = this.vLinesBufferMin[n8];
                        d3 = this.vLinesBufferMinX[n8];
                        d4 = this.vLinesBufferMinIncX[n8];
                        d5 = this.vLinesBufferMinIz[n8];
                        d6 = this.vLinesBufferMinIncIz[n8];
                        n6 = 0;
                        d11 = d3;
                        d13 = d5;
                    }
                    if (n8 == n5) {
                        n5 = this.vLinesBufferMax[n8];
                        d7 = this.vLinesBufferMaxX[n8];
                        d8 = this.vLinesBufferMaxIncX[n8];
                        d9 = this.vLinesBufferMaxIz[n8];
                        d10 = this.vLinesBufferMaxIncIz[n8];
                        n7 = 0;
                        d12 = d7;
                        d14 = d9;
                    }
                }
                double d15 = d11;
                double d16 = d12;
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = d16 - d15;
                if (d15 >= (double)this.maxXValue) {
                    if (d4 > 0.0) {
                        return 0;
                    }
                } else {
                    if (d15 < (double)this.minXValue) {
                        d17 = (double)this.minXValue - d15;
                        d15 = this.minXValue;
                    }
                    if (d16 <= (double)this.minXValue) {
                        if (d8 < 0.0) {
                            return 0;
                        }
                    } else {
                        int n9;
                        int n10;
                        if (d16 > (double)this.maxXValue) {
                            d18 = d16 - (double)this.maxXValue;
                            d16 = this.maxXValue;
                        }
                        if ((n10 = (int)d16) > (n9 = (int)d15)) {
                            int n11;
                            double d20;
                            double d21;
                            double d22 = d13;
                            double d23 = d14;
                            double d24 = (d23 - d22) / d19;
                            d22 += d24 * d17;
                            d23 -= d24 * d18;
                            if (d24 > 0.0) {
                                d21 = d22;
                                d20 = d23;
                            } else {
                                d21 = d23;
                                d20 = d22;
                            }
                            boolean bl = false;
                            int n12 = 0;
                            int n13 = this.zBuffer[n3] & 0xFFFF;
                            while (n9 >= n13) {
                                n12 = n13;
                                n13 = this.zBuffer[n3 + n13] & 0xFFFF;
                            }
                            int n14 = n12;
                            while (n10 > (n11 = n14) && n11 < this.renderPixelWidth) {
                                int n15;
                                int n16;
                                int n17;
                                int n18;
                                double d25;
                                boolean bl2;
                                int n19 = n3 + n11;
                                n14 = this.zBuffer[n19] & 0xFFFF;
                                double d26 = this.zBufferIzMin[n19];
                                double d27 = this.zBufferIzInc[n19];
                                double d28 = d26 + d27 * (double)(n14 - n11);
                                double d29 = d26;
                                double d30 = d28;
                                if (d27 > 0.0) {
                                    d29 = d26;
                                    d30 = d28;
                                } else {
                                    d29 = d28;
                                    d30 = d26;
                                }
                                boolean bl3 = d20 <= d29;
                                boolean bl4 = bl2 = d21 >= d30;
                                if (!bl) {
                                    if (bl3) {
                                        if (n10 > n14) continue;
                                        break block58;
                                    }
                                    if (n9 <= n11) {
                                        if (bl2) {
                                            d = n11;
                                            bl = true;
                                        } else if (d22 + (double)(n11 - n9) * d24 + d24 > d26 + d27) {
                                            d = n11;
                                            bl = true;
                                        } else {
                                            if (d24 <= d27) {
                                                if (n10 > n14) continue;
                                                break block58;
                                            }
                                            if (d22 + (double)(n14 - n9) * d24 - d24 > d28 - d27) {
                                                d25 = (d26 - (double)n11 * d27 - (d22 - (double)n9 * d24)) / (d24 - d27);
                                                n18 = (int)d25;
                                                if (n18 <= n11) {
                                                    if (n10 > n14) {
                                                        continue;
                                                    }
                                                    break block58;
                                                }
                                                if (n18 < n14 && n18 < n10) {
                                                    d = d25;
                                                    bl = true;
                                                }
                                            }
                                        }
                                    } else if (bl2) {
                                        d = d15;
                                        bl = true;
                                    } else if (d22 + d24 > d26 + (double)(n9 - n11) * d27 + d27) {
                                        d = d15;
                                        bl = true;
                                    } else {
                                        double d31;
                                        if (d24 <= d27) {
                                            if (n10 > n14) continue;
                                            break block58;
                                        }
                                        if (d22 + (double)(n14 - n9) * d24 - d24 > d28 - d27 && (n18 = (int)(d31 = (d26 - (double)n11 * d27 - (d22 - (double)n9 * d24)) / (d24 - d27))) > n9 && n18 < n14 && n18 < n10) {
                                            d = d31;
                                            bl = true;
                                        }
                                    }
                                    if (!bl) continue;
                                    if ((this.zBufferMode & 4) != 0) {
                                        return 1;
                                    }
                                    n = (int)d;
                                    n2 = n11;
                                }
                                if (bl2) {
                                    if (n10 > n14) continue;
                                    d2 = n10;
                                    bl = false;
                                } else if (bl3) {
                                    d2 = n11;
                                    bl = false;
                                } else if (n < n11 && d22 + (double)(n11 - n9) * d24 + d24 < d26 + d27) {
                                    d2 = n11;
                                    bl = false;
                                } else if (n10 <= n14) {
                                    if (d23 - d24 >= d26 + (double)(n10 - n11 - 1) * d27) {
                                        d2 = d16;
                                        bl = false;
                                    } else {
                                        d25 = (d26 - (double)n11 * d27 - (d22 - (double)n9 * d24)) / (d24 - d27);
                                        n18 = (int)d25;
                                        d2 = n18 > n11 && n18 > n && n18 <= n10 ? d25 : (n18 >= n10 ? d16 : (n > n11 ? (double)(n + 1) : (double)(n11 + 1)));
                                        bl = false;
                                    }
                                } else if (d22 + (double)(n14 - n9 + 1) * d24 < d28 + d27 && (n18 = (int)(d25 = (d26 - (double)n11 * d27 - (d22 - (double)n9 * d24)) / (d24 - d27))) > n11 && n18 > n && n18 <= n14) {
                                    d2 = d25;
                                    bl = false;
                                }
                                if (bl) continue;
                                int n20 = (int)(d * 65536.0);
                                int n21 = (int)(d15 * 65536.0) >> 8 & 0xFF;
                                n18 = (int)(d2 * 65536.0);
                                int n22 = (int)(d16 * 65536.0) >> 8 & 0xFF;
                                int n23 = n18 >> 16;
                                if (n23 == n) {
                                    bl = false;
                                    continue;
                                }
                                if ((this.zBufferMode & 1) != 0 || (this.zBufferMode & 2) != 0) {
                                    if (n != n2) {
                                        n17 = this.zBuffer[n3 + n2] >> 16 & 0xFF;
                                        this.zBuffer[n3 + n2] = n | n17 << 16;
                                    }
                                    n17 = n3 + n11;
                                    n16 = this.zBufferO[n17];
                                    n15 = this.zBufferP[n17];
                                    int n24 = n3 + n;
                                    this.zBufferO[n24] = this.cMesh3D.id;
                                    this.zBufferP[n24] = compiledFace.face.id;
                                    this.zBuffer[n24] = n23 | n21 << 16;
                                    this.zBufferIzMin[n24] = d22 + d24 * (double)(n - n9);
                                    this.zBufferIzInc[n24] = d24;
                                    if (n23 != n14) {
                                        int n25 = n3 + n23;
                                        this.zBuffer[n25] = n14 | n22 << 16;
                                        this.zBufferO[n25] = n16;
                                        this.zBufferP[n25] = n15;
                                        this.zBufferIzMin[n25] = d26 + d27 * (double)(n23 - n11);
                                        this.zBufferIzInc[n25] = d27;
                                    }
                                }
                                if ((this.zBufferMode & 2) != 0 && n23 != n) {
                                    if (compiledFace.lastRenderImage != this.numImage) {
                                        compiledFace.lastRenderImage = this.numImage;
                                        compiledFace.lastRenderOffset = compiledFace.firstRenderOffset = n | n8 << 16 & 0xFFFF0000;
                                    } else {
                                        n17 = compiledFace.lastRenderOffset;
                                        n16 = n17 >> 16 & 0xFFFF;
                                        n15 = (n17 &= 0xFFFF) + n16 * this.renderPixelWidth;
                                        this.zBufferF[n15] = n | n8 << 16 & 0xFFFF0000;
                                        compiledFace.lastRenderOffset = n | n8 << 16 & 0xFFFF0000;
                                    }
                                }
                                n14 = n23;
                            }
                            if (bl) {
                                Log.log("erreur");
                            }
                        }
                    }
                }
            }
            ++n8;
            ++n6;
            ++n7;
        }
        return 0;
    }

    private final void prepareFaceBuffer(IScene3D iScene3D) {
        int n;
        int n2;
        int n3;
        CompiledMesh compiledMesh = null;
        CompiledFace compiledFace = null;
        this.firstRenderBackgroundOffset = -1;
        this.firstMeshToRender = null;
        this.nbRenderedFace = 0;
        this.nbRenderedMesh = 0;
        int n4 = -1;
        int n5 = -1;
        for (n3 = 0; n3 < this.renderPixelHeight; ++n3) {
            n2 = 0;
            n = n3 * this.renderPixelWidth;
            while (n2 != this.renderPixelWidth) {
                int n6;
                int n7;
                int n8;
                int n9 = n + n2;
                int n10 = this.zBuffer[n9] & 0xFFFF;
                int n11 = this.zBufferO[n9];
                if (n11 != -1) {
                    if (n11 != n4) {
                        compiledMesh = this.compiledMeshes[n11];
                        n4 = n11;
                        n5 = -1;
                    }
                    if (compiledMesh.lastRenderImage != this.numImage) {
                        compiledMesh.lastRenderImage = this.numImage;
                        compiledMesh.nbRenderFace = 0;
                        compiledMesh.firstFaceToRender = null;
                        compiledMesh.nextMeshToRender = this.firstMeshToRender;
                        this.firstMeshToRender = compiledMesh;
                        ++this.nbRenderedMesh;
                    }
                    if ((n8 = this.zBufferP[n9]) != n5) {
                        compiledFace = compiledMesh.compiledFaces[n8];
                        n5 = n8;
                    }
                    if (compiledFace.lastRenderImage != this.numImage) {
                        compiledFace.lastRenderImage = this.numImage;
                        compiledFace.nextFaceToRender = compiledMesh.firstFaceToRender;
                        compiledMesh.firstFaceToRender = compiledFace;
                        ++compiledMesh.nbRenderFace;
                        compiledFace.lastRenderOffset = compiledFace.firstRenderOffset = n2 | n3 << 16 & 0xFFFF0000;
                        ++this.nbRenderedFace;
                    } else {
                        n7 = compiledFace.lastRenderOffset;
                        n6 = n7 >> 16 & 0xFFFF;
                        int n12 = (n7 &= 0xFFFF) + n6 * this.renderPixelWidth;
                        this.zBufferF[n12] = n2 | n3 << 16 & 0xFFFF0000;
                        compiledFace.lastRenderOffset = n2 | n3 << 16 & 0xFFFF0000;
                    }
                } else if (this.firstRenderBackgroundOffset == -1) {
                    this.lastRenderBackgroundOffset = this.firstRenderBackgroundOffset = n2 | n3 << 16 & 0xFFFF0000;
                } else {
                    n8 = this.lastRenderBackgroundOffset;
                    n7 = n8 >> 16 & 0xFFFF;
                    n6 = (n8 &= 0xFFFF) + n7 * this.renderPixelWidth;
                    this.zBufferF[n6] = n2 | n3 << 16 & 0xFFFF0000;
                    this.lastRenderBackgroundOffset = n2 | n3 << 16 & 0xFFFF0000;
                }
                n2 = n10;
            }
        }
        n3 = this.lastRenderBackgroundOffset;
        n2 = n3 >> 16 & 0xFFFF;
        n = (n3 &= 0xFFFF) + n2 * this.renderPixelWidth;
        this.zBufferF[n] = this.renderPixelWidth - 1 | this.renderPixelHeight - 1 << 16 & 0xFFFF0000;
        this.lastRenderBackgroundOffset = this.renderPixelWidth - 1 | this.renderPixelHeight - 1 << 16 & 0xFFFF0000;
    }

    private final CompiledMesh getFirstMeshToRender() {
        return this.firstMeshToRender;
    }

    private final CompiledMesh getNextMeshToRender(CompiledMesh compiledMesh) {
        return compiledMesh.nextMeshToRender;
    }

    private final void renderMesh3D(IScene3D iScene3D) {
        Object object;
        CompiledMesh compiledMesh = this.getFirstMeshToRender();
        this.zBufferMode = 1;
        while (compiledMesh != null) {
            object = compiledMesh.mesh;
            if ((((Scene3DObject)object).renderMode & 1) != 0) {
                this.prepareMesh3DLocalLight3DBuffer(iScene3D, (Mesh3D)object);
            }
            this.drawer.setMesh3D((Mesh3D)object);
            CompiledFace compiledFace = compiledMesh.firstFaceToRender;
            while (compiledFace != null) {
                this.drawer.drawFace3D(compiledFace, false);
                compiledFace = compiledFace.nextFaceToRender;
            }
            compiledMesh = this.getNextMeshToRender(compiledMesh);
        }
        this.zBufferMode = 2;
        object = this.firstAlphaFace;
        while (object != null) {
            this.setCurrentMesh3D(((Face3D)object).object);
            this.setFaces3DToZBuffer(((Face3D)object).object.faces3D, ((Face3D)object).id);
            object = ((Face3D)object).nextAlphaFace;
        }
    }

    public final String getImplementationName() {
        return "SOFT";
    }

    public final int getRenderedMesh3DIdAt(int n, int n2) {
        if ((this.antialias & 2) != 0) {
            n *= 2;
        }
        if ((this.antialias & 4) != 0) {
            n2 *= 2;
        }
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                n3 = this.zBufferO[n7];
                break;
            }
            n4 = n10;
        }
        return n3;
    }

    public final int getRenderedFace3DIdAt(int n, int n2) {
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                n3 = this.zBufferP[n7];
                break;
            }
            n4 = n10;
        }
        return n3;
    }

    public final double getZAt(int n, int n2) {
        double d = 0.0;
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                int n12 = this.zBufferO[n7];
                int n13 = this.zBufferP[n7];
                if (n12 == -1) {
                    d = this.zMax;
                    break;
                }
                double d2 = this.zBufferIzMin[n7];
                double d3 = this.zBufferIzInc[n7];
                double d4 = d2 + d3 * (double)(n - n4);
                d = 1.0 / d4;
                break;
            }
            n4 = n10;
        }
        return d;
    }

    class CompiledMaterial {
        private static final int MAT_SIZE = 1024;
        Material material;
        int[] specularLightMap;

        CompiledMaterial(Material material) {
            this.material = material;
            this.specularLightMap = new int[1024];
            this.initSpecularLightMap();
        }

        public void initSpecularLightMap() {
            for (int i = 0; i < 1024; ++i) {
                int n = Math.min(i - 512, 256);
                double d = 1.0 * (double)n / 256.0;
                if (d < 0.0) {
                    d = 0.0;
                }
                if (d > 1.0) {
                    d = 1.0;
                }
                int n2 = (int)(d * 255.0);
                if ((n2 += this.material.selfIlluminationLevel * 255 / 100) > 255) {
                    n2 = 255;
                }
                if (this.material.specularLevel != 0) {
                    double d2 = (this.material.specularColor & 0xFF0000) >> 16;
                    double d3 = (this.material.specularColor & 0xFF00) >> 8;
                    double d4 = this.material.specularColor & 0xFF;
                    int n3 = (int)(Math.pow(d, this.material.specularPower) * (double)this.material.specularLevel);
                    int n4 = (int)(d2 *= (double)n3 / 256.0);
                    int n5 = (int)(d3 *= (double)n3 / 256.0);
                    int n6 = (int)(d4 *= (double)n3 / 256.0);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    this.specularLightMap[i] = n2 << 24 | (n4 << 16 | n5 << 8 | n6) & 0xFEFEFE;
                    continue;
                }
                this.specularLightMap[i] = n2 << 24;
            }
        }
    }

    class CompiledMesh {
        Mesh3D mesh;
        CompiledMesh nextMeshToRender;
        int lastRenderImage;
        int nbRenderFace;
        CompiledFace[] compiledFaces;
        CompiledFace firstFaceToRender;
        CompiledMesh3DOctree[] compiledMesh3DOctrees;

        CompiledMesh(Mesh3D mesh3D) {
            int n;
            this.mesh = mesh3D;
            this.nextMeshToRender = null;
            this.nbRenderFace = 0;
            this.lastRenderImage = -1;
            this.compiledFaces = new CompiledFace[mesh3D.getNbFace3D()];
            this.compiledMesh3DOctrees = null;
            for (n = 0; n < mesh3D.getNbFace3D(); ++n) {
                this.compiledFaces[n] = new CompiledFace((Face3D)mesh3D.getFace3D(n));
            }
            if (mesh3D.getMesh3DOctree() != null) {
                n = 1 + mesh3D.octree.getNbChildren(true);
                this.compiledMesh3DOctrees = new CompiledMesh3DOctree[n];
                IMesh3DOctree[] iMesh3DOctreeArray = mesh3D.octree.getMesh3DOctreeArray(new Mesh3DOctree[n]);
                for (int i = 0; i < n; ++i) {
                    this.compiledMesh3DOctrees[i] = new CompiledMesh3DOctree((Mesh3DOctree)iMesh3DOctreeArray[i]);
                }
            }
        }
    }

    class CompiledMesh3DOctree {
        int lastVisibleImage;
        Mesh3DOctree tree;

        CompiledMesh3DOctree(Mesh3DOctree mesh3DOctree) {
            this.tree = mesh3DOctree;
            this.lastVisibleImage = -1;
        }
    }

    class CompiledFace {
        Face3D face;
        CompiledFace nextFaceToRender;
        CompiledMaterial compiledMaterial;
        int lastRenderImage;
        int firstRenderOffset;
        int lastRenderOffset;
        int lastZbufferImage;

        CompiledFace(Face3D face3D) {
            this.face = face3D;
            this.nextFaceToRender = null;
            this.lastRenderImage = -1;
            this.firstRenderOffset = -1;
            this.lastRenderOffset = -1;
            this.lastZbufferImage = -1;
            this.compiledMaterial = face3D.material != null ? Render3DSW.this.compiledMaterials[face3D.material.id] : Render3DSW.this.compiledMaterials[0];
        }
    }
}

