/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.IScene2D;
import net.dzzd.access.IScene2DObject;
import net.dzzd.access.IShape2D;
import net.dzzd.core.Scene;
import net.dzzd.core.Shape2D;

public class Scene2D
extends Scene
implements IScene2D {
    protected Shape2D[] shapes2D;
    protected int nbShape2D;

    public Scene2D() {
        this.setScene2DBufferSize(1024);
        this.clearScene2D();
    }

    public void setScene2DBufferSize(int n) {
        this.shapes2D = new Shape2D[n];
        this.clearScene2D();
    }

    public int getNbScene2DObject() {
        int n = this.nbShape2D;
        return n;
    }

    public int getNbShape2D() {
        return this.nbShape2D;
    }

    public void addShape2D(IShape2D iShape2D) {
        if (((Shape2D)iShape2D).scene == this) {
            return;
        }
        ((Shape2D)iShape2D).scene = this;
        this.shapes2D[this.nbShape2D] = (Shape2D)iShape2D;
        iShape2D.setId(this.nbShape2D);
        this.startMonitorSceneObject((Shape2D)iShape2D);
        iShape2D.build();
        ++this.nbShape2D;
    }

    public void clearScene2D() {
        for (int i = 0; i < this.nbShape2D; ++i) {
            this.shapes2D[i] = null;
        }
        this.nbShape2D = 0;
    }

    public void addScene2DObject(IScene2DObject iScene2DObject) {
        if (iScene2DObject instanceof IShape2D) {
            this.addShape2D((IShape2D)iScene2DObject);
            return;
        }
    }

    public void addScene2DObjects(IScene2DObject[] iScene2DObjectArray) {
        for (int i = 0; i < iScene2DObjectArray.length; ++i) {
            this.addScene2DObject(iScene2DObjectArray[i]);
        }
    }

    public void removeScene2DObject(IScene2DObject iScene2DObject) {
        if (iScene2DObject == null) {
            return;
        }
        if (iScene2DObject instanceof IShape2D) {
            this.removeShape2DById(iScene2DObject.getId());
        }
    }

    public void removeShape2DById(int n) {
        if (this.shapes2D[n] == null) {
            return;
        }
        this.shapes2D[n] = null;
        --this.nbShape2D;
        for (int i = n; i < this.getNbShape2D(); ++i) {
            this.shapes2D[i] = this.shapes2D[i + 1];
            this.shapes2D[i].setId(i);
        }
    }

    public IShape2D getShape2DById(int n) {
        return this.shapes2D[n];
    }

    public IShape2D getShape2DByName(String string) {
        for (int i = 0; i < this.nbShape2D; ++i) {
            if (this.shapes2D[i] == null || this.shapes2D[i].nom == null || !this.shapes2D[i].nom.equals(string)) continue;
            return this.shapes2D[i];
        }
        return null;
    }
}

