/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.dzzd.access.IShape2D;
import net.dzzd.core.Scene2DObject;

public class Shape2D
extends Scene2DObject
implements IShape2D {
    private int nbKey = 0;
    private Shape2DKey firstKey = null;
    private Shape2DKey lastKey = null;
    private Shape2DKey currentKey = null;

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.nbKey);
        this.firstKey();
        while (!this.isEnd()) {
            this.currentKey.write(outputStream);
            this.nextKey();
        }
    }

    public void read(InputStream inputStream) throws IOException {
        this.firstKey = null;
        this.lastKey = null;
        this.currentKey = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Shape2DKey shape2DKey = new Shape2DKey();
            shape2DKey.read(inputStream);
            this.addKey(shape2DKey);
        }
    }

    public void firstKey() {
        this.currentKey = this.firstKey;
    }

    public void nextKey() {
        if (this.currentKey != null) {
            this.currentKey = this.currentKey.getNextKey();
        }
    }

    public boolean isEnd() {
        return this.currentKey == null;
    }

    public int getCurrentKeyType() {
        if (this.currentKey == null) {
            return -1;
        }
        return this.currentKey.getType();
    }

    public double[] getCurrentKeyValues() {
        if (this.currentKey == null) {
            return null;
        }
        return this.currentKey.getValues();
    }

    public void addKey() {
        Shape2DKey shape2DKey = new Shape2DKey();
        if (this.firstKey == null) {
            this.firstKey = shape2DKey;
            this.lastKey = shape2DKey;
            this.currentKey = shape2DKey;
            ++this.nbKey;
            return;
        }
        this.lastKey.setNextKey(shape2DKey);
        this.lastKey = shape2DKey;
        this.currentKey = shape2DKey;
        ++this.nbKey;
    }

    public void setStartKey(double d, double d2) {
        if (this.currentKey == null) {
            this.addKey();
        }
        this.currentKey.setStartKey(d, d2);
    }

    public void setLineKey(double d, double d2) {
        if (this.currentKey == null) {
            this.addKey();
        }
        this.currentKey.setLineKey(d, d2);
    }

    public void setEndKey() {
        if (this.currentKey == null) {
            this.addKey();
        }
        this.currentKey.setEndKey();
    }

    public void setQuadKey(double d, double d2, double d3, double d4) {
        if (this.currentKey == null) {
            this.addKey();
        }
        this.currentKey.setQuadKey(d, d2, d3, d4);
    }

    public void setCubicKey(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.currentKey == null) {
            this.addKey();
        }
        this.currentKey.setCubicKey(d, d2, d3, d4, d5, d6);
    }

    private void addKey(Shape2DKey shape2DKey) {
        if (this.firstKey == null) {
            this.firstKey = shape2DKey;
            this.lastKey = shape2DKey;
            this.currentKey = shape2DKey;
            ++this.nbKey;
            return;
        }
        this.lastKey.setNextKey(shape2DKey);
        this.lastKey = shape2DKey;
        this.currentKey = shape2DKey;
        ++this.nbKey;
    }

    private class Shape2DKey {
        private Shape2DKey nextKey = null;
        private int type = -1;
        private double[] values = null;

        public void write(OutputStream outputStream) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this.type);
            int n = 0;
            switch (this.type) {
                case 1: 
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 0;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                case 5: {
                    n = 6;
                }
            }
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeDouble(this.values[i]);
            }
        }

        public void read(InputStream inputStream) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.type = dataInputStream.readInt();
            int n = 0;
            switch (this.type) {
                case 1: 
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 0;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                case 5: {
                    n = 6;
                }
            }
            this.values = new double[n];
            for (int i = 0; i < n; ++i) {
                this.values[i] = dataInputStream.readDouble();
            }
            this.nextKey = null;
        }

        Shape2DKey() {
        }

        public Shape2DKey getNextKey() {
            return this.nextKey;
        }

        public int getType() {
            return this.type;
        }

        public double[] getValues() {
            return this.values;
        }

        public Shape2DKey setNextKey(Shape2DKey shape2DKey) {
            this.nextKey = shape2DKey;
            return this.nextKey;
        }

        public void setStartKey(double d, double d2) {
            this.type = 1;
            this.values = new double[2];
            this.values[0] = d;
            this.values[1] = d2;
        }

        public void setLineKey(double d, double d2) {
            this.type = 2;
            this.values = new double[2];
            this.values[0] = d;
            this.values[1] = d2;
        }

        public void setEndKey() {
            this.type = 3;
            this.values = null;
        }

        public void setQuadKey(double d, double d2, double d3, double d4) {
            this.type = 4;
            this.values = new double[4];
            this.values[0] = d;
            this.values[1] = d2;
            this.values[2] = d3;
            this.values[3] = d4;
        }

        public void setCubicKey(double d, double d2, double d3, double d4, double d5, double d6) {
            this.type = 5;
            this.values = new double[6];
            this.values[0] = d;
            this.values[1] = d2;
            this.values[2] = d3;
            this.values[3] = d4;
            this.values[4] = d5;
            this.values[5] = d6;
        }
    }
}

