/**
 * Gimbals
 *
 * Research on Gimbals lock...
 * 
 * @author Bruno Augier
 * @website: http://dzzd.net/
 * @version 1.00 2008/10/08
 */

import net.dzzd.utils.Log;
 
import net.dzzd.access.*;
import net.dzzd.DzzDApplet;
import net.dzzd.*;
import net.dzzd.utils.io.*;

import java.awt.event.KeyEvent;
import java.awt.event.*;

import java.awt.*;
import java.net.*;
import java.awt.image.*;

import java.awt.Button;

import java.util.*;



public final class Gimbals extends DzzDApplet implements Runnable,IScene3DRenderCallBack
{		
	private int nbStart=0;
	
	IScene3DRender scene3DRender;
	IScene3DRenderCallBack mainSceneHandler;
	
	private String model1Base="GIMBALS/";			//Default 3D model directory
	private String model1File="GIMBALS.3DS";		//Default 3D model files
	private String loadingImage="GIMBALS/LOAD.GIF";	//Default loading image
	private String cameraName="Camera01";
	private int bgColor=0x000000;					//Default background color
	private int loadingBarFrontColor=0xAAAAAA;		//Default loading bar front color
	private int loadingBarBackColor=0xEEEEEE;		//Default loading bar back color
	private int loadingBarBorderColor=0x0000EE;		//Default loading bar border color
	private int loadingBarWidth=280;				//Default loading bar width
	private int loadingBarHeight=40;				//Default loading bar height
	
	private Image loadImage;	//Image object for loading
	private Graphics bg;		//Back buffer
	private Image bgi;			//Back buffer image

	private int loadProgress3D=0;	//Progress of 3D download
	private int maxProgress3D=0;	//Max progress of 3D download for multiple files
	private int loadProgressIMG=0;	//Progress of 3D download
	private int maxProgressIMG=0;	//Progress of 3D download for multiple files
	
	private boolean loading=true;	//still loading flag ?
	
	/**
	 * Init Method called by the browser
	 * there we replace default value by applet param tag value
	 */	
	public void init()
	{
		System.out.println("Init : "+Thread.currentThread());
		super.init();
		DzzD.extensionBaseURL=this.getBaseURL()+"/LIB/";
		
				if(this.getParameter("MODELFILENAME")!=null)
		{
			this.model1Base="./";
			this.model1File=this.getParameter("MODELFILENAME");
		}
		
		if(this.getParameter("MODELFILEPATH")!=null)
			this.model1Base=this.getParameter("MODELFILEPATH");
		
		if(this.getParameter("IMAGELOADFILE")!=null)
			this.loadingImage=this.getParameter("IMAGELOADFILE");
		
		if(this.getParameter("CAMERANAME")!=null)
			this.cameraName=this.getParameter("CAMERANAME");

		if(this.getParameter("BGCOLOR")!=null)
		{
			try
			{
				this.bgColor=Integer.parseInt(this.getParameter("BGCOLOR"),16);
			}
			catch(NumberFormatException nfe)
			{
				Log.log("Invalid background color value BGCOLOR="+this.getParameter("BGCOLOR"));
			}
			
		}
		
		if(this.getParameter("LOADBARFRONTCOLOR")!=null)
		{
			try
			{
				this.loadingBarFrontColor=Integer.parseInt(this.getParameter("LOADBARFRONTCOLOR"),16);
			}
			catch(NumberFormatException nfe)
			{
				Log.log("Invalid color value LOADBARFRONTCOLOR="+this.getParameter("LOADBARFRONTCOLOR"));
			}
			
		}	
		
		if(this.getParameter("LOADBARBACKCOLOR")!=null)
		{
			try
			{
				this.loadingBarBackColor=Integer.parseInt(this.getParameter("LOADBARBACKCOLOR"),16);
			}
			catch(NumberFormatException nfe)
			{
				Log.log("Invalid color value LOADBARBACKCOLOR="+this.getParameter("LOADBARBACKCOLOR"));
			}
			
		}				
		
		if(this.getParameter("LOADBARBORDERCOLOR")!=null)
		{
			try
			{
				this.loadingBarBorderColor=Integer.parseInt(this.getParameter("LOADBARBORDERCOLOR"),16);
			}
			catch(NumberFormatException nfe)
			{
				Log.log("Invalid color value LOADBARBORDERCOLOR="+this.getParameter("LOADBARBORDERCOLOR"));
			}
			
		}				
		
		if(this.getParameter("LOADBARWIDTH")!=null)
		{
			try
			{
				this.loadingBarWidth=Integer.parseInt(this.getParameter("LOADBARWIDTH"),10);
			}
			catch(NumberFormatException nfe)
			{
				Log.log("Invalid color value LOADBARWIDTH="+this.getParameter("LOADBARWIDTH"));
			}
			
		}		
		
		if(this.getParameter("LOADBARHEIGHT")!=null)
		{
			try
			{
				this.loadingBarHeight=Integer.parseInt(this.getParameter("LOADBARHEIGHT"),10);
			}
			catch(NumberFormatException nfe)
			{
				Log.log("Invalid color value LOADBARHEIGHT="+this.getParameter("LOADBARHEIGHT"));
			}
			
		}						
		
		
		this.setBackground(new Color(this.bgColor));
	}
	
	/**
	 * Start Method called by the browser
	 * There we start a Thread
	 */
	public void start()
	{
		System.out.println("Start : "+Thread.currentThread());
		super.start();
		if(this.nbStart++==0)			
			this.startOnce();		
	}
	
	
	/**
	 * Start Once Method called once by start() method
	 * There we start a Thread
	 */		
	public void startOnce()
	{

		this.setLayout(null);
		this.bgi=this.createImage(this.getWidth(),this.getHeight());
		this.bg=this.bgi.getGraphics();		
		
		String loadingImageTmp=this.getBaseURL()+this.loadingImage;
		Log.log("Load image "+loadingImageTmp);
		
		this.loadImage=IOManager.loadImage(loadingImageTmp);
		this.update(this.getGraphics());
		
		
		Thread t=new Thread(this);
		t.start();	
	}

	/**
	 * Destroy Method called by the browser
	 * There we stop Scene3DRender 
	 */
	public void destroy()
	{
		System.out.println("Destroy : "+Thread.currentThread());
		if(this.scene3DRender!=null)
			this.scene3DRender.stop();
		this.scene3DRender=null;
	}
	
	/**
	 * Main thread
	 */	
	public void run()
	{		
		this.load3D();
		this.loading=false;
		this.show3D();
	}
	
	/**
	 * Load 3D file and create the main Scene3DRender
	 */	
	public void load3D()
	{
    	this.scene3DRender=DzzD.newScene3DRender();
    	IScene3D s=this.scene3DRender.getScene3D();
		IScene3DLoader s1=DzzD.newScene3DLoader();
		String loadImage=this.getBaseURL()+this.loadImage;
		String loadFile=this.getBaseURL()+this.model1Base+this.model1File;
		Log.log("Load 3ds "+loadFile);
		s1.loadScene3D(this.getBaseURL()+this.model1Base,this.model1File);
		s.setScene3DLoader(s1);	
		do
		{
			this.loadProgress3D=0;
			this.loadProgressIMG=0;
			this.maxProgressIMG=0;
			this.maxProgress3D=0;

			s.updateMonitoredSceneObjects();
			if(s.getNbMonitoredSceneObject()!=0)
			{
				IMonitoredSceneObject m=s.getMonitoredSceneObject(0);
				if(m instanceof IScene3DLoader)
				{
					this.loadProgress3D+=(m.getProgress()*100)/m.getMaximumProgress();
					this.maxProgress3D+=100;
				}
				if(m instanceof ITexture)
				{
					this.loadProgressIMG+=(m.getProgress()*100)/m.getMaximumProgress();
					this.maxProgressIMG+=100;
				}
				
			}
			this.update(this.getGraphics());
			DzzD.sleep(10);
		}
		while(s.getNbMonitoredSceneObject()!=0);	
		
		this.loadProgress3D=0;
		this.loadProgressIMG=100;
		this.maxProgressIMG=100;
		this.maxProgress3D=0;
		this.update(this.getGraphics());
	}
		
	/**
	 * Initialise some value in the Scene3DRender before showing it
	 */
	public void show3D()
	{
		IRender3D r=this.scene3DRender.getRender3D();
		if(this.mainSceneHandler==null)
		{
			
			IScene3D s=this.scene3DRender.getScene3D();
			s.setBackgroundColor(this.bgColor);	
			
			IPoint3D lRot=s.getLight3DById(0).getRotation();
			lRot.set(-Math.PI*0.12,0,0.00);
			
			r.setSize(this.getWidth(),this.getHeight());
			if(s.getCamera3DByName(this.cameraName)!=null)
			{
				s.getCamera3DByName(this.cameraName).setParent(null);
				s.setCurrentCamera3DByName(cameraName);
			}
			else
			{
				ICamera3D c=s.getCurrentCamera3D();
				c.getPosition().setZ(-400);
				c.setFOV(60);
				
			}
			 
			
			ICamera3D c=s.getCurrentCamera3D();
			//c.getPosition().setZ(-200);
			
			c.setZMin(0.1);
			c.setZoomY(((double)r.getWidth())/((double)r.getHeight()));	
			r.setScreenUpdateEnabled(true);
			r.getCanvas().setVisible(true);
			
			this.mainSceneHandler=this;
			this.scene3DRender.setScene3DRenderCallBack(this.mainSceneHandler);
		}
		
		this.add(r.getCanvas());
		r.getCanvas().requestFocus();
		this.scene3DRender.start();			
	}
	
	
	
	
	
	
	public void paint(Graphics g)
	{
		this.update(g);
	}
	
	Font f=new Font("Verdana",Font.PLAIN,12);
	
	public void update(Graphics g)
	{

		if(g==null) return;
		if(this.bgi==null) return;
		
		try
		{
			if(this.loading)
			{
					this.bg=this.bgi.getGraphics();
					this.renderLoading(g);
					Thread.sleep(50);
			}
		}
		catch(InterruptedException ie)
		{
		}
		
		
	}		
	
	private void renderLoading(Graphics g)
	{
		
		int cx=this.getWidth()>>1;
		int cy=this.getHeight()>>1;
		this.bg.setColor(Color.black);
		this.bg.setFont(f);
		
		int progress=0;
		if(this.maxProgress3D!=0)
			progress+=this.loadProgress3D*50/this.maxProgress3D;
		if(this.maxProgressIMG!=0)
			progress+=50+this.loadProgressIMG*50/this.maxProgressIMG;			
		progress=progress*this.loadingBarWidth/100;
		
		int width2=this.loadingBarWidth>>1;
		int height2=this.loadingBarHeight>>1;
		
		drawProgressBar(this.bg,cx-width2,cy-height2,this.loadingBarWidth,this.loadingBarHeight,progress,this.loadingBarBorderColor,this.loadingBarFrontColor,this.loadingBarBackColor);
		
		if(this.loadImage!=null)
			this.bg.drawImage(this.loadImage,cx-(this.loadImage.getWidth(null)>>1),cy-(this.loadImage.getHeight(null)>>1),null);
			
		g.drawImage(this.bgi,0,0,null);
		
	}
  
    private void drawProgressBar(Graphics g,int x,int y,int w,int h,int p,int bcolor,int fcolor,int bgcolor)
    {
		g.setColor(new Color(bcolor));
		g.drawRect(x,y,w,h);
		
		if(p>=w)
			p=w-1;
				
		g.setColor(new Color(fcolor));
		g.fillRect(x+1,y+1,p,h-1);	
		
		g.setColor(new Color(bgcolor));
		g.fillRect(x+1+p,y+1,(w-p)-1,h-1);
    }
    
    
    //We implements here the callback
    
	IRender3D render;
	IScene3D scene;
	ICamera3D camera;
	IDirectInput input;
	
	
	
	
	public void render3DstartCallBack(IScene3DRender r)
	{
		this.render=r.getRender3D();
		this.scene=r.getScene3D();
		this.input=this.render.getDirectInput();
		this.camera=this.scene.getCurrentCamera3D();	
		r.start();		
	}
	
	public void render3DSwitched(IScene3DRender r)
	{
		this.render=r.getRender3D();
		this.input=this.render.getDirectInput();
	}
	
	public void render3DStart(IScene3DRender r)
	{
		
	}
	

	boolean dragZoom=false;
	double dragZoomStartZoomX=0;
	double dragZoomStartZoomY=0;
	double dragZoomStartX=0;
	double dragZoomStartY=0;

	
	double dragStartX=0;
	double dragStartY=0;
	IScene3DObject dragObject=null;
	IAxis3D dragObjectAxisStart=null;
	IAxis3D dragObjectAxis=null;
	IPoint3D dragObjectRotation=null;
	
	public void render3DWorldSpace(IScene3DRender r)
	{
		Thread.yield();
		Thread.yield();
		Thread.yield();
		//Rotation
		if(this.input.isMouseB1())
		{
			
			if(this.dragObject==null)
			{
				//Start drag rotation
				this.dragObjectAxis=DzzD.newAxis3D();
				this.dragObjectAxisStart=DzzD.newAxis3D();
				this.dragObject=this.scene.getMesh3DById(0);
				this.dragObjectRotation=this.dragObject.getRotation();
				this.dragObjectAxisStart.copy(this.dragObject.getAxis3D());
				this.dragObjectAxisStart.toLocalAxis(this.camera.getAxis3D());
				this.dragObjectAxisStart.sub(this.dragObjectAxisStart.getOrigin());
				this.dragStartX=(double)this.input.getMouseX()/this.render.getWidth()-0.5;
				this.dragStartY=(double)this.input.getMouseY()/this.render.getHeight()-0.5;
			}
			else
			{
				//Currently drag rotation			
				double mx=(double)this.input.getMouseX()/this.render.getWidth()-0.5;
				double my=(double)this.input.getMouseY()/this.render.getHeight()-0.5;
				double vx=mx-this.dragStartX;
				double vy=my-this.dragStartY;
				double angle=Math.PI*Math.sqrt(vx*vx+vy*vy);
				this.dragObjectAxis.copy(this.dragObjectAxisStart);
				this.dragObjectAxis.rotate(angle,vy,vx,0);
				this.dragObjectAxis.toAxis(this.camera.getAxis3D());
				this.dragObjectAxis.getRotationXZY(this.dragObjectRotation);							
			}	
		}
		else
		{
			if(this.dragObject!=null)
			{
				//End drag rotation
				this.dragObject=null;
			}		
		}
		
		//Zoom
		if(this.input.isMouseB3())
		{
			if(!this.dragZoom)
			{
				//Start drag zoom
				this.dragZoom=true;
				this.dragZoomStartX=(double)this.input.getMouseX()/this.render.getWidth()-0.5;
				this.dragZoomStartY=(double)this.input.getMouseY()/this.render.getHeight()-0.5;
				this.dragZoomStartZoomX=this.camera.getZoomX();
				this.dragZoomStartZoomY=this.camera.getZoomY();
			}
			else
			{
				//Currently drag zoom
				double mx=(double)this.input.getMouseX()/this.render.getWidth()-0.5;
				double my=(double)this.input.getMouseY()/this.render.getHeight()-0.5;
				double vx=my-this.dragZoomStartX;
				double vy=my-this.dragZoomStartY;
				this.camera.setZoomX(this.dragZoomStartZoomX+vy);
				double ratio=((double)r.getRender3D().getWidth())/((double)r.getRender3D().getHeight());
				this.camera.setZoomY(ratio*this.camera.getZoomX());
			}
			
		}
		else
		{
			if(this.dragZoom)
			{
				//End drag zoom
				this.dragZoom=false;
				
			}
			
			
		}
		
		if(this.input.isKey(KeyEvent.VK_1))
		{
			IPoint3D rot=this.scene.getMesh3DByName("Torus01").getRotation();
			rot.setY(rot.getY()+0.1);
			
		}
		
		if(this.input.isKey(KeyEvent.VK_2))
		{
			IPoint3D rot=this.scene.getMesh3DByName("Torus02").getRotation();
			rot.setZ(rot.getZ()+0.1);
			
		}
		
		if(this.input.isKey(KeyEvent.VK_3))
		{
			IPoint3D rot=this.scene.getMesh3DByName("Torus03").getRotation();
			rot.setX(rot.getX()+0.1);
			
		}		
				
		
		
		if(this.input.isKey(KeyEvent.VK_H))
			r.switchRender3D("JOGL");
		if(this.input.isKey(KeyEvent.VK_S))
			r.switchRender3D("SOFT");
		
			
		
		if(!this.input.isMouseB3() && !this.input.isMouseB1())
			DzzD.sleep(10);
		
		
	}
	public void render3DCameraSpace(IScene3DRender r){}
	public void render3DPixelsUpdate(IScene3DRender r){}
	public void render3DPixelsUpdated(IScene3DRender r){}
	public void render3DEnd(IScene3DRender r){}    
	
}
