/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.IFace3D;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.core.Face3D;
import net.dzzd.core.Point3D;

public final class Mesh3DOctree
implements IMesh3DOctree {
    int id;
    Point3D center;
    double visibilitySphereBoxRadius;
    double visibilitySphereBoxRadius2;
    double boxSize;
    Mesh3DOctree[] childrens;
    int nbChildren;
    Face3D[] parentFaces;
    Face3D[] faces;
    int nbFaceIn;
    int[] octreeCellNum;
    private transient Integer build;
    Mesh3DOctree parent;
    IMesh3D mesh;

    Mesh3DOctree(IMesh3D iMesh3D, int n, double d, double d2, double d3, double d4, double d5, Face3D[] face3DArray, int[] nArray, Mesh3DOctree mesh3DOctree) {
        this.mesh = iMesh3D;
        this.id = n;
        this.parent = mesh3DOctree;
        this.center = new Point3D(d, d2, d3);
        this.visibilitySphereBoxRadius = d4;
        this.visibilitySphereBoxRadius2 = d4 * d4;
        this.boxSize = d5;
        this.childrens = new Mesh3DOctree[8];
        this.parentFaces = face3DArray;
        this.nbFaceIn = 0;
        this.octreeCellNum = nArray;
        this.faces = null;
        this.build = new Integer(-1);
        this.nbChildren = 8;
    }

    public int initMesh3DOctreeId(int n) {
        int n2;
        this.id = n++;
        this.nbChildren = 0;
        for (int i = 0; i < this.childrens.length; ++i) {
            if (this.childrens[i] == null) continue;
            ++this.nbChildren;
        }
        Mesh3DOctree[] mesh3DOctreeArray = new Mesh3DOctree[this.nbChildren];
        int n3 = 0;
        for (n2 = 0; n2 < this.childrens.length; ++n2) {
            if (this.childrens[n2] == null) continue;
            mesh3DOctreeArray[n3++] = this.childrens[n2];
        }
        this.childrens = mesh3DOctreeArray;
        for (n2 = 0; n2 < this.childrens.length; ++n2) {
            n = this.childrens[n2].initMesh3DOctreeId(n++);
        }
        return n;
    }

    public IMesh3DOctree[] getMesh3DOctreeArray(IMesh3DOctree[] iMesh3DOctreeArray) {
        iMesh3DOctreeArray[this.id] = this;
        for (int i = 0; i < this.childrens.length; ++i) {
            this.childrens[i].getMesh3DOctreeArray(iMesh3DOctreeArray);
        }
        return iMesh3DOctreeArray;
    }

    public int getNbChildren(boolean bl) {
        int n = this.nbChildren;
        if (bl) {
            for (int i = 0; i < this.childrens.length; ++i) {
                n += this.childrens[i].getNbChildren(bl);
            }
        }
        return n;
    }

    void fillMesh3DOctreeArray() {
    }

    int generate() {
        int n;
        Thread.yield();
        this.nbFaceIn = 0;
        int n2 = 0;
        int[] nArray = new int[this.parentFaces.length];
        for (n = 0; n < this.parentFaces.length; ++n) {
            Face3D face3D = this.parentFaces[n];
            int n3 = 0;
            if (this.include(face3D) == 1) {
                n3 = 1;
                ++this.nbFaceIn;
            }
            nArray[n] = n3;
        }
        if (this.nbFaceIn >= 12 + this.parentFaces.length / 50 && this.id < 65536) {
            double d = this.center.x;
            double d2 = this.center.y;
            double d3 = this.center.z;
            this.childrens[0] = new Mesh3DOctree(this.mesh, (this.id << 3) + 1, d - this.boxSize / 4.0, d2 - this.boxSize / 4.0, d3 - this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            this.childrens[1] = new Mesh3DOctree(this.mesh, (this.id << 3) + 2, d + this.boxSize / 4.0, d2 - this.boxSize / 4.0, d3 - this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            this.childrens[2] = new Mesh3DOctree(this.mesh, (this.id << 3) + 3, d - this.boxSize / 4.0, d2 + this.boxSize / 4.0, d3 - this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            this.childrens[3] = new Mesh3DOctree(this.mesh, (this.id << 3) + 4, d + this.boxSize / 4.0, d2 + this.boxSize / 4.0, d3 - this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            this.childrens[4] = new Mesh3DOctree(this.mesh, (this.id << 3) + 5, d - this.boxSize / 4.0, d2 - this.boxSize / 4.0, d3 + this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            this.childrens[5] = new Mesh3DOctree(this.mesh, (this.id << 3) + 6, d + this.boxSize / 4.0, d2 - this.boxSize / 4.0, d3 + this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            this.childrens[6] = new Mesh3DOctree(this.mesh, (this.id << 3) + 7, d - this.boxSize / 4.0, d2 + this.boxSize / 4.0, d3 + this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            this.childrens[7] = new Mesh3DOctree(this.mesh, (this.id << 3) + 8, d + this.boxSize / 4.0, d2 + this.boxSize / 4.0, d3 + this.boxSize / 4.0, this.visibilitySphereBoxRadius / 2.0, this.boxSize / 2.0, this.parentFaces, this.octreeCellNum, this);
            for (int i = 0; i < this.childrens.length; ++i) {
                int n4 = this.childrens[i].generate();
                if (n4 == 0) {
                    this.childrens[i] = null;
                    continue;
                }
                n2 += n4;
            }
        }
        this.nbFaceIn = 0;
        for (n = 0; n < this.parentFaces.length; ++n) {
            if (nArray[n] != 1 || this.octreeCellNum[n] != -1) continue;
            ++this.nbFaceIn;
        }
        if (this.id != 0 && (n2 += this.nbFaceIn) <= 12 + this.parentFaces.length / 50) {
            return 0;
        }
        for (n = 0; n < this.parentFaces.length; ++n) {
            if (nArray[n] != 1 || this.octreeCellNum[n] != -1) continue;
            this.octreeCellNum[n] = this.id;
        }
        return n2;
    }

    public int generateFaces() {
        int n;
        int n2;
        Thread.yield();
        this.nbFaceIn = 0;
        int n3 = 0;
        for (n2 = 0; n2 < this.childrens.length; ++n2) {
            if (this.childrens[n2] == null) continue;
            n = this.childrens[n2].generateFaces();
            if (n == 0) {
                this.childrens[n2] = null;
                continue;
            }
            n3 += n;
        }
        for (n2 = 0; n2 < this.octreeCellNum.length; ++n2) {
            if (this.octreeCellNum[n2] != this.id) continue;
            ++this.nbFaceIn;
        }
        this.faces = new Face3D[this.nbFaceIn];
        n2 = 0;
        for (n = 0; n < this.octreeCellNum.length; ++n) {
            if (this.octreeCellNum[n] != this.id) continue;
            this.faces[n2++] = this.parentFaces[n];
        }
        this.parentFaces = null;
        this.octreeCellNum = null;
        return n3 += this.nbFaceIn;
    }

    public int print() {
        int n = this.nbFaceIn;
        System.out.println("ID=" + this.id + " : " + this.nbFaceIn);
        for (int i = 0; i < this.childrens.length; ++i) {
            if (this.childrens[i] == null) continue;
            n += this.childrens[i].print();
        }
        return n;
    }

    int include(Face3D face3D) {
        if (face3D.p0.distance2(this.center) * 0.99 <= this.visibilitySphereBoxRadius2 && face3D.p1.distance2(this.center) * 0.99 <= this.visibilitySphereBoxRadius2 && face3D.p2.distance2(this.center) * 0.99 <= this.visibilitySphereBoxRadius2) {
            return 1;
        }
        return 0;
    }

    public int getId() {
        return this.id;
    }

    public Integer getBuildAsInteger() {
        return this.build;
    }

    public void build() {
        this.build = new Integer(this.getBuild() + 1);
    }

    public int getBuild() {
        return this.build;
    }

    public IFace3D[] getFaces3D() {
        return this.faces;
    }

    public int getNbFace3D() {
        return this.faces.length;
    }

    public IMesh3DOctree getChildren(int n) {
        if (this.childrens == null || n < 0 || n > this.childrens.length) {
            return null;
        }
        return this.childrens[n];
    }

    public IMesh3D getMesh3D() {
        return this.mesh;
    }
}

