/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import net.dzzd.access.IDirectInput;
import net.dzzd.access.IRender2D;
import net.dzzd.access.IRender2DMode;
import net.dzzd.access.IScene2D;
import net.dzzd.access.ISceneObject;
import net.dzzd.core.Render;

public class Render2D
extends Render
implements IRender2D {
    protected PCanvas canvas = new PCanvas();
    protected int viewPixelWidth;
    protected int viewPixelHeight;
    protected int antialias = 1;
    protected int maxAntialias = 1;
    protected int minXValue;
    protected int maxXValue;
    protected int minYValue;
    protected int maxYValue;
    protected boolean isScreenUpdateEnabled = true;
    protected boolean isPixelUpdateEnabled = true;
    protected int numImage = 0;
    protected boolean rendering = false;
    protected IDirectInput directInput = null;
    protected int render2DMode = -65;

    public Canvas getCanvas() {
        return this.canvas;
    }

    public IDirectInput getDirectInput() {
        return this.directInput;
    }

    public void setSize(int n, int n2, int n3) {
        this.canvas.setSize(n, n2);
        this.viewPixelWidth = n;
        this.viewPixelHeight = n2;
        this.maxAntialias = n3;
        this.antialias = n3;
    }

    public void setSize(int n, int n2) {
        this.setSize(n, n2, this.maxAntialias);
    }

    public void setAntialiasLevel(int n) {
        if (n == this.antialias) {
            return;
        }
        this.setSize(this.viewPixelWidth, this.viewPixelHeight, n);
        this.antialias = n;
    }

    public int getWidth() {
        return this.viewPixelWidth;
    }

    public int getHeight() {
        return this.viewPixelHeight;
    }

    public void setCursor(Cursor cursor) {
        this.canvas.setCursor(cursor);
    }

    public boolean isScreenUpdateEnabled() {
        return this.isScreenUpdateEnabled;
    }

    public void setScreenUpdateEnabled(boolean bl) {
        this.isScreenUpdateEnabled = bl;
    }

    public boolean isPixelUpdateEnabled() {
        return this.isPixelUpdateEnabled;
    }

    public void setPixelUpdateEnabled(boolean bl) {
        this.isPixelUpdateEnabled = bl;
    }

    public String getImplementationName() {
        return "NONE";
    }

    protected void compileAllScene2DObject(IScene2D iScene2D) {
        this.compileSceneObject(iScene2D);
    }

    public void removeSceneObject(ISceneObject iSceneObject) {
        super.removeSceneObject(iSceneObject);
    }

    protected void startFrame(IScene2D iScene2D) {
    }

    protected void renderFrame(IScene2D iScene2D) {
    }

    protected void endFrame(IScene2D iScene2D) {
    }

    public void renderScene2D(IScene2D iScene2D) {
        this.rendering = true;
        this.startFrame(iScene2D);
        this.renderFrame(iScene2D);
        this.endFrame(iScene2D);
        ++this.numImage;
        this.rendering = false;
    }

    public IRender2DMode getRender2DMode() {
        return this;
    }

    public void enableRender2DMode(int n) {
        this.render2DMode |= n;
    }

    public void disableRender2DMode(int n) {
        this.render2DMode &= n ^ 0xFFFFFFBF;
    }

    public void setRender2DModeFlags(int n) {
        this.render2DMode = n;
    }

    public int getRender2DModeFlags() {
        return this.render2DMode;
    }

    class PCanvas
    extends Canvas {
        public Image image;

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        public void update(Graphics graphics) {
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, null);
            }
            this.validate();
        }
    }
}

