/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.ICamera3D;
import net.dzzd.access.IFace3D;
import net.dzzd.access.ILight3D;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.access.IRender3D;
import net.dzzd.access.IRender3DMode;
import net.dzzd.access.IScene3D;
import net.dzzd.core.Axis3D;
import net.dzzd.core.Camera3D;
import net.dzzd.core.Face3DList;
import net.dzzd.core.Light3D;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Mesh3DOctree;
import net.dzzd.core.Point3D;
import net.dzzd.core.Render2D;
import net.dzzd.utils.Log;
import net.dzzd.utils.MathX;

public class Render3D
extends Render2D
implements IRender3D {
    protected Axis3D axes = new Axis3D();
    protected double focus;
    double iFocus;
    double iZoomX;
    double iZoomY;
    protected double screenZoomXFocus;
    protected double screenZoomYFocus;
    protected double zMax;
    protected double iZMax;
    protected double zMin;
    protected double iZMin;
    protected double zoomX;
    protected double zoomY;
    protected int render3DMode = -65;
    protected Mesh3D cMesh3D;
    protected double RA;
    protected double RB;
    protected double RC;
    protected double LA;
    protected double LB;
    protected double LC;
    protected double UA;
    protected double UB;
    protected double UC;
    protected double DA;
    protected double DB;
    protected double DC;
    protected double maxFaceViewAngleCos;
    protected Mesh3DLight3D[] mesh3DLocalLight3DBuffer;
    protected int nbLocalLight3D;
    protected int colorFog = 0x808080;
    protected double startZFog = 0.0;
    protected double endZFog = Double.MAX_VALUE;
    double ox;
    double oy;
    double oz;
    double axx;
    double axy;
    double axz;
    double ayx;
    double ayy;
    double ayz;
    double azx;
    double azy;
    double azz;
    double px;
    double py;
    double pz;
    double nx;
    double ny;
    double nz;

    protected void setCurrentMesh3D(Mesh3D mesh3D) {
        this.cMesh3D = mesh3D;
        Axis3D axis3D = mesh3D.axes;
        Point3D point3D = axis3D.axeX;
        Point3D point3D2 = axis3D.axeY;
        Point3D point3D3 = axis3D.axeZ;
        Point3D point3D4 = axis3D.origine;
        this.ox = point3D4.x;
        this.oy = point3D4.y;
        this.oz = point3D4.z;
        this.axx = point3D.x - this.ox;
        this.axy = point3D.y - this.oy;
        this.axz = point3D.z - this.oz;
        this.ayx = point3D2.x - this.ox;
        this.ayy = point3D2.y - this.oy;
        this.ayz = point3D2.z - this.oz;
        this.azx = point3D3.x - this.ox;
        this.azy = point3D3.y - this.oy;
        this.azz = point3D3.z - this.oz;
        this.px = -(this.axx * this.ox + this.axy * this.oy + this.axz * this.oz);
        this.py = -(this.ayx * this.ox + this.ayy * this.oy + this.ayz * this.oz);
        this.pz = -(this.azx * this.ox + this.azy * this.oy + this.azz * this.oz);
        this.nx = -(this.axx * this.ox + this.axy * this.oy + this.axz * (this.oz - 1.0));
        this.ny = -(this.ayx * this.ox + this.ayy * this.oy + this.ayz * (this.oz - 1.0));
        this.nz = -(this.azx * this.ox + this.azy * this.oy + this.azz * (this.oz - 1.0));
    }

    public Render3D() {
        this.mesh3DLocalLight3DBuffer = new Mesh3DLight3D[64];
        for (int i = 0; i < this.mesh3DLocalLight3DBuffer.length; ++i) {
            this.mesh3DLocalLight3DBuffer[i] = new Mesh3DLight3D();
        }
    }

    public void setCamera3D(ICamera3D iCamera3D) {
        Camera3D camera3D = (Camera3D)iCamera3D;
        this.axes.axeX.copy(camera3D.axes.axeX);
        this.axes.axeY.copy(camera3D.axes.axeY);
        this.axes.axeZ.copy(camera3D.axes.axeZ);
        this.axes.origine.copy(camera3D.axes.origine);
        this.zMax = camera3D.zMax;
        this.iZMax = 1.0 / this.zMax;
        this.zMin = camera3D.zMin;
        this.iZMin = 1.0 / this.zMin;
        double d = MathX.sin(camera3D.getFOV() * 0.5 * MathX.PI / 180.0);
        double d2 = Math.asin(d / camera3D.zoomX);
        double d3 = MathX.cos(d2);
        double d4 = MathX.sin(d2);
        double d5 = Math.asin(d / camera3D.zoomY);
        double d6 = MathX.cos(d5);
        double d7 = MathX.sin(d5);
        double d8 = Math.asin(Math.sqrt(d7 * d7 + d4 * d4));
        this.maxFaceViewAngleCos = MathX.cos(d8);
        this.iFocus = Math.tan(d2);
        this.focus = 1.0 / this.iFocus;
        this.zoomX = camera3D.zoomX;
        this.zoomY = camera3D.zoomY;
        double d9 = (double)this.viewPixelWidth * 0.5 * this.zoomX;
        double d10 = (double)this.viewPixelHeight * 0.5 * this.zoomY;
        if ((this.antialias & 2) != 0) {
            d9 *= 2.0;
        }
        if ((this.antialias & 4) != 0) {
            d10 *= 2.0;
        }
        this.iZoomX = 1.0 / d9;
        this.iZoomY = 1.0 / d10;
        this.screenZoomXFocus = d9 * this.focus;
        this.screenZoomYFocus = d10 * this.focus;
        d3 = this.focus * camera3D.zoomX;
        d4 = 1.0;
        d6 = this.focus * camera3D.zoomY;
        d7 = 1.0;
        this.RA = 1.0 * d3;
        this.RB = 0.0;
        this.RC = -1.0 * d4;
        double d11 = 1.0 / Math.sqrt(this.RA * this.RA + this.RB * this.RB + this.RC * this.RC);
        this.RA *= d11;
        this.RB *= d11;
        this.RC *= d11;
        this.LA = -1.0 * d3;
        this.LB = 0.0;
        this.LC = -1.0 * d4;
        double d12 = 1.0 / Math.sqrt(this.LA * this.LA + this.LB * this.LB + this.LC * this.LC);
        this.LA *= d12;
        this.LB *= d12;
        this.LC *= d12;
        this.UA = 0.0;
        this.UB = 1.0 * d6;
        this.UC = -1.0 * d7;
        double d13 = 1.0 / Math.sqrt(this.UA * this.UA + this.UB * this.UB + this.UC * this.UC);
        this.UA *= d13;
        this.UB *= d13;
        this.UC *= d13;
        this.DA = 0.0;
        this.DB = -1.0 * d6;
        this.DC = -1.0 * d7;
        double d14 = 1.0 / Math.sqrt(this.DA * this.DA + this.DB * this.DB + this.DC * this.DC);
        this.DA *= d14;
        this.DB *= d14;
        this.DC *= d14;
    }

    protected void compileMesh3D(IMesh3D iMesh3D) {
        Log.log("Render3D.compileMesh3D :" + iMesh3D.getName());
    }

    protected void compileMesh3DOctree(IMesh3DOctree iMesh3DOctree) {
        Log.log("Render3D.compileMesh3DOctree() : " + iMesh3DOctree.getMesh3D().getName());
    }

    private void compileAllMesh3DOctree(IMesh3DOctree iMesh3DOctree) {
        Integer n = iMesh3DOctree.getBuildAsInteger();
        if (!n.equals(this.compiledBuild.get(iMesh3DOctree))) {
            this.compileMesh3DOctree(iMesh3DOctree);
            this.compiledBuild.put(iMesh3DOctree, n);
        }
        for (int i = 0; i < iMesh3DOctree.getNbChildren(false); ++i) {
            if (iMesh3DOctree.getChildren(i) == null) continue;
            this.compileAllMesh3DOctree(iMesh3DOctree.getChildren(i));
        }
    }

    protected void compileLight3D(ILight3D iLight3D) {
        Log.log("Render3D.compileLight3D() : " + iLight3D.getName());
    }

    protected void compileCamera3D(ICamera3D iCamera3D) {
        Log.log("Render3D.compileCamera3D() : " + iCamera3D.getName());
    }

    protected void disposeMesh3D(IMesh3D iMesh3D) {
        Log.log("Render3D.disposeMesh3D() : " + iMesh3D.getName());
    }

    protected void disposeCamera3D(ICamera3D iCamera3D) {
        Log.log("Render3D.disposeCamera3D() : " + iCamera3D.getName());
    }

    protected void disposeLight3D(ILight3D iLight3D) {
        Log.log("Render3D.light() : " + iLight3D.getName());
    }

    protected void compileAllScene3DObject(IScene3D iScene3D) {
        Object object;
        int n;
        Object object2;
        int n2;
        this.compileAllScene2DObject(iScene3D);
        int n3 = iScene3D.getNbMesh3D();
        for (n2 = 0; n2 < n3; ++n2) {
            IMesh3D iMesh3D = iScene3D.getMesh3DById(n2);
            object2 = iMesh3D.getBuildAsInteger();
            if (((Integer)object2).equals(this.compiledBuild.get(iMesh3D))) continue;
            this.compileMesh3D(iMesh3D);
            this.compiledBuild.put(iMesh3D, object2);
            if (iMesh3D.getMesh3DOctree() == null) continue;
            this.compileAllMesh3DOctree(iMesh3D.getMesh3DOctree());
        }
        n2 = iScene3D.getNbLight3D();
        for (n = 0; n < n2; ++n) {
            object2 = iScene3D.getLight3DById(n);
            object = object2.getBuildAsInteger();
            if (((Integer)object).equals(this.compiledBuild.get(object2))) continue;
            this.compileLight3D((ILight3D)object2);
            this.compiledBuild.put(object2, object);
        }
        n = iScene3D.getNbCamera3D();
        for (int i = 0; i < n; ++i) {
            object = iScene3D.getCamera3DById(i);
            Integer n4 = object.getBuildAsInteger();
            if (n4.equals(this.compiledBuild.get(object))) continue;
            this.compileCamera3D((ICamera3D)object);
            this.compiledBuild.put(object, n4);
        }
    }

    public void renderScene3D(IScene3D iScene3D) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        this.rendering = true;
        this.compileAllScene3DObject(iScene3D);
        this.startFrame(iScene3D);
        this.renderFrame(iScene3D);
        this.endFrame(iScene3D);
        ++this.numImage;
        this.rendering = false;
    }

    protected void startFrame(IScene3D iScene3D) {
    }

    protected void renderFrame(IScene3D iScene3D) {
        for (int i = 0; i < iScene3D.getNbMesh3D(); ++i) {
            Mesh3D mesh3D = (Mesh3D)iScene3D.getMesh3DById(i);
            if (!mesh3D.isVisible()) continue;
            this.setCurrentMesh3D(mesh3D);
            if ((mesh3D.renderMode & 1) != 0) {
                this.prepareMesh3DLocalLight3DBuffer(mesh3D.getScene3D(), mesh3D);
            }
            if (mesh3D.meshViewGenerator != null) {
                mesh3D.meshViewGenerator.generateForView(this.px, this.py, this.pz, this.nx, this.ny, this.nz, this.focus, this.viewPixelWidth);
                this.setMesh3DListToZBuffer(mesh3D);
                continue;
            }
            if (mesh3D.octree == null) {
                this._setMesh3DToZBuffer(mesh3D);
                continue;
            }
            this._setMesh3DOctreeToZBuffer(mesh3D, mesh3D.octree);
        }
    }

    protected void endFrame(IScene3D iScene3D) {
    }

    protected void prepareMesh3DLocalLight3DBuffer(IScene3D iScene3D, Mesh3D mesh3D) {
        Point3D point3D = mesh3D.axes.axeX;
        Point3D point3D2 = mesh3D.axes.axeY;
        Point3D point3D3 = mesh3D.axes.axeZ;
        Point3D point3D4 = mesh3D.axes.origine;
        this.ox = point3D4.x;
        this.oy = point3D4.y;
        this.oz = point3D4.z;
        this.axx = point3D.x - this.ox;
        this.axy = point3D.y - this.oy;
        this.axz = point3D.z - this.oz;
        this.ayx = point3D2.x - this.ox;
        this.ayy = point3D2.y - this.oy;
        this.ayz = point3D2.z - this.oz;
        this.azx = point3D3.x - this.ox;
        this.azy = point3D3.y - this.oy;
        this.azz = point3D3.z - this.oz;
        int n = iScene3D.getNbLight3D();
        for (int i = 0; i < n; ++i) {
            Light3D light3D = (Light3D)iScene3D.getLight3DById(i);
            Mesh3DLight3D mesh3DLight3D = this.mesh3DLocalLight3DBuffer[i];
            Point3D point3D5 = light3D.axes.origine;
            double d = point3D5.x - this.ox;
            double d2 = point3D5.y - this.oy;
            double d3 = point3D5.z - this.oz;
            mesh3DLight3D.x = this.axx * d + this.axy * d2 + this.axz * d3;
            mesh3DLight3D.y = this.ayx * d + this.ayy * d2 + this.ayz * d3;
            mesh3DLight3D.z = this.azx * d + this.azy * d2 + this.azz * d3;
            point3D5 = light3D.axes.axeX;
            d = point3D5.x - this.ox;
            d2 = point3D5.y - this.oy;
            d3 = point3D5.z - this.oz;
            mesh3DLight3D.axx = this.axx * d + this.axy * d2 + this.axz * d3;
            mesh3DLight3D.axy = this.ayx * d + this.ayy * d2 + this.ayz * d3;
            mesh3DLight3D.axz = this.azx * d + this.azy * d2 + this.azz * d3;
            point3D5 = light3D.axes.axeY;
            d = point3D5.x - this.ox;
            d2 = point3D5.y - this.oy;
            d3 = point3D5.z - this.oz;
            mesh3DLight3D.ayx = this.axx * d + this.axy * d2 + this.axz * d3;
            mesh3DLight3D.ayy = this.ayx * d + this.ayy * d2 + this.ayz * d3;
            mesh3DLight3D.ayz = this.azx * d + this.azy * d2 + this.azz * d3;
            point3D5 = light3D.axes.axeZ;
            d = point3D5.x - this.ox;
            d2 = point3D5.y - this.oy;
            d3 = point3D5.z - this.oz;
            mesh3DLight3D.azx = this.axx * d + this.axy * d2 + this.axz * d3;
            mesh3DLight3D.azy = this.ayx * d + this.ayy * d2 + this.ayz * d3;
            mesh3DLight3D.azz = this.azx * d + this.azy * d2 + this.azz * d3;
            mesh3DLight3D.axx -= mesh3DLight3D.x;
            mesh3DLight3D.axy -= mesh3DLight3D.y;
            mesh3DLight3D.axz -= mesh3DLight3D.z;
            mesh3DLight3D.ayx -= mesh3DLight3D.x;
            mesh3DLight3D.ayy -= mesh3DLight3D.y;
            mesh3DLight3D.ayz -= mesh3DLight3D.z;
            mesh3DLight3D.azx -= mesh3DLight3D.x;
            mesh3DLight3D.azy -= mesh3DLight3D.y;
            mesh3DLight3D.azz -= mesh3DLight3D.z;
        }
    }

    private void _setMesh3DToZBuffer(Mesh3D mesh3D) {
        double d = mesh3D.center.x;
        double d2 = mesh3D.center.y;
        double d3 = mesh3D.center.z;
        double d4 = mesh3D.sphereBox;
        if (mesh3D.getNbFace3D() > 0 && this.isSphereVisible(d, d2, d3, d4) == 1) {
            this.setMesh3DToZBuffer(mesh3D);
        }
    }

    protected void _setMesh3DOctreeToZBuffer(Mesh3D mesh3D, Mesh3DOctree mesh3DOctree) {
        double d = mesh3DOctree.center.x;
        double d2 = mesh3DOctree.center.y;
        double d3 = mesh3DOctree.center.z;
        double d4 = mesh3DOctree.visibilitySphereBoxRadius;
        if (this.isSphereVisible(d, d2, d3, d4) == 1) {
            if (mesh3DOctree.getNbFace3D() > 0) {
                this.setMesh3DOctreeToZBuffer(mesh3DOctree);
            }
            for (int i = 0; i < mesh3DOctree.getNbChildren(false); ++i) {
                if (mesh3DOctree.childrens[i] == null) continue;
                this._setMesh3DOctreeToZBuffer(mesh3D, mesh3DOctree.childrens[i]);
            }
        }
    }

    protected void setMesh3DToZBuffer(IMesh3D iMesh3D) {
    }

    protected void setMesh3DOctreeToZBuffer(IMesh3DOctree iMesh3DOctree) {
    }

    protected int setFaces3DToZBuffer(IFace3D[] iFace3DArray, int n) {
        return 0;
    }

    private void setMesh3DListToZBuffer(Mesh3D mesh3D) {
        Face3DList face3DList = (Face3DList)mesh3D.meshViewGenerator.getViewFace3DList();
        while (face3DList != null) {
            this.setFaces3DToZBuffer(mesh3D.faces3D, face3DList.face.id);
            face3DList = face3DList.nextFaceList;
        }
    }

    protected int isSphereVisible(double d, double d2, double d3, double d4) {
        double d5 = this.ox + this.axx * d + this.ayx * d2 + this.azx * d3;
        double d6 = this.oy + this.axy * d + this.ayy * d2 + this.azy * d3;
        double d7 = this.oz + this.axz * d + this.ayz * d2 + this.azz * d3;
        double d8 = d7 + d4;
        if (d8 <= this.zMin) {
            return 0;
        }
        if (d5 * d5 + d6 * d6 + d7 * d7 <= d4 * d4) {
            return 1;
        }
        double d9 = d7 - d4;
        if (d9 >= this.zMax) {
            return 0;
        }
        if (this.RA * d5 + this.RB * d6 + this.RC * d7 >= d4) {
            return 0;
        }
        if (this.LA * d5 + this.LB * d6 + this.LC * d7 >= d4) {
            return 0;
        }
        if (this.UA * d5 + this.UB * d6 + this.UC * d7 >= d4) {
            return 0;
        }
        if (this.DA * d5 + this.DB * d6 + this.DC * d7 >= d4) {
            return 0;
        }
        return 1;
    }

    public int getRenderedMesh3DIdAt(int n, int n2) {
        return -1;
    }

    public int getRenderedFace3DIdAt(int n, int n2) {
        return -1;
    }

    public double getZAt(int n, int n2) {
        return this.zMax;
    }

    public void setFogColor(int n) {
        this.colorFog = n;
    }

    public void setFogStart(double d) {
        this.startZFog = d;
    }

    public void setFogEnd(double d) {
        this.endZFog = d;
    }

    public IRender3DMode getRender3DMode() {
        return this;
    }

    public void enableRender3DMode(int n) {
        this.render3DMode |= n;
    }

    public void disableRender3DMode(int n) {
        this.render3DMode &= n ^ 0xFFFFFFBF;
    }

    public void setRender3DModeFlags(int n) {
        this.render3DMode = n;
    }

    public int getRender3DModeFlags() {
        return this.render3DMode;
    }

    protected class Mesh3DLight3D {
        public double x;
        public double y;
        public double z;
        public double axx;
        public double axy;
        public double axz;
        public double ayx;
        public double ayy;
        public double ayz;
        public double azx;
        public double azy;
        public double azz;

        protected Mesh3DLight3D() {
        }
    }
}

