/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.ICamera3D;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene3DObject;
import net.dzzd.core.Scene3DObject;

public final class Camera3D
extends Scene3DObject
implements ICamera3D {
    double focus = 1.0;
    double width = 1.0;
    double height = 0.75;
    double zoomX = 1.0;
    double zoomY = 1.0;
    double zMin = 1.0;
    double zMax = 3.4028234663852886E38;
    int type = 1;
    IPoint3D target = null;
    double roll = 0.0;
    double fov;

    public String toString() {
        String string = "";
        string = string + " FOV(" + this.getFOV() + ") ";
        string = string + " focal(" + this.focus + ") ";
        string = string + " size(" + this.width + "," + this.height + ") ";
        string = string + " zoom(" + this.zoomX + "," + this.zoomY + ") ";
        string = string + " clipZ(" + this.zMin + "," + this.zMax + ") ";
        return string;
    }

    public Camera3D() {
        this.setFOV(45.0);
        this.sphereBox = 1.0;
    }

    public double getFOV() {
        return this.fov;
    }

    public void setFOV(double d) {
        this.fov = d;
    }

    public double getFocus() {
        return this.focus;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getZoomX() {
        return this.zoomX;
    }

    public double getZoomY() {
        return this.zoomY;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getZMin() {
        return this.zMin;
    }

    public void setFocus(double d) {
        this.focus = d;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public void setZoomX(double d) {
        this.zoomX = d;
    }

    public void setZoomY(double d) {
        this.zoomY = d;
    }

    public void setZMax(double d) {
        this.zMax = d;
    }

    public void setZMin(double d) {
        this.zMin = d;
    }

    public IScene3DObject getClone(boolean bl) {
        Camera3D camera3D = new Camera3D();
        camera3D.copy(this);
        if (bl) {
            Scene3DObject scene3DObject = this.firstChild;
            while (scene3DObject != null) {
                camera3D.addChild(scene3DObject.getClone(bl));
                scene3DObject = scene3DObject.nextChild;
            }
        }
        return camera3D;
    }

    public void copy(ICamera3D iCamera3D) {
        this.setWidth(iCamera3D.getWidth());
        this.setHeight(iCamera3D.getHeight());
        this.setZMin(iCamera3D.getZMin());
        this.setZMax(iCamera3D.getZMax());
        this.setFocus(iCamera3D.getFocus());
        this.setZoomX(iCamera3D.getZoomX());
        this.setZoomY(iCamera3D.getZoomY());
        if (iCamera3D.getTarget() != null) {
            this.setTarget(iCamera3D.getTarget().getClone());
        } else {
            this.setTarget(null);
        }
        super.copy(iCamera3D);
    }

    public void setTarget(IPoint3D iPoint3D) {
        this.target = iPoint3D;
    }

    public IPoint3D getTarget() {
        return this.target;
    }
}

