/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Canvas;
import net.dzzd.access.IDrawer2D;
import net.dzzd.access.IFont2D;
import net.dzzd.access.IScene2D;
import net.dzzd.access.IShape2D;
import net.dzzd.core.Font2D;
import net.dzzd.core.Shape2D;

public class Drawer2D
implements IDrawer2D {
    protected double xMin = 0.0;
    protected double xMax = 0.0;
    protected double yMin = 0.0;
    protected double yMax = 0.0;
    protected int opacity = 255;
    protected Font2D font = null;
    protected int color = -16777216;
    protected int width = 0;
    protected int height = 0;
    protected double sx;
    protected double sy;
    protected double cx;
    protected double cy;
    protected boolean sFlag;
    protected int mode = 1;
    private static double[] fac = new double[]{1.0, 1.0, 2.0, 6.0, 24.0};

    public Canvas getCanvas() {
        return null;
    }

    public void doRender() {
    }

    public final void setMode(int n) {
        this.mode = n;
    }

    public final void setClip(double d, double d2, double d3, double d4) {
        this.xMin = Math.max(0.0, d);
        this.yMin = Math.min((double)(this.width - 1), d2);
        this.xMax = Math.max(0.0, d3);
        this.yMax = Math.min((double)(this.height - 1), d4);
    }

    public final void drawString(String string, double d, double d2, double d3) {
        if (this.font == null) {
            return;
        }
        double d4 = 0.0;
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i) & 0xFF;
            Shape2D shape2D = this.font.getShape2D(n);
            this.drawShape2D(shape2D, 100.0 + (d4 += this.font.getAdvance(n) * d3), 100.0, 100.0, 10.0 * this.font.getRatioHW());
        }
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.setClip(this.xMin, this.yMin, this.xMax, this.yMax);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.opacity = n >> 24 & 0xFF;
        this.color = n & 0xFFFFFF;
    }

    public IFont2D getFont2D() {
        return this.font;
    }

    public void setFont2D(IFont2D iFont2D) {
        this.font = (Font2D)iFont2D;
    }

    public void setPixel(double d, double d2, int n) {
    }

    public void setPixel(int n, int n2, int n3) {
    }

    public void drawShape2D(IShape2D iShape2D, double d, double d2, double d3, double d4) {
        this.beginShape2D();
        iShape2D.firstKey();
        while (!iShape2D.isEnd()) {
            int n = iShape2D.getCurrentKeyType();
            double[] dArray = iShape2D.getCurrentKeyValues();
            switch (n) {
                case 1: {
                    this.moveTo(dArray[0] * d3 + d, dArray[1] * d4 + d2);
                    break;
                }
                case 2: {
                    this.lineTo(dArray[0] * d3 + d, dArray[1] * d4 + d2);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.quadTo(dArray[0] * d3 + d, dArray[1] * d4 + d2, dArray[2] * d3 + d, dArray[3] * d4 + d2);
                    break;
                }
            }
            iShape2D.nextKey();
        }
        this.endShape2D();
    }

    public void beginShape2D() {
        this.sx = 0.0;
        this.sy = 0.0;
        this.cx = 0.0;
        this.cy = 0.0;
        this.sFlag = true;
    }

    public void moveTo(double d, double d2) {
        if (!this.sFlag) {
            return;
        }
        this.sx = d;
        this.sy = d2;
        this.cx = d;
        this.cy = d2;
    }

    public void lineTo(double d, double d2) {
        if (!this.sFlag) {
            return;
        }
        this.cx = d;
        this.cy = d2;
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        if (!this.sFlag) {
            return;
        }
        this.quadShape2D(this.cx, this.cy, d, d2, d3, d4, 0.0, 1.0);
        this.lineTo(d3, d4);
    }

    public void endShape2D() {
        if (!this.sFlag) {
            return;
        }
        this.sFlag = false;
    }

    public void line(double d, double d2, double d3, double d4) {
    }

    public void fillSolid() {
    }

    protected void lineShape2D(double d, double d2, double d3, double d4) {
    }

    private double B(int n, int n2, double d) {
        return this.C(n, n2) * Math.pow(d, n2) * Math.pow(1.0 - d, n - n2);
    }

    private double C(int n, int n2) {
        return fac[n] / (fac[n2] * fac[n - n2]);
    }

    private void quadShape2D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d7 + d8) * 0.5;
        double d10 = this.B(2, 0, d7);
        double d11 = this.B(2, 1, d7);
        double d12 = this.B(2, 2, d7);
        double d13 = d10 * d + d11 * d3 + d12 * d5;
        double d14 = d10 * d2 + d11 * d4 + d12 * d6;
        d10 = this.B(2, 0, d9);
        d11 = this.B(2, 1, d9);
        d12 = this.B(2, 2, d9);
        double d15 = d10 * d + d11 * d3 + d12 * d5;
        double d16 = d10 * d2 + d11 * d4 + d12 * d6;
        d10 = this.B(2, 0, d8);
        d11 = this.B(2, 1, d8);
        d12 = this.B(2, 2, d8);
        double d17 = d10 * d + d11 * d3 + d12 * d5;
        double d18 = d10 * d2 + d11 * d4 + d12 * d6;
        if (Math.abs(d13 - d15) > 1.0 || Math.abs(d14 - d16) > 1.0) {
            this.quadShape2D(d, d2, d3, d4, d5, d6, d7, d9);
            this.quadShape2D(d, d2, d3, d4, d5, d6, d9, d8);
            return;
        }
        if (Math.abs(d15 - d) >= 1.0 || Math.abs(d16 - d2) >= 1.0) {
            this.lineTo(d15, d16);
        }
        if (Math.abs(d15 - d5) >= 1.0 || Math.abs(d16 - d6) >= 1.0) {
            this.lineTo(d15, d16);
        }
    }

    public void quad(double d, double d2, double d3, double d4, double d5, double d6) {
        this.quad(d, d2, d3, d4, d5, d6, 0.0, 0.5, 1.0);
    }

    private void quad(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        if (d2 < this.yMin && d4 < this.yMin && d6 < this.yMin) {
            return;
        }
        if (d2 > this.yMax && d4 > this.yMax && d6 > this.yMax) {
            return;
        }
        if (d < this.xMin && d3 < this.xMin && d5 < this.xMin) {
            return;
        }
        if (d > this.xMax && d3 > this.xMax && d5 > this.xMax) {
            return;
        }
        double d10 = this.B(2, 0, d7);
        double d11 = this.B(2, 1, d7);
        double d12 = this.B(2, 2, d7);
        double d13 = d10 * d + d11 * d3 + d12 * d5;
        double d14 = d10 * d2 + d11 * d4 + d12 * d6;
        d10 = this.B(2, 0, d8);
        d11 = this.B(2, 1, d8);
        d12 = this.B(2, 2, d8);
        double d15 = d10 * d + d11 * d3 + d12 * d5;
        double d16 = d10 * d2 + d11 * d4 + d12 * d6;
        d10 = this.B(2, 0, d9);
        d11 = this.B(2, 1, d9);
        d12 = this.B(2, 2, d9);
        double d17 = d10 * d + d11 * d3 + d12 * d5;
        double d18 = d10 * d2 + d11 * d4 + d12 * d6;
        if (Math.abs(d13 - d15) < 2.0 && Math.abs(d14 - d16) < 2.0) {
            this.line(d13, d14, d15, d16);
        } else {
            this.quad(d, d2, d3, d4, d5, d6, d7, (d7 + d8) * 0.5, d8);
        }
        if (Math.abs(d15 - d17) < 2.0 && Math.abs(d16 - d18) < 2.0) {
            this.line(d15, d16, d17, d18);
        } else {
            this.quad(d, d2, d3, d4, d5, d6, d8, (d8 + d9) * 0.5, d9);
        }
    }

    public void renderScene2D(IScene2D iScene2D) {
    }
}

