/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.IFace3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IVertex3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Point3D;
import net.dzzd.core.Vertex3D;

public final class Face3D
implements IFace3D {
    Mesh3D object = null;
    int id;
    Vertex3D p0;
    Vertex3D p1;
    Vertex3D p2;
    int smoothGroupMask;
    float p0nx;
    float p0ny;
    float p0nz;
    float p1nx;
    float p1ny;
    float p1nz;
    float p2nx;
    float p2ny;
    float p2nz;
    float p0tx;
    float p0ty;
    float p0tz;
    float p1tx;
    float p1ty;
    float p1tz;
    float p2tx;
    float p2ty;
    float p2tz;
    float p0bx;
    float p0by;
    float p0bz;
    float p1bx;
    float p1by;
    float p1bz;
    float p2bx;
    float p2by;
    float p2bz;
    float u0;
    float u1;
    float u2;
    float v0;
    float v1;
    float v2;
    float pa;
    float pb;
    float pc;
    float pd;
    Material material;
    float sphereBox;
    Face3D nextAlphaFace;

    public Face3D() {
        this.p0 = null;
        this.p1 = null;
        this.p2 = null;
        this.smoothGroupMask = 0;
        this.material = null;
        this.u0 = 0.0f;
        this.u1 = 1.0f;
        this.u2 = 1.0f;
        this.v0 = 0.0f;
        this.v1 = 0.0f;
        this.v2 = 1.0f;
    }

    public Face3D(IVertex3D iVertex3D, IVertex3D iVertex3D2, IVertex3D iVertex3D3) {
        this.p0 = (Vertex3D)iVertex3D;
        this.p1 = (Vertex3D)iVertex3D2;
        this.p2 = (Vertex3D)iVertex3D3;
        this.smoothGroupMask = 0;
        this.material = null;
        this.u0 = 0.0f;
        this.u1 = 1.0f;
        this.u2 = 1.0f;
        this.v0 = 0.0f;
        this.v1 = 0.0f;
        this.v2 = 1.0f;
    }

    Face3D setNormal() {
        Point3D point3D = new Point3D();
        Point3D point3D2 = new Point3D();
        point3D2.copy(this.p1);
        point3D.copy(this.p2);
        point3D2.sub(this.p0);
        point3D.sub(this.p0);
        point3D2.cross(point3D);
        point3D2.normalize();
        point3D.copy(point3D2);
        this.pa = (float)point3D.x;
        this.pb = (float)point3D.y;
        this.pc = (float)point3D.z;
        this.pd = (float)(-point3D.dot(this.p0));
        this.p0nx = (float)point3D.x;
        this.p0ny = (float)point3D.y;
        this.p0nz = (float)point3D.z;
        this.p1nx = (float)point3D.x;
        this.p1ny = (float)point3D.y;
        this.p1nz = (float)point3D.z;
        this.p2nx = (float)point3D.x;
        this.p2ny = (float)point3D.y;
        this.p2nz = (float)point3D.z;
        double d = this.u1 - this.u0;
        double d2 = this.v1 - this.v0;
        double d3 = this.u2 - this.u0;
        double d4 = this.v2 - this.v0;
        Point3D point3D3 = new Point3D();
        point3D3.copy(this.p1);
        point3D3.sub(this.p0);
        point3D3.mul(-d4);
        Point3D point3D4 = new Point3D();
        point3D4.copy(this.p2);
        point3D4.sub(this.p0);
        point3D4.mul(-d2);
        point3D3.sub(point3D4);
        double d5 = point3D3.dot(point3D);
        point3D3.normalize();
        this.p0tx = (float)point3D3.x;
        this.p0ty = (float)point3D3.y;
        this.p0tz = (float)point3D3.z;
        this.p1tx = (float)point3D3.x;
        this.p1ty = (float)point3D3.y;
        this.p1tz = (float)point3D3.z;
        this.p2tx = (float)point3D3.x;
        this.p2ty = (float)point3D3.y;
        this.p2tz = (float)point3D3.z;
        Point3D point3D5 = new Point3D();
        point3D5.copy(this.p1);
        point3D5.sub(this.p0);
        point3D5.mul(d3);
        Point3D point3D6 = new Point3D();
        point3D6.copy(this.p2);
        point3D6.sub(this.p0);
        point3D6.mul(d);
        point3D5.sub(point3D6);
        double d6 = point3D5.dot(point3D);
        point3D5.normalize();
        this.p0bx = (float)point3D5.x;
        this.p0by = (float)point3D5.y;
        this.p0bz = (float)point3D5.z;
        this.p1bx = (float)point3D5.x;
        this.p1by = (float)point3D5.y;
        this.p1bz = (float)point3D5.z;
        this.p2bx = (float)point3D5.x;
        this.p2by = (float)point3D5.y;
        this.p2bz = (float)point3D5.z;
        return this;
    }

    void initSphereBox() {
        this.sphereBox = (float)this.p2.dist(this.p0);
        double d = this.p2.dist(this.p1);
        if (d > (double)this.sphereBox) {
            this.sphereBox = (float)d;
        }
    }

    public void flipNormal() {
        Vertex3D vertex3D = this.p0;
        this.p0 = this.p2;
        this.p2 = vertex3D;
        float f = this.u0;
        this.u0 = this.u2;
        this.u2 = f;
        float f2 = this.v0;
        this.v0 = this.v2;
        this.v2 = f2;
    }

    public double getSphereBox() {
        return this.sphereBox;
    }

    public void setMaterial(IMaterial iMaterial) {
        this.material = (Material)iMaterial;
    }

    public IMaterial getMaterial() {
        return this.material;
    }

    public IVertex3D getVertex3D0() {
        return this.p0;
    }

    public IVertex3D getVertex3D1() {
        return this.p1;
    }

    public IVertex3D getVertex3D2() {
        return this.p2;
    }

    public IMesh3D getMesh3D() {
        return this.object;
    }

    public double getPA() {
        return this.pa;
    }

    public double getPB() {
        return this.pb;
    }

    public double getPC() {
        return this.pc;
    }

    public double getPD() {
        return this.pd;
    }

    public float getMappingU(int n) {
        switch (n) {
            case 0: {
                return this.u0;
            }
            case 1: {
                return this.u1;
            }
            case 2: {
                return this.u2;
            }
        }
        return 0.0f;
    }

    public float getMappingV(int n) {
        switch (n) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
            case 2: {
                return this.v2;
            }
        }
        return 0.0f;
    }

    public void setMappingU(int n, float f) {
        switch (n) {
            case 0: {
                this.u0 = f;
                break;
            }
            case 1: {
                this.u1 = f;
                break;
            }
            case 2: {
                this.u2 = f;
                break;
            }
        }
    }

    public void setMappingV(int n, float f) {
        switch (n) {
            case 0: {
                this.v0 = f;
                break;
            }
            case 1: {
                this.v1 = f;
                break;
            }
            case 2: {
                this.v2 = f;
                break;
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public float getVertex3D0Nx() {
        return this.p0nx;
    }

    public float getVertex3D0Ny() {
        return this.p0ny;
    }

    public float getVertex3D0Nz() {
        return this.p0nz;
    }

    public float getVertex3D1Nx() {
        return this.p1nx;
    }

    public float getVertex3D1Ny() {
        return this.p1ny;
    }

    public float getVertex3D1Nz() {
        return this.p1nz;
    }

    public float getVertex3D2Nx() {
        return this.p2nx;
    }

    public float getVertex3D2Ny() {
        return this.p2ny;
    }

    public float getVertex3D2Nz() {
        return this.p2nz;
    }
}

