/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.dzzd.access.IFont2D;
import net.dzzd.core.Shape2D;
import net.dzzd.utils.Log;
import net.dzzd.utils.io.IOManager;

public class Font2D
implements IFont2D {
    private Shape2D[] shapes = new Shape2D[256];
    private double[] advance = new double[256];
    private double[] minX = new double[256];
    private double[] minY;
    private double[] maxX = new double[256];
    private double[] maxY;
    private double maxWidth = 1.0;
    private double maxHeight = 1.0;
    private double ratioHW = 1.0;

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeDouble(this.maxWidth);
        dataOutputStream.writeDouble(this.maxHeight);
        dataOutputStream.writeDouble(this.ratioHW);
        for (int i = 0; i < 256; ++i) {
            dataOutputStream.writeBoolean(this.shapes[i] != null);
            if (this.shapes[i] == null) continue;
            dataOutputStream.writeDouble(this.advance[i]);
            dataOutputStream.writeDouble(this.minX[i]);
            dataOutputStream.writeDouble(this.minY[i]);
            dataOutputStream.writeDouble(this.maxX[i]);
            dataOutputStream.writeDouble(this.maxY[i]);
            this.shapes[i].write(outputStream);
        }
    }

    public void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.maxWidth = dataInputStream.readDouble();
        this.maxHeight = dataInputStream.readDouble();
        this.ratioHW = dataInputStream.readDouble();
        for (int i = 0; i < 256; ++i) {
            boolean bl = dataInputStream.readBoolean();
            if (!bl) {
                this.shapes[i] = null;
                continue;
            }
            this.advance[i] = dataInputStream.readDouble();
            this.minX[i] = dataInputStream.readDouble();
            this.minY[i] = dataInputStream.readDouble();
            this.maxX[i] = dataInputStream.readDouble();
            this.maxY[i] = dataInputStream.readDouble();
            Shape2D shape2D = new Shape2D();
            shape2D.read(inputStream);
            this.shapes[i] = shape2D;
        }
    }

    public Font2D() {
        this.minY = new double[256];
        this.maxY = new double[256];
    }

    public static Font2D load(String string, String string2) {
        Font2D font2D = null;
        try {
            InputStream inputStream = IOManager.openStream(string + "/" + string2, false);
            font2D = new Font2D();
            font2D.read(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            Log.log(exception);
            return null;
        }
        return font2D;
    }

    public Shape2D getShape2D(int n) {
        return this.shapes[n];
    }

    public double getAdvance(int n) {
        return this.advance[n];
    }

    public double getMinX(int n) {
        return this.minX[n];
    }

    public double getMinY(int n) {
        return this.minY[n];
    }

    public double getMaxX(int n) {
        return this.maxX[n];
    }

    public double getMaxY(int n) {
        return this.maxY[n];
    }

    public double getRatioHW() {
        return this.ratioHW;
    }

    public void createFont2D(Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = font.getMaxCharBounds(fontRenderContext);
        this.maxWidth = rectangle2D.getMaxX() - rectangle2D.getMinX();
        this.maxHeight = rectangle2D.getMaxY() - rectangle2D.getMinY();
        char[] cArray = new char[1];
        double d = 1.0 / this.maxWidth;
        double d2 = 1.0 / this.maxHeight;
        this.ratioHW = this.maxHeight / this.maxWidth;
        for (int i = 0; i < 256; ++i) {
            Shape2D shape2D;
            cArray[0] = (char)i;
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, new String(cArray));
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
            this.advance[i] = (double)glyphMetrics.getAdvance() * d;
            this.minX[i] = glyphVector.getVisualBounds().getMinX() * d;
            this.maxX[i] = glyphVector.getVisualBounds().getMaxX() * d;
            this.minY[i] = glyphVector.getVisualBounds().getMinY() * d2;
            this.maxY[i] = glyphVector.getVisualBounds().getMaxY() * d2;
            Shape shape = glyphVector.getOutline();
            PathIterator pathIterator = shape.getPathIterator(null);
            double[] dArray = new double[6];
            this.shapes[i] = shape2D = new Shape2D();
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(dArray);
                for (int j = 0; j < 6; ++j) {
                    if (j % 2 == 0) {
                        int n2 = j;
                        dArray[n2] = dArray[n2] * d;
                    }
                    if (j % 2 != 1) continue;
                    int n3 = j;
                    dArray[n3] = dArray[n3] * d2;
                }
                switch (n) {
                    case 2: {
                        shape2D.addKey();
                        shape2D.setQuadKey(dArray[0], dArray[1], dArray[2], dArray[3]);
                        break;
                    }
                    case 3: {
                        shape2D.addKey();
                        shape2D.setCubicKey(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        break;
                    }
                    case 0: {
                        shape2D.addKey();
                        shape2D.setStartKey(dArray[0], dArray[1]);
                        break;
                    }
                    case 1: {
                        shape2D.addKey();
                        shape2D.setLineKey(dArray[0], dArray[1]);
                        break;
                    }
                    case 4: {
                        shape2D.addKey();
                        shape2D.setEndKey();
                    }
                }
                pathIterator.next();
            }
        }
    }

    public double getMaxWidth() {
        return this.maxWidth;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public double getStringWidth(String string, double d) {
        double d2 = 0.0;
        for (int i = 0; i < string.length(); ++i) {
            d2 += this.getAdvance(string.charAt(i)) * d;
        }
        return d2;
    }
}

