/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.IPoint3D;
import net.dzzd.core.Axis3D;
import net.dzzd.utils.MathX;

public class Point3D
implements IPoint3D {
    public double x;
    public double y;
    public double z;

    public Point3D() {
        this.set(0.0, 0.0, 0.0);
    }

    public Point3D(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public IPoint3D rotateX(double d) {
        double d2 = this.y;
        double d3 = this.z;
        double d4 = MathX.cos(d);
        double d5 = MathX.sin(d);
        this.y = d2 * d4 + d3 * d5;
        this.z = -d2 * d5 + d3 * d4;
        return this;
    }

    public IPoint3D rotateY(double d) {
        double d2 = this.x;
        double d3 = this.z;
        double d4 = MathX.cos(d);
        double d5 = MathX.sin(d);
        this.x = d2 * d4 - d3 * d5;
        this.z = d2 * d5 + d3 * d4;
        return this;
    }

    public IPoint3D rotateZ(double d) {
        double d2 = this.y;
        double d3 = this.x;
        double d4 = MathX.cos(d);
        double d5 = MathX.sin(d);
        this.x = d3 * d4 + d2 * d5;
        this.y = -d3 * d5 + d2 * d4;
        return this;
    }

    public IPoint3D add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    public IPoint3D cross(IPoint3D iPoint3D) {
        double d;
        double d2 = iPoint3D.getX();
        double d3 = iPoint3D.getY();
        double d4 = iPoint3D.getZ();
        double d5 = this.x * d3 - this.y * d2;
        double d6 = this.z * d2 - this.x * d4;
        this.x = d = this.y * d4 - this.z * d3;
        this.y = d6;
        this.z = d5;
        return this;
    }

    public double dot(IPoint3D iPoint3D) {
        return this.x * iPoint3D.getX() + this.y * iPoint3D.getY() + this.z * iPoint3D.getZ();
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double length2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public boolean equals(IPoint3D iPoint3D) {
        if (this.x != iPoint3D.getX()) {
            return false;
        }
        if (this.y != iPoint3D.getY()) {
            return false;
        }
        return this.z == iPoint3D.getZ();
    }

    public IPoint3D mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public IPoint3D mul(IPoint3D iPoint3D) {
        this.x *= iPoint3D.getX();
        this.y *= iPoint3D.getY();
        this.z *= iPoint3D.getZ();
        return this;
    }

    public IPoint3D div(double d) {
        double d2 = 1.0 / d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return this;
    }

    public double distance2(IPoint3D iPoint3D) {
        double d = this.x - iPoint3D.getX();
        double d2 = this.y - iPoint3D.getY();
        double d3 = this.z - iPoint3D.getZ();
        return d * d + d2 * d2 + d3 * d3;
    }

    public double dist(IPoint3D iPoint3D) {
        return Math.sqrt(this.distance2(iPoint3D));
    }

    public Point3D toLocalAxe(Axis3D axis3D) {
        Point3D point3D = axis3D.origine;
        Point3D point3D2 = axis3D.axeX;
        Point3D point3D3 = axis3D.axeY;
        Point3D point3D4 = axis3D.axeZ;
        double d = point3D.x;
        double d2 = point3D.y;
        double d3 = point3D.z;
        double d4 = point3D2.x - d;
        double d5 = point3D2.y - d2;
        double d6 = point3D2.z - d3;
        double d7 = point3D3.x - d;
        double d8 = point3D3.y - d2;
        double d9 = point3D3.z - d3;
        double d10 = point3D4.x - d;
        double d11 = point3D4.y - d2;
        double d12 = point3D4.z - d3;
        double d13 = this.x - d;
        double d14 = this.y - d2;
        double d15 = this.z - d3;
        this.x = d4 * d13 + d5 * d14 + d6 * d15;
        this.y = d7 * d13 + d8 * d14 + d9 * d15;
        this.z = d10 * d13 + d11 * d14 + d12 * d15;
        return this;
    }

    public String toString() {
        return "(" + this.x + " , " + this.y + " , " + this.z + ")";
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public IPoint3D copy(IPoint3D iPoint3D) {
        this.x = iPoint3D.getX();
        this.y = iPoint3D.getY();
        this.z = iPoint3D.getZ();
        return this;
    }

    public IPoint3D add(IPoint3D iPoint3D) {
        this.x += iPoint3D.getX();
        this.y += iPoint3D.getY();
        this.z += iPoint3D.getZ();
        return this;
    }

    public IPoint3D sub(IPoint3D iPoint3D) {
        this.x -= iPoint3D.getX();
        this.y -= iPoint3D.getY();
        this.z -= iPoint3D.getZ();
        return this;
    }

    public IPoint3D normalize() {
        double d = 1.0 / this.norm();
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public IPoint3D zoom(double d, double d2, double d3) {
        this.x *= d;
        this.y *= d2;
        this.z *= d3;
        return this;
    }

    public IPoint3D getClone() {
        return new Point3D(this.x, this.y, this.z);
    }
}

