/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.util.Vector;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMonitoredSceneObject;
import net.dzzd.access.IRemoveSceneObjectConsumer;
import net.dzzd.access.IScene;
import net.dzzd.access.ISceneLoader;
import net.dzzd.access.ISceneObject;
import net.dzzd.access.ITexture;
import net.dzzd.core.Material;
import net.dzzd.core.MonitoredSceneObject;
import net.dzzd.core.Texture;

public class Scene
implements IScene {
    protected Material[] materials3D;
    protected int nbMaterial;
    protected Texture[] textures;
    protected int nbTexture;
    protected Vector monitoredSceneObjects;
    protected Vector removeSceneObjectConsumer;

    public Scene() {
        this.setSceneBufferSize(1024, 1024);
        this.clearScene();
        this.monitoredSceneObjects = new Vector();
        this.removeSceneObjectConsumer = new Vector();
    }

    public int getNbRemoveSceneObjectConsumer() {
        return this.removeSceneObjectConsumer.size();
    }

    public void addRemoveSceneObjectConsumer(IRemoveSceneObjectConsumer iRemoveSceneObjectConsumer) {
        this.removeSceneObjectConsumer.addElement(iRemoveSceneObjectConsumer);
    }

    public IRemoveSceneObjectConsumer getRemoveSceneObjectConsumer(int n) {
        return (IRemoveSceneObjectConsumer)this.removeSceneObjectConsumer.elementAt(n);
    }

    public void setSceneBufferSize(int n, int n2) {
        this.materials3D = new Material[n];
        this.textures = new Texture[n2];
        this.clearScene();
    }

    public void clearScene() {
        int n;
        for (n = 0; n < this.nbMaterial; ++n) {
            this.materials3D[n] = null;
        }
        this.nbMaterial = 0;
        for (n = 0; n < this.nbTexture; ++n) {
            this.textures[n] = null;
        }
        this.nbTexture = 0;
        Material material = new Material();
        material.setName("Default 3DzzD Material");
        this.addMaterial(material);
    }

    public int getNbSceneObject() {
        int n = this.nbTexture;
        return n += this.nbMaterial;
    }

    public int getNbMaterial() {
        return this.nbMaterial;
    }

    public int getNbTexture() {
        return this.nbTexture;
    }

    public void addMaterial(IMaterial iMaterial) {
        if (((Material)iMaterial).scene == this) {
            return;
        }
        ((Material)iMaterial).scene = this;
        this.materials3D[this.nbMaterial] = (Material)iMaterial;
        ((Material)iMaterial).setId(this.nbMaterial);
        iMaterial.build();
        ++this.nbMaterial;
    }

    public void addTexture(ITexture iTexture) {
        if (((Texture)iTexture).scene == this) {
            return;
        }
        ((Texture)iTexture).scene = this;
        this.textures[this.nbTexture] = (Texture)iTexture;
        iTexture.setId(this.nbTexture);
        this.startMonitorSceneObject((Texture)iTexture);
        iTexture.build();
        ++this.nbTexture;
    }

    public void addSceneObject(ISceneObject iSceneObject) {
        if (iSceneObject instanceof IMaterial) {
            this.addMaterial((IMaterial)iSceneObject);
            return;
        }
        if (iSceneObject instanceof ITexture) {
            this.addTexture((ITexture)iSceneObject);
            return;
        }
    }

    public void addSceneObjects(ISceneObject[] iSceneObjectArray) {
        for (int i = 0; i < iSceneObjectArray.length; ++i) {
            this.addSceneObject(iSceneObjectArray[i]);
        }
    }

    public void removeSceneObject(ISceneObject iSceneObject) {
        if (iSceneObject == null) {
            return;
        }
        if (iSceneObject instanceof ITexture) {
            this.removeTextureById(iSceneObject.getId());
        }
        if (iSceneObject instanceof IMaterial) {
            this.removeMaterialById(iSceneObject.getId());
        }
    }

    public void removeMaterialById(int n) {
        int n2;
        if (this.materials3D[n] == null) {
            return;
        }
        Material material = this.materials3D[n];
        --this.nbMaterial;
        for (n2 = n; n2 < this.getNbMaterial(); ++n2) {
            this.materials3D[n2] = this.materials3D[n2 + 1];
            this.materials3D[n2].setId(n2);
        }
        for (n2 = 0; n2 < this.getNbRemoveSceneObjectConsumer(); ++n2) {
            this.getRemoveSceneObjectConsumer(n2).removeSceneObject(material);
        }
    }

    public void removeTextureById(int n) {
        int n2;
        if (this.textures[n] == null) {
            return;
        }
        Texture texture = this.textures[n];
        --this.nbTexture;
        for (n2 = n; n2 < this.getNbTexture(); ++n2) {
            this.textures[n2] = this.textures[n2 + 1];
            this.textures[n2].setId(n2);
        }
        for (n2 = 0; n2 < this.getNbRemoveSceneObjectConsumer(); ++n2) {
            this.getRemoveSceneObjectConsumer(n2).removeSceneObject(texture);
        }
    }

    public IMaterial getMaterialById(int n) {
        return this.materials3D[n];
    }

    public IMaterial getMaterialByName(String string) {
        for (int i = 0; i < this.nbMaterial; ++i) {
            if (this.materials3D[i] == null || this.materials3D[i].nom == null || !this.materials3D[i].nom.equals(string)) continue;
            return this.materials3D[i];
        }
        return null;
    }

    public ITexture getTextureById(int n) {
        return this.textures[n];
    }

    public ITexture getTextureByName(String string) {
        for (int i = 0; i < this.nbTexture; ++i) {
            if (this.textures[i] == null || this.textures[i].nom == null || !this.textures[i].nom.equals(string)) continue;
            return this.textures[i];
        }
        return null;
    }

    public int getNbMonitoredSceneObject() {
        return this.monitoredSceneObjects.size();
    }

    public void updateMonitoredSceneObjects() {
        int n = this.getNbMonitoredSceneObject();
        if (n != 0) {
            for (int i = 0; i < this.getNbMonitoredSceneObject(); ++i) {
                IMonitoredSceneObject iMonitoredSceneObject = this.getMonitoredSceneObject(i);
                if (!iMonitoredSceneObject.getFinished()) continue;
                if (!iMonitoredSceneObject.getError() && iMonitoredSceneObject instanceof ISceneLoader) {
                    this.addSceneObjects(((ISceneLoader)iMonitoredSceneObject).getSceneObjects());
                }
                this.stopMonitorSceneObject(iMonitoredSceneObject);
            }
            try {
                Thread.sleep(1L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void startMonitorSceneObject(IMonitoredSceneObject iMonitoredSceneObject) {
        this.monitoredSceneObjects.addElement(iMonitoredSceneObject);
    }

    public IMonitoredSceneObject getMonitoredSceneObject(int n) {
        return (MonitoredSceneObject)this.monitoredSceneObjects.elementAt(n);
    }

    public void stopMonitorSceneObject(int n) {
        this.monitoredSceneObjects.removeElementAt(n);
    }

    public void stopMonitorSceneObject(IMonitoredSceneObject iMonitoredSceneObject) {
        this.monitoredSceneObjects.removeElement(iMonitoredSceneObject);
    }
}

