/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.ICamera3D;
import net.dzzd.access.ILight3D;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMonitoredSceneObject;
import net.dzzd.access.IScene3D;
import net.dzzd.access.IScene3DLoader;
import net.dzzd.access.IScene3DObject;
import net.dzzd.access.ISceneLoader;
import net.dzzd.core.Axis3D;
import net.dzzd.core.Camera3D;
import net.dzzd.core.Light3D;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Scene2D;
import net.dzzd.core.Scene3DObject;

public final class Scene3D
extends Scene2D
implements IScene3D {
    protected int maxMesh3D;
    protected Mesh3D[] objects3D;
    protected int nbMesh3D;
    protected int maxLight3D;
    protected Light3D[] lights3D;
    protected int nbLight3D;
    protected int maxCamera3D;
    protected Camera3D[] cameras3D;
    protected int nbCamera3D;
    private int skyBoxMeshId;
    private Camera3D currentCamera3D;
    private int backgroundColor;
    private boolean isBackgroundEnabled;
    private int fogColor;
    private boolean isFogEnabled;

    public Scene3D() {
        this.setScene3DBufferSize(4096, 1024, 1024);
        this.clearScene3D();
    }

    public void setScene3DBufferSize(int n, int n2, int n3) {
        this.maxMesh3D = n;
        this.maxLight3D = n2;
        this.maxCamera3D = n3;
        this.objects3D = new Mesh3D[n];
        this.lights3D = new Light3D[n2];
        this.cameras3D = new Camera3D[n3];
    }

    public int getNbScene3DObject() {
        int n = this.nbCamera3D;
        n += this.nbLight3D;
        return n += this.nbMesh3D;
    }

    public int getNbMesh3D() {
        return this.nbMesh3D;
    }

    public int getNbLight3D() {
        return this.nbLight3D;
    }

    public int getNbCamera3D() {
        return this.nbCamera3D;
    }

    public void addScene3DObject(IScene3DObject iScene3DObject) {
        if (iScene3DObject.getScene3D() == this) {
            return;
        }
        if (iScene3DObject instanceof Light3D) {
            this.addLight3D((ILight3D)iScene3DObject);
            return;
        }
        if (iScene3DObject instanceof Camera3D) {
            this.addCamera3D((ICamera3D)iScene3DObject);
            return;
        }
        if (iScene3DObject instanceof Mesh3D) {
            this.addMesh3D((IMesh3D)iScene3DObject);
            return;
        }
        for (IScene3DObject iScene3DObject2 = iScene3DObject.getFirstChild(); iScene3DObject2 != null; iScene3DObject2 = iScene3DObject2.getNextChild()) {
            this.addScene3DObject(iScene3DObject2);
        }
    }

    public void addMesh3D(IMesh3D iMesh3D) {
        if (((Mesh3D)iMesh3D).scene == this) {
            return;
        }
        ((Mesh3D)iMesh3D).scene = this;
        this.objects3D[this.nbMesh3D] = (Mesh3D)iMesh3D;
        ((Mesh3D)iMesh3D).setId(this.nbMesh3D);
        iMesh3D.build();
        ++this.nbMesh3D;
        for (IScene3DObject iScene3DObject = iMesh3D.getFirstChild(); iScene3DObject != null; iScene3DObject = iScene3DObject.getNextChild()) {
            this.addScene3DObject(iScene3DObject);
        }
    }

    public void addLight3D(ILight3D iLight3D) {
        if (((Light3D)iLight3D).scene == this) {
            return;
        }
        ((Light3D)iLight3D).scene = this;
        this.lights3D[this.nbLight3D] = (Light3D)iLight3D;
        ((Light3D)iLight3D).setId(this.nbLight3D);
        iLight3D.build();
        ++this.nbLight3D;
        for (IScene3DObject iScene3DObject = iLight3D.getFirstChild(); iScene3DObject != null; iScene3DObject = iScene3DObject.getNextChild()) {
            this.addScene3DObject(iScene3DObject);
        }
    }

    public void addCamera3D(ICamera3D iCamera3D) {
        if (((Camera3D)iCamera3D).scene == this) {
            return;
        }
        ((Camera3D)iCamera3D).scene = this;
        this.cameras3D[this.nbCamera3D] = (Camera3D)iCamera3D;
        ((Camera3D)iCamera3D).setId(this.nbCamera3D);
        iCamera3D.build();
        ++this.nbCamera3D;
        for (IScene3DObject iScene3DObject = iCamera3D.getFirstChild(); iScene3DObject != null; iScene3DObject = iScene3DObject.getNextChild()) {
            this.addScene3DObject(iScene3DObject);
        }
    }

    public void removeScene3DObject(IScene3DObject iScene3DObject) {
        if (iScene3DObject == null) {
            return;
        }
        if (iScene3DObject.getScene3D() != this) {
            return;
        }
        for (IScene3DObject iScene3DObject2 = iScene3DObject.getFirstChild(); iScene3DObject2 != null; iScene3DObject2 = iScene3DObject2.getNextChild()) {
            this.removeScene3DObject(iScene3DObject2);
        }
        if (iScene3DObject instanceof IMesh3D) {
            this.removeMesh3DById(iScene3DObject.getId());
        }
        if (iScene3DObject instanceof ILight3D) {
            this.removeLight3DById(iScene3DObject.getId());
        }
        if (iScene3DObject instanceof ICamera3D) {
            this.removeCamera3DById(iScene3DObject.getId());
        }
    }

    public void removeMesh3DById(int n) {
        int n2;
        Mesh3D mesh3D = this.objects3D[n];
        if (mesh3D == null) {
            return;
        }
        if (mesh3D.getScene3D() != this) {
            return;
        }
        for (IScene3DObject iScene3DObject = mesh3D.getFirstChild(); iScene3DObject != null; iScene3DObject = iScene3DObject.getNextChild()) {
            this.removeScene3DObject(iScene3DObject);
        }
        --this.nbMesh3D;
        for (n2 = mesh3D.getId(); n2 < this.getNbMesh3D(); ++n2) {
            this.objects3D[n2] = this.objects3D[n2 + 1];
            this.objects3D[n2].setId(n2);
        }
        for (n2 = 0; n2 < this.getNbRemoveSceneObjectConsumer(); ++n2) {
            this.getRemoveSceneObjectConsumer(n2).removeSceneObject(mesh3D);
        }
    }

    public void removeLight3DById(int n) {
        int n2;
        Light3D light3D = this.lights3D[n];
        if (light3D == null) {
            return;
        }
        if (light3D.getScene3D() != this) {
            return;
        }
        for (IScene3DObject iScene3DObject = light3D.getFirstChild(); iScene3DObject != null; iScene3DObject = iScene3DObject.getNextChild()) {
            this.removeScene3DObject(iScene3DObject);
        }
        --this.nbLight3D;
        for (n2 = light3D.getId(); n2 < this.getNbLight3D(); ++n2) {
            this.lights3D[n2] = this.lights3D[n2 + 1];
            this.lights3D[n2].setId(n2);
        }
        for (n2 = 0; n2 < this.getNbRemoveSceneObjectConsumer(); ++n2) {
            this.getRemoveSceneObjectConsumer(n2).removeSceneObject(light3D);
        }
    }

    public void removeCamera3DById(int n) {
        int n2;
        Camera3D camera3D = this.cameras3D[n];
        if (camera3D == null) {
            return;
        }
        if (camera3D.getScene3D() != this) {
            return;
        }
        for (IScene3DObject iScene3DObject = camera3D.getFirstChild(); iScene3DObject != null; iScene3DObject = iScene3DObject.getNextChild()) {
            this.removeScene3DObject(iScene3DObject);
        }
        if (this.currentCamera3D == this.cameras3D[n]) {
            this.currentCamera3D = null;
        }
        --this.nbCamera3D;
        for (n2 = camera3D.getId(); n2 < this.getNbCamera3D(); ++n2) {
            this.cameras3D[n2] = this.cameras3D[n2 + 1];
            this.cameras3D[n2].setId(n2);
        }
        for (n2 = 0; n2 < this.getNbRemoveSceneObjectConsumer(); ++n2) {
            this.getRemoveSceneObjectConsumer(n2).removeSceneObject(camera3D);
        }
    }

    public void clearScene3D() {
        int n;
        this.currentCamera3D = null;
        this.skyBoxMeshId = -1;
        this.backgroundColor = 0xFFFFFF;
        this.isBackgroundEnabled = true;
        this.fogColor = 0xFFFFFF;
        this.isFogEnabled = false;
        for (n = 0; n < this.nbMesh3D; ++n) {
            this.objects3D[n] = null;
        }
        this.nbMesh3D = 0;
        for (n = 0; n < this.nbLight3D; ++n) {
            this.lights3D[n] = null;
        }
        this.nbLight3D = 0;
        for (n = 0; n < this.nbCamera3D; ++n) {
            this.cameras3D[n] = null;
        }
        this.nbCamera3D = 0;
        Camera3D camera3D = new Camera3D();
        camera3D.setName("Default 3DzzD Camera3D");
        this.addCamera3D(camera3D);
        Light3D light3D = new Light3D();
        light3D.setName("Default 3DzzD Light3D");
        this.addLight3D(light3D);
        this.setCurrentCamera3DById(0);
    }

    public IMesh3D getMesh3DById(int n) {
        return this.objects3D[n];
    }

    public IMesh3D getMesh3DByName(String string) {
        for (int i = 0; i < this.nbMesh3D; ++i) {
            if (this.objects3D[i] == null || this.objects3D[i].nom == null || !this.objects3D[i].nom.equals(string)) continue;
            return this.objects3D[i];
        }
        return null;
    }

    public ICamera3D getCamera3DById(int n) {
        return this.cameras3D[n];
    }

    public ICamera3D getCamera3DByName(String string) {
        for (int i = 0; i < this.nbCamera3D; ++i) {
            if (this.cameras3D[i] == null || this.cameras3D[i].nom == null || !this.cameras3D[i].nom.equals(string)) continue;
            return this.cameras3D[i];
        }
        return null;
    }

    public ILight3D getLight3DById(int n) {
        return this.lights3D[n];
    }

    public ILight3D getLight3DByName(String string) {
        for (int i = 0; i < this.nbCamera3D; ++i) {
            if (this.lights3D[i] == null || this.lights3D[i].nom == null || !this.lights3D[i].nom.equals(string)) continue;
            return this.lights3D[i];
        }
        return null;
    }

    public void setSkyBoxMesh3DByName(String string) {
        IMesh3D iMesh3D = this.getMesh3DByName(string);
        if (iMesh3D != null) {
            this.setSkyBoxMesh3DById(iMesh3D.getId());
        }
    }

    public void setSkyBoxMesh3DById(int n) {
        this.skyBoxMeshId = n;
    }

    public int getSkyBoxMesh3DId() {
        return this.skyBoxMeshId;
    }

    public String getSkyBoxMesh3DName() {
        IMesh3D iMesh3D = this.getMesh3DById(this.skyBoxMeshId);
        if (iMesh3D != null) {
            return iMesh3D.getName();
        }
        return null;
    }

    public void setCurrentCamera3DById(int n) {
        this.currentCamera3D = this.cameras3D[n];
    }

    public void setCurrentCamera3DByName(String string) {
        ICamera3D iCamera3D = this.getCamera3DByName(string);
        if (iCamera3D != null) {
            this.setCurrentCamera3DById(iCamera3D.getId());
        }
    }

    public ICamera3D getCurrentCamera3D() {
        return this.currentCamera3D;
    }

    public void setScene3DObjectToWorld() {
        Scene3DObject scene3DObject;
        int n;
        for (n = 0; n < this.nbMesh3D; ++n) {
            scene3DObject = this.objects3D[n];
            if (scene3DObject == null || !scene3DObject.isActive() || scene3DObject.parent != null) continue;
            this.setToParentSpace(scene3DObject);
        }
        for (n = 0; n < this.nbCamera3D; ++n) {
            scene3DObject = this.cameras3D[n];
            if (scene3DObject == null || !scene3DObject.isActive() || scene3DObject.parent != null) continue;
            this.setToParentSpace(scene3DObject);
        }
        for (n = 0; n < this.nbLight3D; ++n) {
            scene3DObject = this.lights3D[n];
            if (scene3DObject == null || !scene3DObject.isActive() || scene3DObject.parent != null) continue;
            this.setToParentSpace(scene3DObject);
        }
    }

    public void setScene3DObjectToCamera() {
        this.setMesh3DToCamera();
        this.setCamera3DToCamera();
        this.setLight3DToCamera();
    }

    public boolean isBackgroundEnabled() {
        return this.isBackgroundEnabled;
    }

    public void setBackgroundEnabled(boolean bl) {
        this.isBackgroundEnabled = bl;
    }

    public void setBackgroundColor(int n) {
        this.backgroundColor = n;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isFogEnabled() {
        return this.isFogEnabled;
    }

    public void setFogEnabled(boolean bl) {
        this.isFogEnabled = bl;
    }

    public void setFogColor(int n) {
        this.fogColor = n;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public void addScene3DObjects(IScene3DObject[] iScene3DObjectArray) {
        for (int i = 0; i < iScene3DObjectArray.length; ++i) {
            this.addScene3DObject(iScene3DObjectArray[i]);
        }
    }

    private void setToParentSpace(Scene3DObject scene3DObject) {
        if (scene3DObject == null) {
            return;
        }
        Axis3D axis3D = scene3DObject.axes;
        axis3D.init();
        axis3D.set(scene3DObject.pivot, scene3DObject.position, scene3DObject.rotation);
        if (scene3DObject.parent != null) {
            axis3D.toAxis(scene3DObject.parent.axes);
        }
        Scene3DObject scene3DObject2 = scene3DObject.firstChild;
        while (scene3DObject2 != null) {
            this.setToParentSpace(scene3DObject2);
            scene3DObject2 = scene3DObject2.nextChild;
        }
    }

    private void setLight3DToCamera() {
        for (int i = 0; i < this.nbLight3D; ++i) {
            Light3D light3D = this.lights3D[i];
            if (light3D == null || !light3D.isActive()) continue;
            light3D.axes.toLocalAxis(this.currentCamera3D.axes);
        }
    }

    private void setCamera3DToCamera() {
        for (int i = 0; i < this.nbCamera3D; ++i) {
            Camera3D camera3D = this.cameras3D[i];
            if (camera3D == null || camera3D == this.currentCamera3D || !camera3D.isActive()) continue;
            camera3D.axes.toLocalAxis(this.currentCamera3D.axes);
        }
    }

    private void setMesh3DToCamera() {
        for (int i = 0; i < this.nbMesh3D; ++i) {
            Mesh3D mesh3D = this.objects3D[i];
            if (mesh3D == null || !mesh3D.isActive()) continue;
            mesh3D.axes.toLocalAxis(this.currentCamera3D.axes);
        }
    }

    private void playScene3DObjectAnimator(Scene3DObject scene3DObject, int n) {
        if (scene3DObject == null) {
            return;
        }
        if (scene3DObject.animator == null) {
            return;
        }
        if (scene3DObject.animator.getStartTime() != -1L) {
            scene3DObject.animator.playAt(n);
            scene3DObject.position.copy(scene3DObject.animator.getPosition());
            scene3DObject.rotation.copy(scene3DObject.animator.getRotation());
            if (scene3DObject.parent != null) {
                scene3DObject.position.add(scene3DObject.parent.pivot);
            }
        }
    }

    public void playScene3DObjectAnimator(int n) {
        int n2;
        for (n2 = 0; n2 < this.nbMesh3D; ++n2) {
            this.playScene3DObjectAnimator(this.objects3D[n2], n);
        }
        for (n2 = 0; n2 < this.nbCamera3D; ++n2) {
            this.playScene3DObjectAnimator(this.cameras3D[n2], n);
        }
        for (n2 = 0; n2 < this.nbLight3D; ++n2) {
            this.playScene3DObjectAnimator(this.lights3D[n2], n);
        }
    }

    public void setScene3DLoader(IScene3DLoader iScene3DLoader) {
        this.startMonitorSceneObject(iScene3DLoader);
    }

    public void updateMonitoredSceneObjects() {
        int n = this.getNbMonitoredSceneObject();
        if (n != 0) {
            for (int i = 0; i < this.getNbMonitoredSceneObject(); ++i) {
                IMonitoredSceneObject iMonitoredSceneObject = this.getMonitoredSceneObject(i);
                if (!iMonitoredSceneObject.getFinished()) continue;
                if (!iMonitoredSceneObject.getError()) {
                    if (iMonitoredSceneObject instanceof ISceneLoader) {
                        this.addSceneObjects(((ISceneLoader)iMonitoredSceneObject).getSceneObjects());
                    }
                    if (iMonitoredSceneObject instanceof IScene3DLoader) {
                        this.addScene3DObjects(((IScene3DLoader)iMonitoredSceneObject).getScene3DObjects());
                    }
                }
                this.stopMonitorSceneObject(iMonitoredSceneObject);
            }
            try {
                Thread.sleep(1L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

