/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import net.dzzd.access.IAxis3D;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IRender3DMode;
import net.dzzd.access.IScene3D;
import net.dzzd.access.IScene3DObject;
import net.dzzd.access.IScene3DObjectAnimator;
import net.dzzd.access.ISceneObject;
import net.dzzd.core.Axis3D;
import net.dzzd.core.Point3D;
import net.dzzd.core.Scene2DObject;
import net.dzzd.core.Scene3DObjectAnimator;
import net.dzzd.core.SolidSphere3D;

public class Scene3DObject
extends Scene2DObject
implements IScene3DObject {
    Axis3D axes = new Axis3D();
    SolidSphere3D collision = null;
    double sphereBox;
    Point3D position = new Point3D();
    Point3D rotation = new Point3D();
    Point3D pivot = new Point3D();
    Point3D center = new Point3D();
    Point3D zoom = new Point3D(1.0, 1.0, 1.0);
    Scene3DObject parent = null;
    Scene3DObject firstChild;
    Scene3DObject nextChild;
    Scene3DObjectAnimator animator = null;
    private boolean isVisible = true;
    private boolean isActive = true;
    private boolean isSolid = true;
    protected int renderMode = -65;

    Scene3DObject() {
    }

    Scene3DObject toLocalAxe(Axis3D axis3D) {
        this.axes.toLocalAxis(axis3D);
        Point3D point3D = this.axes.origine;
        Point3D point3D2 = this.axes.axeX;
        Point3D point3D3 = this.axes.axeY;
        Point3D point3D4 = this.axes.axeZ;
        double d = point3D.x;
        double d2 = point3D.y;
        double d3 = point3D.z;
        double d4 = point3D2.x - d;
        double d5 = point3D2.y - d2;
        double d6 = point3D2.z - d3;
        double d7 = point3D3.x - d;
        double d8 = point3D3.y - d2;
        double d9 = point3D3.z - d3;
        double d10 = point3D4.x - d;
        double d11 = point3D4.y - d2;
        double d12 = point3D4.z - d3;
        double d13 = this.pivot.x;
        double d14 = this.pivot.y;
        double d15 = this.pivot.z;
        double d16 = d + d4 * d13 + d7 * d14 + d10 * d15;
        double d17 = d2 + d5 * d13 + d8 * d14 + d11 * d15;
        double d18 = d3 + d6 * d13 + d9 * d14 + d12 * d15;
        this.axes.getRotationXZY(this.rotation);
        this.position.set(d16, d17, d18);
        return this;
    }

    Scene3DObject translate(double d, double d2, double d3) {
        this.axes.add(d, d2, d3);
        return this;
    }

    public void zoom(double d, double d2, double d3) {
        if (this.animator != null) {
            this.animator.zoom(d, d2, d3);
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.zoom(d, d2, d3);
            scene3DObject.position.sub(this.pivot).zoom(d, d2, d3).add(this.pivot);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void copy(IScene3DObject iScene3DObject) {
        this.position.copy(iScene3DObject.getPosition());
        this.rotation.copy(iScene3DObject.getRotation());
        this.pivot.copy(iScene3DObject.getPivot());
        this.center.copy(iScene3DObject.getCenter());
        this.zoom.copy(iScene3DObject.getZoom());
        this.sphereBox = iScene3DObject.getSphereBox();
        if (iScene3DObject.getScene3DObjectAnimator() != null) {
            this.setScene3DObjectAnimator(iScene3DObject.getScene3DObjectAnimator().getClone());
        } else {
            this.animator = null;
        }
        this.isVisible = iScene3DObject.isVisible();
        this.isActive = iScene3DObject.isActive();
        this.isSolid = iScene3DObject.isSolid();
        this.axes.copy(iScene3DObject.getAxis3D());
        super.copy(iScene3DObject);
    }

    public IScene3DObject getClone(boolean bl) {
        Scene3DObject scene3DObject = new Scene3DObject();
        scene3DObject.copy((ISceneObject)this);
        if (bl) {
            Scene3DObject scene3DObject2 = this.firstChild;
            while (scene3DObject2 != null) {
                scene3DObject.addChild(scene3DObject2.getClone(bl));
                scene3DObject2 = scene3DObject2.nextChild;
            }
        }
        return scene3DObject;
    }

    public IScene3D getScene3D() {
        return (IScene3D)this.scene;
    }

    public IPoint3D getPosition() {
        return this.position;
    }

    public IPoint3D getRotation() {
        return this.rotation;
    }

    public IPoint3D getPivot() {
        return this.pivot;
    }

    public IPoint3D getZoom() {
        return this.zoom;
    }

    public IAxis3D getAxis3D() {
        return this.axes;
    }

    public IScene3DObject getParent() {
        return this.parent;
    }

    public void setParent(IScene3DObject iScene3DObject) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = (Scene3DObject)iScene3DObject;
        iScene3DObject.addChild(this);
    }

    public void addChild(IScene3DObject iScene3DObject) {
        if (iScene3DObject == null) {
            return;
        }
        Object var2_2 = null;
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            if (iScene3DObject == scene3DObject) {
                return;
            }
            scene3DObject = scene3DObject.nextChild;
        }
        ((Scene3DObject)iScene3DObject).nextChild = this.firstChild;
        this.firstChild = (Scene3DObject)iScene3DObject;
        ((Scene3DObject)iScene3DObject).parent = this;
    }

    public void removeChild(IScene3DObject iScene3DObject) {
        Scene3DObject scene3DObject = (Scene3DObject)iScene3DObject;
        scene3DObject.parent = null;
        Scene3DObject scene3DObject2 = null;
        Scene3DObject scene3DObject3 = this.firstChild;
        while (scene3DObject3 != null) {
            if (scene3DObject3 == scene3DObject) {
                if (scene3DObject2 == null) {
                    this.firstChild = scene3DObject.nextChild;
                    break;
                }
                scene3DObject2.nextChild = scene3DObject.nextChild;
                break;
            }
            scene3DObject2 = scene3DObject3;
            scene3DObject3 = scene3DObject3.nextChild;
        }
    }

    public IScene3DObject getFirstChild() {
        return this.firstChild;
    }

    public IScene3DObject getNextChild() {
        return this.nextChild;
    }

    public double getSphereBox() {
        return this.sphereBox;
    }

    public void setSphereBox(double d) {
        this.sphereBox = d;
    }

    public IPoint3D getCenter() {
        return this.center;
    }

    public IScene3DObjectAnimator getScene3DObjectAnimator() {
        return this.animator;
    }

    public void setScene3DObjectAnimator(IScene3DObjectAnimator iScene3DObjectAnimator) {
        this.animator = (Scene3DObjectAnimator)iScene3DObjectAnimator;
    }

    public void playScene3DObjectAnimator() {
        if (this.animator == null) {
            return;
        }
        this.animator.play();
        this.position.copy(this.animator.getPosition());
        this.rotation.copy(this.animator.getRotation());
        if (this.parent != null) {
            this.position.add(this.parent.pivot);
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.playScene3DObjectAnimator();
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void startScene3DObjectAnimator() {
        if (this.animator != null) {
            this.animator.start();
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.startScene3DObjectAnimator();
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void startScene3DObjectAnimator(long l) {
        if (this.animator != null) {
            this.animator.start(l);
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.startScene3DObjectAnimator(l);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void startScene3DObjectAnimator(long l, long l2) {
        if (this.animator != null) {
            this.animator.start(l, l2);
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.startScene3DObjectAnimator(l, l2);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void stopScene3DObjectAnimator() {
        if (this.animator != null) {
            this.animator.stop();
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.stopScene3DObjectAnimator();
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void pauseScene3DObjectAnimator() {
        if (this.animator != null) {
            this.animator.pause();
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.pauseScene3DObjectAnimator();
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void resumeScene3DObjectAnimator() {
        if (this.animator != null) {
            this.animator.resume();
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.resumeScene3DObjectAnimator();
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void loopAtScene3DObjectAnimator(long l) {
        if (this.animator != null) {
            this.animator.loopAt(l);
        }
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.loopAtScene3DObjectAnimator(l);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isSolid() {
        return this.isSolid;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.setVisible(bl);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.setActive(bl);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void setSolid(boolean bl) {
        this.isSolid = bl;
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.setSolid(bl);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public IScene3DObject setAxis3DToWorld() {
        this.axes.init();
        this.axes.set(this.pivot, this.position, this.rotation);
        Scene3DObject scene3DObject = this.parent;
        while (scene3DObject != null) {
            this.axes.set(scene3DObject.pivot, scene3DObject.position, scene3DObject.rotation);
            scene3DObject = scene3DObject.parent;
        }
        return this;
    }

    public IRender3DMode getRender3DMode() {
        return this;
    }

    public void enableRender3DMode(int n) {
        this.renderMode |= n;
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.enableRender3DMode(n);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void disableRender3DMode(int n) {
        this.renderMode &= n ^ 0xFFFFFFBF;
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.disableRender3DMode(n);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public void setRender3DModeFlags(int n) {
        this.renderMode = n;
        Scene3DObject scene3DObject = this.firstChild;
        while (scene3DObject != null) {
            scene3DObject.setRender3DModeFlags(n);
            scene3DObject = scene3DObject.nextChild;
        }
    }

    public int getRender3DModeFlags() {
        return this.renderMode;
    }

    public void setPoint3DToWorld(IPoint3D iPoint3D) {
        Point3D point3D = (Point3D)iPoint3D;
        point3D.add(-this.pivot.x, -this.pivot.y, -this.pivot.z);
        point3D.rotateX(this.rotation.x);
        point3D.rotateZ(this.rotation.z);
        point3D.rotateY(this.rotation.y);
        point3D.add(this.position.x, this.position.y, this.position.z);
        Scene3DObject scene3DObject = this.parent;
        while (scene3DObject != null) {
            point3D.add(-scene3DObject.pivot.x, -scene3DObject.pivot.y, -scene3DObject.pivot.z);
            point3D.rotateX(scene3DObject.rotation.x);
            point3D.rotateZ(scene3DObject.rotation.z);
            point3D.rotateY(scene3DObject.rotation.y);
            point3D.add(scene3DObject.position.x, scene3DObject.position.y, scene3DObject.position.z);
            scene3DObject = scene3DObject.parent;
        }
    }
}

