TITLE Fonction pour grer les fonction 3d

.DATA
 COSIN_TAB DD 0

.CODE

;*****************************************************************************
;        Fonction qui initialise la table des cosinus et sinus
;*****************************************************************************
;    Sortie : la variable COSIN_TAB=pointeur32 sur 7FFFFFFF*sin(ofset) (DWORD)
;*****************************************************************************
;   REMARQUE: Utilise le coprocesseur arithmtique
;             La taille de la table est de (360+90)*4
;*****************************************************************************
TEMP_buffer=16
 Angle=[BP+2]
 A180=[BP+6]
 Amult=[BP+10]
 result=[BP+14]

SR_INIT_COSIN_TAB PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ES

  PUSH WORD PTR 3
  CALL SR_ALLOUE_EMB

  MOV EDI,EAX
  MOV AX,@DATA
  MOV DS,AX
  MOV COSIN_TAB,EDI

  XOR AX,AX
  MOV DS,AX
  MOV ES,AX

  FINIT            ;Initialise coprocesseur

  MOV DWORD PTR angle,0
  MOV DWORD PTR a180,180
  MOV DWORD PTR amult,07FFFFFFFH

  FILD DWORD PTR amult ;Charge valeur 07FFFFFFFH
  FLDPI                ;charge valeur de pi
  FILD DWORD PTR a180  ;Charge valeur 180

  CLD
  MOV ECX,450
  @SR_I_C_T0:
   FILD DWORD PTR angle
   FMUL ST(0),ST(2)
   FDIV ST(0),ST(1)
   FSIN
   FMUL ST(0),ST(3)
   FISTP DWORD PTR result
   INC DWORD PTR angle
   MOV EAX,result
   DB 67H
   STOSD
  LOOPD @SR_I_C_T0

 POP ES
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN
ENDP

INIT_COSIN_TAB MACRO
 CALL SR_INIT_COSIN_TAB
ENDM

;*****************************************************************************
;   Effectue la rotation d'un tableaux de point 3D autour de l'axe des Z X=>Y
;*****************************************************************************
;    Entree : angle de rotation (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs rotation
;*****************************************************************************
;   REMARQUE: Il faut dabord lancer la fonction init_cosin_tab
;             newX = X*cos(RZ) - Y*sin(RZ)
;             newY = X*sin(RZ) + Y*cos(RZ)
;             newZ = Z
;*****************************************************************************
TEMP_buffer=24
 cosangle=[BP+2]
 sinangle=[BP+6]
 newx=[BP+10]
 newY=[BP+14]
 A180=[BP+18]
 Amult=[BP+22]


;Parametre passer  la fonction
 angle=[BP+12+TEMP_buffer]            ;angle z de rotation
 ofs32_tabd=[BP+8+TEMP_buffer]        ;ofs32 tab depart
 ofs32_taba=[BP+4+TEMP_buffer]        ;ofs32 tab arriv

SR_ROTATE_P3D_AXEZ PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 ;Rectifie l'angle si >359 ou <0
 ; MOV EAX,angle
 ; CDQ
 ; MOV EBX,360
 ; IDIV EBX
 ; CMP EDX,0
 ; JNS @SR_R_P_AZ0
 ;  ADD EDX,360
 ; @SR_R_P_AZ0:
 ; SHL EDX,2

  FINIT                     ;Initialise coprocesseur

  MOV DWORD PTR a180,180
  MOV DWORD PTR amult,07FFFFFFFH

  FILD DWORD PTR amult      ;Charge valeur 07FFFFFFFH
  FLDPI                     ;charge valeur de pi
  FILD DWORD PTR a180       ;Charge valeur 180

  FILD DWORD PTR angle      ;Calcul sinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FSIN
  FMUL ST(0),ST(3)
  FISTP DWORD PTR SinAngle

  FILD DWORD PTR angle      ;Calcul Cosinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FCOS
  FMUL ST(0),ST(3)
  FISTP DWORD PTR CosAngle



 ; MOV AX,@DATA
 ; MOV DS,AX
  
 ; MOV ESI,COSIN_TAB        ;ESI pointe sur sin(angle)
 ; ADD ESI,EDX              ;ESI+90 cos(angle)

  XOR AX,AX
  MOV DS,AX
 ; MOV EAX,[ESI]
 ; MOV sinangle,EAX
 ; MOV EAX,[ESI+90*4]
 ; MOV cosangle,EAX

  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX


  @SR_R_P_AZ1:
   ADD EDI,12
   ADD ESI,12

   ;newX = X*cos(RZ) - Y*sin(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newx,EAX                  ;Calcul newX
                                 ;
   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   SUB newx,EAX                  ;

   ;newY = X*sin(RZ) + Y*cos(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newy,EAX                  ;Calcul newY
                                 ;
   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   ADD newy,EAX                  ;


   MOV EAX,newX                  ;
   MOV [EDI],EAX                 ;Fixe les nouvelles valeurs
   MOV EAX,newY                  ;
   MOV [EDI+4],EAX               ;

   ;newZ=Z

   MOV EAX,[ESI+8]               ; Fixe newZ
   MOV [EDI+8],EAX               ;

  LOOPD @SR_R_P_AZ1

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 12
ENDP

ROTATE_P3D_AXEZ MACRO angle,ofs32d,ofs32a
 PUSH DWORD PTR angle
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_ROTATE_P3D_AXEZ
ENDM

;*****************************************************************************
;   Effectue la rotation d'un tableaux de point 3D autour de l'axe des X Y=>Z
;*****************************************************************************
;    Entree : angle de rotation (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs rotation
;*****************************************************************************
;   REMARQUE: Il faut dabord lancer la fonction init_cosin_tab
;             newX = X
;             newY = Y*cos(RX) - Z*sin(RX)
;             newZ = Y*sin(RX) + Z*cos(RX)
;
;*****************************************************************************

TEMP_buffer=16
 cosangle=[BP+2]
 sinangle=[BP+6]
 newy=[BP+10]
 newz=[BP+14]

;Parametre passer  la fonction
 angle=[BP+12+TEMP_buffer]            ;angle z de rotation
 ofs32_tabd=[BP+8+TEMP_buffer]        ;ofs32 tab depart
 ofs32_taba=[BP+4+TEMP_buffer]        ;ofs32 tab arriv

SR_ROTATE_P3D_AXEX PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 ;Rectifie l'angle si >359 ou <0
  MOV EAX,angle
  CDQ
  MOV EBX,360
  IDIV EBX
  CMP EDX,0
  JNS @SR_R_P_AX0
   ADD EDX,360
  @SR_R_P_AX0:
  SHL EDX,2

  MOV AX,@DATA
  MOV DS,AX
  
  MOV ESI,COSIN_TAB        ;ESI pointe sur sin(angle)
  ADD ESI,EDX              ;ESI+90 cos(angle)

  XOR AX,AX
  MOV DS,AX
  MOV EAX,[ESI]
  MOV sinangle,EAX
  MOV EAX,[ESI+90*4]
  MOV cosangle,EAX

  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX


  @SR_R_P_AX1:
   ADD EDI,12
   ADD ESI,12

   ;newZ = Y*sin(RX) + Z*cos(RX)

   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newz,EAX                  ;Calcul newZ
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   ADD newz,EAX                  ;

   ;newY = Y*cos(RX) - Z*sin(RX)

   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newy,EAX                  ;Calcul newY
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   SUB newy,EAX                  ;

   MOV EAX,newY                  ;
   MOV [EDI+4],EAX               ;Fixe les nouvelles valeurs
   MOV EAX,newZ                  ;
   MOV [EDI+8],EAX               ;

   ;newX=X

   MOV EAX,[ESI]                 ; Fixe newX
   MOV [EDI],EAX                 ;

  LOOPD @SR_R_P_AX1

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 12
ENDP

ROTATE_P3D_AXEX MACRO angle,ofs32d,ofs32a
 PUSH DWORD PTR angle
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_ROTATE_P3D_AXEX
ENDM


;*****************************************************************************
;   Effectue la rotation d'un tableaux de point 3D autour de l'axe des Y X=>Z
;*****************************************************************************
;    Entree : angle de rotation (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs rotation
;*****************************************************************************
;   REMARQUE: Il faut dabord lancer la fonction init_cosin_tab
;
;             newX = X*cos(RZ) - Z*sin(RZ)
;             newZ = X*sin(RZ) + Z*cos(RZ)
;             newY = Y
;*****************************************************************************

TEMP_buffer=16
 cosangle=[BP+2]
 sinangle=[BP+6]
 newx=[BP+10]
 newz=[BP+14]

;Parametre passer  la fonction
 angle=[BP+12+TEMP_buffer]            ;angle z de rotation
 ofs32_tabd=[BP+8+TEMP_buffer]        ;ofs32 tab depart
 ofs32_taba=[BP+4+TEMP_buffer]        ;ofs32 tab arriv

SR_ROTATE_P3D_AXEY PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 ;Rectifie l'angle si >359 ou <0
  MOV EAX,angle
  CDQ
  MOV EBX,360
  IDIV EBX
  CMP EDX,0
  JNS @SR_R_P_AY0
   ADD EDX,360
  @SR_R_P_AY0:
  SHL EDX,2

  MOV AX,@DATA
  MOV DS,AX
  
  MOV ESI,COSIN_TAB        ;ESI pointe sur sin(angle)
  ADD ESI,EDX              ;ESI+90 cos(angle)

  XOR AX,AX
  MOV DS,AX
  MOV EAX,[ESI]
  MOV sinangle,EAX
  MOV EAX,[ESI+90*4]
  MOV cosangle,EAX

  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX


  @SR_R_P_AY1:
   ADD EDI,12
   ADD ESI,12

   ;newZ = X*sin(RZ) + Z*cos(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newz,EAX                  ;Calcul newZ
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   ADD newz,EAX                  ;

   ;newX = X*cos(RZ) - Z*sin(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newx,EAX                  ;Calcul newX
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   SUB newx,EAX                  ;

   MOV EAX,newX                  ;
   MOV [EDI],EAX                 ;Fixe les nouvelles valeurs
   MOV EAX,newZ                  ;
   MOV [EDI+8],EAX               ;

   ;newY=Y

   MOV EAX,[ESI+4]               ; Fixe newY
   MOV [EDI+4],EAX               ;

  LOOPD @SR_R_P_AY1

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 12
ENDP

ROTATE_P3D_AXEY MACRO angle,ofs32d,ofs32a
 PUSH DWORD PTR angle
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_ROTATE_P3D_AXEY
ENDM


;*****************************************************************************
;   Effectue la translation d'un tableaux de point 3D suivant les axes x,y,z
;*****************************************************************************
;    Entree : transX (DWORD)
;             transY (DWORD)
;             transZ (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs translation
;*****************************************************************************
;   REMARQUE: newX = X+TX
;             newY = Y+TY
;             newZ = Z+TZ
;*****************************************************************************

;Parametre passer  la fonction
 TransX=[BP+20]           ;Translation X
 TransY=[BP+16]           ;Translation Y
 TransZ=[BP+12]           ;Translation Z
 ofs32_tabd=[BP+8]        ;ofs32 tab depart
 ofs32_taba=[BP+4]        ;ofs32 tab arriv

SR_TRANSLATE_P3D PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX
  XOR AX,AX
  MOV DS,AX
  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX

  @SR_T_P1:
   ADD EDI,12
   ADD ESI,12

   MOV EAX,[ESI]      ;
   ADD EAX,TransX     ;Traite posX
   MOV [EDI],EAX      ;

   MOV EAX,[ESI+4]    ;
   ADD EAX,TransY     ;Traite posY
   MOV [EDI+4],EAX    ;

   MOV EAX,[ESI+8]    ;
   ADD EAX,TransZ     ;Traite posZ
   MOV [EDI+8],EAX    ;
  LOOPD @SR_T_P1

 POP ECX
 POP DS
 POP BP
RETN 20
ENDP

TRANSLATE_P3D MACRO tranX,tranY,tranZ,ofs32d,ofs32a
 PUSH DWORD PTR tranX
 PUSH DWORD PTR tranY
 PUSH DWORD PTR tranZ
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_TRANSLATE_P3D
ENDM

;*****************************************************************************
;       Projette un tableaux de point pour donner une impression 3D
;*****************************************************************************
;    Entree : longueur du focus de la camera (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs projection
;*****************************************************************************
;   REMARQUE: newX = X-(Z*X)/f
;             newY = Y-(Z*Y)/f
;             newZ = Z
;*****************************************************************************

;Parametre passer  la fonction
 focusc=[BP+12]           ;Focus lentille 
 ofs32_tabd=[BP+8]        ;ofs32 tab depart
 ofs32_taba=[BP+4]        ;ofs32 tab arriv

SR_PROJETTE_P3D PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX
  XOR AX,AX
  MOV DS,AX
  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX

  @SR_P_P1:
   MOV EAX,12
   ADD EDI,EAX
   ADD ESI,EAX

  MOV EAX,focusc
  NEG EAX
  CMP DWORD PTR [ESI+8],EAX
  JLE @SR_P_P0

   MOV EAX,[ESI]          ;Traite posX
   MOV EBX,focusc         ;
   IMUL EBX               ;new x = x*focus/(focus+z)
   ADD EBX,[ESI+8]        ;
   IDIV EBX               ;
   MOV [EDI],EAX          ;

   MOV EAX,[ESI+4]        ;Traite posY
   MOV EBX,focusc         ;
   IMUL EBX               ;new y = y*focus/(focus+z)
   ADD EBX,[ESI+8]        ;
   IDIV EBX               ;
   MOV [EDI+4],EAX        ;

  JMP @SR_P_P2
  @SR_P_P0:

   MOV EAX,[ESI]          ;Traite posX
   IMUL DWORD PTR focusc
   MOV [EDI],EAX          ;

   MOV EAX,[ESI+4]        ;Traite posY
   IMUL DWORD PTR focusc
   MOV [EDI+4],EAX        ;

  @SR_P_P2:

   MOV EAX,[ESI+8]        ;Traite posZ
   MOV [EDI+8],EAX        ;
  LOOPD @SR_P_P1

 POP ECX
 POP DS
 POP BP
RETN 12
ENDP

PROJETTE_P3D MACRO focusc,ofs32d,ofs32a
 PUSH DWORD PTR focusc
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_PROJETTE_P3D
ENDM

;*****************************************************************************
;                         Crer un bufferZ 
;*****************************************************************************
;    Entree : Zmin       (DWORD) PositionZ minimum
;             Zmax       (DWORD) PositionZ maximum 
;             NBobjMAX  (DWORD) Nombre max d'objet(dword)  stocker par posZ
;*****************************************************************************
;    Sortie : le bufferZ est cr EAX=pointeur sur le buffer
;*****************************************************************************
;  REMARQUE : Ncessite les fonction HIMEM.FNC
;*****************************************************************************

;Variables locales
 TEMP_buffer=4
 bufferz=[BP+2]

;Parametre passer  la fonction
 Zmin=[BP+12+TEMP_buffer]       ;pos Zmin
 Zmax=[BP+8+TEMP_buffer]        ;pos Zmin
 NBpolyMax=[BP+4+TEMP_buffer]   ;Nombre max de polygone par posZ

SR_CREATE_BUFFERZ PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 MOV EAX,Zmax        ;
 SUB EAX,Zmin        ;
 INC EAX             ;
 MOV EBX,NBpolyMAX   ;Calcul taille du buffer =12+(nbpolymax+1)*(zmax-zmin+1)*4
 INC EBX             ;
 MUL EBX             ;
 MOV EBX,4           ;
 MUL EBX             ;
 ADD EAX,12          ;
 SHR EAX,10          ;
 INC EAX             ;

 PUSH AX             ;Alloue le buffer
 CALL SR_ALLOUE_EMB  ;
 MOV bufferz,EAX     ;

 XOR AX,AX           ;Fixe valeur zmin,zmax,nbmaxpoly du buffer
 MOV DS,AX           ;
 MOV EDI,bufferz     ;
 MOV EAX,Zmin        ;
 MOV [EDI],EAX       ;
 MOV EAX,Zmax        ;
 MOV [EDI+4],EAX     ;
 MOV EAX,NBpolyMax   ;
 MOV [EDI+8],EAX     ;

 MOV EAX,bufferz     ;valeur de retour = adresse buffer

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
 RETN 12
ENDP

CREATE_BUFFERZ MACRO zmin,zmax,nbmaxpoly
 PUSH DWORD PTR ZMin
 PUSH DWORD PTR ZMax
 PUSH DWORD PTR nbmaxpoly
 CALL SR_CREATE_BUFFERZ
ENDM

;*****************************************************************************
;                         Initialise un bufferZ 
;*****************************************************************************
;    Entree : Bufferz pointeur 32 sur buffer  initialiser
;*****************************************************************************
;    Sortie : le bufferZ est initialis
;*****************************************************************************

;Parametre passer  la fonction
 BufferZ=[BP+4]        ;Pointeur sur le bufferz

SR_INIT_BUFFERZ PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

  XOR AX,AX
  MOV DS,AX

  MOV EDI,bufferz
  MOV ECX,[EDI+4]
  SUB ECX,[EDI]
  INC ECX

  MOV EAX,[EDI+8]   ;EBX=NBmaxPoly
  INC EAX           ;
  SHL EAX,2
  MOV EDX,EAX

  XOR EAX,EAX
  ADD EDI,12

  @I_BZ0:
   MOV [EDI],EAX
   ADD EDI,EDX
  LOOPD @I_BZ0

 POP ECX
 POP DS
 POP BP
 RETN 4
ENDP

INIT_BUFFERZ MACRO bufferz
 PUSH DWORD PTR bufferz
 CALL SR_INIT_BUFFERZ
ENDM


;*****************************************************************************
;     Ajoute un polygone a un bufferZ si il est visible
;*****************************************************************************
;    Entree : polygone (DWORD)  polygone  ajouter
;             ecranz   (DWORD)  ecran d'affichage 
;             bufferz  (DWORD)  buffer de stockage
;*****************************************************************************
;    Sortie : le bufferZ est mis  jour
;*****************************************************************************

;Variables locales
TEMP_buffer=44
 PosXmin =[BP+2]
 PosXmax =[BP+6]
 PosYmin =[BP+10]
 PosYmax =[BP+14]
 PosZmin =[BP+18]
 PosZmax =[BP+22]
 NPXmax=[BP+26]
 NPXmin=[BP+30]
 NPYmax=[BP+34]
 NPYmin=[BP+38]
 NPYX=[BP+42]

;Parametre passer  la fonction
 polya=[BP+12+TEMP_buffer]       ;ofs32 du polygone
 ecranz=[BP+8+TEMP_buffer]       ;ofs32 ecran
 bufferz=[BP+4+TEMP_buffer]      ;ofs32 du bufferZ

SR_AJOUTE_POLYGONE_BUFFERZ PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX
  XOR AX,AX
  MOV DS,AX

  MOV ESI,polya
  MOV EDI,ESI.[Ptab_P2D]
  MOV ECX,ESI.[PNB_points]

 ;Cherche PosXmin,PosXmax,PosYmin,PosYmax,PosZmin,PosZmax
  MOV EAX,ESI.[PNP1]        ; EAX=numro point 1
  MOV EBX,12                ;
  MUL EBX                   ; 
  MOV EBX,EAX               ; EBX+EDI=offset point1
  MOV EAX,DS:[EDI+EBX]      ; EAX=X point 1
  MOV PosXmin,EAX
  MOV PosXmax,EAX
  MOV EAX,DS:[EDI+EBX+4]    ; EAX=Y point 1
  MOV PosYmin,EAX
  MOV PosYmax,EAX
  MOV EAX,DS:[EDI+EBX+8]    ; EAX=Z point 1
  MOV PosZmin,EAX
  MOV PosZmax,EAX

  MOV EAX,1
  MOV NPXmax,EAX
  MOV NPXmin,EAX
  MOV NPYmin,EAX
  MOV NPYmax,EAX

  MOV NPYX,EAX

  DEC ECX
  @SR_A_P_BZ0:
   INC DWORD PTR NPYX
   ADD ESI,12
   MOV EAX,ESI.[PNP1]
   MOV EBX,12
   MUL EBX
   MOV EBX,EAX
   MOV EDX,NPYX           ;


   MOV EAX,DS:[EDI+EBX]   ;
   CMP EAX,PosXmin        ;
   JGE @SR_A_P_BZ1        ;Fixe PosXmin et PosXmax
    MOV PosXmin,EAX       ;
    MOV NPXmin,EDX        ;
   @SR_A_P_BZ1:           ;
   CMP EAX,PosXmax        ;
   JLE @SR_A_P_BZ2        ;
    MOV PosXmax,EAX       ;
    MOV NPXmax,EDX        ;
   @SR_A_P_BZ2:           ;

   MOV EAX,DS:[EDI+EBX+4] ;   
   CMP EAX,PosYmin        ;
   JGE @SR_A_P_BZ3        ;Fixe PosYmin et PosYmax
    MOV PosYmin,EAX       ;
    MOV NPYmin,EDX        ;
   @SR_A_P_BZ3:           ;
   CMP EAX,PosYmax        ;
   JLE @SR_A_P_BZ4        ;
    MOV PosYmax,EAX       ;
    MOV NPYmax,EDX        ;
   @SR_A_P_BZ4:           ;

   MOV EAX,DS:[EDI+EBX+8] ;   
   CMP EAX,PosZmin        ;
   JGE @SR_A_P_BZ5        ;Fixe PosZmin et PosZmax
    MOV PosZmin,EAX       ;
   @SR_A_P_BZ5:           ;
   CMP EAX,PosZmax        ;
   JLE @SR_A_P_BZ6        ;
    MOV PosZmax,EAX       ;
   @SR_A_P_BZ6:           ;

   DEC ECX
   JECXZ @SR_A_P_BZ20
   JMP @SR_A_P_BZ0
  @SR_A_P_BZ20:
  ;Les Positions max et min sont fixes.

  MOV ESI,bufferz
  MOV EAX,PosZmax                ;
  CMP EAX,[ESI]                  ;
  JGE @SR_A_P_BZ12               ;Test si polygone compris entre Zmin et Zmax
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ12:                  ;
  MOV EAX,PosZmin                ;
  CMP EAX,[ESI+4]                ;
  JLE @SR_A_P_BZ13               ;
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ13:                  ;

  MOV ESI,ecranz
  MOV EAX,PosYmax                ;
  CMP EAX,ESI.[Ymin]             ;
  JGE @SR_A_P_BZ9                ;Test si polygone compris entre Ymin et Ymax
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ9:                   ;
  MOV EAX,PosYmin                ;
  CMP EAX,ESI.[Ymax]             ;
  JLE @SR_A_P_BZ10               ;
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ10:                  ;

  ;Test si polygone dans l'ecran et dans le bufferZ
  MOV ESI,ecranz
  MOV EAX,PosXmax                ;
  CMP EAX,ESI.[Xmin]             ;
  JGE @SR_A_P_BZ7                ;Test si polygone compris entre Xmin et Xmax
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ7:                   ;
  MOV EAX,PosXmin                ;
  CMP EAX,ESI.[Xmax]             ;
  JLE @SR_A_P_BZ8                ;
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ8:                   ;

 ;Ici on sait que le polygone est compris dans l'ecran et dans le bufferz 


 ;test si le polygone est  l'endroit.

 ;si oui NPXmin>NPYmin>NPXmax>NPYmax
  MOV DWORD PTR NPYX,0
  MOV EAX,NPXmax
  CMP NPYmax,EAX
  JG @SR_A_P_BZ16
   INC DWORD PTR NPYX
  @SR_A_P_BZ16:
  CMP EAX,NPYmin
  JG @SR_A_P_BZ17
   INC DWORD PTR NPYX
  @SR_A_P_BZ17:
  MOV EAX,NPXmin
  CMP NPYmin,EAX
  JG @SR_A_P_BZ18
   INC DWORD PTR NPYX
  @SR_A_P_BZ18:
  CMP EAX,NPYmax
  JG @SR_A_P_BZ19
   INC DWORD PTR NPYX
  @SR_A_P_BZ19:


  CMP DWORD PTR NPYX,2
  JL @SR_A_P_BZ11        ;Si positif polygone out

 ;Ajoute le polygonne au bufferZ
  MOV EDI,BufferZ

  MOV EAX,PosZmax            ;
  ADD EAX,PosZmin            ;
  CDQ                        ;Calcul PosZmilieu
  MOV EBX,2                  ; est rectifie si sort du bufferZ
  IDIV EBX                   ;
  CMP EAX,[EDI]              ;
  JGE @SR_A_P_BZ14           ;
   MOV EAX,[EDI]             ;
  @SR_A_P_BZ14:              ;
  CMP EAX,[EDI+4]            ;
  JLE @SR_A_P_BZ15           ;
   MOV EAX,[EDI+4]           ;
  @SR_A_P_BZ15:              ;

  MOV EBX,[EDI+8]            ;
  INC EBX                    ;Calcul pos dans le buffer
  SHL EBX,2                  ;
  SUB EAX,[EDI]              ;
  MUL EBX                    ;
  ADD EAX,12                 ;
  MOV EBX,EAX                ;

  MOV EAX,DS:[EDI+EBX]       ;Test si buffer plein  cette place
  CMP EAX,[EDI+8]            ;si oui ne stock pas le polygone
  JGE @SR_A_P_BZ11           ;
   INC EAX
   MOV DS:[EDI+EBX],EAX      ;
   SHL EAX,2                 ;ESI pointe sur entr dans le buffer
   ADD EBX,EAX               ;

   MOV EAX,polya             ;Stock le polygone
   MOV DS:[EDI+EBX],EAX      ;
 @SR_A_P_BZ11:


 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 12
ENDP

AJOUTE_POLYGONE_BUFFERZ MACRO polya,ecranz,bufferz
 PUSH DWORD PTR polya
 PUSH DWORD PTR ecranz
 PUSH DWORD PTR bufferz
 CALL SR_AJOUTE_POLYGONE_BUFFERZ
ENDM

;*****************************************************************************
;     Affiche les polygone contenue dans un bufferZ
;*****************************************************************************
;    Entree : bufferZ  (DWORD)  bufferz
;             numroZD (DWORD)  positionZ des poly  afficher
;             numroZF (DWORD)  positionZ des poly  afficher
;             ecranz   (DWORD)  ecran d'affichage
;             masquez  (DWORD)  masque  utiliser
;*****************************************************************************
;    Sortie : les poly sont afficher
;*****************************************************************************

;Parametre passer  la fonction
 bufferZ=[BP+20]      ;
 numeroZD=[BP+16]     ;
 numeroZF=[BP+12]     ;
 ecranz=[BP+8]        ;
 masquez=[BP+4]       ;

SR_AFFICHE_POLYGONE_BUFFERZ PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 XOR AX,AX
 MOV DS,AX
 MOV EDI,bufferZ



 MOV ECX,numeroZF
 SUB ECX,numeroZD
 INC ECX
 @SR_A_P_B2:
 PUSH ECX

 MOV EAX,numerozD           ;
 MOV EBX,[EDI+8]            ;
 INC EBX                    ;Calcul pos dpart dans le buffer
 SHL EBX,2                  ;
 SUB EAX,[EDI]              ;
 MUL EBX                    ;
 ADD EAX,12                 ;
 MOV EBX,EAX

 MOV ECX,DS:[EDI+EBX]
 JECXZ @SR_A_P_B1
 @SR_A_P_B0:
  ADD EBX,4
  PUSH DWORD PTR DS:[EDI+EBX]
  PUSH DWORD PTR [ecranz]
  PUSH DWORD PTR [masquez]
  CALL SR_TRACE_POLYGONE_MAPPE_AVECMASQUE
 LOOPD @SR_A_P_B0
 @SR_A_P_B1:

 INC DWORD PTR numeroZD
 POP ECX
 LOOPD @SR_A_P_B2


 POP ECX
 POP DS
 POP BP
RETN 20
ENDP

AFFICHE_POLYGONE_BUFFERZ MACRO bufferz,numerozD,numerozF,ecranz,masquez
 PUSH DWORD PTR bufferz
 PUSH DWORD PTR numerozD
 PUSH DWORD PTR numerozF
 PUSH DWORD PTR ecranz
 PUSH DWORD PTR masquez
 CALL SR_AFFICHE_POLYGONE_BUFFERZ
ENDM


;*****************************************************************************
;              Crer une grille de point 3d sur le plan X,Z 
;*****************************************************************************
;    Entree : NbpointL (DWORD)  Nombre de point en largeur
;             NbpointH (DWORD)  Nombre de point en Hauteur
;             Largeur  (DWORD)  Largeur entre les points
;             Hauteur  (DWORD)  Hauteur entre les points
;*****************************************************************************
;    Sortie : pointeur 32 sur tableau de points
;*****************************************************************************
; REMARQUE  : Utilise fonction HIMEM.FNC
;*****************************************************************************

;Variable locale
 TEMP_buffer=16
 point32=[BP+2]
 NBpointT=[BP+6]
 PosPL=[BP+10]
 PosPH=[BP+14]

;Parametre passer  la fonction
 NbpointL=[BP+16+TEMP_buffer]     ;
 NbpointH=[BP+12+TEMP_buffer]     ;
 largeur=[BP+8+TEMP_buffer]       ;
 hauteur=[BP+4+TEMP_buffer]       ;

SR_CREATE_P3D_GRILLEXZ PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 XOR AX,AX
 MOV DS,AX

 MOV EAX,NbPointL
 MOV EBX,NbpointH
 MUL EBX
 MOV NBpointT,EAX
 MOV EBX,size Point3D
 MUL EBX
 ADD EAX,size Point3D
 SHR EAX,10
 INC AX
 PUSH AX
 CALL SR_ALLOUE_EMB
 MOV Point32,EAX
 MOV EDI,EAX

 MOV EAX,NBpointT
 MOV EDI.[X],EAX
 MOV EAX,NBpointL
 MOV EDI.[Y],EAX
 MOV EAX,NBpointH
 MOV EDI.[Z],EAX
 ADD EDI,size Point3D

 XOR EAX,EAX
 MOV PosPH,EAX

 MOV ECX,NBpointH
 @SR_C_P_G0:
 PUSH ECX

  MOV DWORD PTR PosPL,0
  MOV ECX,NBpointL
  @SR_C_P_G1:
   MOV EAX,PosPL
   MOV EDI.[X],EAX
   MOV EAX,PosPH
   MOV EDI.[Z],EAX
   XOR EAX,EAX
   MOV EDI.[Y],EAX

   MOV EAX,Largeur
   ADD PosPL,EAX
   ADD EDI,size Point3D
  LOOPD @SR_C_P_G1

  MOV EAX,hauteur
  SUB PosPH,EAX
 POP ECX
 LOOPD @SR_C_P_G0


 MOV EAX,Point32
 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 16
ENDP

CREATE_P3D_GRILLEXZ MACRO nbpl,nbph,largeu,hauteu
 PUSH DWORD PTR nbpl
 PUSH DWORD PTR nbph
 PUSH DWORD PTR largeu
 PUSH DWORD PTR hauteu
 CALL SR_CREATE_P3D_GRILLEXZ 
ENDM

;*****************************************************************************
;    Crer des polygones  quatres cots sur une grille entire de point 3d
;*****************************************************************************
;    Entree : Grille de point                     (Dword)
;             Texture utilis pour tous les poly  (Dword)
;             Tableaux de point3d (2d) pour affic (Dword)
;             PosTX1                              (Dword) \
;             PosTY1                              (Dword)  |  Position des points
;             PosTX2                              (Dword)   >  de la texture.
;             PosTY2                              (Dword)  |
;             PosTX3                              (Dword)  |
;             PosTY3                              (Dword)  |
;             PosTX4                              (Dword)  |
;             PosTY4                              (Dword) /
;*****************************************************************************
;    Sortie : pointeur 32 sur tableau de polygone
;*****************************************************************************
; REMARQUE  : Utilise fonction HIMEM.FNC
;*****************************************************************************

;Variable locale
 TEMP_buffer=12
 poly32=[BP+2]
 NBpolyT=[BP+6]
 NumP=[BP+10]

;Parametre passer  la fonction
 GPoint=[BP+44+TEMP_buffer]       ;
 polyT=[BP+40+TEMP_buffer]        ;
 TabP=[BP+36+TEMP_buffer]         ;
 PosTX1=[BP+32+TEMP_buffer]       ;
 PosTY1=[BP+28+TEMP_buffer]       ;
 PosTX2=[BP+24+TEMP_buffer]       ;
 PosTY2=[BP+20+TEMP_buffer]       ;
 PosTX3=[BP+16+TEMP_buffer]       ;
 PosTY3=[BP+12+TEMP_buffer]       ;
 PosTX4=[BP+8+TEMP_buffer]        ;
 PosTY4=[BP+4+TEMP_buffer]        ;

SR_CREATE_POLY_SUR_GRILLE PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 XOR AX,AX
 MOV DS,AX

 MOV ESI,GPoint
 MOV EAX,ESI.[Y]
 MOV EBX,ESI.[Z]
 DEC EAX
 DEC EBX
 MUL EBX
 MOV NBpolyT,EAX
 MOV EBX,size Polygone + size Point3D
 MUL EBX
 ADD EAX,size Point3D
 SHR EAX,10
 SHL AX,1 ;****$$*
 INC AX
 PUSH AX
 CALL SR_ALLOUE_EMB
 MOV Poly32,EAX
 MOV EDI,EAX

 MOV EAX,NBpolyT
 MOV EDI.[X],EAX
 MOV EAX,ESI.[Y]
 DEC EAX
 MOV EDI.[Y],EAX
 MOV EAX,ESI.[Z]
 DEC EAX
 MOV EDI.[Z],EAX

 ADD EDI,size Point3D


 MOV DWORD PTR NumP,1

 MOV ECX,NBpolyT
 @SR_C_P_S_G0:

  XOR EAX,EAX
  MOV EDI.[Pattribut],EAX
  MOV EAX,GPoint
  MOV EDI.[PTab_P3d],EAX
  MOV EAX,TabP
  MOV EDI.[PTab_P2d],EAX
  MOV EAX,PolyT
  MOV EDI.[PTexture],EAX
  XOR EAX,EAX
  MOV EDI.[PNormale],EAX
  MOV EAX,3 ;****$$*
  MOV EDI.[PNb_Points],EAX
  MOV EAX,NumP
  MOV EDI.[PNp1],EAX
  MOV EAX,PosTX1
  MOV EDI.[P1Tx],EAX
  MOV EAX,PosTY1
  MOV EDI.[P1Ty],EAX

  MOV EAX,NumP
  INC EAX
  MOV EDI.[PNp2],EAX
  MOV EAX,PosTX2
  MOV EDI.[P2Tx],EAX
  MOV EAX,PosTY2
  MOV EDI.[P2Ty],EAX

  MOV EAX,NumP
  ADD EAX,ESI.[Y]
  MOV EDI.[size polygone].X,EAX
  MOV EAX,PosTX4
  MOV EDI.[size polygone].Y,EAX
  MOV EAX,PosTY4
  MOV EDI.[size polygone].Z,EAX

  MOV EAX,NumP
  INC EAX
  ADD EAX,ESI.[Y]
  MOV EDI.[PNp3],EAX
  MOV EAX,PosTX3
  MOV EDI.[P3Tx],EAX
  MOV EAX,PosTY3
  MOV EDI.[P3Ty],EAX
  
;****$$*;****$$*;****$$*
  ADD EDI,size polygone+size Point3d
  XOR EAX,EAX
  MOV EDI.[Pattribut],EAX
  MOV EAX,GPoint
  MOV EDI.[PTab_P3d],EAX
  MOV EAX,TabP
  MOV EDI.[PTab_P2d],EAX
  MOV EAX,PolyT
  MOV EDI.[PTexture],EAX
  XOR EAX,EAX
  MOV EDI.[PNormale],EAX
  MOV EAX,3 ;****$$*
  MOV EDI.[PNb_Points],EAX
  MOV EAX,NumP
  MOV EDI.[PNp1],EAX
  MOV EAX,PosTX1
  MOV EDI.[P1Tx],EAX
  MOV EAX,PosTY1
  MOV EDI.[P1Ty],EAX


  MOV EAX,NumP
  ADD EAX,ESI.[Y]
  INC EAX
  MOV EDI.[PNp2],EAX
  MOV EAX,PosTX3
  MOV EDI.[P2Tx],EAX
  MOV EAX,PosTY3
  MOV EDI.[P2Ty],EAX

  MOV EAX,NumP
  ADD EAX,ESI.[Y]
  MOV EDI.[size polygone].X,EAX
  MOV EAX,PosTX4
  MOV EDI.[size polygone].Y,EAX
  MOV EAX,PosTY4
  MOV EDI.[size polygone].Z,EAX

  MOV EAX,NumP
  ADD EAX,ESI.[Y]
  MOV EDI.[PNp3],EAX
  MOV EAX,PosTX4
  MOV EDI.[P3Tx],EAX
  MOV EAX,PosTY4
  MOV EDI.[P3Ty],EAX

;****$$*;****$$*;****$$*
  INC DWORD PTR NumP
  MOV EAX,Nump
  XOR EDX,EDX
  DIV DWORD PTR ESI.[Y]
  CMP EDX,0
  JNE @SR_C_P_S_G2
   INC DWORD PTR NumP
  @SR_C_P_S_G2:

  ADD EDI,size polygone+size Point3d
 DEC ECX
 JECXZ @SR_C_P_S_G1
 JMP @SR_C_P_S_G0
 @SR_C_P_S_G1:


 MOV EAX,Poly32
 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 44
ENDP

CREATE_POLY_SUR_GRILLE MACRO Gpoint,PolyT,TabP,PosTx1,PosTy1,PosTx2,PosTy2,PosTx3,PosTy3,PosTx4,PosTy4
 PUSH DWORD PTR Gpoint
 PUSH DWORD PTR PolyT
 PUSH DWORD PTR TabP
 PUSH DWORD PTR PosTx1
 PUSH DWORD PTR PosTy1
 PUSH DWORD PTR PosTx2
 PUSH DWORD PTR PosTy2
 PUSH DWORD PTR PosTx3
 PUSH DWORD PTR PosTy3
 PUSH DWORD PTR PosTx4
 PUSH DWORD PTR PosTy4
 CALL SR_CREATE_POLY_SUR_GRILLE 
ENDM
