TITLE Fonction graphique pour les mode en 65536 couleur

.DATA

;Strucure d'information sur un mode vesa

MODE_INFO STRUC
        ModeAttributes      dw  ?  ; mode attributes
        WinAAttributes      db  ?  ; window A attributes
        WinBAttributes      db  ?  ; window B attributes
        WinGranularity      dw  ?  ; window granularity
        WinSize             dw  ?  ; window size
        WinASegment         dw  ?  ; window A start segment
        WinBSegment         dw  ?  ; window B start segment
        WinFuncPtr          dd  ?  ; pointer to window function
        BytesPerScanLine    dw  ?  ; bytes per scan line

        XResolution         dw  ?  ; horizontal resolution
        YResolution         dw  ?  ; vertical resolution
        XCharSize           db  ?  ; character cell width
        YCharSize           db  ?  ; character cell height
        NumberOfPlanes      db  ?  ; number of memory planes
        BitsPerPixel        db  ?  ; bits per pixel
        NumberOfBanks       db  ?  ; number of banks
        MemoryModel         db  ?  ; memory model type
        BankSize            db  ?  ; bank size in kb
        NumberOfImagePages  db  ?  ; number of images
        Reserved_page       db  1  ; reserved for page function

        RedMaskSize         db  ?  ; size of direct color red mask in bits
        RedFieldPosition    db  ?  ; bit position of LSB of red mask
        GreenMaskSize       db  ?  ; size of direct color green mask in bits
        GreenFieldPosition  db  ?  ; bit position of LSB of green mask
        BlueMaskSize        db  ?  ; size of direct color blue mask in bits
        BlueFieldPosition   db  ?  ; bit position of LSB of blue mask
        RsvdMaskSize        db  ?  ; size of direct color reserved mask in bits
        DirectColorModeInfo db  ?  ; Direct Color mode attributes
        Reserved_futur      db  216 dup(?)      ; remainder of ModeInfoBlock
ENDS

;Structure d'un cran

POINT3d STRUC
 X DD 0
 Y DD 0
 Z DD 0
ENDS

POINT2d STRUC
 X DD 0
 Y DD 0
ENDS

ECRAN STRUC
 largeur_ecran DD 640         ;Largeur de l'ecran
 hauteur_ecran DD 480         ;Hauteur de l'ecran
 X_origine     DD 320         ;Position X de l'origine
 Y_origine     DD 240         ;Position Y de l'origine
 Xmin          DD -320        ; Fentre d'affichage: Xmin
 Ymin          DD -239        ;                      Ymin
 Xmax          DD 319         ;                      Xmax
 Ymax          DD 240         ;                      Ymax
 Add32_ecran   DD 0A0000H     ;Adresse 32bit de l'cran dans la mmoire concerne
 attribut_ecran DD 0          ;Attribut de l'ecran 
                              ;     bit 0: 0 mmoire video               
                              ;            1 ram CPU
                              ;     bit 1: 1 actuellement affich
                              ;     bit 2-3:Nb octets par pixel couleur
ENDS                          


.CODE
;*****************************************************************************
;                       CREATE_ECRAN_RAM
;*****************************************************************************
;  PARAMETRE: LargeurEC,HauteurEC,X_origine,Y_origine,  (DWORD)
;             Xmin,Ymin,Xmax,Ymax,Attibut_ecran         (DWORD)
;  SORTIE   :EAX=pointeur32 sur ecran
;****************************************************************************
;  REMARQUE:  necessite les fonction HIMEM
;****************************************************************************

;Variables locales
 TEMP_buffer=4
 EMB_adresse=[BP+2]

;Parametre passer  la fonction
 LargeurEC=[BP+36+TEMP_buffer]        ;Largeur ecran       
 HauteurEC=[BP+32+TEMP_buffer]        ;hauteur ecran       
 XorigineEC=[BP+28+TEMP_buffer]       ;Origine X        
 YorigineEC=[BP+24+TEMP_buffer]       ;Origine Y 
 XminEC=[BP+20+TEMP_buffer]           ;
 YminEC=[BP+16+TEMP_buffer]           ;Fenetre d'affichage
 XmaxEC=[BP+12+TEMP_buffer]           ;
 YmaxEC=[BP+8+TEMP_buffer]           ;
 AttribEC=[BP+4+TEMP