;Fonction pour gerer les polygones 

;*****************************************************************************
;                         Crer un bufferZ 
;*****************************************************************************
;    Entree : Zmin       (DWORD) PositionZ minimum
;             Zmax       (DWORD) PositionZ maximum 
;             NBobjMAX  (DWORD) Nombre max d'objet(dword)  stocker par posZ
;*****************************************************************************
;    Sortie : le bufferZ est cr EAX=pointeur sur le buffer
;*****************************************************************************
;  REMARQUE : Ncessite les fonction HIMEM.FNC
;*****************************************************************************

;Variables locales
 TEMP_buffer=4
 bufferz=[BP+2]

;Parametre passer  la fonction
 Zmin=[BP+12+TEMP_buffer]       ;pos Zmin
 Zmax=[BP+8+TEMP_buffer]        ;pos Zmin
 NBpolyMax=[BP+4+TEMP_buffer]   ;Nombre max de polygone par posZ

SR_CREATE_BUFFERZ PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 MOV EAX,Zmax        ;
 SUB EAX,Zmin        ;
 INC EAX             ;
 MOV EBX,NBpolyMAX   ;Calcul taille du buffer =12+(nbpolymax+1)*(zmax-zmin+1)*4
 INC EBX             ;
 MUL EBX             ;
 MOV EBX,4           ;
 MUL EBX             ;
 ADD EAX,12          ;
 SHR EAX,10          ;
 INC EAX             ;

 PUSH AX             ;Alloue le buffer
 CALL SR_ALLOUE_EMB  ;
 MOV bufferz,EAX     ;

 XOR AX,AX           ;Fixe valeur zmin,zmax,nbmaxpoly du buffer
 MOV DS,AX           ;
 MOV EDI,bufferz     ;
 MOV EAX,Zmin        ;
 MOV [EDI],EAX       ;
 MOV EAX,Zmax        ;
 MOV [EDI+4],EAX     ;
 MOV EAX,NBpolyMax   ;
 MOV [EDI+8],EAX     ;

 MOV EAX,bufferz     ;valeur de retour = adresse buffer

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
 RETN 12
ENDP

CREATE_BUFFERZ MACRO zmin,zmax,nbmaxpoly
 PUSH DWORD PTR ZMin
 PUSH DWORD PTR ZMax
 PUSH DWORD PTR nbmaxpoly
 CALL SR_CREATE_BUFFERZ
ENDM


;*****************************************************************************
;                         Initialise un bufferZ 
;*****************************************************************************
;    Entree : Bufferz pointeur 32 sur buffer  initialiser
;*****************************************************************************
;    Sortie : le bufferZ est initialis
;*****************************************************************************

;Parametre passer  la fonction
 BufferZ=[BP+4]        ;Pointeur sur le bufferz

SR_INIT_BUFFERZ PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

  XOR AX,AX
  MOV DS,AX

  MOV EDI,bufferz
  MOV ECX,[EDI+4]
  SUB ECX,[EDI]
  INC ECX

  MOV EAX,[EDI+8]   ;EBX=NBmaxPoly
  INC EAX           ;
  SHL EAX,2
  MOV EDX,EAX

  XOR EAX,EAX
  ADD EDI,12

  @I_BZ0:
   MOV [EDI],EAX
   ADD EDI,EDX
  LOOPD @I_BZ0

 POP ECX
 POP DS
 POP BP
 RETN 4
ENDP

INIT_BUFFERZ MACRO bufferz
 PUSH DWORD PTR bufferz
 CALL SR_INIT_BUFFERZ
ENDM


;*****************************************************************************
;     Ajoute un polygone a un bufferZ si il est visible
;*****************************************************************************
;    Entree : polygone (DWORD)  polygone  ajouter
;             ecranz   (DWORD)  ecran d'affichage 
;             bufferz  (DWORD)  buffer de stockage
;*****************************************************************************
;    Sortie : le bufferZ est mis  jour
;*****************************************************************************

;Variables locales
TEMP_buffer=44
 PosXmin =[BP+2]
 PosXmax =[BP+6]
 PosYmin =[BP+10]
 PosYmax =[BP+14]
 PosZmin =[BP+18]
 PosZmax =[BP+22]
 NPXmax=[BP+26]
 NPXmin=[BP+30]
 NPYmax=[BP+34]
 NPYmin=[BP+38]
 NPYX=[BP+42]

;Parametre passer  la fonction
 polya=[BP+12+TEMP_buffer]       ;ofs32 du polygone
 ecranz=[BP+8+TEMP_buffer]       ;ofs32 ecran
 bufferz=[BP+4+TEMP_buffer]      ;ofs32 du bufferZ

SR_AJOUTE_POLYGONE_BUFFERZ PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX
  XOR AX,AX
  MOV DS,AX

  MOV ESI,polya
  MOV EDI,ESI.[Ptab_P2D]
  MOV ECX,ESI.[PNB_points]

 ;Cherche PosXmin,PosXmax,PosYmin,PosYmax,PosZmin,PosZmax
  MOV EAX,ESI.[PNP1]        ; EAX=numro point 1
  MOV EBX,12                ;
  MUL EBX                   ; 
  MOV EBX,EAX               ; EBX+EDI=offset point1
  MOV EAX,DS:[EDI+EBX]      ; EAX=X point 1
  MOV PosXmin,EAX
  MOV PosXmax,EAX
  MOV EAX,DS:[EDI+EBX+4]    ; EAX=Y point 1
  MOV PosYmin,EAX
  MOV PosYmax,EAX
  MOV EAX,DS:[EDI+EBX+8]    ; EAX=Z point 1
  MOV PosZmin,EAX
  MOV PosZmax,EAX

  MOV EAX,1
  MOV NPXmax,EAX
  MOV NPXmin,EAX
  MOV NPYmin,EAX
  MOV NPYmax,EAX

  MOV NPYX,EAX

  DEC ECX
  @SR_A_P_BZ0:
   INC DWORD PTR NPYX
   ADD ESI,12
   MOV EAX,ESI.[PNP1]
   MOV EBX,12
   MUL EBX
   MOV EBX,EAX
   MOV EDX,NPYX           ;


   MOV EAX,DS:[EDI+EBX]   ;
   CMP EAX,PosXmin        ;
   JGE @SR_A_P_BZ1        ;Fixe PosXmin et PosXmax
    MOV PosXmin,EAX       ;
    MOV NPXmin,EDX        ;
   @SR_A_P_BZ1:           ;
   CMP EAX,PosXmax        ;
   JLE @SR_A_P_BZ2        ;
    MOV PosXmax,EAX       ;
    MOV NPXmax,EDX        ;
   @SR_A_P_BZ2:           ;

   MOV EAX,DS:[EDI+EBX+4] ;   
   CMP EAX,PosYmin        ;
   JGE @SR_A_P_BZ3        ;Fixe PosYmin et PosYmax
    MOV PosYmin,EAX       ;
    MOV NPYmin,EDX        ;
   @SR_A_P_BZ3:           ;
   CMP EAX,PosYmax        ;
   JLE @SR_A_P_BZ4        ;
    MOV PosYmax,EAX       ;
    MOV NPYmax,EDX        ;
   @SR_A_P_BZ4:           ;

   MOV EAX,DS:[EDI+EBX+8] ;   
   CMP EAX,PosZmin        ;
   JGE @SR_A_P_BZ5        ;Fixe PosZmin et PosZmax
    MOV PosZmin,EAX       ;
   @SR_A_P_BZ5:           ;
   CMP EAX,PosZmax        ;
   JLE @SR_A_P_BZ6        ;
    MOV PosZmax,EAX       ;
   @SR_A_P_BZ6:           ;

   DEC ECX
   JECXZ @SR_A_P_BZ20
   JMP @SR_A_P_BZ0
  @SR_A_P_BZ20:
  ;Les Positions max et min sont fixes.

  MOV ESI,bufferz
  MOV EAX,PosZmax                ;
  CMP EAX,[ESI]                  ;
  JGE @SR_A_P_BZ12               ;Test si polygone compris entre Zmin et Zmax
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ12:                  ;
  MOV EAX,PosZmin                ;
  CMP EAX,[ESI+4]                ;
  JLE @SR_A_P_BZ13               ;
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ13:                  ;

  MOV ESI,ecranz
  MOV EAX,PosYmax                ;
  CMP EAX,ESI.[Ymin]             ;
  JGE @SR_A_P_BZ9                ;Test si polygone compris entre Ymin et Ymax
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ9:                   ;
  MOV EAX,PosYmin                ;
  CMP EAX,ESI.[Ymax]             ;
  JLE @SR_A_P_BZ10               ;
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ10:                  ;

  ;Test si polygone dans l'ecran et dans le bufferZ
  MOV ESI,ecranz
  MOV EAX,PosXmax                ;
  CMP EAX,ESI.[Xmin]             ;
  JGE @SR_A_P_BZ7                ;Test si polygone compris entre Xmin et Xmax
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ7:                   ;
  MOV EAX,PosXmin                ;
  CMP EAX,ESI.[Xmax]             ;
  JLE @SR_A_P_BZ8                ;
   JMP @SR_A_P_BZ11              ;
  @SR_A_P_BZ8:                   ;

 ;Ici on sait que le polygone est compris dans l'ecran et dans le bufferz 


 ;test si le polygone est  l'endroit.

 ;si oui NPXmin>NPYmin>NPXmax>NPYmax
  MOV DWORD PTR NPYX,0
  MOV EAX,NPXmax
  CMP NPYmax,EAX
  JG @SR_A_P_BZ16
   INC DWORD PTR NPYX
  @SR_A_P_BZ16:
  CMP EAX,NPYmin
  JG @SR_A_P_BZ17
   INC DWORD PTR NPYX
  @SR_A_P_BZ17:
  MOV EAX,NPXmin
  CMP NPYmin,EAX
  JG @SR_A_P_BZ18
   INC DWORD PTR NPYX
  @SR_A_P_BZ18:
  CMP EAX,NPYmax
  JG @SR_A_P_BZ19
   INC DWORD PTR NPYX
  @SR_A_P_BZ19:


  CMP DWORD PTR NPYX,2
  JL @SR_A_P_BZ11        ;Si positif polygone out

 ;Ajoute le polygonne au bufferZ
  MOV EDI,BufferZ

  MOV EAX,PosZmax            ;
  ADD EAX,PosZmin            ;
  CDQ                        ;Calcul PosZmilieu
  MOV EBX,2                  ; est rectifie si sort du bufferZ
  IDIV EBX                   ;
  ;*modif*
   MOV EAX,PosZmin           ;modif! pos Zmin = pos buffer
  ;*modif*
  CMP EAX,[EDI]              ;
  JGE @SR_A_P_BZ14           ;
   MOV EAX,[EDI]             ;
  @SR_A_P_BZ14:              ;
  CMP EAX,[EDI+4]            ;
  JLE @SR_A_P_BZ15           ;
   MOV EAX,[EDI+4]           ;
  @SR_A_P_BZ15:              ;

  MOV EBX,[EDI+8]            ;
  INC EBX                    ;Calcul pos dans le buffer
  SHL EBX,2                  ;
  SUB EAX,[EDI]              ;
  MUL EBX                    ;
  ADD EAX,12                 ;
  MOV EBX,EAX                ;

  MOV EAX,DS:[EDI+EBX]       ;Test si buffer plein  cette place
  CMP EAX,[EDI+8]            ;si oui ne stock pas le polygone
  JGE @SR_A_P_BZ11           ;
   INC EAX
   MOV DS:[EDI+EBX],EAX      ;
   SHL EAX,2                 ;ESI pointe sur entr dans le buffer
   ADD EBX,EAX               ;

   MOV EAX,polya             ;Stock le polygone
   MOV DS:[EDI+EBX],EAX      ;
 @SR_A_P_BZ11:


 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 12
ENDP

AJOUTE_POLYGONE_BUFFERZ MACRO polya,ecranz,bufferz
 PUSH DWORD PTR polya
 PUSH DWORD PTR ecranz
 PUSH DWORD PTR bufferz
 CALL SR_AJOUTE_POLYGONE_BUFFERZ
ENDM



;*****************************************************************************
;     Affiche les polygone contenue dans un bufferZ
;*****************************************************************************
;    Entree : bufferZ  (DWORD)  bufferz
;             numroZD (DWORD)  positionZ des poly  afficher
;             numroZF (DWORD)  positionZ des poly  afficher
;             ecranz   (DWORD)  ecran d'affichage
;             masquez  (DWORD)  masque  utiliser
;*****************************************************************************
;    Sortie : les poly sont afficher
;*****************************************************************************

;Parametre passer  la fonction
 bufferZ=[BP+20]      ;
 numeroZD=[BP+16]     ;
 numeroZF=[BP+12]     ;
 ecranz=[BP+8]        ;
 masquez=[BP+4]       ;

SR_AFFICHE_POLYGONE_BUFFERZ PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

 XOR AX,AX
 MOV DS,AX
 MOV EDI,bufferZ



 MOV ECX,numeroZF
 SUB ECX,numeroZD
 INC ECX
 @SR_A_P_B2:
 PUSH ECX

 MOV EAX,numerozD           ;
 MOV EBX,[EDI+8]            ;
 INC EBX                    ;Calcul pos dpart dans le buffer
 SHL EBX,2                  ;
 SUB EAX,[EDI]              ;
 MUL EBX                    ;
 ADD EAX,12                 ;
 MOV EBX,EAX

 MOV ECX,DS:[EDI+EBX]
 JECXZ @SR_A_P_B1
 @SR_A_P_B0:
  ADD EBX,4
  PUSH DWORD PTR DS:[EDI+EBX]
  PUSH DWORD PTR [ecranz]
  PUSH DWORD PTR [masquez]
  CALL SR_TRACE_POLYGONE_MAPPE_AVECMASQUE
 LOOPD @SR_A_P_B0
 @SR_A_P_B1:

 INC DWORD PTR numeroZD
 POP ECX
 LOOPD @SR_A_P_B2


 POP ECX
 POP DS
 POP BP
RETN 20;24
ENDP

AFFICHE_POLYGONE_BUFFERZ MACRO bufferz,numerozD,numerozF,ecranz,masquez
 PUSH DWORD PTR bufferz
 PUSH DWORD PTR numerozD
 PUSH DWORD PTR numerozF
 PUSH DWORD PTR ecranz
 PUSH DWORD PTR masquez
 CALL SR_AFFICHE_POLYGONE_BUFFERZ
ENDM


;renvoie une valeur positive si un point et devant un polygone 
;renvoie une valeur negative si un point et derriere un polygone 

TEST_POINT_POLY MACRO Poly,TabP,NumP
 PUSH DWORD PTR Poly
 PUSH DWORD PTR TabP
 PUSH DWORD PTR Nump
 CALL SR_TEST_POINT_POLY
ENDM

 TEMP_buffer=24
 PoX=[BP+2]
 PoY=[BP+6]
 PoZ=[BP+10]
 P1X=[BP+14]
 P1Y=[BP+18]
 P1Z=[BP+22]



 Poly=[BP+12+TEMP_buffer]
 TabP=[BP+8+TEMP_buffer]
 NumP=[BP+4+TEMP_buffer]
SR_TEST_POINT_POLY PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
  XOR AX,AX
  MOV DS,AX
  MOV ESI,Poly      ;ESI pointe sur le Poly
  MOV EDI,TabP
  MOV EAX,NumP      ;EDI pointe sur le point
  MOV EBX,Size Point3D
  MUL EBX
  ADD EDI,EAX
  MOV EAX,EDI.[X]   ;
  MOV PoX,EAX       
  MOV EAX,EDI.[Y]   ;
  MOV PoY,EAX
  MOV EAX,EDI.[Z]   ;
  MOV PoZ,EAX

  MOV EAX,ESI.[PNP1]      ;
  MOV EBX,Size Point3D    ; EDI pointe sur point1 du poly
  MUL EBX                 ;  origine de la normale au polygone
  MOV EDI,ESI.[Ptab_P2D]  ;
  ADD EDI,EAX            
  MOV EAX,EDI.[X]
  SUB PoX,EAX
  MOV P1X,EAX
  MOV EAX,EDI.[Y]
  SUB PoY,EAX
  MOV P1Y,EAX
  MOV EAX,EDI.[Z]
  SUB PoZ,EAX
  MOV P1Z,EAX
  MOV EAX,ESI.[PNormale] ;
  MOV EBX,Size Point3D   ;
  MUL EBX                ;  EDI point sur le point dfinissant la normale
  MOV EDI,ESI.[Ptab_P2D] ;
  ADD EDI,EAX            ;

  ;Calcul produit scalaire pour savoir si angle < ou >  +/-90
  ;s = X*XP+Y*YP+Z*ZP = |V|*|U|*cos(u^v)

  MOV EAX,EDI.[X]
  SUB EAX,P1X
  IMUL DWORD PTR PoX
  MOV PoX,EAX

  MOV EAX,EDI.[Y]
  SUB EAX,P1Y
  IMUL DWORD PTR PoY
  ADD PoX,EAX

  MOV EAX,EDI.[Z]
  SUB EAX,P1Z
  IMUL DWORD PTR PoZ
  ADD PoX,EAX         ;Ici EAX=produit scalaire p1p.p1Pn

  MOV EAX,PoX

 POP DS
 POP BP
 ADD SP,TEMP_buffer
 RETN 12
 ENDP
