TITLE fonction pur gerer l'XMS
DOSSEG
.MODEL SMALL
.486

PUBLIC SR_TEST_HIMEM
PUBLIC SR_GET_HIMEM_adresse
PUBLIC SR_ALLOUE_EMB
PUBLIC SR_LIBERE_EMB
PUBLIC SR_ACTIVE_A20
PUBLIC SR_DESACTIVE_A20
 

;Variable globale
.DATA
 XMSdriver_adresse DD 0

.CODE

;  ͻ
;                                          
;  Test la prsene du driver HIMEM.SYS     
;  sortie: 0   => himem n'est pas install 
;                                          
;  ͼ

 SR_TEST_HIMEM PROC NEAR
  MOV AX,4300H        
  INT 2FH             
  SUB AL,80H
  NOT AL
 RETN
 ENDP

; ͻ
;                                            
; rcupre l'adresse mmoire du driver HIMEM 
;                                            
; ͼ

 SR_GET_HIMEM_adresse PROC NEAR
  MOV AX,4310H                   
  INT 2FH                        
  MOV WORD PTR [XMSdriver_adresse],BX
  MOV BX,ES
  MOV WORD PTR [XMSdriver_adresse+2],BX
 RETN 
 ENDP




; ͻ
;  Alloue un block EMB                       
;  taille en ko(word)+4octet =>              
;  => EAX=adresse 32 bit                     
; ͼ

taille=[BP+4]
SR_ALLOUE_EMB PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DS
  PUSH ESI
  PUSH EDI
  PUSH ES
  MOV AX,@DATA
  MOV DS,AX
  MOV AH,09H
  MOV DX,taille                        
  CALL DWORD PTR DS:[XMSdriver_adresse] ;Reserve l'EMB
  MOV taille,DX
  MOV AH,0CH                            ;DX=handle
  CALL DWORD PTR DS:[XMSdriver_adresse] ;Lock l'EMB pour savoir son adresse
  MOV DI,DX                             ;EDI=ofs32 de l'EMB
  SHL EDI,16                            ;
  MOV DI,BX                             ;
  MOV AH,0DH                            ;
  MOV DX,taille                         ;Delock l'EMB pour pouvoir le deallouer
  CALL DWORD PTR DS:[XMSdriver_adresse] ;
  XOR AX,AX                             ;
  MOV DS,AX                             ;Premier word de l'EMB=handle de l'EMB 
  MOV AX,taille                         ;
  MOV [EDI],AX                          ;
  ADD EDI,4
  MOV EAX,EDI
  POP ES
  POP EDI
  POP ESI
  POP DS
  POP BP
RETN 2
ENDP


; ͻ
;   Libere un EMB                            
;   =>offset 32 bit (dword)                  
;                                            
; ͼ

ofs32=[BP+4]
SR_LIBERE_EMB PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX
 XOR AX,AX
 MOV DS,AX
 MOV EDI,ofs32
 MOV DX,[EDI-4]
 MOV AX,@DATA
 MOV DS,AX
 MOV AH,0AH
 CALL DWORD PTR DS:[XMSdriver_adresse]
 POP ECX
 POP DS
 POP BP
 RETN 4
ENDP


; ͻ
;   Active la ligne d'adresse A20            
; ͼ

SR_ACTIVE_A20 PROC NEAR
 MOV AH,03H                            
 CALL DWORD PTR DS:[XMSdriver_adresse] 
 RETN
ENDP


; ͻ
;   Desactive la ligne d'adresse A20         
; ͼ

SR_DESACTIVE_A20 PROC NEAR
 MOV AH,04H                            
 CALL DWORD PTR DS:[XMSdriver_adresse] 
 RETN
ENDP

 
END
