TITLE fonction 3D

CONVERTIT_POINTS_3D_2D MACRO ofs32p3,ofs32p2,focus_camera,Nb_points
 PUSH DWORD PTR ofs32p3             ; tab3d=X3,Y3,Z3,X3,Y3,Z3 
 PUSH DWORD PTR ofs32p2             ; tab2d=X2,Y2,?,X2,Y2,? 
 PUSH DWORD PTR focus_camera        ;
 PUSH DWORD PTR NB_points           ; Convertit un tableaux de point 3D
 CALL SR_CONVERTITS_POINT_3D_2D     ;  en tableaux de point 2D
ENDM                                ;  Entre: ofs32 point 3d,ofs32 point 2d
                                    ;           ,camera focus


TRANSLATION_POINTS_SUR_AXE MACRO ofs32pd,ofs32pa,PAX,PAY,PAZ,NB_points
 PUSH DWORD PTR ofs32pd          ; 
 PUSH DWORD PTR ofs32pa          ; Converit un tableaux de points3D en un autre
 PUSH DWORD PTR PAX              ;  tableau de point3d translats sur les position
 PUSH DWORD PTR PAY              ;  transmise de l'axe
 PUSH DWORD PTR PAZ              ;     Entre: ofs32 point  translat,ofs32 point translat
 PUSH DWORD PTR NB_points        ;            ,position axe X, // y, // z
 CALL SR_TRANSLATION_POINTS_SUR_AXE   ;       ,NB de points  translat.
ENDM                                  


.CODE

NB_points=[BP+4]
focus_camera=[BP+8]
ofs32p2=[BP+12]
ofs32p3=[BP+16]

SR_CONVERTIT_POINTS_3D_2D PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH EDI
 PUSH ESI
 PUSH EBX
 PUSH EDX
 PUSH ES
 PUSH DS

 XOR AX,AX
 MOV ES,AX
 MOV DS,AX

 MOV ECX,NB_points
 MOV ESI,ofs32p3
 MOV EDI,ofs32p2

 @S_C_P_3_20:
  MOV EAX,[ESI]              ;EAX=X3D
  IMUL DWORD PTR focus_camera;EDX:EAX=focus_camera*X3D
  MOV EBX,focus_camera       ;EBX=focus_camera+Z3D
  ADD EBX,[ESI+8]            ;
  IDIV EBX                   ;EAX=X2D
  MOV [EDI],EAX              ;

  MOV EAX,[ESI+4]            ;EAX=Y3D
  IMUL DWORD PTR focus_camera;EDX:EAX=focus_camera*Y3D
  MOV EBX,focus_camera       ;EBX=focus_camera+Z3D
  ADD EBX,[ESI+8]            ;
  IDIV EBX                   ;EAX=Y2D
  MOV [EDI+4],EAX            ;

  ADD ESI,12
  ADD EDI,12
 LOOPD @S_C_P_3_20


 POP DS
 POP ES
 POP EDX
 POP EBX
 POP ESI
 POP EDI
 POP BP
 RETN 16
ENDP


NB_points=[BP+4]
PAZ=[BP+8]
PAY=[BP+12]
PAX=[BP+16]
ofs32pa=[BP+20]
ofs32pd=[BP+24]

SR_TRANSLATION_POINTS_SUR_AXE PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH ES
 PUSH DS
 PUSH EDI
 PUSH ESI
 PUSH ECX

 XOR AX,AX
 MOV ES,AX
 MOV DS,AX

 MOV ESI,ofs32pd
 MOV EDI,ofs32pa
 MOV ECX,NB_points

 @S_T_P_S_A0:
  MOV EAX,[ESI]           ;
  SUB EAX,PAX             ; Translate suivant X
  MOV [EDI],EAX           ;

  MOV EAX,[ESI+4]
  SUB EAX,PAY             ; Translate suivant Y
  MOV [EDI+4],EAX

  MOV EAX,[ESI+8]
  SUB EAX,PAZ             ; Translate suivant Z
  MOV [EDI+8],EAX

  ADD ESI,12              ; Passe au point suivant
  ADD EDI,12              ;
 LOOPD @S_T_P_S_A0


 POP ECX
 POP ESI
 POP EDI
 POP DS
 POP ES
 POP BP
 RETN 24
ENDP
