TITLE fonction graphique pour la 3d

.DATA

 ;chunk des objets bufferZ

 CH_LIGNE_COULEUR=5

 ;structure d'un polygone non mapp

 POLYGONE STRUC
  P_ATTRIBUT        DD 0
  P_OFS32_PTAB      DD 0
  P_P1              DD 0
  P_P2              DD 0
  P_P3              DD 0
  P_COULEUR         DD 0
  P_RESERVE         DD 0
 ENDS

 ;structure d'une fenetre graphique

  FENETRE STRUC
   FENETRE_Xmin DD 0 ;position Xmin
   FENETRE_Ymin DD 0 ;position Ymin
   FENETRE_Xmax DD 0 ;position Xmax
   FENETRE_Ymax DD 0 ;position Ymax
  ENDS

 ;structure de l'objet ligne

 OBJ_LIGNE STRUC
  OFS32_PROCHAIN      DD 0
  TYPE_OBJET          DD 0
  LIGNE_offset        DD 0
  LIGNE_taille        DD 0
  LIGNE_PRECAL        DD 0
  LIGNE_offset_precal DD 0
  LIGNE_couleur       DD 0
 ENDS




.CODE
 ;**********************************************************
 ; Fonction init_bufferZ
 ; cette fonction cre un nouveau bufferZ pour l'affichage
 ; Enre: Zmin,Zmax (DWORD)
 ;        ofs32 du bufferZ (DWORD)
 ;***********************************************************

 
 ofs32=[BP+4]
 Zmax=[BP+8]
 Zmin=[BP+12]

 SR_INIT_BUFFERZ PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DS
  PUSH EDI
  PUSH ECX

  XOR AX,AX
  MOV DS,AX
  MOV EDI,ofs32

  MOV EAX,Zmin
  MOV [EDI+4],EAX
  MOV EAX,Zmax
  MOV [EDI+8],EAX

  MOV ECX,Zmax       ;Calcul delta Z
  SUB ECX,Zmin
  INC ECX

  MOV EAX,ECX        ;Calcul ofset fin du tableau
  SHL EAX,3
  ADD EAX,12
  ADD EAX,EDI
  MOV [EDI],EAX
  ADD EDI,12

  ;ICI ECX=deltaX
  ;    EDI pointe sur premiere entre 

  XOR EAX,EAX
  @S_I_B0:
   MOV [EDI],EAX               ;offset premire objet=0 (pas d'objet)
   MOV [EDI+4],EDI             ;offset dernire objet=offset premire entre
   ADD EDI,8
  LOOPD @S_I_B0

  POP ECX
  POP EDI
  POP DS
  POP BP
  RETN 12
 ENDP


;******************************************************
; Fonction Decode BUFFERZ
; decode un bufferZ
; Entre: ofs32 bufferz,ofs32 bufferd(centre de l'ecran)
; Sortie le bufferd contient le bufferz dcod
;*******************************************************

 ofs32_bufferD=[BP+4]
 ofs32_bufferZ=[BP+8]
 SR_DECODE_BUFFERZ PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSHA
  PUSH ES
  PUSH DS

   XOR AX,AX
   MOV ES,AX
   MOV DS,AX

   MOV ESI,ofs32_bufferZ

   MOV ECX,[ESI+8] ;Calcul delta Z du bufferZ(Nombre d'entre)
   SUB ECX,[ESI+4]
   INC ECX

   ADD ESI,12      ;ESI pointe sur premiere entre
   JMP @SR_D_BZ_suivant
    

   ;*************************************
   ;Decodage d'une entre dans le bufferZ
   ;ESI pointe sur objet
   ;*************************************
   @SR_D_B_decode_objet_suivant:
   PUSH ESI
    MOV EAX,[ESI.TYPE_OBJET]
    
    ;Decodage d'une ligne de couleur

    CMP EAX,CH_LIGNE_COULEUR ;Test si il s'agit d'une ligne de couleur
    JNE @SR_D_B_0            ; si oui la decode sinon continue 
     MOV EDI,ofs32_bufferD
     ADD EDI,[ESI.ligne_offset]
     MOV ECX,[ESI.ligne_taille]
     MOV EAX,[ESI.ligne_couleur]
     MOV EBX,[ESI.ligne_offset_precal]
     SHL EBX,2
     MOV ESI,[ESI.ligne_precal]
     ADD ESI,EBX
     MOV EDX,4
     CMP ECX,0
     JGE @SR_D_B_01
      NEG ECX
      NEG EDX
     @SR_D_B_01:
     INC ECX

     MOV EBX,[ESI]
     @SR_D_B_02:
      MOV [EDI+EBX],AL
      ADD ESI,EDX
      MOV EBX,[ESI]
     LOOPD @SR_D_B_02


    JMP @SR_D_B_objet_decodee
    @SR_D_B_0:





    @SR_D_B_objet_decodee:
    POP ESI
    CMP DWORD PTR [ESI.OFS32_PROCHAIN],0
    JE @SR_D_B_entree_fini
    MOV ESI,[ESI]
    JMP @SR_D_B_decode_objet_suivant
   JMP @SR_D_B_OUT

   @SR_D_BZ_suivant:
   PUSH ECX
   PUSH ESI

   ;Ici ESI pointe sur premiere entr dans le buffer Z
   ;**********************************
   ; Programmation carte video
   ; pour effet suivant Z (Z=Zmax-ECX)
   ;**********************************
    PUSH ESI



    POP ESI
   ;*********************
   ; Fin prog carte VIDEO
   ;*********************

   CMP DWORD PTR [ESI],0       ;Test si il y'a au moin un objet pour ce Z
   JE @SR_D_B_entree_fini
    MOV ESI,[ESI]                    ;ESI pointe sur premiere objet
    JMP @SR_D_B_decode_objet_suivant ;lance le decodage pour ce Z
   @SR_D_B_entree_fini:

   POP ESI
   ADD ESI,8       
   POP ECX
   LOOPD @SR_D_BZ_suivant   ;passe  l'entre suivante




   @SR_D_B_OUT:


  POP DS
  POP ES
  POPA
  POP BP
  RETN 8
 ENDP




;******************************************************
; Fonction poly_grid
; Stock dans un bufferZ les informations d'un polygone
; non mapp
; Entre: ofs32 polygone,largeur_ecran,hauteur_ecran,focus_ecran,
;         bufferZ,lineS.
; Sortie le bufferZ est mis  jour
;*******************************************************



 TEMPbuffer=200       ;taille      ;taille du buffer pour les variables locales
 P1=[BP+2]            ;4 ;4        ;point le plus proche
 P2=[BP+6]            ;4 ;8        ;point mdian
 P3=[BP+10]           ;4 ;12       ;point le plus loin
 Xm=[BP+14]           ;4 ;16       ;coordon X du point m (Zm=Zpoint mdian)
 Ym=[BP+18]           ;4 ;20       ;coordon Y du point m (Zm=Zpoint mdian)
 P1_2D=[BP+22]        ;8 ;28       ;coordonns 2d P1
 P2_2D=[BP+30]        ;8 ;36       ;coordonns 2d P2
 P3_2D=[BP+38]        ;8 ;44       ;coordonns 2d P3
 P2YMOINYM=[BP+46]    ;4 ;48       ;P2Y - Ym
 P2XMOINXM=[BP+50]    ;4 ;52       ;P2X - Xm
 DXSUPDY=[BP+54]      ;4 ;56       ;1 Si DX suprieur  DY (ligne prcal.)
 WYmin=[BP+58]        ;4 ;60       ;  
 WYmax=[BP+62]        ;4 ;64       ;  FENETRE D'AFFICHAGE
 WXmax=[BP+66]        ;4 ;68       ;
 WXmin=[BP+70]        ;4 ;72       ;
 PXTREMmin=[BP+74]    ;4 ;76       ; Position extreme min
 PXTREMmax=[BP+78]    ;4 ;80       ; Position extreme max
 FACinc=[BP+82]       ;4 ;84       ;
 incOBL=[BP+86]       ;4 ;88       ; POUR STOCKAGE LIGNE PRECALCULE
 incFAC=[BP+90]       ;4 ;92       ;
 couleur=[BP+94]      ;4 ;96       ;couleur polygone
 attribut=[BP+98]     ;4 ;100      ;attribut polygone
 Pdepart=[BP+102]     ;4 ;104      ;position X dpart pour balayage du polygone
 Pfin=[BP+106]        ;4 ;108      ;position Y fin pour balayage du polygone
 Pmilieu=[BP+110]     ;4 ;112      ;position mdiane 
 offsetd=[BP+114]     ;4 ;116      ;offset de dpart de la ligne
 offseta=[BP+118]     ;4 ;120      ;offset de fin de la ligne
 incofsd=[BP+122]     ;4 ;124      ;
 incofsa3=[BP+126]    ;4 ;128      ;
 incofsa1=[BP+130]    ;4 ;132      ;
 offsetmin=[BP+134]   ;4 ;136      ;offset min
 offsetmax=[BP+138]   ;4 ;140      ;offset max
 Pcolmin=[BP+142]     ;4 ;144      ;position min pour un colision
 Pcolmax=[BP+146]     ;4 ;148      ;position max pour un colision
 INCofsl=[BP+150]     ;4 ;152      ;incrmentation de l'offset de la ligne
 offsetl=[BP+154]     ;4 ;156      ;incrmentation de offset de la ligne
 INCpz=[BP+158]       ;4 ;160      ;pour correction Z=65536(Z3-Z1)/(P3-P1)
 PZ=[BP+162]          ;4 ;164      ;
 Zcorrect=[BP+166]    ;4 ;168      ;65536*(-Z3+X3(Z3-Z1)/(P3-P1))
 Z3MOINZ1=[BP+170]    ;4 ;172      ;
 P3MOINP1=[BP+174]    ;4 ;176      ;
 NBligne=[BP+178]     ;4 ;180      ;nombre total de ligne pour ce polygone
 NBligneSKIPd=[BP+182];4 ;184      ;nombre de ligne a skippes au dpart
 NBligneSKIPf=[BP+186];4 ;188      ;nombre de ligne  skippes pour fin
 offsetaLm=[BP+190]   ;4 ;192      ;offset ariv ligne du milieu
 NBlignePDPM=[BP+194] ;4 ;196      ;nombre de ligne de pdepart  pmilieu
 NBlignePMPF=[BP+198] ;4 ;200      ;nombre de ligne de pmilieu  pfin


 lineS=[BP+4+TEMPbuffer]           ;offset du tableau de stockage des lignes prcalcul
 OFS32_bufferZ=[BP+8+TEMPbuffer]   ;offset du bufferZ
 focus=[BP+12+TEMPbuffer]          ;longueur du focus de l'ecran
 hauteur=[BP+16+TEMPbuffer]        ;hauteur de l'cran
 largeur=[BP+20+TEMPbuffer]        ;largeur de l'ecran
 OFS32_fenetre=[BP+24+TEMPbuffer]  ;pointeur sur une structure dfinissant la fenetre d'affichage
 OFS32_polygone=[BP+28+TEMPbuffer] ;offset sur le polygone a affich.

 SR_POLY_GRID PROC NEAR
  SUB SP,TEMPbuffer       ;reserve une zone mmoire pour les variables locales
  PUSH BP
  MOV BP,SP
  PUSH ES
  PUSH DS
  PUSHA

  XOR AX,AX
  MOV ES,AX
  MOV DS,AX
  MOV ESI,OFS32_polygone         ;ESI pointe sur le polygone 
  MOV EDI,[ESI.P_OFS32_PTAB]     ;EDI pointe sur le tableau de point
  ADD EDI,4
  MOV EAX,[ESI.P_ATTRIBUT]       ;Stock l'attribut du polygone dans une variable local
  MOV ATTRIBUT,EAX               ;
  MOV EAX,[ESI.P_COULEUR]        ;Stock la couleur du polygone dans une variable local
  MOV couleur,EAX                ;

  ;On commence par trier les points

  MOV EAX,[ESI+P_P1]          ;EAX=numro du point 1
  MOV EBX,12
  MUL EBX
  ADD EAX,EDI                 ;EAX pointe sur le point 1
  MOV P1,EAX                  ;P1=ofset point1

  MOV EAX,[ESI+P_P2]          ;EAX=numro du point 2
  MOV EBX,12
  MUL EBX
  ADD EAX,EDI                 ;EAX pointe sur le point 2
  MOV P2,EAX                  ;P2=ofset point2

  MOV EAX,[ESI+P_P3]          ;EAX=numro du point 3
  MOV EBX,12
  MUL EBX
  ADD EAX,EDI                 ;EAX pointe sur le point 3
  MOV P3,EAX                  ;P3=ofset point3

  ;Les points doivent etre tri par ordre croissant de leur composante Z

   MOV EDI,P1
   MOV EAX,[EDI+8]            ;EAX=Z point1
   MOV EDI,P2
   CMP EAX,[EDI+8]            ;compare Zpoint1  Zpoint2 ------\
   JL SHORT @SR_P_G0          ;Si infrieur ne fait rien       |
    MOV EAX,P1                ;Si non change les points       |
    MOV P1,EDI                ;                                |
    MOV P2,EAX                ;                                |
   @SR_P_G0:                  ;                            <---/

  ;Ici on sait que P1Z<P2Z

   MOV EDI,P3
   MOV EAX,[EDI+8]            ;EAX=Z point3
   MOV EDI,P1
   CMP EAX,[EDI+8]            ;Compare Zpoint3  Zpoint1
   JG SHORT @SR_P_G1          ;Si suprieur ne fait rien      ---\
    MOV EAX,P1                ;Si non effectue P1=P3;P2=P1;P3=P2 |
    MOV EBX,P2                ;aprs ca le tri est fini.         |
    MOV ECX,P3                ;                                  |
    MOV P1,ECX                ;                                  |
    MOV P2,EAX                ;                                  |
    MOV P3,EBX                ;                                  |
   JMP SHORT @SR_P_G2         ;                                  |
                              ;                                  |
   @SR_P_G1:                  ;                   <--------------/ 
   MOV EDI,P2
   CMP EAX,[EDI+8]           ;Compare Zpoint3  Zpoint2
   JG SHORT @SR_P_G2         ;Si suprieur ne fait rien   -------\
    MOV EAX,P3               ;Si non P3=P2 et P2=P3              |
    MOV P3,EDI               ;                                   |
    MOV P2,EAX               ;                                   |
   @SR_P_G2:                 ;                        <----------/

   ; partir d'ici les points sont tri par ordre croissant de leur Z.

   MOV EDI,P1                ; Compare Zpoint1  Zpoint3
   MOV EAX,[EDI+8]           ;
   MOV EDI,P3                ;
   CMP EAX,[EDI+8]           ;
   JNE SHORT @SR_P_G3        ; si gale tout les points ont le meme Z
    MOV EAX,[EDI]            ; =>Xm=P3x
    MOV Xm,EAX               ; =>Ym=P3y
    MOV EAX,[EDI+4]          ;
    MOV Ym,EAX               ; Si diffrent on calcul le point m sur la
    JMP SHORT @SR_P_G4       ; ligne de p1  p3 avec Zm=Zpoint2
   @SR_P_G3:                 ; ce qui dfinit la ligne
    MOV EDI,P2      ;        ; du plan pour laquelle Z est constant.
    MOV EAX,[EDI+8] ;EAX=Z2  ; Xm=(Z2-Z1)*(X3-X1)/(Z3-Z1)+X1 (ou avec X1=X2)
    MOV EDI,P3               ; Ym=(Z2-Z1)*(Y3-Y1)/(Z3-Z1)+Y1 (ou avec Y1=Y2)
    MOV ECX,[EDI+8] ;ECX=Z3
    MOV EDI,P1
    MOV EBX,[EDI+8] ;EBX=Z1

    SUB EAX,EBX     ;EAX=Z2-Z1
    SUB ECX,EBX     ;ECX=Z3-Z1

    MOV EBX,65536
    IMUL EBX        ;EAX=EAX*65536 (pour les virgules)
    IDIV ECX        ;EAX=65536*(Z2-Z1)/(Z3-Z1)

    MOV EDI,P3
    MOV EBX,[EDI]   ;EBX=X3
    MOV ECX,[EDI+4] ;ECX=Y3
    MOV EDI,P1
    SUB EBX,[EDI]   ;EBX=X3-X1
    SUB ECX,[EDI+4] ;ECX=Y3-Y1

    PUSH EAX
     IMUL EBX        ;
     MOV EBX,65536   ;
     IDIV EBX        ;
     ADD EAX,[EDI]   ;
     MOV Xm,EAX      ;Xm est fix
    POP EAX
     IMUL ECX        ;
     IDIV EBX        ;
     ADD EAX,[EDI+4] ;
     MOV Ym,EAX      ;Ym est fix
   @SR_P_G4:

    ; partir d'ici Xm,Ym contienne la position du point de la ligne [P1,P3]
    ; pour lequel Zm=Zp2
    ; Grace au focus on peut donc dfinir la direction de la ligne Zconstant

   ;on convertit les points 3D en points 2D grace au focus. 

  ;Calcul P1_2D
   MOV EDI,P1        ;
   MOV EBX,FOCUS     ;EBX=focus
   MOV ECX,EBX       ;
   ADD ECX,[EDI+8]   ;ECX=focus+z1

   MOV EAX,[EDI]     ;
   IMUL EBX          ;x'=x*focus/(focus+z)
   IDIV ECX          ;
   MOV P1_2D,EAX     ;

   MOV EAX,[EDI+4]   ;
   NEG EAX           ;
   IMUL EBX          ;y'=-y*focus/(focus+z)
   IDIV ECX          ;
   MOV [P1_2D+4],EAX ;

  ;Calcul P2_2D
   MOV EDI,P2        ;
   MOV ECX,EBX       ;
   ADD ECX,[EDI+8]   ;ECX=focus+z2

   MOV EAX,[EDI]     ;
   IMUL EBX          ;x'=x*focus/(focus+z)
   IDIV ECX          ;
   MOV P2_2D,EAX     ;

   MOV EAX,[EDI+4]   ;
   NEG EAX           ;
   IMUL EBX          ;y'=-y*focus/(focus+z)
   IDIV ECX          ;
   MOV [P2_2D+4],EAX ;


  ;Calcul P3_2D
   MOV EDI,P3        ;
   MOV ECX,EBX       ;
   ADD ECX,[EDI+8]   ;ECX=focus+z3

   MOV EAX,[EDI]     ;
   IMUL EBX          ;x'=x*focus/(focus+z)
   IDIV ECX          ;
   MOV P3_2D,EAX     ;

   MOV EAX,[EDI+4]   ;
   NEG EAX           ;
   IMUL EBX          ;y'=-y*focus/(focus+z)
   IDIV ECX          ;
   MOV [P3_2D+4],EAX ;

  ;Calcul Pm_2D
   MOV EDI,P2        ;
   MOV ECX,EBX       ;
   ADD ECX,[EDI+8]   ;ECX=focus+zm

   MOV EAX,Xm        ;
   IMUL EBX          ;x'=x*focus/(focus+z)
   IDIV ECX          ;
   MOV Xm,EAX        ;

   MOV EAX,Ym        ;
   NEG EAX           ;
   IMUL EBX          ;y'=-y*focus/(focus+z)
   IDIV ECX          ;
   MOV Ym,EAX ;


   ;Fixe les variable WXmin,WXmax,WYmin,WYmax
    MOV EDI,[OFS32_FENETRE]
    MOV EAX,[EDI.FENETRE_Xmin]
    MOV WXmin,EAX

    MOV EAX,[EDI.FENETRE_Ymin]
    MOV WYmin,EAX

    MOV EAX,[EDI.FENETRE_Xmax]
    MOV WXmax,EAX

    MOV EAX,[EDI.FENETRE_Ymax]
    MOV WYmax,EAX

  ;on stock la ligne prcalcule

   ;calcul P2X-Xm  et delta X
    MOV EAX,[P2_2D]
    SUB EAX,Xm
    MOV [P2XMOINXM],EAX
    JNS @SR_P_GL0
     NEG EAX
    @SR_P_GL0:

   ;calcul P2Y-Ym et delta Y
    MOV EBX,[P2_2D+4]
    SUB EBX,Ym
    MOV [P2YMOINYM],EBX
    JNS @SR_P_GL1
     NEG EBX
    @SR_P_GL1:

    CMP EAX,EBX
    JG @SR_P_GL2                     ;delta X < delta Y
     CMP DWORD PTR [P2YMOINYM],0
     JNE @SR_P_GE0
      JMP @SR_P_OUT
     @SR_P_GE0:
     MOV DWORD PTR [DXSUPDY],0
     ;calcul facteur d'incrmentation de X 65536(p2x - xm)/(p2y - ym)
     MOV DWORD PTR INCfac,1
     MOV EAX,65536
     IMUL DWORD PTR [P2XMOINXM]
     IDIV DWORD PTR [P2YMOINYM]
     JNS @SR_P_GL4
      NEG DWORD PTR INCfac
     @SR_P_GL4:
     MOV [FACinc],EAX
     MOV EAX,largeur
     MOV [INCOBL],EAX
     MOV ECX,[WYmax]
     SUB ECX,[WYmin]
    JMP @SR_P_GL3
    @SR_P_GL2:                          ;delta X > delta Y
     CMP DWORD PTR [P2XMOINXM],0
     JNE @SR_P_GE1
      JMP @SR_P_OUT
     @SR_P_GE1:
     MOV DWORD PTR [DXSUPDY],1
     ;calcul facteur d'incrmentation de Y 65536(p2y - ym)/(p2x - xm)
     MOV EAX,largeur
     MOV DWORD PTR INCfac,EAX
     MOV EAX,65536
     IMUL DWORD PTR [P2YMOINYM]
     IDIV DWORD PTR [P2XMOINXM]
     JNS @SR_P_GL07
      NEG DWORD PTR INCfac
     @SR_P_GL07:
     MOV [FACinc],EAX
     MOV EAX,1
     MOV [INCOBL],EAX
     MOV ECX,[WXmax]
     SUB ECX,[WXmin]
    @SR_P_GL3:

 ;Stock la ligne dans BUFFERL
   MOV EDI,lineS
   MOV ESI,EDI
   MOV EDI,[EDI]
   MOV lineS,EDI
   INC ECX
   ADD [ESI],ECX
   DEC ECX
   XOR EAX,EAX
   MOV [EDI],EAX
   ADD EDI,4
   MOV EBX,FACinc
   @SR_P_GL08:
    ADD EAX,[INCOBL]
    ADD EBX,[FACINC]
    CMP EBX,0FFFFH
    JBE @SR_P_GL09
     AND EBX,0FFFFH
     ADD EAX,[INCFAC]
    @SR_P_GL09:
    MOV [EDI],EAX
    ADD EDI,4
  LOOPD @SR_P_GL08

 CMP DWORD PTR [DXSUPDY],1   ;
 JNE @SR_P_GS0               ;
  JMP @SR_P_GS1              ;Test si il faut parcourir le poly en X ou Y
 @SR_P_GS0:                  ;si DY>DX on parcour en X

 ;on calcul d'abord Pdpart,Pfin,Pmilieu
  MOV EAX,[P3_2D+4] ;calcul Pdpart
  SUB EAX,[WYmin]
  IMUL DWORD PTR [P2XMOINXM]
  IDIV DWORD PTR [P2YMOINYM]
  MOV EBX,[P3_2D]
  SUB EBX,EAX
  MOV [Pdepart],EBX
  MOV EAX,[P2_2D+4]     ;calcul Pmilieu
  SUB EAX,[WYmin]
  IMUL DWORD PTR [P2XMOINXM]
  IDIV DWORD PTR [P2YMOINYM]
  MOV EBX,[P2_2D]
  SUB EBX,EAX
  MOV [Pmilieu],EBX
  MOV EAX,[P1_2D+4] ;calcul Pfin
  SUB EAX,[WYmin]
  IMUL DWORD PTR [P2XMOINXM]
  IDIV DWORD PTR [P2YMOINYM]
  MOV EBX,[P1_2D]
  SUB EBX,EAX
  MOV [Pfin],EBX

 ;calcul PXTREMmin,PXTREMmax,Pcolmin,Pcolmax
  MOV EBX,[WYmax]     
  SUB EBX,[WYmin]
  MOV EAX,[P2XMOINXM]
  IMUL EBX
  IDIV DWORD PTR [P2YMOINYM]
  CMP EAX,0            ;Test si il faut echang PXTREMmin et PCOLmin
  JL @SR_P_GP0         ;ou PXTREMmax et PCOLmax
   MOV EDX,[WXmin]     ;calcul PXTREMmin et Pcolmin
   MOV [Pcolmin],EDX
   SUB EDX,EAX
   MOV [PXTREMmin],EDX
   MOV EDX,[WXmax]     ;calcul PXTREMmax et Pcolmax
   MOV [PXTREMmax],EDX
   SUB EDX,EAX
   MOV [Pcolmax],EDX
  JMP @SR_P_GP1
  @SR_P_GP0:
   MOV EDX,[WXmin]     ;calcul PXTREMmin et Pcolmin
   MOV [PXTREMmin],EDX
   SUB EDX,EAX
   MOV [Pcolmin],EDX
   MOV EDX,[WXmax]     ;calcul PXTREMmax et Pcolmax
   MOV [Pcolmax],EDX
   SUB EDX,EAX
   MOV [PXTREMmax],EDX
  @SR_P_GP1:

  ;on calcul maintenant les diffrent coeff d'incrmentation

   MOV EBX,65536

  ;INCofsl=+/- 1
  ;NB ligne=Pfin-Pdepart
   MOV DWORD PTR INCofsl,1
   MOV EAX,Pfin
   SUB EAX,Pdepart
   JNS @SR_P_G_P01
    NEG DWORD PTR INCofsl
    NEG EAX
   @SR_P_G_P01:
   MOV NBligne,EAX

  ;Calcul z3-z1,p3-p1,Zcorrect1
   MOV EDI,P3
   MOV EAX,[EDI+8]
   MOV EDI,P1
   SUB EAX,[EDI+8]
   MOV [Z3MOINZ1],EAX
   MOV EDI,P3
   MOV EAX,[EDI]
   MOV EDI,P1
   SUB EAX,[EDI]
   MOV [P3MOINP1],EAX

   MOV EDI,P3
   MOV EAX,[EDI+8]
   NEG EAX
   IMUL EBX
   MOV Zcorrect,EAX

   MOV EAX,[Z3MOINZ1]        ; Zcorrect=65536*(-Z3+(z3-z1)*X3/(X3-X1))
   IMUL EBX                  ;
   IDIV DWORD PTR [P3MOINP1] ;
   IMUL DWORD PTR [EDI]
   ADD Zcorrect,EAX
   
  ;calcul INCpz=65536/NBligne*(X1(2d)(Z3-Z1)/(X3-X1))-(X3(2d)(Z3-Z1)/(X3-X1))
  ;Fixe Pz de dpart
   MOV EAX,[P1_2D]
   SUB EAX,[P3_2D]
   IMUL DWORD PTR [Z3MOINZ1]
   IDIV DWORD PTR [P3MOINP1]
   IMUL EBX
   IDIV DWORD PTR NBligne
   MOV INCpz,EAX

  ;INCofsd=(Y1-Y3)*65536/NBligne
   MOV EAX,[P1_2D+4]
   SUB EAX,[P3_2D+4]
   IMUL EBX
   IDIV DWORD PTR NBligne
   MOV INCofsd,EAX

  ;INCofsa3=(Y2-Y3)*65536/NB ligne Pdepart  Pmilieu
   MOV EAX,[P2_2D+4]
   SUB EAX,[P3_2D+4]
   IMUL EBX
   MOV ECX,Pmilieu
   SUB ECX,Pdepart
   JNS @SR_P_G02
    NEG ECX
   @SR_P_G02:
   INC ECX
   IDIV ECX
   MOV INCofsa3,EAX

  ;INCofsa1=(Y1-Y2)*65536/NB ligne Pmilieu  Pfin
   MOV EAX,[P1_2D+4]
   SUB EAX,[P2_2D+4]
   IMUL EBX
   MOV ECX,Pfin
   SUB ECX,Pmilieu
   JNS @SR_P_G03
    NEG ECX
   @SR_P_G03:
   INC ECX
   IDIV ECX
   MOV INCofsa1,EAX

 ;Fixe les valeur de depart
 ;Offsetl=WYmin*largeur+Pdepart
  MOV EAX,WYmin
  IMUL DWORD PTR largeur
  ADD EAX,Pdepart
  MOV offsetl,EAX

 ;PZ=65536*X3(2d)*(Z3-Z1)/(X3-X1)
  MOV EAX,[P3_2D]
  IMUL DWORD PTR [Z3MOINZ1]
  IDIV DWORD PTR [P3MOINP1]
  IMUL EBX
  MOV PZ,EAX

 ;offsetaLm=(P2Y-WYmin)*65536
  MOV EAX,[P2_2D+4]
  SUB EAX,WYmin
  IMUL EBX
  MOV offsetaLm,EAX

 ;offsetd=(P3Y-WYmin)*65536
  MOV EAX,[P3_2D+4]
  SUB EAX,WYmin
  IMUL EBX
  MOV offsetd,EAX
  MOV offseta,EAX     ;offseta=offsetd

JMP @SR_P_G_stockage


 @SR_P_GS1:  ;parcour en Y du poly

@SR_P_G_stockage:

 ;calcul nombre de ligne a skippes au dpart et  la fin
  XOR EAX,EAX
  MOV NBligneSKIPd,EAX
  MOV NBligneSKIPf,EAX

  MOV EAX,PXTREMmin ;Calcul nombre de ligne  skippes pour dpart et pour fin
  CMP Pdepart,EAX   ;pour colision sur PXTREMmin
  JGE @SR_P_GR0     ;Test si Pdepart<PXTREMmin si oui
  CMP Pfin,EAX      ;Test si Pfin<PXTREMmin si oui
  JGE @SR_P_GR2     ;polygone out
   JMP @SR_P_OUT
  @SR_P_GR2:        ;Ici on sait que Pdepart<PXTREMmin et Pfin>=PXTREMmin
   MOV EAX,PXTREMmin;Fixe nombre de ligne  skipp pour dpart
   SUB EAX,Pdepart
   MOV NBligneSKIPd,EAX 
  JMP @SR_P_GR3
  @SR_P_GR0:        ;Ici on sait que Pdepart >=PXTREMmin
  CMP Pfin,EAX      ;Test si Pfin < PXTREMmin
  JGE @SR_P_GR3     ;Si oui Pdepart>= PXTREMmin et Pfin<PXTREMmin
   MOV EAX,PXTREMmin;Fixe nombre de ligne  skipp pour fin
   SUB EAX,Pfin
   MOV NBligneSKIPf,EAX

  @SR_P_GR3:        ;Colision sur PXTREMmin traite

  MOV EAX,PXTREMmax ;Calcul nombre de ligne  skippes pour dpart et pour fin
  CMP Pdepart,EAX   ;pour colision sur PXTREMmax
  JLE @SR_P_GR4     ;Test si Pdepart>PXTREMmax si oui
  CMP Pfin,EAX      ;Test si Pfin>PXTREMmax si oui
  JLE @SR_P_GR5     ;polygone out
   JMP @SR_P_OUT
  @SR_P_GR5:        ;Ici on sait que Pdepart>PXTREMmax et Pfin<=PXTREMmax
   MOV EAX,Pdepart  ;Fixe nombre de ligne  skipp pour dpart
   SUB EAX,PXTREMmax
   MOV NBligneSKIPd,EAX 
  JMP @SR_P_GR6
  @SR_P_GR4:        ;Ici on sait que Pdepart <=PXTREMmax
  CMP Pfin,EAX      ;Test si Pfin > PXTREMmax
  JLE @SR_P_GR6     ;Si oui Pdepart<= PXTREMmax et Pfin>PXTREMmax
   MOV EAX,Pfin     ;Fixe nombre de ligne  skipp pour fin
   SUB EAX,PXTREMmax
   MOV NBligneSKIPf,EAX
  @SR_P_GR6:        ;NBligneSKIPd et NBligneSKIPf fixes

  MOV ECX,Pdepart ;calcul nombre de ligne de Pdepart  Pmilieu (Comprise)
  SUB ECX,Pmilieu
  JNS @SR_P_G_S0
   NEG ECX
  @SR_P_G_S0:
   INC ECX
   MOV NBlignePDPM,ECX

  MOV ECX,Pfin ;calcul nombre de ligne de Pmilieu(exclu)  Pfin
  SUB ECX,Pmilieu
  JNS @SR_P_G_S3
   NEG ECX
  @SR_P_G_S3:
   MOV NBlignePMPF,ECX


;rectifie les valeurs de dpart pour offseta,offsetd,offsetl,pz et le nombre de ligne.
 MOV EBX,NBligneSKIPd
 CMP NBlignePDPM,EBX
 JL @SR_P_GR7        ;Test si il faut parcourir de Pdepart  Pmilieu
  SUB NBlignePDPM,EBX

  MOV EAX,INCofsd
  IMUL EBX
  ADD offsetd,EAX

  MOV EAX,INCofsa3
  IMUL EBX
  ADD offseta,EAX

  MOV EAX,INCpz
  IMUL EBX
  ADD Pz,EAX

  MOV EAX,INCofsl
  IMUL EBX
  ADD offsetl,EAX

 MOV EAX,NBligneSKIPf
 CMP NBlignePMPF,EAX
 JG @SR_P_GR8
  SUB EAX,NBlignePMPF
  SUB NBlignePDPM,EAX
  XOR EAX,EAX
  MOV NBlignePMPF,EAX
 JMP @SR_P_GR9
 @SR_P_GR8:
  SUB NBlignePMPF,EAX
 JMP @SR_P_GR9
 @SR_P_GR7:

  MOV EAX,INCpz
  IMUL EBX
  ADD Pz,EAX

  MOV EAX,INCofsl
  IMUL EBX
  ADD offsetl,EAX

  MOV EAX,INCofsd
  IMUL EBX
  ADD offsetd,EAX

  SUB EBX,NBlignePDPM
  SUB NBlignePMPF,EBX

  MOV EAX,OffsetaLm
  MOV offseta,EAX
  MOV EAX,INCofsa1
  IMUL EBX
  ADD offseta,EAX


  MOV EAX,NBligneSKIPf
  SUB NBlignePMPF,EAX
  XOR EAX,EAX
  MOV NBlignePDPM,EAX
 @SR_P_GR9:


;Depart du stockage des lignes dans le BUFFERZ

 ;Stock les lignes de Pdepart  Pmilieu.

 ;Rectifie les valeur de dpart du polygone
  MOV ECX,NBlignePDPM
  CMP ECX,0
  JNE @SR_P_G_S1
   JMP @SR_P_G_S2
  @SR_P_G_S1:           ;Stock la ligne(offset ligne,taille,ligne precal,offset precal).
  MOV ESI,OFS32_BUFFERZ

  MOV EAX,INCofsa3
  ADD offseta,EAX

  ;Calcul Z=Zcorrect-Pz/(Pz/focus)-65536

  MOV EAX,PZ
  CDQ
  IDIV DWORD PTR focus
  SUB EAX,65536
  MOV EBX,EAX

  MOV EAX,Zcorrect
  SUB EAX,Pz
  CDQ
  IDIV EBX

  MOV EBX,65536

  CMP EAX,[ESI+8]     ;si pos Z>Zmax le polygone commence a sortir on sort
  JLE @SR_P_G6
   JMP @SR_P_OUT
  @SR_P_G6:           ;si Z<Zmin on ne stock pas la ligne
  SUB EAX,[ESI+4]
  JS @SR_P_G_S5
      

  ;Stock nouvelle offset_prochain du dernier objet stock pour ce Z
  ;nouvelle offset dernier objet et nouvelle offset de fin de bufferz
   MOV ESI,OFS32_BUFFERZ
   MOV EDI,ESI
   SHL EAX,3
   ADD EAX,16
   ADD ESI,EAX
   MOV EDX,ESI       ;EDX=offset ou est offset dernier objet de ce Z
   MOV ESI,[ESI]     ;ESI=offset dernier objet
   MOV EAX,[EDI]     ;EAX=offset fin de buffer
   MOV [ESI.OFS32_PROCHAIN],EAX ;Fixe offset prochain_obj du dernier objet de ce Z
   MOV ESI,EDX
   MOV [ESI],EAX     ;Fixe offset du dernier objet de ce Z
   MOV ESI,EDI
   MOV EDI,[EDI]
   MOV EAX,size OBJ_LIGNE
   ADD [ESI],EAX     ;Fixe nouvelle offset de fin du buffer
   XOR EAX,EAX       ;stock offset prochain objet=0
   MOV [EDI.OFS32_PROCHAIN],EAX
   MOV EAX,CH_LIGNE_COULEUR   ;stock le type de l'objet
   MOV [EDI.TYPE_OBJET],EAX

  ;stock l'offset pour le dpart de cette ligne
   MOV EAX,offsetl
   MOV [EDI.LIGNE_offset],EAX

  ;stock l'offset de la ligne precalcule
   MOV EAX,lineS
   MOV [EDI.LIGNE_PRECAL],EAX

  ;stock l'offset de dpart dans la ligne precal
   MOV EAX,offsetd
   CDQ
   IDIV EBX  
   MOV [EDI.LIGNE_OFFSET_PRECAL],EAX

  ;stock la longueur de la ligne=offseta-offsetd
   MOV EAX,offseta
   CDQ
   IDIV EBX
   SUB EAX,[EDI.LIGNE_OFFSET_PRECAL]
   MOV [EDI.LIGNE_taille],EAX

  ;stock la couleur de la ligne
   MOV EAX,couleur
   MOV [EDI.LIGNE_COULEUR],EAX

  @SR_P_G_S5:   ;incrmente PZ,offsetl,offsetd,offseta

   MOV EAX,INCPZ
   ADD PZ,EAX
   MOV EAX,INCofsd
   ADD offsetd,EAX
   MOV EAX,INCofsl
   ADD offsetl,EAX

  DEC ECX
  JECXZ @SR_P_G_S2 ;Si derniere ligne traite passe au parcour de Pmilieu  Pfin
  JMP @SR_P_G_S1


  @SR_P_G_S2: ;Stock les lignes de Pmilieu(exclu)  Pfin.



  MOV ECX,NBlignePMPF
  CMP ECX,0
  JNE @SR_P_GE3
   JMP @SR_P_OUT
  @SR_P_GE3:

 ;Stock la ligne(offset ligne,taille,ligne precal,offset precal).
  @SR_P_G_S01:      
   MOV ESI,OFS32_BUFFERZ

  MOV EAX,INCofsa1     
  ADD offseta,EAX

  ;Calcul Z=Zcorrect-Pz/(Pz/focus)-65536

  MOV EAX,PZ
  CDQ
  IDIV DWORD PTR focus
  SUB EAX,65536
  MOV EBX,EAX

  MOV EAX,Zcorrect
  SUB EAX,Pz
  CDQ
  IDIV EBX

  MOV EBX,65536

   CMP EAX,[ESI+8]     ;si pos Z>Zmax le polygone commence a sortir on sort
   JLE @SR_P_G06
    JMP @SR_P_OUT
   @SR_P_G06:           ;si Z<Zmin on ne stock pas la ligne
   SUB EAX,[ESI+4]
   JS @SR_P_G_S05



  ;Stock nouvelle offset_prochain du dernier objet stock pour ce Z
  ; nouvelle offset dernier objet et nouvelle offset de fin de bufferz
   MOV ESI,OFS32_BUFFERZ
   MOV EDI,ESI
   SHL EAX,3
   ADD EAX,16
   ADD ESI,EAX
   MOV EDX,ESI       ;EDX=offset ou est offset dernier objet de ce Z
   MOV ESI,[ESI]     ;ESI=offset dernier objet
   MOV EAX,[EDI]     ;EAX=offset fin de buffer
   MOV [ESI.OFS32_PROCHAIN],EAX ;Fixe offset prochain_obj du dernier objet de ce Z
   MOV ESI,EDX
   MOV [ESI],EAX     ;Fixe offset du dernier objet de ce Z
   MOV ESI,EDI
   MOV EDI,[EDI]
   MOV EAX,size OBJ_LIGNE
   ADD [ESI],EAX     ;Fixe nouvelle offset de fin du buffer
   XOR EAX,EAX       ;stock offset prochain objet=0
   MOV [EDI.OFS32_PROCHAIN],EAX  
   MOV EAX,CH_LIGNE_COULEUR ;stock le type de l'objet
   MOV [EDI.TYPE_OBJET],EAX

  ;stock l'offset pour le dpart de cette cette ligne
   MOV EAX,offsetl
   MOV [EDI.LIGNE_offset],EAX

  ;stock l'offset de la ligne precalcule
   MOV EAX,lineS
   MOV [EDI.LIGNE_PRECAL],EAX

  ;stock l'offset de dpart dans la ligne precal
   MOV EAX,offsetd
   CDQ
   IDIV EBX  
   MOV [EDI.LIGNE_OFFSET_PRECAL],EAX

  ;stock la longueur de la ligne=offseta-offsetd
   MOV EAX,offseta
   CDQ
   IDIV EBX
   SUB EAX,[EDI.LIGNE_OFFSET_PRECAL]
   MOV [EDI.LIGNE_taille],EAX

  ;stock la couleur de la ligne
   MOV EAX,couleur
   MOV [EDI.LIGNE_COULEUR],EAX
   @SR_P_G_S05:

  ;incrmente PZ,offsetl,offsetd,offseta

  MOV EAX,INCPZ
  ADD PZ,EAX
  MOV EAX,INCofsd
  ADD offsetd,EAX
  MOV EAX,INCofsl
  ADD offsetl,EAX

  DEC ECX
  JECXZ @SR_P_G_S02
 JMP @SR_P_G_S01
 @SR_P_G_S02:

 JMP @SR_P_OUT


 ;**************************************************
 ;Test affiche Pdpart,Pfin,Pmilieu,Ligne de P2  Pm
 ;**************************************************

 MOV EDI,0A0000H+32160
 MOV EAX,Ym
 MOV EBX,320
 IMUL EBX
 ADD EAX,Xm
 ADD EDI,EAX
 MOV AL,1
 MOV [EDI],AL
 
 MOV EDI,0A0000H+32160
 MOV EAX,[P1_2D+4]
 MOV EBX,320
 IMUL EBX
 ADD EAX,[P1_2D]
 ADD EDI,EAX
 MOV AL,1
 MOV [EDI],AL

 MOV EDI,0A0000H+32160
 MOV EAX,[P2_2D+4]
 MOV EBX,320
 IMUL EBX
 ADD EAX,[P2_2D]
 ADD EDI,EAX
 MOV AL,1
 MOV [EDI],AL
 
 MOV EDI,0A0000H+32160
 MOV EAX,[P3_2D+4]
 MOV EBX,320
 IMUL EBX
 ADD EAX,[P3_2D]
 ADD EDI,EAX
 MOV AL,1
 MOV [EDI],AL

 MOV EDI,0A0000H+32160
 MOV EAX,WYmin
 MOV EBX,320
 IMUL EBX
 ADD EAX,[Pdepart]
 ADD EDI,EAX
 MOV AL,2
 MOV [EDI],AL

 MOV EDI,0A0000H+32160
 MOV EAX,WYmin
 MOV EBX,320
 IMUL EBX
 ADD EAX,[Pfin]
 ADD EDI,EAX
 MOV AL,2
 MOV [EDI],AL

 MOV EDI,0A0000H+32160
 MOV EAX,WYmin
 MOV EBX,320
 IMUL EBX
 ADD EAX,[Pmilieu]
 ADD EDI,EAX
 MOV AL,2
 MOV [EDI],AL


 MOV EDI,0A0000H+32160
 MOV EAX,WYmin
 MOV EBX,320
 IMUL EBX
 ADD EAX,[Pmilieu]
 ADD EDI,EAX
 MOV ESI,LINES
 MOV AL,3
 MOV ECX,WYmax
 SUB ECX,WYmin
 MOV EBX,[ESI]
 @pp:
  MOV [EDI+EBX],AL
  ADD ESI,4
  MOV EBX,[ESI]
 LOOP @pp

 MOV EDI,0A0000H+32160
 MOV EAX,WYmin
 MOV EBX,320
 IMUL EBX
 ADD EAX,[Pdepart]
 ADD EDI,EAX
 MOV ESI,LINES
 MOV AL,3
 MOV ECX,WYmax
 SUB ECX,WYmin
 MOV EBX,[ESI]
 @ppd:
  MOV [EDI+EBX],AL
  ADD ESI,4
  MOV EBX,[ESI]
 LOOP @ppd

 MOV EDI,0A0000H+32160
 MOV EAX,WYmin
 MOV EBX,320
 IMUL EBX
 ADD EAX,[Pfin]
 ADD EDI,EAX
 MOV ESI,LINES
 MOV AL,3
 MOV ECX,WYmax
 SUB ECX,WYmin
 MOV EBX,[ESI]
 @ppf:
  MOV [EDI+EBX],AL
  ADD ESI,4
  MOV EBX,[ESI]
 LOOP @ppf



 @SR_P_OUT:

  POPA
  POP DS
  POP ES
  POP BP
  ADD SP,TEMPbuffer
  RETN 28
 ENDP
