TITLE fonctions pour la manipulation de fichiers


; Fixe l'adresse de la DTA

 FIXE_ADRESSE_DTA MACRO
  MOV DX,offset DTA
  MOV AH,1AH
  INT 21H
 ENDM

; Charge la DTA avec les information d'un fichier
 PREND_DTA_INFO MACRO nomfichier,attribut
 LOCAL nomf
 .DATA
  nomf DB nomfichier,0
 .CODE
  PUSH OFFSET nomf
  PUSH WORD PTR attribut
  CALL SR_PREND_DTA_INFO
 ENDM
 

; Mode d'ouverture des fichiers

 LECTURE=00
 ECRITURE=01
 LECTURE_ECRITURE=02

OUVRE_FICHIER MACRO NOM_DU_FICHIER,MODE
 LOCAL NOMF                          ;
 .DATA                               ;
  NOMF DB NOM_DU_FICHIER,0           ; Ouvre un fichier
 .CODE                               ;  Entre: nom du fichier,mode(lecture,ecriture)
  PUSH OFFSET NOMF                   ;  Sortie: AX=handle
  PUSH MODE                          ;          CF->erreur
  CALL SR_OUVRE_FICHIER
ENDM


FERME_FICHIER MACRO Handle
 PUSH HANDLE                        ; Ferme un fichier
 CALL SR_FERME_FICHIER              ;  Entre: Handle du fichier
ENDM


;Attribut des fichier

RO=1          ;read only
HI=2          ;cach
SY=4          ;systme
LA=8          ;label
DIR=16         ;directory
AR=32         ;archive


CREER_FICHIER MACRO NOM_DU_FICHIER,ATTRIBUT
 LOCAL  NOMF
 .DATA
  NOMF DB NOM_DU_FICHIER,0          ; Creer un fichier
 .CODE                              ;  Entre: nom du fichier, attribut
  PUSHA                             ;  Sortie: CF->erreur
  MOV DX,OFFSET NOMF                ;
  MOV CX,ATTRIBUT                   ;
  MOV AH,3CH
  INT 21H
  POPA
ENDM



; Origine de deplacement du pointeur dans le fichiers

DU_DEPART=00
DE_LA_POSITION_COURANTE=1
DE_LA_FIN=2

DEPLACE_POINTEUR_FICHIER MACRO HANDLE,ofs32,origine
 PUSH HANDLE                       ;
 PUSH DWORD PTR ofs32              ; Dplace le pointeur d'un fichier
 PUSH origine                      ;  Entre: handle,ofs32,origine dplacement
 CALL SR_DEPLACE_POINTEUR_FICHIER  ;  Sortie= aucune (CF->erreur)
ENDM



LIT_FICHIER MACRO HANDLE,NB_bytes,ofs32
 PUSH WORD PTR handle    ;
 PUSH WORD PTR NB_bytes  ; Lit dans un fichier
 PUSH DWORD PTR ofs32    ;  Entre: handle,nb d'octets a lire,ofset du buffer
 CALL SR_LIT_FICHIER     ;  Sortie: AX=nb d'octets lue
ENDM


ECRIT_FICHIER MACRO handle,NB_bytes,ofs32
 PUSH handle              ;
 PUSH NB_bytes            ; Ecrit dans un fichier
 PUSH DWORD PTR ofs32     ;  Entre: handle,nb d'octets  crire,ofset du buffer
 CALL SR_ECRIT_FICHIER    ;
ENDM                      ;



LIT_FICHIER_ENTIER MACRO nomfichier,ofs32
 LOCAL nomf
 .DATA
  nomf DB nomfichier,0     ;  Charge un fichier entier
 .CODE                     ;   Entre: nom du fichier,ofs32 mmoire
  SUB SP,6                 ;   Sortie: EAX=taille du fichier
  PUSH OFFSET nomf         
  PUSH ofs32
  CALL SR_LIT_FICHIER_ENTIER
ENDM

.DATA

 DTA DB 21 DUP(?)
 ATTRIBUT_FICHIER DB 0
 HEURE_FICHIER    DW 0
 DATE_FICHIER     DW 0
 TAILLE_FICHIER   DD 0
 NOM_FICHIER      DB 13 DUP (0)

.CODE

 origine =[BP+4]
 ofs32=[BP+6]
 handle=[BP+10]

 SR_DEPLACE_POINTEUR_FICHIER PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSHAD
   MOV EAX,ofs32
   MOV DX,AX
   SHR EAX,16
   MOV CX,AX
   MOV BX,handle
   MOV AL,origine
   MOV AH,42H
   INT 21H
  POPAD
  POP BP
  RETN 8
 ENDP



 ofs32=[BP+4]
 NB_bytes=[BP+8]
 handle=[BP+10]

 SR_LIT_FICHIER PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DS
  PUSH ECX
  PUSH EDX
  PUSH EBX

   MOV EAX,ofs32
   MOV DX,AX
   AND DX,1111b
   SHR EAX,4
   MOV DS,AX
   MOV BX,handle
   MOV CX,NB_bytes
   MOV AH,3FH
   INT 21H

  POP EBX
  POP EDX
  POP ECX
  POP DS
  POP BP
  RETN 8
 ENDP




 SR_ECRIT_FICHIER PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DS
  PUSH ECX
  PUSH EDX
  PUSH EBX

   MOV EAX,ofs32
   MOV DX,AX
   AND DX,1111b
   SHR EAX,4
   MOV DS,AX
   MOV BX,handle
   MOV CX,NB_bytes
   MOV AH,40H
   INT 21H

  POP EBX
  POP EDX
  POP ECX
  POP DS
  POP BP
  RETN 8
 ENDP


 NOMF=[BP+6]
 MODE=[BP+4]

 SR_OUVRE_FICHIER PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DX

   MOV DX,NOMF
   MOV AL,MODE                        
   MOV AH,3DH                         
   INT 21H                            

  POP DX
  POP BP
  RETN 4
 ENDP


 handle=[BP+4]

 SR_FERME_FICHIER PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH BX

  MOV BX,Handle                   ; Ferme un fichier
  MOV AH,3EH                      ;  Entre: Handle du fichier
  INT 21H                         ;  Sortie: CF->erreur

  POP BX
  POP BP
  RETN 2
 ENDP


 nomf=[BP+8]
 ofs32=[BP+4]
 handle=[BP+10]
 taille=[BP+12]

 SR_LIT_FICHIER_ENTIER PROC NEAR
  PUSH BP
  MOV BP,SP

  PUSH WORD PTR nomf
  PUSH 0
  CALL SR_OUVRE_FICHIER
  MOV handle,AX

  XOR EAX,EAX
  MOV TAILLE,EAX
  
  @SR_L_F_E0:
   PUSH WORD PTR handle
   PUSH WORD PTR 0FFFFH
   PUSH DWORD PTR ofs32
   CALL SR_LIT_FICHIER

   
   AND EAX,0FFFFH
   ADD ofs32,EAX
   ADD TAILLE,EAX
   CMP AX,0FFFFH
   JE @SR_L_F_E0


  PUSH WORD PTR handle
  CALL SR_FERME_FICHIER

  MOV EAX,taille

  POP BP
  RETN 12
 ENDP

 nomf=[BP+6]
 attribut=[BP+4]
 SR_PREND_DTA_INFO PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DX
  PUSH CX
   MOV DX,nomf
   MOV CX,attribut
   MOV AH,4EH
   INT 21H
  POP CX
  POP DX
  POP BP
  RETN 4
 ENDP
