TITLE fonction pour jouer une animation fli


;structure de l'entte d'un fichier fli et flc

EN_TETE_FLI STRUC
 taille_fichier_fli   DD 0   ;taille du fichier
 magic                DW 0   ;code d'identification (fli AF11,flc AF12)
 nombre_images        DW 0   ;nombre d'images (maximum pour fli = 4000)
 largeur_ecran        DW 0   ;largeur de l'ecran
 longueur_ecran       DW 0   ;longeur de l'ecran
 profondeur_pixel     DW 0   ;nombre de bit par pixel (en gnral 8)
 flags                DW 0   ;flags qui doit tre  zro ???
 vitesse              DW 0   ;delay pour les image FLI 1/70s, 1/1000 s
 next                 DD 0   ; zro ???
 frit                 DD 0   ;c'est bon les frites ( zro ???)
 extension_fli        DB 102 DUP (0) ;pour des extensions futures 
ENDS


;structure de l'entte d'une image fli

EN_TETE_IMAGE_FLI STRUC
 nombre_octets DD 0   ;nombre d'octets pour cette image
 magic         DW 0   ;j'aime bien aussi la magie (=F1FA ???)
 nombre_chunks DW 0   ;nombre de "chunk" pour cette image
 extension_img DB 8 DUP (0) ;pour extensions futures
ENDS

;structure d'un "chunk"

EN_TETE_CHUNK STRUC
 nombre_octets DD 0 ;nombre d'octet pour ce "chunk"
 chunk_type    DW 0 ;type de chunk
ENDS

;type de "chunk" possible

FLI_COLOR=11    ; table de couleur RVB 18 bit (compress) 
FLI_LC=12       ; lignes comprsse
FLI_BLACK=13    ; ecran noir
FLI_BRUN=15     ; image comprss run lenght encoding (RLE)
FLI_COPY=16     ; image brut, non comprss
FLI_DELTA=7     ; lignes comprss (un peu diffrent de FLI_LC)
FLI_256_COLOR=4 ; FLI_COLOR mais avec des couleur cod sur 24 bit 
FLI_MINI=18     ; mme image que la premiere mais en 64 * 32 

.CODE

;******************************************************
; description: dcode une image d'une animation fli ou flc
; entre: SP+2=hauteur image
;         SP+4=largeur image
;         SP+6=ofs 32 ou dcod l'image
;         SP+10=ofs 32 image   dcod
; sortie: l'image est dcod
;******************************************************

hauteur_image=[BP+4]
largeur_image=[BP+6]
ofs32imaged=[BP+8]
ofs32image=[BP+12]

DECODE_IMAGE_FLI PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH ESI EDI ECX EBX EDX ES DS

 XOR AX,AX
 MOV DS,AX
 MOV ES,AX

 MOV ESI,ofs32image
 MOV EDI,ofs32imaged

 ;vrifie si il s'agit vraiment d'une image

 CMP WORD PTR [ESI+magic],0F1FAH
 JE SHORT @D_I_F0
  JMP @D_I_F1
 @D_I_F0:

 ;commence  dcod l'image

 MOV CX,[ESI+nombre_chunks]   ;CX= nombre de chunk dans l'image
 ADD ESI,16                   ;ESI pointe sur le premier chunk

 @D_I_F2:
  PUSH CX
  PUSH ESI

  CMP [ESI+chunk_type],FLI_COLOR   ;si il s'agit d'un chunk color le dcode
  JNE SHORT @D_I_F3
   CALL DECODE_CHUNK_COLOR
   JMP SHORT @D_I_F10
  @D_I_F3:

  CMP [ESI+chunk_type],FLI_LC     ;si il s'agit d'un chunk LC le dcode                         
  JNE SHORT @D_I_F4
   PUSH WORD PTR largeur_image
   CALL DECODE_CHUNK_LC
   JMP SHORT @D_I_F10
  @D_I_F4:

  CMP [ESI+chunk_type],FLI_BLACK  ;si il s'agit d'un chunk BLACK le dcode                         
  JNE SHORT @D_I_F5
   PUSH WORD PTR largeur_image
   PUSH WORD PTR hauteur_image
   CALL DECODE_CHUNK_BLACK
   JMP SHORT @D_I_F10
  @D_I_F5:

  CMP [ESI+chunk_type],FLI_BRUN  ;si il s'agit d'un chunk BRUN le dcode
  JNE SHORT @D_I_F6
   PUSH WORD PTR largeur_image
   PUSH WORD PTR hauteur_image
   CALL DECODE_CHUNK_BRUN
   JMP SHORT @D_I_F10
  @D_I_F6:

  CMP [ESI+chunk_type],FLI_COPY  ;si il s'agit d'un chunk COPY le dcode
  JNE SHORT @D_I_F7
   PUSH WORD PTR largeur_image
   PUSH WORD PTR hauteur_image
   CALL DECODE_CHUNK_COPY
   JMP SHORT @D_I_F10
  @D_I_F7:

  @D_I_F10:
  POP ESI
  ADD ESI,[ESI]               ;Passe au chunk suivant
  POP CX
 LOOP @D_I_F2



 @D_I_F1:

 POP DS ES EDX EBX ECX EDI ESI
 POP BP
RETN 12
ENDP

;**************************************************
; description: dcode un chunk color
; entre: DS:[ESI] pointe sur l'header du chunk color
;         ES:[EDI]=pointeur courant de l'image
; sortie: chunk dcod
;**************************************************

DECODE_CHUNK_COLOR PROC NEAR
 

 ADD ESI,size EN_TETE_CHUNK     ;ESI pointe sur le dpart du chunk

 MOV CX,[ESI]                   ;CX=nombre de packet dans le chunk
 ADD ESI,2
 MOV BL,0                       ;couleur courante
 

 @D_C_C0:
  PUSH CX                       ;ESI pointe su le packet  dcoder

  ADD BL,[ESI]                  ;BL+skip count
  INC ESI
  MOV DX,3C8H                   ;
  MOV AL,BL                     ;couleur de dpart  changer
  OUT DX,AL                     ;
  INC DX                        ;

  MOV CL,[ESI]                  ;
  ADD BL,CL                     ;
  INC ESI                       ;
  AND CX,0FFH                   ; CX=nombre de couleur  changer
  CMP CX,0                      ;
  JNE SHORT @D_C_C1             ;
   MOV CX,256                   ; SI 0 alors 256 couleurs  changer
  @D_C_C1:                      ;

   MOV AL,[ESI]                 ; Fixe le rouge
   OUT DX,AL                    ;
                                
   MOV AL,[ESI+1]               ; Fixe le vert
   OUT DX,AL                    ;

   MOV AL,[ESI+2]               ; Fixe le bleu
   OUT DX,AL                    ;

   ADD ESI,3                    ;passe  la couleur (attribut) suivante.
  LOOP @D_C_C1

  POP CX
 LOOP @D_C_C0



RETN
ENDP

;**************************************************
; description: dcode un chunk LC
; entre: DS:[ESI] pointe sur l'header du chunk LC
;         ES:[EDI]=pointeur courant de l'image
;         [SP+2]=largeur_image
; sortie: chunk dcod
;**************************************************

largeur_image=[BP+4]

DECODE_CHUNK_LC PROC NEAR
 PUSH BP
 MOV BP,SP

 ADD ESI,size EN_TETE_CHUNK     ;ESI pointe sur le dpart du chunk


 MOV AX,[ESI]                   ;AX=nombre de ligne inchanger
 MOV BX,largeur_image
 AND EAX,0FFFFH
 AND EBX,0FFFFH
 MUL EBX                        ;EDI pointe sur la premiere ligne  changer
 ADD EDI,EAX

 MOV CX,[ESI+2]                 ;CX=nombre de lignes qui change
 ADD ESI,4
 XOR BX,BX

 @D_C_L0:                       ;[ESI] pointe sur la ligne courante
 PUSH CX
 PUSH EDI

 MOV CL,[ESI]                   ; nombre de packet dans la ligne
 AND CX,0FFH
 INC ESI
 CMP CX,BX                      ; si aucun la ligne est inchanger
 JE @D_C_L1                     ;                               
 @D_C_L3:                       ;[ESI] pointe sur le packet courant
  PUSH CX

   MOV AL,[ESI]                 ;
   INC ESI                      ;
   AND EAX,0FFH                 ; traite skip count
   ADD EDI,EAX                  ;

   MOV CL,[ESI]                 ; traite size count
   INC ESI                      ;
   CMP CL,BL                    ; si positif plusieur octets  copier
   JL @D_C_L2                   ; si non 1 seul  rpter
    AND CX,0FFH
    @D_C_L4:
     MOV AL,[ESI]
     MOV [EDI],AL
     INC ESI
     INC EDI
    LOOP @D_C_L4
   JMP @D_C_L5

   @D_C_L2:
    NEG CL
    AND CX,0FFH
    MOV AL,[ESI]
    INC ESI
    @D_C_L6:
     MOV [EDI],AL
     INC EDI
    LOOP @D_C_L6
   @D_C_L5:

  POP CX
 LOOP @D_C_L3                     ;passe au packet suivant

 @D_C_L1:
 POP EDI
 MOV AX,largeur_image
 AND EAX,0FFFFH
 ADD EDI,EAX
 POP CX
 LOOP @D_C_L0                     ;passe  la ligne suivante


 POP BP
RETN 2
ENDP


;**************************************************
; description: dcode un chunk BLACK
; entre: DS:[ESI] pointe sur l'header du chunk BLACK
;         ES:[EDI]=pointeur su l'image
;         [SP+4]=largeur_image
;         [SP+2]=hauteur_image
; sortie: chunk dcod
;**************************************************

largeur_image=[BP+6]
hauteur_image=[BP+4]

DECODE_CHUNK_BLACK PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH EDI

 MOV AX,largeur_image
 AND EAX,0FFFFH
 MOV BX,hauteur_image
 AND EBX,0FFFFH
 MUL EBX

 MOV ECX,EAX
 SHR ECX,2
 XOR EAX,EAX

 @D_C_B0:
  MOV [EDI],EAX
  ADD EDI,4
 LOOPD @D_C_B0

 POP EDI
 POP BP
RETN 4
ENDP


;**************************************************
; description: dcode un chunk BRUN
; entre: DS:[ESI] pointe sur l'header du chunk BRUN
;         ES:[EDI]=pointeur sur l'image
;         [SP+2]=hauteur_image
;         [SP+4]=largeur_image
; sortie: chunk dcod
;**************************************************

hauteur_image=[BP+4]
largeur_image=[BP+6]

DECODE_CHUNK_BRUN PROC NEAR
 PUSH BP
 MOV BP,SP

 ADD ESI,size EN_TETE_CHUNK     ;ESI pointe sur le dpart du chunk

 MOV BX,largeur_image
 AND EBX,0FFFFH
 XOR DX,DX

 MOV CX,hauteur_image
 @D_C_B01:                      ;ESI pointe sur la ligne courante
 PUSH CX
 PUSH EDI
  MOV CL,[ESI]                  ;CX=nombre de packet
  AND CX,0FFH
  INC ESI

  @D_C_B02:                     ;ESI pointe sur le packet courant
  PUSH CX

  MOV CL,[ESI]                  ;si size count positif  1 octet rpeter
  INC ESI                       ;
  CMP CL,DL                     ;sinon plusieurs octets  copier
  JL @D_C_B03
   AND CX,0FFH
   MOV AL,[ESI]
   INC ESI
   @D_C_B06:
    MOV [EDI],AL
    INC EDI
   LOOP @D_C_B06
  JMP SHORT @D_C_B04

  @D_C_B03:
   NEG CL
   AND CX,0FFH
   @D_C_B05:
    MOV AL,[ESI]
    MOV [EDI],AL
    INC EDI
    INC ESI
   LOOP @D_C_B05
  @D_C_B04:

  POP CX
  LOOP @D_C_B02

 POP EDI
 ADD EDI,EBX
 POP CX
 LOOP @D_C_B01


 POP BP
RETN 4
ENDP

;**************************************************
; description: dcode un chunk COPY
; entre: DS:[ESI] pointe sur l'header du chunk COPY
;         ES:[EDI]=pointeur su l'image
;         [SP+2]=hauteur_image
;         [SP+4]=largeur_image
; sortie: chunk dcod
;**************************************************

largeur_image=[BP+6]
hauteur_image=[BP+4]

DECODE_CHUNK_COPY PROC NEAR
 PUSH BP
 MOV BP,SP
 
 ADD ESI,size EN_TETE_CHUNK     ;ESI pointe sur le dpart du chunk

 MOV AX,largeur_image
 AND EAX,0FFFFH
 MOV BX,hauteur_image
 AND EBX,0FFFFH
 MUL EBX

 MOV ECX,EAX
 SHR ECX,2

 @D_C_C00:
  MOV EAX,[ESI]
  MOV [EDI],EAX
  ADD EDI,4
  ADD ESI,4
 LOOPD @D_C_C00


 POP BP
RETN 4
ENDP
