TITLE fonction pour la manipulation d'images


CHARGE_IMAGE_PCX MACRO nomfichier,ofs32
 LOCAL nomf
 .DATA                                ; Charge une image PCX
  nomf DB nomfichier,0                ;  Entre: nom de l'image,ofs32,largeur de la fenetre 
 .CODE                                ;  Sortie: l'image est charg
  SUB SP,16
  PUSH OFFSET nomf
  PUSH DWORD PTR ofs32                          
  CALL SR_CHARGE_IMAGE_PCX
ENDM

CHARGE_PALETTE_PCX MACRO nomfichier,ofs32
 LOCAL nomf
 .DATA                                ;
   nomf DB nomfichier,0               ; Charge la palette d'une image PCX
 .CODE                                ;  Entre: nom du fichier,offset mmoire
   SUB SP,770                         ;  NB: la palette 8 bit est convertit
   PUSH OFFSET nomf                   ;      en palette 6 bit.
   PUSH DWORD PTR ofs32
   CALL SR_CHARGE_PALETTE_PCX
ENDM

ACTIVE_PALETTE MACRO ofs32,depart,nb_coul
  PUSH DWORD PTR ofs32                ; Active une palette en mmoire
  PUSH WORD PTR depart                ;  Entre: ofs32,couleur dpart,
  PUSH WORD PTR nb_coul               ;          nb de couleur  charg
  CALL SR_ACTIVE_PALETTE
ENDM

 
.CODE

 ofs32=[BP+4]
 nomf=[BP+8]
 handle_fic=[BP+10]
 XMIN=[BP+12]
 YMIN=[BP+14]
 XMAX=[BP+16]
 YMAX=[BP+18]
 EDIfin=[BP+20]
 CH1=[BP+24]
 CH2=[BP+25]


 SR_CHARGE_IMAGE_PCX PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH ES
  PUSH EDI
  PUSH EDX
  PUSH EBX

  PUSH WORD PTR nomf
  PUSH WORD PTR 0
  CALL SR_OUVRE_FICHIER
  MOV handle_fic,AX

  PUSH WORD PTR handle_fic
  PUSH DWORD PTR 4
  PUSH WORD PTR 0
  CALL SR_DEPLACE_POINTEUR_FICHIER

  MOV AX,SS
  AND EAX,0FFFFH
  SHL EAX,4
  AND EBP,0FFFFH
  ADD EAX,EBP
  ADD EAX,12

  PUSH WORD PTR handle_fic ; Lit les dimension de l'image
  PUSH WORD PTR 8          ;
  PUSH EAX
  CALL SR_LIT_FICHIER

  MOV AX,Xmax             ;
  SUB AX,Xmin             ; Calcul l'offset max de l'image
  MOV BX,Ymax             ;  pour svoir quand arrter le dcodage
  SUB BX,Ymin             ;  de l'image.
  AND EBX,0FFFFH          ;
  AND EAX,0FFFFH          ;
  INC EBX                 ;
  INC EAX                 ;
  MUL EBX                 ;
  ADD EAX,ofs32           ;
  MOV EDIfin,EAX          ;


  PUSH WORD PTR handle_fic
  PUSH DWORD PTR 128
  PUSH WORD PTR 0
  CALL SR_DEPLACE_POINTEUR_FICHIER

  MOV DX,SS
  AND EDX,0FFFFH
  SHL EDX,4
  AND EBP,0FFFFH
  ADD EDX,EBP
  ADD EDX,24

  PUSH WORD PTR handle_fic 
  PUSH WORD PTR 2          
  PUSH EDX
  CALL SR_LIT_FICHIER

  XOR ECX,ECX
  MOV EDI,ofs32
  XOR AX,AX
  MOV ES,AX


  @S_C_I_P0:
   CMP BYTE PTR CH1,192
   JBE SHORT @S_C_I_P1
    MOV CL,CH1
    SUB CL,192
    MOV AL,CH2
   @S_C_I_P2:
    MOV ES:[EDI],AL
    INC EDI
   LOOP @S_C_I_P2
    CMP EDI,EDIfin
    JAE SHORT @S_C_I_P3
     PUSH WORD PTR handle_fic 
     PUSH WORD PTR 2          
     PUSH EDX
     CALL SR_LIT_FICHIER
   JMP SHORT @S_C_I_P0
    @S_C_I_P1:
     MOV AL,CH1
     MOV ES:[EDI],AL
     INC EDI
     MOV AL,CH2
     MOV CH1,AL
     CMP EDI,EDIfin
     JAE SHORT @S_C_I_P3
      INC EDX
      PUSH WORD PTR handle_fic
      PUSH WORD PTR 1          
      PUSH EDX
      CALL SR_LIT_FICHIER
      DEC EDX
     JMP SHORT @S_C_I_P0
   @S_C_I_P3:


  PUSH WORD PTR handle_fic
  CALL SR_FERME_FICHIER

  POP EBX
  POP EDX
  POP EDI
  POP ES
  POP BP
  RETN 22
 ENDP

 ofs32=[BP+4]
 nomf=[BP+8]
 handle=[BP+10]
 buffer=[BP+12]            ;buffer de 768 octet

 SR_CHARGE_PALETTE_PCX PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DS
  PUSH ES
  PUSH EDI
  PUSH ESI
  PUSH ECX


  PUSH WORD PTR nomf             ;
  PUSH WORD PTR 0                ; Lit la taille du fichier
  CALL SR_PREND_DTA_INFO         ;  TAILLE_FICHIER=taille du fichier
  SUB DWORD PTR TAILLE_FICHIER,768  ;  et calcul la position de la palette
                                 ;  dans le fichier

  PUSH WORD PTR nomf             ;
  PUSH WORD PTR 0                ; ouvre le fichier
  CALL SR_OUVRE_FICHIER          ;
  MOV handle,AX

  PUSH WORD PTR handle           ;
  PUSH DWORD PTR TAILLE_FICHIER  ; dplace le pointeur au dbut de la palette dans le fichier
  PUSH WORD PTR 0                ;
  CALL SR_DEPLACE_POINTEUR_FICHIER  ;
  
  MOV AX,SS                      ;
  AND EAX,0FFFFH                 ; EAX=ofs32 du buffer pour la palette
  SHL EAX,4                      ;
  AND EBP,0FFFFH                 ;
  ADD EAX,EBP                    ;
  ADD EAX,12                     ;
  MOV ESI,EAX

  PUSH WORD PTR handle           ;
  PUSH WORD PTR 768              ; Lit la palette dans le buffer
  PUSH EAX                       ;
  CALL SR_LIT_FICHIER            ;


  XOR AX,AX                      ;
  MOV ES,AX                      ; Convertit la palette 8 bit
  MOV DS,AX                      ;  en palette 6 bit et la copy
  MOV EDI,ofs32                  ;  du buffer  l'offset ou elle doit etre charge
  MOV ECX,768                    ;
                                 ;
  @S_C_P_P0:                     ;
   MOV AL,[ESI]                  ;
   SHR AL,2                      ;
   MOV [EDI],AL                  ;
   INC ESI                       ;
   INC EDI                       ;
  LOOPD @S_C_P_P0                ;


  PUSH WORD PTR handle           ; ferme le fichier
  CALL SR_FERME_FICHIER          ;

  POP ECX
  POP ESI
  POP EDI
  POP ES
  POP DS
  POP BP
  RETN 776
 ENDP

 nombre_de_couleur=[BP+4]
 couleur_depart=[BP+6]
 ofs32=[BP+8]

 SR_ACTIVE_PALETTE PROC NEAR
  PUSH BP
  MOV BP,SP
  PUSH DX
  PUSH CX
  PUSH ESI
  PUSH DS

  XOR AX,AX
  MOV DS,AX
  MOV ESI,ofs32
  MOV AL,couleur_depart        ;
  AND EAX,0FFH                 ; ESI pointe sur la couleur de dpart dans
  ADD ESI,EAX                  ;  le tableaux de palette.
  ADD ESI,EAX                  ;
  ADD ESI,EAX                  ;

  MOV DX,3C8H                  ; indexe la premiere couleur  charg
  MOV AL,couleur_depart        ;  dans le registre d'indexe du DAC
  OUT DX,AL                    ;
  INC DX                       ;

  MOV CX,nombre_de_couleur     ;CX=3*nombre de couleur
  ADD CX,CX                    ; +rapide que de multiplier
  ADD CX,nombre_de_couleur     ;

  @S_A_P0:                     ;
   MOV AL,[ESI]                ; Charge la palette
   OUT DX,AL                   ;
   INC ESI                     ;
  LOOP @S_A_P0                 ;

  POP DS
  POP ESI
  POP CX
  POP DX
  POP BP
  RETN 8
 ENDP



;****************************************************
;Fonction quie effectue un filtrage anti-pixlisation
; sur une image 8bit/pixel mono
;****************************************************

 ofs32=[BP+12]     ;offset image
 largeur=[BP+8]    ;largeur de l'image
 hauteur=[BP+4]    ;hauteur image

SR_FILTRE_BILINEAIRE_IMAGE_MONO PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH ECX
 PUSH DS
 PUSH EDI
 PUSH ESI

 XOR AX,AX
 MOV DS,AX

 MOV EDI,ofs32
 MOV ECX,hauteur
 SHR ECX,1
 @SR_F_B_I_M0:              ;Effectue le filtrage horizontale
  PUSH ECX
  PUSH EDI

  XOR AX,AX
  XOR DX,DX

  MOV ECX,largeur           
  SHR ECX,1
  @SR_F_B_I_M1:
   MOV AL,[EDI]
   MOV DL,[EDI+2]
   ADD AX,DX
   SHR AX,1
   MOV [EDI+1],AL
   ADD EDI,2
  LOOPD @SR_F_B_I_M1

  POP EDI
  MOV EAX,largeur
  SHL EAX,1
  ADD EDI,EAX
  POP ECX
 LOOPD @SR_F_B_I_M0


 MOV EDI,ofs32
 MOV EBX,largeur
 MOV ECX,hauteur
 SHR ECX,1
 @SR_F_B_I_M2:              ;Effectue le filtrage verticale
  PUSH ECX
  PUSH EDI

  XOR AX,AX
  XOR DX,DX

  MOV ECX,largeur           
  @SR_F_B_I_M3:
   MOV AL,[EDI]
   ADD EDI,EBX
   MOV DL,[EDI+EBX]
   SUB EDI,EBX
   ADD AX,DX
   SHR AX,1
   MOV [EDI+EBX],AL
   INC EDI
  LOOPD @SR_F_B_I_M3

  POP EDI
  MOV EAX,largeur
  SHL EAX,1
  ADD EDI,EAX
  POP ECX
 LOOPD @SR_F_B_I_M2

 POP ESI
 POP EDI
 POP DS
 POP ECX
 POP BP
 RETN 12
ENDP


;***************************************************************
;zoom 2x d'une image 16bit/pixel avec filtrage anti-pixlisation
;***************************************************************

 ofs32imaged=[BP+16]
 ofs32imagea=[BP+12]
 largeur=[BP+8]          ; concerne l'image de dpart
 hauteur=[BP+4]          ; l'image d'arriv  des dimensions double.

SR_ZOOM2_image16 PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH EDI
 PUSH ESI
 PUSH ECX

 XOR AX,AX
 MOV DS,AX
 MOV ESI,ofs32imaged
 MOV EDI,ofs32imagea

  MOV ECX,hauteur
  @SR_Z_I0:           ;Traite les lignes paires
  PUSH ECX

  XOR EBX,EBX
  MOV EDX,2
  MOV ECX,largeur
  DEC ECX
  MOV AX,[ESI]        ;Dessine le premier pixel de la ligne
  SHR AX,1
  AND AX,0111101111101111b
  MOV [EDI],AX        ;
  ADD ESI,EDX         ;
  ADD EDI,EDX         ;
  @SR_Z_I1:
   MOV BX,[ESI]
   MOV [EDI+2],BX
   SHR BX,1
   SHR AX,1
   AND AX,0111101111101111b
   AND BX,0111101111101111b
   ADD AX,BX
   MOV [EDI],AX
   MOV AX,[ESI]
   ADD EDI,4
   ADD ESI,2
  LOOPD @SR_Z_I1
   MOV [EDI],BX   ;Dessine le dernier pixel
   ADD EDI,EDX
   MOV EAX,largeur
   SHL EAX,2
   ADD EDI,EAX    ;Saute une ligne
  POP ECX
  LOOPD @SR_Z_I0

  MOV EDI,ofs32imagea
  MOV ESI,EDI
  MOV EBX,largeur
  SHL EBX,2
  ADD EDI,EBX
  MOV ECX,hauteur
  @SR_Z_I2:           ;Traite les lignes impaires
  PUSH ECX
   MOV ECX,largeur
   @SR_Z_I3:
    MOV EAX,[ESI]
    SHR EAX,1
    AND EAX,01111011111011110111101111101111b
    MOV EDX,[EDI+EBX]
    SHR EDX,1
    AND EDX,01111011111011110111101111101111b
    ADD EAX,EDX
    MOV [EDI],EAX
    ADD ESI,4
    ADD EDI,4
   LOOPD @SR_Z_I3
   ADD ESI,EBX
   ADD EDI,EBX
  POP ECX
  LOOPD @SR_Z_I2

 POP ECX
 POP ESI
 POP EDI
 POP DS
 POP BP
 RETN 16
ENDP

;***************************************
;Convertit une image 8bit en image 16bit
;***************************************

 TEMP_buffer=256*2;buffer temporaire pour stock la palette pour l'image 16bit
 taille_image=[BP+4+TEMP_buffer]     ;taille image en pixel
 ofs32p=[BP+8+TEMP_buffer]           ;offset palette image 8bit
 ofs3216=[BP+12+TEMP_buffer]         ;offset image 16 bit
 ofs328=[BP+16+TEMP_buffer]          ;offset image 8 bit


SR_CONVERT_image8_image16 PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH EDI
 PUSH ESI
 PUSH ECX
 PUSH EBX
 PUSH EDX

 XOR AX,AX
 MOV DS,AX


 ;Commence par crer la palette de l'image 16bit

 MOV DI,2
 MOV ESI,ofs32p
 MOV CX,256
 @SR_C_I8_I160:
  MOV AL,[ESI]              ;Al=composante rouge de la couleur
  SHR AL,1                  ;rduit la composante rouge  5bit
  MOV BL,AL
  SHL BX,11

  MOV AL,[ESI+1]            ;AL=composante verte
  SHL AX,5
  AND AX,00000111111100000b
  OR BX,AX

  MOV AL,[ESI+2]            ;AL=composante bleu
  SHR AX,1                  ;rduit  5bit
  AND AX,11111b
  OR BX,AX

  MOV [BP+DI],BX
  ADD DI,2
  ADD ESI,3
 LOOP @SR_C_I8_I160

;Crait l'image 16bit

 MOV ECX,taille_image
 MOV ESI,ofs328           ;
 MOV EDI,ofs3216          ;
 @SR_C_I8_I161:
  MOV BL,[ESI]            ; BL=numro de couleur 8 bit
  AND BX,0FFH             ;
  INC BX                  ;
  SHL BX,1                ;
  ADD BX,BP               ;
  MOV AX,SS:[BX]          ; AX=couleur correspondante 16 bit
  MOV [EDI],AX            ; Ecrit la couleur
  ADD EDI,2               ;
  INC ESI                 ; Passe au pixel suivant
 LOOPD @SR_C_I8_I161      ;

 POP EDX
 POP EBX
 POP ECX
 POP ESI
 POP EDI
 POP DS
 POP BP
 ADD SP,TEMP_buffer
 RETN 16
ENDP


