TITLE fonction de gestion de la mmoire
                            
                              ; ͻ
ALLOUE_MEM_BASSE MACRO taille ; Alloue un block de mmoire conventionelle    
 PUSH TAILLE                  ;  Entre: taille en paragraphe du block allou
 CALL SR_ALLOUE_MEM_BASSE     ;  Sortie: EAX offset 32bit de la zone allou  
ENDM                          ;                                              
                              ; ͼ
                               
                             ;ͻ
LIBERE_MEM_BASSE MACRO ofs32 ; Libre un zone de mmoire conventionelle
 PUSH DWORD PTR ofs32        ;  Entre: offset 32bit de la zone        
 CALL SR_LIBERE_MEM_BASSE    ;  Sortie: nant                          
ENDM                         ;                                         
                             ;ͼ



CALCUL_MEM_BASSE_LIBRE MACRO
 PUSH BX
 MOV AH,48H                       ;Calcul la taille de la mmoire basse libre
 MOV BX,0FFFFH                    ; Entre: aucune
 INT 21H                          ; Sortie: AX=taille en paragraphe de la mmoire basse disponible
 MOV AX,BX
 POP BX
ENDM

DEPLACE_BLOCK_MEMOIRE MACRO ofs32d,ofs32a,size
 PUSH DWORD PTR ofs32d ;   
 PUSH DWORD PTR ofs32a ;         Dplace un block de mmoire de la taille indiqu
 PUSH DWORD PTR size   ;          Entre: ofs32 dpart,ofs32 arriv,nombre d'octets
 CALL SR_DEPLACE_BLOCK_MEMOIRE
ENDM

DEPLACE_FENETRE_MEMOIRE MACRO ofs32d,ofs32a,XD,YD,XA,YA,largeurf,hauteurf,largeurfd,largeurfa
 SUB SP,8                      ;   
 PUSH DWORD PTR ofs32d         ;
 PUSH DWORD PTR ofs32a         ;     
 PUSH DWORD PTR XD             ;
 PUSH DWORD PTR YD             ;       
 PUSH DWORD PTR XA             ;
 PUSH DWORD PTR YA             ;       Dplace une fentre memoire d'une
 PUSH DWORD PTR largeurf       ;        page virtuelle  une autre.
 PUSH DWORD PTR hauteurf       ;       Entre: ofs32 page dpart ,ofs32 page arrive, 
 PUSH DWORD PTR largeurfd      ;               position X dpart ,position Y dpart,position x arrive,position y arrive
 PUSH DWORD PTR largeurfa      ;               largeur fentre ,hauteur fentre,
 CALL SR_DEPLACE_FENETRE_MEMOIRE;              largeur page dpart,largeur page arrive. 
ENDM                           



.CODE

 SR_ALLOUE_MEM_BASSE PROC NEAR 
  PUSH BP
  MOV BP,SP
  PUSH BX
  MOV BX,[BP+4]
  MOV AH,48H
  INT 21H
  AND EAX,0FFFFH
  SHL EAX,4
  POP BX
  POP BP
 RETN 2
 ENDP


 SR_LIBERE_MEM_BASSE PROC NEAR
  PUSH BP
  MOV BP,SP
  MOV EAX,[BP+4]
  SHR EAX,4
  PUSH ES
   MOV ES,AX
   MOV AH,49H
   INT 21H
  POP ES
  POP BP
 RETN 4
 ENDP



SR_DEPLACE_BLOCK_MEMOIRE PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH ES
 PUSH DS
 PUSH ECX
 PUSH ESI
 PUSH EDI

  XOR AX,AX
  MOV ES,AX
  MOV DS,AX
  MOV ECX,[BP+4]
  MOV EDI,[BP+8]
  MOV ESI,[BP+12]
  SHR ECX,2
  CMP ECX,0
  JE SHORT @SR_D_B_M4

  MOV EBX,4

  @SR_D_B_M1:
   MOV EAX,[ESI]
   MOV [EDI],EAX
   ADD EDI,EBX
   ADD ESI,EBX
  LOOPD @SR_D_B_M1


 @SR_D_B_M4:
  MOV ECX,[BP+4]
  AND ECX,11b
  CMP ECX,0
  JE SHORT @SR_D_B_M3

  @SR_D_B_M2:
   MOV AL,[ESI]
   MOV [EDI],AL
   INC ESI
   INC EDI
  LOOPD @SR_D_B_M2

  @SR_D_B_M3:

 POP EDI
 POP ESI
 POP ECX
 POP DS
 POP ES
 POP BP
 RETN 12
ENDP








LARGEURfa =[BP+4]
LARGEURfd =[BP+8]
HAUTEURf  =[BP+12]
LARGEURf  =[BP+16]
YA        =[BP+20]
XA        =[BP+24]
YD        =[BP+28]
XD        =[BP+32]
OFS32a    =[BP+36]
OFS32d    =[BP+40]

INCESI    =[BP+44]
INCEDI    =[BP+48]

SR_DEPLACE_FENETRE_MEMOIRE PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH ECX
 PUSH EDI
 PUSH ESI
 PUSH EBX
 PUSH ES
 PUSH DS

 XOR AX,AX
 MOV ES,AX
 MOV DS,AX

 ;Calcul "ESI" = ofs32d+Xd+Yd*largeurfd

 MOV EAX,YD
 MUL DWORD PTR largeurfd
 ADD EAX,XD
 ADD EAX,ofs32d
 MOV ESI,EAX

 ;Calcul "EDI" = ofs32a+Xa+Ya*largeurfa

 MOV EAX,YA
 MUL DWORD PTR largeurfa
 ADD EAX,XA
 ADD EAX,ofs32a
 MOV EDI,EAX
 

 ;Copy la fentre mmoire en mode byte

 MOV EBX,largeurf
 AND EBX,11b
 CMP EBX,0
 JE SHORT @SR_M_F_M2

 ADD EDI,EBX
 ADD ESI,EBX
 PUSH EDI
 PUSH ESI
 SUB EDI,EBX
 SUB ESI,EBX

 ;Calcul "INCESI" =largeurfd-largeurf

 MOV EAX,largeurfd
 SUB EAX,EBX
 MOV INCESI,EAX

 ;Calcul "INCEDI" =largeurfa-largeurf

 MOV EAX,largeurfa
 SUB EAX,EBX
 MOV INCEDI,EAX


  MOV ECX,hauteurf
  @SR_M_F_M3:
   PUSH ECX

   MOV ECX,EBX
   @SR_M_F_M4:
    MOV AL,[ESI]
    MOV [EDI],AL
    INC EDI
    INC ESI
   LOOPD @SR_M_F_M4

   ADD ESI,INCESI
   ADD EDI,INCEDI

   POP ECX
  LOOPD @SR_M_F_M3

 POP ESI
 POP EDI

 @SR_M_F_M2:
 MOV ECX,hauteurf
 MOV EBX,largeurf
 AND EBX,0FFFFFFFCH
 MOV EDX,4

 ;Calcul "INCESI" =largeurfd-largeurf

 MOV EAX,largeurfd
 SUB EAX,EBX
 MOV INCESI,EAX

 ;Calcul "INCEDI" =largeurfa-largeurf

 MOV EAX,largeurfa
 SUB EAX,EBX
 MOV INCEDI,EAX

 ;Copy la fentre mmoire en mode double word

 SHR EBX,2

 @SR_M_F_M0:
  PUSH ECX 

  MOV ECX,EBX
  @SR_M_F_M1:
   MOV EAX,[ESI]
   MOV [EDI],EAX
   ADD EDI,EDX
   ADD ESI,EDX
  LOOP @SR_M_F_M1

  ADD ESI,INCESI
  ADD EDI,INCEDI
  POP ECX
 LOOPD @SR_M_F_M0



 POP DS
 POP ES
 POP EBX
 POP ESI
 POP EDI
 POP ECX
 POP BP
 RETN 48
ENDP
