TITLE fonctions vesa 1.2



; Variable necessaire pour stocker les informations retourn par le driver vesa

.DATA

SIGNATURE_VESA      DB 4 DUP(?)             ;normalement="VESA"
VERSION_VESA        DW ?                    ;version du driver
OEM_POINTEUR        DD ?                    ;pointeur sur une chaine identifiant la carte graphique
CAPABILITIES        DD ?                    ;permet de savoire si le DAC peut etre etendu  8 bit
VIDEO_MODE_POINTEUR DD ?                    ;pointeur sur les modes video supports
TOTALE_MEMOIRE      DW ?                    ;nombre totale de block de 64k de memoire video
RESERVE_VESA        DB 236 DUP (?)          ;reserv pour extension futur

;variable qui stock les informations d'un mode video

MODE_INFO STRUC
        ModeAttributes      dw  ?  ; mode attributes
        WinAAttributes      db  ?  ; window A attributes
        WinBAttributes      db  ?  ; window B attributes
        WinGranularity      dw  ?  ; window granularity
        WinSize             dw  ?  ; window size
        WinASegment         dw  ?  ; window A start segment
        WinBSegment         dw  ?  ; window B start segment
        WinFuncPtr          dd  ?  ; pointer to windor function
        BytesPerScanLine    dw  ?  ; bytes per scan line


        XResolution         dw  ?  ; horizontal resolution
        YResolution         dw  ?  ; vertical resolution
        XCharSize           db  ?  ; character cell width
        YCharSize           db  ?  ; character cell height
        NumberOfPlanes      db  ?  ; number of memory planes
        BitsPerPixel        db  ?  ; bits per pixel
        NumberOfBanks       db  ?  ; number of banks
        MemoryModel         db  ?  ; memory model type
        BankSize            db  ?  ; bank size in kb
        NumberOfImagePages  db  ?  ; number of images
        Reserved_page       db  1  ; reserved for page function

        RedMaskSize         db  ?  ; size of direct color red mask in bits
        RedFieldPosition    db  ?  ; bit position of LSB of red mask
        GreenMaskSize       db  ?  ; size of direct color green mask in bits
        GreenFieldPosition  db  ?  ; bit position of LSB of green mask
        BlueMaskSize        db  ?  ; size of direct color blue mask in bits
        BlueFieldPosition   db  ?  ; bit position of LSB of blue mask
        RsvdMaskSize        db  ?  ; size of direct color reserved mask in bits
        DirectColorModeInfo db  ?  ; Direct Color mode attributes
        Reserved_futur      db  216 dup(?)      ; remainder of ModeInfoBlock
ENDS


.CODE

;Retourne les informations sur les possibilites SVGA
SR_RETURN_SVGA_INFO PROC NEAR
 PUSH ES
 PUSH DI

 
 MOV AX,4F00H
 MOV DI,SEG SIGNATURE_VESA
 MOV ES,DI
 MOV DI,OFFSET SIGNATURE_VESA
 INT 10H

 POP DI
 POP ES
RETN
ENDP

;retourne des informations sur le mode video specifi

ofsbuffer=[BP+4]
segbuffer=[BP+6]
mode=[BP+8]

SR_RETURN_MODE_INFO PROC NEAR
 PUSH BP
 MOV BP,SP 
 PUSH CX
 PUSH ES
 PUSH DI

 MOV AX,4F01H
 MOV DI,segbuffer
 MOV ES,DI
 MOV DI,ofsbuffer
 MOV CX,mode
 INT 10H

 POP DI
 POP ES
 POP CX
 POP BP
RETN 6
ENDP


;Fixe un mode video

mode=[BP+4]
SR_SET_SVGA_MODE PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH BX

 MOV AX,4F02H
 MOV BX,MODE
 INT 10H

 POP BX
 POP BP
RETN 2
ENDP


; renvoie en AX le mode video courant

SR_GET_SVGA_MODE PROC NEAR
 PUSH BX

 MOV AX,4F03H
 INT 10H
 MOV AX,BX

 POP BX
RETN
ENDP

;Fixe la largeur d'une ligne en pixels

long=[BP+4]

SR_SET_LIGNE_LONGUEUR PROC NEAR
 PUSH BP
 MOV BP,SP

 MOV AX,4F06H
 XOR BL,BL
 MOV CX,long                 ; BX=NB byte par ligne
 INT 10H                     ; CX=NB de pixels par ligne
                             ; DX=nombre maximum de ligne
 POP BP
RETN 2
ENDP

;Renvoie la largeur d'une ligne en pixels et en octets ainsi que le NB max de ligne

SR_GET_LIGNE_LONGUEUR PROC NEAR

 MOV AX,4F06H      ; BX=NB byte par ligne
 MOV BL,1          ; CX=NB de pixels par ligne
 INT 10H           ; DX=nombre maximum de ligne

RETN
ENDP


;Selectionne la ligne et la colone ou commence l'affichage

 Y_depart=[BP+4]
 X_depart=[BP+6]
SR_SET_DISPLAY_START PROC NEAR
 PUSH BP 
 MOV BP,SP
 PUSH BX
 PUSH CX
 PUSH DX

 MOV AX,4F07H
 XOR BX,BX
 MOV CX,X_depart
 MOV DX,Y_depart
 INT 10H

 POP DX
 POP CX
 POP BX
 POP BP
RETN 4
ENDP


;renvoie en CX et DX la ligne et la colone ou commence l'affichage

SR_GET_DISPLAY_START PROC NEAR
 PUSH BX

  MOV AX,4F07H
  MOV BL,1
  INT 10H

 POP BX
ENDP

;selectionne le nombre de bit pour coder une couleur (VGA mode13=6bit)

NB_bit=[BP+4]
SR_SET_DAC_LARGEUR PROC NEAR
 PUSH BP
 MOV BP,SP

 MOV AX,4F08H
 MOV BL,0
 MOV BH,NB_bit
 INT 10H
                     ;BH=nombre de bit par couleur
 POP BP
RETN 2
ENDP

;renvoie le nombre de bit pour coder une couleur (VGA mode13=6bit)

SR_GET_DAC_LARGEUR PROC NEAR

 MOV AX,4F08H
 MOV BL,1
 INT 10H
                     ;BH=nombre de bit par couleur
RETN 2
ENDP
