TITLE fonction pour grer les images


;Structure de la DTA pour l'accs au fichier
DTA STRUC
 DTA_reserve      DB 21 DUP(?)
 ATTRIBUT_FICHIER DB 0
 HEURE_FICHIER    DW 0
 DATE_FICHIER     DW 0
 TAILLE_FICHIER   DD 0
 NOM_FICHIER      DB 13 DUP (0)
ENDS

;Structure de l'en-tte PCX
PCX_HEADER STRUC
;Nom         Taille  Description
Manufacturer DB 0   ;Constant Flag, 10 = ZSoft .pcx 
Version      DB 0   ;Version information 
                    ; 0 = Version 2.5 of PC Paintbrush 
                    ; 2 = Version 2.8 w/palette information 
                    ; 3 = Version 2.8 w/o palette information 
                    ; 4 = PC Paintbrush for Windows(Plus for
                    ;     Windows uses Ver 5) 
                    ; 5 = Version 3.0 and > of PC Paintbrush
                    ;     and PC Paintbrush +, includes
                    ;     Publisher's Paintbrush . Includes
                    ;     24-bit .PCX files 
Encoding      DB 0  ; 1 = .PCX run length encoding 
BitsPerPixel  DB 0  ;Number of bits to represent a pixel
                    ; (per Plane) - 1, 2, 4, or 8 
Window        DW 4 DUP (0) ;Image Dimensions: Xmin,Ymin,Xmax,Ymax 
HDpi          DW           ;Horizontal Resolution of image in DPI* 
VDpi          DW           ;Vertical Resolution of image in DPI* 
Colormap      DB 48 DUP(0) ;Color palette setting, see text 
Reserved      DB           ;Should be set to 0. 
NPlanes       DB           ;Number of color planes 
BytesPerLine  DW           ;Number of bytes to allocate for a scanline
                           ; plane.  MUST be an EVEN number.  Do NOT
                           ; calculate from Xmax-Xmin. 
PaletteInfo   DW           ;How to interpret palette- 1 = Color/BW,
                           ; 2 = Grayscale (ignored in PB IV/ IV +) 
HscreenSize   DW           ;Horizontal screen size in pixels. New field
                           ; found only in PB IV/IV Plus 
VscreenSize   DW           ;Vertical screen size in pixels. New field
                           ; found only in PB IV/IV Plus 
Filler       DB 54 DUP(0)  ;Blank to fill out 128 byte header.  Set all
                           ; bytes to 0 
ENDS

;*****************************************************************************
;                     CHARGE une image PCX 24bit
;*****************************************************************************
;  PARAMETRE: Pointeur sur nom du fichier (DWORD)
;           : Pointeur sur structure ecran
;****************************************************************************

;Variables locales
 TEMP_buffer=size(pcx_header)+8
 image_header=[BP+2]
 handle_fic=[BP+2+size(pcx_header)]
 byte1=[BP+4+size(pcx_header)]
 byte2=[BP+5+size(pcx_header)]
 Nbecrit=[BP+6+size(pcx_header)]

;Parametre passer  la fonction
 ofs32_nom_fichier=[BP+8+TEMP_buffer]    
 ofs32_ecran      =[BP+4+TEMP_buffer]    

SR_CHARGE_IMAGE_PCX24 PROC NEAR
 SUB SP,TEMP_BUFFER
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ES

 XOR AX,AX
 MOV ES,AX

 ;Ouvre le fichier
  MOV EAX,ofs32_nom_fichier ;
  MOV DX,AX                 ;DS:DX=seg,ofs nom du fichier
  AND DX,1111b              ;
  SHR EAX,4                 ;
  MOV DS,AX                 ;
  MOV AL,0                  ;Mode d'ouverture=lecture
  MOV AH,3DH                         
  INT 21H                            
  MOV handle_fic,AX

 ;Lit l'en-tete du fichier
  MOV DX,BP
  ADD BP,2
  MOV AX,SS
  MOV DS,AX
  MOV BX,handle_fic
  MOV CX,size(pcx_header)
  MOV AH,3FH
  INT 21H

 ;Fixe EDI sur le buffer de l'ecran et calcul la taille de l'image en 
  MOV EDI,ofs32_ecran
  MOV EDI,ES:[EDI.add32_ecran]


 ;DECODE L'IMAGE
 



  MOV AX,SS                   ;Lit le 1er byte
  MOV DS,AX
  MOV DX,BP
  ADD DX,4+size(pcx_header)
  MOV BX,handle_fic
  MOV CX,NB_bytes
  MOV AH,3FH
  INT 21H

;Boucle  chaque octets       
  @SR_C_I_P240:
  





 ;Calcul la taille de l'image pour allouer la mmoire
  MOV BX,Handle_fic              ; Ferme le fichier
  MOV AH,3EH                      
  INT 21H                         

 POP ES
 POP DS
 POP BP
 ADD SP,TEMP_BUFFER
 RETN 8
ENDP
