TITLE fonctions vesa 1.2
DOSSEG
.MODEL SMALL
.486

PUBLIC SR_RETURN_SVGA_INFO
PUBLIC SR_RETURN_MODE_INFO
PUBLIC SR_SET_SVGA_MODE
PUBLIC SR_GET_SVGA_MODE
PUBLIC SR_SET_LIGNE_LONGUEUR
PUBLIC SR_GET_LIGNE_LONGUEUR
PUBLIC SR_SET_DISPLAY_START
PUBLIC SR_GET_DISPLAY_START
PUBLIC SR_SET_POS_WINDOW
PUBLIC SR_COPY_RAM_RAMVIDEO


.DATA

;Structure d'un ecran
ECRAN STRUC
 largeur_ecran DD 640         ;Largeur de l'ecran
 hauteur_ecran DD 480         ;Hauteur de l'ecran
 X_origine     DD 320         ;Position X de l'origine
 Y_origine     DD 240         ;Position Y de l'origine
 Xmin          DD -320        ; Fentre d'affichage: Xmin
 Ymin          DD -239        ;                      Ymin
 Xmax          DD 319         ;                      Xmax
 Ymax          DD 240         ;                      Ymax
 Add32_ecran   DD 0A0000H     ;Adresse 32bit de l'cran dans la mmoire concerne
 attribut_ecran DD 0          ;Attribut de l'ecran 
                              ;     bit 0: 0 mmoire video               
                              ;            1 ram CPU
                              ;     bit 1: 1 actuellement affich (vrouill)
                              ;     bit 2-4:Nb octets par pixel couleur
ENDS                          


; Variable necessaire pour stocker les informations retourn par le driver vesa

;Information sur le possibilite VESA

SIGNATURE_VESA      DB 4 DUP(?)             ;normalement="VESA"
VERSION_VESA        DW ?                    ;version du driver
OEM_POINTEUR        DD ?                    ;pointeur sur une chaine identifiant la carte graphique
CAPABILITIES        DD ?                    ;permet de savoire si le DAC peut etre etendu  8 bit
VIDEO_MODE_POINTEUR DD ?                    ;pointeur sur les modes video supports
TOTALE_MEMOIRE      DW ?                    ;nombre totale de block de 64k de memoire video
RESERVE_VESA        DB 236 DUP (?)          ;reserv pour extension futur

;structure pour stock les informations d'un mode video

MODE_INFO STRUC
        ModeAttributes      dw  ?  ; mode attributes
        WinAAttributes      db  ?  ; window A attributes
        WinBAttributes      db  ?  ; window B attributes
        WinGranularity      dw  ?  ; window granularity
        WinSize             dw  ?  ; window size
        WinASegment         dw  ?  ; window A start segment
        WinBSegment         dw  ?  ; window B start segment
        WinFuncPtr          dd  ?  ; pointer to window function
        BytesPerScanLine    dw  ?  ; bytes per scan line

        XResolution         dw  ?  ; horizontal resolution
        YResolution         dw  ?  ; vertical resolution
        XCharSize           db  ?  ; character cell width
        YCharSize           db  ?  ; character cell height
        NumberOfPlanes      db  ?  ; number of memory planes
        BitsPerPixel        db  ?  ; bits per pixel
        NumberOfBanks       db  ?  ; number of banks
        MemoryModel         db  ?  ; memory model type
        BankSize            db  ?  ; bank size in kb
        NumberOfImagePages  db  ?  ; number of images
        Reserved_page       db  1  ; reserved for page function

        RedMaskSize         db  ?  ; size of direct color red mask in bits
        RedFieldPosition    db  ?  ; bit position of LSB of red mask
        GreenMaskSize       db  ?  ; size of direct color green mask in bits
        GreenFieldPosition  db  ?  ; bit position of LSB of green mask
        BlueMaskSize        db  ?  ; size of direct color blue mask in bits
        BlueFieldPosition   db  ?  ; bit position of LSB of blue mask
        RsvdMaskSize        db  ?  ; size of direct color reserved mask in bits
        DirectColorModeInfo db  ?  ; Direct Color mode attributes
        Reserved_futur      db  216 dup(?)      ; remainder of ModeInfoBlock
ENDS

;Information sur le mode video courant
 MODE_information MODE_INFO <?>

.CODE

;Retourne les informations sur les possibilites SVGA dans signature VESA
SR_RETURN_SVGA_INFO PROC NEAR
 PUSH ES
 PUSH DI
  MOV AX,4F00H
  MOV DI,SEG SIGNATURE_VESA
  MOV ES,DI
  MOV DI,OFFSET SIGNATURE_VESA
  INT 10H
 POP DI
 POP ES
RETN
ENDP


;retourne des informations sur le mode video specifi

mode=[BP+4]

SR_RETURN_MODE_INFO PROC NEAR
 PUSH BP
 MOV BP,SP 
 PUSH CX
 PUSH ES
 PUSH DI
  MOV AX,4F01H
  MOV DI,SEG Mode_information
  MOV ES,DI
  MOV DI,OFFSET Mode_information
  MOV CX,mode
  INT 10H
 POP DI
 POP ES
 POP CX
 POP BP
RETN 2
ENDP


;Fixe un mode video

mode=[BP+4]
SR_SET_SVGA_MODE PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH BX
  MOV AX,4F02H
  MOV BX,MODE
  INT 10H
 POP BX
 POP BP
RETN 2
ENDP


; renvoie en AX le mode video courant

SR_GET_SVGA_MODE PROC NEAR
 PUSH BX
  MOV AX,4F03H
  INT 10H
  MOV AX,BX
 POP BX
RETN
ENDP


;Fixe la largeur d'une ligne en pixels

long=[BP+4]

SR_SET_LIGNE_LONGUEUR PROC NEAR
 PUSH BP
  MOV BP,SP
  MOV AX,4F06H
  XOR BL,BL
  MOV CX,long                ; BX=NB byte par ligne
  INT 10H                    ; CX=NB de pixels par ligne
 POP BP                      ; DX=nombre maximum de ligne                            
RETN 2
ENDP



;Renvoie la largeur d'une ligne en pixels et en octets ainsi que le NB max de ligne

SR_GET_LIGNE_LONGUEUR PROC NEAR
 MOV AX,4F06H      ; BX=NB byte par ligne
 MOV BL,1          ; CX=NB de pixels par ligne
 INT 10H           ; DX=nombre maximum de ligne
RETN
ENDP



;Selectionne la ligne et la colone ou commence l'affichage

 Y_depart=[BP+4]
 X_depart=[BP+6]
SR_SET_DISPLAY_START PROC NEAR
 PUSH BP 
 MOV BP,SP
 PUSH BX
 PUSH CX
 PUSH DX
  MOV AX,4F07H
  XOR BX,BX
  MOV CX,X_depart
  MOV DX,Y_depart
  INT 10H
 POP DX
 POP CX
 POP BX
 POP BP
RETN 4
ENDP



;renvoie en CX et DX la ligne et la colone ou commence l'affichage

SR_GET_DISPLAY_START PROC NEAR
 PUSH BX
  MOV AX,4F07H
  MOV BL,1
  INT 10H
 POP BX
RETN
ENDP


;selectionne le nombre de bit pour coder une couleur (VGA mode13=6bit)

NB_bit=[BP+4]
SR_SET_DAC_LARGEUR PROC NEAR
 PUSH BP
 MOV BP,SP
 MOV AX,4F08H
 MOV BL,0
 MOV BH,NB_bit
 INT 10H            ;BH=nombre de bit par couleur
 POP BP
RETN 2
ENDP

;renvoie le nombre de bit pour coder une couleur (VGA mode13=6bit)

SR_GET_DAC_LARGEUR PROC NEAR                                            
 MOV AX,4F08H
 MOV BL,1                             
 INT 10H            ;BH=nombre de bit par couleur
RETN 
ENDP


;Selectionne le nouvelle ofset(en granularit) de dpart d'une fenetre.

ofs=[BP+4]
fenetre=[BP+6]
offset_actif_fenetre1 DW 0
offset_actif_fenetre2 DW 0

SR_SET_POS_WINDOW PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH EBX
 PUSH EDX
 PUSH EDI

 MOV DX,ofs
 CMP BYTE PTR [fenetre],0
 JNE @S_S_P_W0
  CMP [offset_actif_fenetre1],DX
  JE @S_S_P_W3
  MOV [offset_actif_fenetre1],DX
 JMP @S_S_P_W1
 @S_S_P_W0:
  CMP [offset_actif_fenetre2],DX
  JE @S_S_P_W3
  MOV [offset_actif_fenetre2],DX
 @S_S_P_W1:

 MOV BH,0
 MOV BL,fenetre
 MOV AX,@DATA
 MOV DS,AX
 CALL DWORD PTR MODE_information.WinFuncPtr


 @S_S_P_W3:

 POP EDI
 POP EDX
 POP EBX
 POP DS
 POP BP
RETN 4
ENDP



;Copy un block mmoire dans la RAM video

;Variables locales
 TEMP_buffer=6
 pageV=[BP+2]                   ;page ou commence le stockage
 offp=[BP+4]                    ;offset dans la page ou commence le stockage

;Parametre fonction
 taille=[BP+4+Temp_buffer]      ;NB d'octets  copier
 ofsa=[BP+8+Temp_buffer]        ;Offset dans la RAM video
 ofsd=[BP+12+Temp_buffer]       ;Offset dans la RAM CPU 

SR_COPY_RAM_RAMVIDEO PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH ES
 PUSH ECX
 PUSH DS

 MOV AX,@DATA
 MOV DS,AX

 MOV AX,MODE_information.winAsegment
 MOV ES,AX

 SR_C_R_R_PAGEsuivante:
  ;Calcul page (offset en granularite) et offset ou commence le stockage
   MOV EAX,ofsa
   CDQ
   XOR EBX,EBX
   MOV BX,WORD PTR MODE_information.winGranularity
   SHL EBX,10
   DIV EBX
   MOV pageV,AX
   MOV offp,EDX

  ;Calcul nombre d'octet  copier dans cette page
   XOR ECX,ECX
   MOV CX,MODE_information.winSize
   SHL ECX,10
   SUB ECX,offp
   CMP ECX,taille
   JBE @SR_C_R_R_COPY0
    MOV ECX,taille
   @SR_C_R_R_COPY0:

  ;Effectue la copy
   PUSH ECX
   PUSH DS
   XOR AX,AX
   MOV DS,AX
   MOV EDI,offp               ;Fixe EDI
   MOV ESI,ofsd               ;Fixe ESI
   PUSH WORD PTR 0            ;Selectionne la page ou afficher
   PUSH WORD PTR pageV        ;
   CALL SR_SET_POS_WINDOW     ;


   MOV EBX,ECX
   AND ECX,11b
   CLD                        ;Copy octet/octet
   DB 67H                    
   REP MOVSB
   MOV ECX,EBX                ;Si necessaire copy le reste dword/dword
   SHR ECX,2
   CMP ECX,0
   JE SHORT @SR_C_R_R_PageFinie
    CLD
    DB 67H
    REP MOVSD

  @SR_C_R_R_PageFinie:
  POP DS
  POP ECX

  SUB taille,ECX
  JZ @SR_C_R_R_Finie
   ADD ofsa,ECX
   ADD ofsd,ECX
   JMP SR_C_R_R_PAGEsuivante
  @SR_C_R_R_Finie:

 POP DS
 POP ECX
 POP ES
 POP BP
 ADD SP,TEMP_buffer
RETN 12
ENDP

END
