DOSSEG
.MODEL SMALL
.STACK 32768
.486

INCLUDE ..\MEMOIRE\FLAT.INC
INCLUDE ..\MEMOIRE\FREE_OVE.FNC
INCLUDE ..\MEMOIRE\HIMEM.INC
INCLUDE ..\CLAVIER\CLAVIER.FNC
INCLUDE ..\VIDEO\VESA.FNC
INCLUDE ..\GRAPH\GRAPH16V.FNC
INCLUDE ..\IMAGES\BMP.FNC
INCLUDE ..\3D\TabP3D.FNC

.DATA

TabPointfond  DD 4,0,0
Pf1          Point3D<-320,239,2999>
Pf2          Point3D<319,239,2999>
Pf3          Point3D<319,-240,2999>
Pf4          Point3D<-320,-240,2999>

PolyFond   Polygone <0,0,0,0,0,4,1,639/2,1,2,0,1,3,0,478>
    p4t    Point3D<4,639/2,478>

Fond    DD 0

TabP3D  DD 0
TabP2D  DD 0

PolyGrille DD 0
Tgoudron   DD 0
Moniteur   DD 0
BufferP    DD 0
MasqueP    DD 0

CAM_dep      Point3D<1,0,0>
CAM_depl     Point3D<0,0,50>
CAM_dep2     Point3D<1,0,0>
CAM_depl2    Point3D<0,0,0>
CAM_position Point3D<-1500,0,6000>
CAM_RY       DD 0


.CODE
 START:
; FREE_OVER_MEM                    ;Libere la mmoire non utilis
 MOV AX,@DATA
 MOV DS,AX
 FLAT_MODE                        ;Passe en mode flat
 NEW_KEY                          ;Installe le nouveau clavier
 GET_HIMEM_ADRESSE                ;Recupre adresse driver HIMEM
 ACTIVE_A20                       ;Active la ligne d'adresse A20
 RETURN_SVGA_INFO                 ;Retourne les infos du driver VESA
 MOV BX,OFFSET Mode_information   ;Passe en mode video 640*480*16
 RETURN_MODE_INFO 111H,DS,BX      ;
 SET_SVGA_MODE 111H               ;
 INIT_COSIN_TAB                   ;Initialise table des sin et cos pour 3d

 ALLOUE_EMB 5000
 MOV TabP2d,EAX
 CREATE_P3D_GRILLEXZ 25,25,350,350
 MOV TabP3D,EAX

 CHARGE_IMAGE_BMP24_CONVERTVIDEO  "MerNuage.bmp"
 MOV Fond,EAX                         
 MOV PolyFond.Ptexture,EAX
 TO_OFS32 TabPointFond
 MOV PolyFond.Ptab_P2D,EAX

 CHARGE_IMAGE_BMP24_CONVERTVIDEO "Test2.bmp"
 MOV Tgoudron,EAX
 CREATE_POLY_SUR_GRILLE TabP3D,Tgoudron,TabP2d,0,0,0,199,199,199,199,0
 MOV PolyGrille,EAX
 CREATE_ECRAN_RAMVIDEO 640,480,640/2,480/2,-640/2,-480/2,640/2-1,480/2-1,0,1000b
 MOV Moniteur,EAX
 CREATE_BUFFERZ -1000,3000,51
 MOV BufferP,EAX
 CREATE_MASQUE Moniteur
 MOV MasqueP,EAX

 TRANSLATE_P3D 0,-240,0,TabP3D,TabP3D

@NOESC:
 INIT_BUFFERZ BufferP
 INIT_MASQUE MasqueP,Moniteur


 TRANSLATE_P3D CAM_position.X,CAM_position.Y,CAM_position.Z,TabP3D,TabP2D

  MOV EBX,CAM_RY
  NEG EBX
  ROTATE_P3D_AXEY EBX,TabP2D,TabP2D

  TRANSLATE_P3D 0,0,-500,TabP2D,TabP2D

  TO_OFS32 CAM_dep
  MOV EBX,EAX
  TO_OFS32 CAM_dep2
  ROTATE_P3D_AXEY CAM_RY,EBX,EAX

  projette_p3d 300,TabP2d,TabP2D

 ;Traite appuie sur les touche
  KEY 80
  JNE @NO80
   MOV EAX,CAM_depl2.X
   ADD CAM_position.X,EAX
   MOV EAX,CAM_depl2.Y
   ADD CAM_position.Y,EAX
   MOV EAX,CAM_depl2.Z
   ADD CAM_position.Z,EAX
  @NO80:
  KEY 72
  JNE @NO72
   MOV EAX,CAM_depl2.X
   SUB CAM_position.X,EAX
   MOV EAX,CAM_depl2.Y
   SUB CAM_position.Y,EAX
   MOV EAX,CAM_depl2.Z
   SUB CAM_position.Z,EAX
  @NO72:
  KEY 75
  JNE @NO75
   ADD DWORD PTR CAM_RY,2
  @NO75:
  KEY 77
  JNE @NO77
   SUB DWORD PTR CAM_RY,2
  @NO77:



 PUSH DS
 MOV ESI,PolyGrille
 XOR AX,AX
 MOV DS,AX
 MOV ECX,ESI.[X]
 ADD ESI,size Point3D

 MOV AX,@DATA
 MOV DS,AX
@ajoute_poly:
 PUSH ECX
 PUSH ESI



 MOV EAX,ESI
 AJOUTE_POLYGONE_BUFFERZ EAX,Moniteur,bufferP


 POP ESI
 ADD ESI,size Polygone+size Point3D
 POP ECX
LOOPD @ajoute_poly

 POP DS

 TO_OFS32 polyFond
 AJOUTE_POLYGONE_BUFFERZ EAX,Moniteur,bufferP

 AFFICHE_POLYGONE_BUFFERZ BufferP,-1000,2999,Moniteur,MasqueP

 KEY 1
JNE @NOESC
 LIBERE_EMB Fond
 LIBERE_EMB PolyGrille
 LIBERE_EMB Tabp3d
 LIBERE_EMB Tabp2d

 LIBERE_EMB BufferP
 LIBERE_EMB MasqueP
 LIBERE_EMB Moniteur
 LIBERE_EMB Tgoudron
 LIBERE_EMB COSIN_TAB    ;Libere espace mmoire de la table COSIN
 MOV AX,0003H            ;Repasse en mode texte
 INT 10H                 ;
 DESACTIVE_A20           ;Desactive la ligne d'adresse A20
 HOLD_KEY                ;Restaure le clavier
 MOV AX,4C00H            ;Retourne au dos
 INT 21H                 ;
END START

