TITLE Fonction graphique pour les mode en 65536 couleur

.DATA

;Strucure d'information sur un mode vesa

MODE_INFO STRUC
        ModeAttributes      dw  ?  ; mode attributes
        WinAAttributes      db  ?  ; window A attributes
        WinBAttributes      db  ?  ; window B attributes
        WinGranularity      dw  ?  ; window granularity
        WinSize             dw  ?  ; window size
        WinASegment         dw  ?  ; window A start segment
        WinBSegment         dw  ?  ; window B start segment
        WinFuncPtr          dd  ?  ; pointer to window function
        BytesPerScanLine    dw  ?  ; bytes per scan line

        XResolution         dw  ?  ; horizontal resolution
        YResolution         dw  ?  ; vertical resolution
        XCharSize           db  ?  ; character cell width
        YCharSize           db  ?  ; character cell height
        NumberOfPlanes      db  ?  ; number of memory planes
        BitsPerPixel        db  ?  ; bits per pixel
        NumberOfBanks       db  ?  ; number of banks
        MemoryModel         db  ?  ; memory model type
        BankSize            db  ?  ; bank size in kb
        NumberOfImagePages  db  ?  ; number of images
        Reserved_page       db  1  ; reserved for page function

        RedMaskSize         db  ?  ; size of direct color red mask in bits
        RedFieldPosition    db  ?  ; bit position of LSB of red mask
        GreenMaskSize       db  ?  ; size of direct color green mask in bits
        GreenFieldPosition  db  ?  ; bit position of LSB of green mask
        BlueMaskSize        db  ?  ; size of direct color blue mask in bits
        BlueFieldPosition   db  ?  ; bit position of LSB of blue mask
        RsvdMaskSize        db  ?  ; size of direct color reserved mask in bits
        DirectColorModeInfo db  ?  ; Direct Color mode attributes
        Reserved_futur      db  216 dup(?)      ; remainder of ModeInfoBlock
ENDS

;Structure d'un cran

POINT3d STRUC
 X DD 0
 Y DD 0
 Z DD 0
ENDS

POINT2d STRUC
 X DD 0
 Y DD 0
ENDS

ECRAN STRUC
 largeur_ecran DD 640         ;Largeur de l'ecran
 hauteur_ecran DD 480         ;Hauteur de l'ecran
 X_origine     DD 320         ;Position X de l'origine
 Y_origine     DD 240         ;Position Y de l'origine
 Xmin          DD -320        ; Fentre d'affichage: Xmin
 Ymin          DD -239        ;                      Ymin
 Xmax          DD 319         ;                      Xmax
 Ymax          DD 240         ;                      Ymax
 Add32_ecran   DD 0A0000H     ;Adresse 32bit de l'cran dans la mmoire concerne
 attribut_ecran DD 0          ;Attribut de l'ecran 
                              ;     bit 0: 0 mmoire video               
                              ;            1 ram CPU
                              ;     bit 1: 1 actuellement affich
                              ;     bit 2-3:Nb octets par pixel couleur
ENDS                          


.CODE
;*****************************************************************************
;                       CREATE_ECRAN_RAM
;*****************************************************************************
;  PARAMETRE: LargeurEC,HauteurEC,X_origine,Y_origine,  (DWORD)
;             Xmin,Ymin,Xmax,Ymax,Attibut_ecran         (DWORD)
;  SORTIE   :EAX=pointeur32 sur ecran
;****************************************************************************
;  REMARQUE:  necessite les fonction HIMEM
;****************************************************************************

;Variables locales
 TEMP_buffer=4
 EMB_adresse=[BP+2]

;Parametre passer  la fonction
 LargeurEC=[BP+36+TEMP_buffer]        ;Largeur ecran       
 HauteurEC=[BP+32+TEMP_buffer]        ;hauteur ecran       
 XorigineEC=[BP+28+TEMP_buffer]       ;Origine X        
 YorigineEC=[BP+24+TEMP_buffer]       ;Origine Y 
 XminEC=[BP+20+TEMP_buffer]           ;
 YminEC=[BP+16+TEMP_buffer]           ;Fenetre d'affichage
 XmaxEC=[BP+12+TEMP_buffer]           ;
 YmaxEC=[BP+8+TEMP_buffer]           ;
 AttribEC=[BP+4+TEMP_buffer]        ;attribut de l'ecran

SR_CREATE_ECRAN_RAM PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS

 MOV EAX,LargeurEC      ;Calcul la taille de l'ecran en octet
 MOV EBX,HauteurEC
 MUL EBX
 MOV EBX,AttribEC
 SHR EBX,2
 AND EBX,11b
 MUL EBX


 SHR EAX,10             ;La taille passe en Ko
 INC EAX                ;+1Ko
 PUSH AX
 CALL SR_ALLOUE_EMB
 MOV EDI,EAX            ;EDI=offset du buffer

 XOR AX,AX
 MOV DS,AX
 MOV EAX,LargeurEC
 MOV EDI.[Largeur_ecran],EAX
 MOV EAX,HauteurEC
 MOV EDI.[Hauteur_ecran],EAX
 MOV EAX,XorigineEC
 MOV EDI.[X_Origine],EAX
 MOV EAX,YorigineEC
 MOV EDI.[Y_Origine],EAX
 MOV EAX,XminEC
 MOV EDI.[Xmin],EAX
 MOV EAX,YminEC
 MOV EDI.[Ymin],EAX
 MOV EAX,XmaxEC
 MOV EDI.[Xmax],EAX
 MOV EAX,YmaxEC
 MOV EDI.[Ymax],EAX
 MOV EAX,AttribEC
 MOV EDI.[Attribut_ecran],EAX
 MOV EAX,EDI
 ADD EAX,size ecran
 MOV EDI.[ADD32_ecran],EAX

 MOV EAX,EDI                   ;Renvoie l'adresse de l'EC

 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 36
ENDP

CREATE_ECRAN_RAM MACRO largec,hautec,xori,yori,xminec,yminec,xmaxec,ymaxec,attri
 PUSH DWORD PTR largec
 PUSH DWORD PTR hautec
 PUSH DWORD PTR xori
 PUSH DWORD PTR yori
 PUSH DWORD PTR xminec
 PUSH DWORD PTR yminec
 PUSH DWORD PTR xmaxec
 PUSH DWORD PTR ymaxec
 PUSH DWORD PTR attri
 CALL SR_CREATE_ECRAN_RAM
ENDM

;*****************************************************************************
;                       CREATE_ECRAN_RAMVIDEO
;*****************************************************************************
;  PARAMETRE: LargeurEC,HauteurEC,X_origine,Y_origine,  (DWORD)
;             Xmin,Ymin,Xmax,Ymax,Attibut_ecran         (DWORD)
;  SORTIE   :EAX=pointeur32 sur structure ecran
;****************************************************************************
;  REMARQUE:  necessite les fonction HIMEM
;****************************************************************************

;Variables locales
 TEMP_buffer=4
 EMB_adresse=[BP+2]

;Parametre passer  la fonction
 LargeurEC=[BP+40+TEMP_buffer]        ;Largeur ecran       
 HauteurEC=[BP+36+TEMP_buffer]        ;hauteur ecran       
 XorigineEC=[BP+32+TEMP_buffer]       ;Origine X        
 YorigineEC=[BP+28+TEMP_buffer]       ;Origine Y 
 XminEC=[BP+24+TEMP_buffer]           ;
 YminEC=[BP+20+TEMP_buffer]           ;Fenetre d'affichage
 XmaxEC=[BP+16+TEMP_buffer]           ;
 YmaxEC=[BP+12+TEMP_buffer]           ;
 ad32=[BP+8+TEMP_buffer]            ;adresse ecran den ram video
 AttribEC=[BP+4+TEMP_buffer]        ;attribut de l'ecran

SR_CREATE_ECRAN_RAMVIDEO PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS

 MOV AX,1
 PUSH AX
 CALL SR_ALLOUE_EMB
 MOV EDI,EAX            ;EDI=offset du buffer

 XOR AX,AX
 MOV DS,AX
 MOV EAX,LargeurEC
 MOV EDI.[Largeur_ecran],EAX
 MOV EAX,HauteurEC
 MOV EDI.[Hauteur_ecran],EAX
 MOV EAX,XorigineEC
 MOV EDI.[X_Origine],EAX
 MOV EAX,YorigineEC
 MOV EDI.[Y_Origine],EAX
 MOV EAX,XminEC
 MOV EDI.[Xmin],EAX
 MOV EAX,YminEC
 MOV EDI.[Ymin],EAX
 MOV EAX,XmaxEC
 MOV EDI.[Xmax],EAX
 MOV EAX,YmaxEC
 MOV EDI.[Ymax],EAX
 MOV EAX,AttribEC
 MOV EDI.[Attribut_ecran],EAX
 MOV EAX,ad32
 MOV EDI.[ADD32_ecran],EAX

 MOV EAX,EDI                   ;Renvoie l'adresse de l'EC

 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 40
ENDP

CREATE_ECRAN_RAMVIDEO MACRO largec,hautec,xori,yori,xminec,yminec,xmaxec,ymaxec,ad32,attri
 PUSH DWORD PTR largec
 PUSH DWORD PTR hautec
 PUSH DWORD PTR xori
 PUSH DWORD PTR yori
 PUSH DWORD PTR xminec
 PUSH DWORD PTR yminec
 PUSH DWORD PTR xmaxec
 PUSH DWORD PTR ymaxec
 PUSH DWORD PTR ad32
 PUSH DWORD PTR attri
 CALL SR_CREATE_ECRAN_RAMVIDEO
ENDM



;*****************************************************************************
;                   Copy un block de pixels de la RAM vers un ecran
;*****************************************************************************
;  PARAMETRE: ofs32d  (dword)       :offset 32bit dans la RAM CPU du premier pixel.
;             ofs32a  (dword)       :offset 32bit dans l'ecran en pixel.
;             NBpixel (dword)       :NB de pixels  copier.
;             ecran   (dword)       :pointeur sur une structure ecran.
;*****************************************************************************
; REMARQUE: necessite la fonction video (vesa:copy_ram_ramvideo)
;*****************************************************************************

;Parametre passer  la fonction
 ofs32d=[BP+16]        ;
 ofs32a=[BP+12]        ;
 NBpixel=[BP+8]        ;
 ecranz=[BP+4]         ;

SR_COPY_BLOCK_PIXEL_RAM_ECRAN PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH ECX
 PUSH ESI
 PUSH EBX
 PUSH EDX
 PUSH DS
 PUSH ES

 XOR AX,AX
 MOV DS,AX
 MOV ES,AX

 MOV ESI,ecranz
 MOV EBX,ESI.[attribut_ecran]
 SHR EBX,2
 AND EBX,11b                  ;EBX=NB octet par pixels

 MOV EAX,DWORD PTR [ofs32a]
 MUL EBX
 ADD EAX,ESI.[ADD32_ecran] 
 MOV DWORD PTR [ofs32a],EAX   ;Nouvelle offset (en bytes)

 MOV EAX,DWORD PTR [NBpixel]  ;Passe la taille en Nb de bytes
 MUL EBX
 MOV DWORD PTR [NBpixel],EAX
 TEST BYTE PTR ESI.[attribut_ecran],1
 JNZ @SR_C_B_P_R0
  PUSH DWORD PTR [ofs32d]     ;Copy de RAM  RAMvideo
  PUSH DWORD PTR [ofs32a]
  PUSH DWORD PTR [NBpixel]
  CALL sr_copy_ram_ramvideo
 JMP  @SR_C_B_P_R1
 @SR_C_B_P_R0:                ;Copy de RAM  RAM
  MOV ESI,ofs32d
  MOV EDI,ofs32a
  MOV ECX,NBpixel
  AND ECX,11b
  CLD
  JECXZ @SR_C_B_P_R2
   DB 67H
   REP MOVSB
  @SR_C_B_P_R2:
  MOV ECX,NBpixel
  SHR ECX,2
  JECXZ @SR_C_B_P_R1
   DB 67H
   REP MOVSD
 @SR_C_B_P_R1:

 POP ES
 POP DS
 POP EDX
 POP EBX
 POP ESI
 POP ECX
 POP BP
RETN 16
ENDP

COPY_BLOCK_PIXEL_RAM_ECRAN MACRO ofs32d,ofs32a,NBpixel,ecranZ
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 PUSH DWORD PTR NBpixel
 PUSH DWORD PTR ecranZ
 CALL SR_COPY_BLOCK_PIXEL_RAM_ECRAN
ENDM


;*****************************************************************************
;   Trace une ligne horizontale mappe sur un ecran en utilisant un masque
;*****************************************************************************
;  PARAMETRE: posy    (dword)       :position y sur l'ecran de la ligne trac Y
;             posXd   (dword)       :position X dpart sur l'ecran
;             posXf   (dword)       :position X fin sur l'ecran
;             PX1T    (dword)       :position X1 de la ligne de texture
;             PY1T    (dword)       :position Y1 de la ligne de texture
;             PX2T    (dword)       :position X2 de la ligne de texture
;             PY2T    (dword)       :position Y2 de la ligne de texture
;             TEXTURE (dword)       :offset 32 de la texture (structure ecran)
;             ECRAN   (dword)       :offset 32 pointant sur une strucutre ecran
;             MASKL   (dword)       :offset 32 pointant sur une structure mask
;*****************************************************************************
; REMARQUE: - ncessite fonction vesa
;           - posXf > posXd
;*****************************************************************************

;Variables locales
 TEMP_buffer=72
 Taille_ligne=[BP+2]
 deltaX=[BP+6]
 deltaY=[BP+10]
 INCofsT=[BP+14]
 coeffx=[BP+18]
 coeffy=[BP+22]
 deplx=[BP+26]
 deply=[BP+30]
 rognage_gauche=[BP+34]
 rognage_droit=[BP+38]
 traitement_cellule=[BP+42]
 cellule_courante=[BP+46]
 cellule_pass=[BP+50]
 futur_cellule=[BP+54]
 facxdep=[BP+58]
 facydep=[BP+62]
 UnPoint=[BP+66]

;Parametre passer  la fonction
 posy=[BP+40+TEMP_buffer]         ;
 posXd=[BP+36+TEMP_buffer]        ;
 posXf=[BP+32+TEMP_buffer]        ;
 PX1T=[BP+28+TEMP_buffer]         ;
 PY1T=[BP+24+TEMP_buffer]         ;
 PX2T=[BP+20+TEMP_buffer]         ;
 PY2T=[BP+16+TEMP_buffer]         ;
 TEXTURE=[BP+12+TEMP_buffer]      ;
 ECRANz=[BP+8+TEMP_buffer]        ;
 MASKL=[BP+4+TEMP_buffer]         ;

SR_TRACE_LIGNE_MAPPE_RAM_ECRAN_AVECMASQUE PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ES
 
 XOR AX,AX
 MOV ES,AX
 MOV DS,AX

 NEG DWORD PTR PY1T
 NEG DWORD PTR PY2T

;Calcul la taille de la ligne (Nb de pixel  tracer - 1)
 MOV DWORD PTR UnPoint,0
 MOV EAX,POSXF
 SUB EAX,POSXD
 CMP EAX,0
 JGE @SR_T_L_M_R_E_AM01
  JMP @SR_T_L_M_R_E_AM7
 @SR_T_L_M_R_E_AM01:
 CMP EAX,0
 JNE @SR_T_L_M_R_E_AM00
  MOV DWORD PTR UnPoint,1
  MOV EAX,1
 @SR_T_L_M_R_E_AM00:
 MOV Taille_ligne,EAX

;Calcul deplX= +/- NbOctParCoul et deltaX
 MOV ESI,TEXTURE
 MOV EAX,DWORD PTR ESI.[attribut_ecran]
 SHR EAX,2
 AND EAX,11b
 MOV deplX,EAX

 MOV EAX,PX2T
 SUB EAX,PX1T
 JNS @SR_T_L_M_R_E_AM0
  NEG EAX
  NEG DWORD PTR deplX
 @SR_T_L_M_R_E_AM0:
 MOV deltaX,EAX

;Calcul deplY= +/- NbOctParCoul*LargeurEC et deltaY
 MOV EAX,DWORD PTR ESI.[attribut_ecran]
 SHR EAX,2
 AND EAX,11b
 MUL DWORD PTR ESI.[largeur_ecran]
 MOV deplY,EAX

 MOV EAX,PY2T
 SUB EAX,PY1T
 JNS @SR_T_L_M_R_E_AM1
  NEG EAX
  NEG DWORD PTR deplY
 @SR_T_L_M_R_E_AM1:
 MOV deltaY,EAX

;Calcul INCofsT=deplY*deltaY/taille+deplX*deltaX/taille
 MOV EBX,taille_ligne
 MOV EAX,deltaY
 XOR EDX,EDX
 DIV EBX
 IMUL DWORD PTR deplY
 MOV INCofsT,EAX
 MOV EAX,deltaX
 XOR EDX,EDX
 DIV EBX
 IMUL DWORD PTR deplX
 ADD INCofsT,EAX

;Calcul coeffX
 MOV EAX,deltaX
 XOR EDX,EDX
 DIV DWORD PTR taille_ligne
 XOR EAX,EAX
 DIV DWORD PTR taille_ligne
 MOV coeffX,EAX

;Calcul coeffY
 MOV EAX,deltaY
 XOR EDX,EDX
 DIV DWORD PTR taille_ligne
 XOR EAX,EAX
 DIV DWORD PTR taille_ligne
 MOV coeffY,EAX

;GESTION des cellules
;Fixe pointeur cellule courante
 MOV ESI,ecranz
 MOV EAX,posy
 ADD EAX,ESI.[Y_origine]
 MOV EBX,ESI.[largeur_ecran]
 MUL EBX
 ADD EAX,maskl
 MOV futur_cellule,EAX
 ADD EAX,4
 MOV cellule_pass,EAX
 MOV EDI,EAX
 MOV EAX,[EDI]
 MOV cellule_courante,EAX

;Boucle a chaque cellule
@SR_T_L_M_R_E_AM6:
  MOV ESI,cellule_courante
  XOR EAX,EAX
  CMP [ESI],EAX               ;Test si il y'a une autre cellule
  JNE @SR_T_L_M_R_E_AM11
   JMP @SR_T_L_M_R_E_AM7
  @SR_T_L_M_R_E_AM11:
   MOV traitement_cellule,EAX
   MOV Rognage_droit,EAX
   MOV Rognage_gauche,EAX
   MOV EAX,[ESI+4]
   CMP EAX,PosXf              ;Test X1 et PosXf
   JLE @SR_T_L_M_R_E_AM8      ;
    JMP @SR_T_L_M_R_E_AM9     ;X1>posXf
   @SR_T_L_M_R_E_AM8:         ;
   MOV EAX,[ESI+8]            ;X1<=posXf
   CMP EAX,posXd              ;Test X2 et PosXd
   JGE @SR_T_L_M_R_E_AM10     ;
    JMP @SR_T_L_M_R_E_AM9     ;X2<posXd
   @SR_T_L_M_R_E_AM10:        ;

   MOV EAX,[ESI+4]            ;X2>=PosXd
   CMP EAX,posXd              ;test X1 et posXd 
   JLE @SR_T_L_M_R_E_AM12     ;
    SUB EAX,PosXd             ;X1>posXd
    MOV rognage_gauche,EAX    ;
    OR DWORD PTR traitement_cellule,1  
   @SR_T_L_M_R_E_AM12:        ;

   MOV EAX,[ESI+8]            ;
   CMP EAX,posXf              ;test X2 et posXf
   JGE @SR_T_L_M_R_E_AM13     ;
    MOV EAX,posXf             ;X2<posXf
    SUB EAX,[ESI+8]           ;
    MOV rognage_droit,EAX     ;
    OR DWORD PTR traitement_cellule,10b
   @SR_T_L_M_R_E_AM13:


;Calcul EDI
 MOV ESI,ECRANZ
 MOV EAX,ESI.[hauteur_ecran]
 DEC EAX
 SUB EAX,ESI.[Y_origine]
 SUB EAX,posy
 MUL DWORD PTR ESI.[largeur_ecran]
 ADD EAX,posXd
 ADD EAX,ESI.[X_origine]
 ADD EAX,rognage_gauche
 MOV EBX,ESI.[attribut_ecran]
 SHR EBX,2
 AND EBX,11b
 MUL EBX
 ADD EAX,ESI.[ADD32_ecran] 
 MOV EDI,EAX

;Selectionne fenetre video et nouvelle valeur de EDI
;fenetre=EDI/Mode_Information.WinSize
;    EDI=EDI MOD Mode_Information.WinSize+fenetre segment*16

MOV AX,@DATA
MOV DS,AX
MOV EAX,EDI
XOR EDX,EDX
MOV BX,Mode_information.WinGranularity
AND EBX,0000FFFFH
SHL EBX,10
DIV EBX
MOV EDI,EDX
PUSH WORD PTR 0                    ;
PUSH AX                            ;Selectionne la fenetre
CALL SR_SET_POS_WINDOW             ;
MOV AX,Mode_information.WinAsegment
AND EAX,0FFFFH
SHL EAX,4
ADD EDI,EAX
XOR AX,AX
MOV DS,AX


;Calcul ESI
 MOV ESI,TEXTURE
 MOV EAX,ESI.[hauteur_ecran]
 DEC EAX
 SUB EAX,ESI.[Y_origine]
 ADD EAX,PY1T
 MUL DWORD PTR ESI.[largeur_ecran]
 ADD EAX,PX1T
 ADD EAX,ESI.[X_origine]
 MOV EBX,ESI.[attribut_ecran]
 SHR EBX,2
 AND EBX,11b
 MUL EBX
 ADD EAX,[ESI.ADD32_ecran]
 MOV ESI,EAX

;Calcul nouvelle valeur de ESI,EDX,EBX
 MOV EAX,80000000H
 MOV facxdep,EAX
 MOV facydep,EAX

 MOV EAX,coeffX                 ;EBX(facXdep) et ESI
 MUL DWORD PTR [rognage_gauche] ;
 ADD facXdep,EAX                ;
 ADC EDX,0
 MOV EAX,EDX
 IMUL DWORD PTR deplX           ;
 ADD ESI,EAX                    ;

 MOV EAX,coeffY                 ;EDX(facYdep) et ESI
 MUL DWORD PTR [rognage_gauche] ;
 ADD facYdep,EAX                ;
 ADC EDX,0
 MOV EAX,EDX
 IMUL DWORD PTR deplY           ;
 ADD ESI,EAX                    ;

 MOV EAX,rognage_gauche         ;
 IMUL DWORD PTR [INCofsT]       ;ESI=ESI+rognage gauche*INCofsT
 ADD ESI,EAX                    ;

;Trace la ligne
 MOV ECX,taille_ligne
 SUB ECX,rognage_gauche
 SUB ECX,rognage_droit
 
 MOV EBX,FACxdep
 MOV EDX,FACydep
 CLD
 MOV AX,[ESI]
 CMP ECX,0
 JLE @SR_T_L_M_R_E_AM51
 CMP DWORD PTR UnPoint,1
 JE @SR_T_L_M_R_E_AM5
 CMP DWORD PTR INCofsT,0
 JE @SR_T_L_M_R_E_AM20
 @SR_T_L_M_R_E_AM2:
  DB 67H
  STOSW
  ADD ESI,INCofsT
  ADD EBX,coeffX
  JNC @SR_T_L_M_R_E_AM3
   ADD ESI,deplX
  @SR_T_L_M_R_E_AM3:
  ADD EDX,coeffY
  JNC @SR_T_L_M_R_E_AM4
   ADD ESI,deplY
  @SR_T_L_M_R_E_AM4:
  MOV EAX,[ESI]
 LOOPD @SR_T_L_M_R_E_AM2
 JMP @SR_T_L_M_R_E_AM5
 @SR_T_L_M_R_E_AM20:
  DB 67H
  STOSW
  ADD EBX,coeffX
  JNC @SR_T_L_M_R_E_AM30
   ADD ESI,deplX
  @SR_T_L_M_R_E_AM30:
  ADD EDX,coeffY
  JNC @SR_T_L_M_R_E_AM40
   ADD ESI,deplY
  @SR_T_L_M_R_E_AM40:
  MOV AX,[ESI]
 LOOPD @SR_T_L_M_R_E_AM20
 @SR_T_L_M_R_E_AM5:
 MOV [EDI],AX
 @SR_T_L_M_R_E_AM51:


;Met  jours les cellules du masque
 CMP DWORD PTR [Traitement_cellule],0
 JE @SR_T_L_M_R_E_AM14
 CMP DWORD PTR [Traitement_cellule],1
 JE @SR_T_L_M_R_E_AM16
 CMP DWORD PTR [Traitement_cellule],2
 JE @SR_T_L_M_R_E_AM17
 CMP DWORD PTR [Traitement_cellule],3
 JNE @SR_T_L_M_R_E_AM6
  MOV ESI,cellule_courante
  MOV EAX,[ESI]             ;EAX=offset cellule suivante
  MOV cellule_courante,EAX
  MOV ESI,cellule_pass
  MOV [ESI],EAX
 JMP @SR_T_L_M_R_E_AM6
 @SR_T_L_M_R_E_AM17:
  MOV ESI,cellule_courante
  MOV cellule_pass,ESI
  MOV EAX,[ESI]             ;EAX=offset cellule suivante
  MOV cellule_courante,EAX
  MOV EAX,posXd
  DEC EAX
  MOV [ESI+8],EAX
 JMP @SR_T_L_M_R_E_AM6
 @SR_T_L_M_R_E_AM16:
  MOV ESI,cellule_courante
  MOV cellule_pass,ESI
  MOV EAX,[ESI]             ;EAX=offset cellule suivante
  MOV cellule_courante,EAX
  MOV EAX,posXf
  INC EAX
  MOV [ESI+4],EAX
 JMP @SR_T_L_M_R_E_AM6
 @SR_T_L_M_R_E_AM14:
  MOV ESI,cellule_courante
  MOV EAX,[ESI]             ;EAX=offset cellule suivante
  MOV EDI,futur_cellule
  MOV EBX,[EDI]             ;EBX=offset nouvelle cellule
  ADD DWORD PTR [EDI],12
  MOV EDI,EBX               ;
  MOV [EDI],EAX             ;Fixe valeurs nouvelle cellule
  MOV EAX,posXf             ;
  INC EAX                   ;
  MOV [EDI+4],EAX           ;
  MOV EAX,[ESI+8]           ;
  MOV [EDI+8],EAX           ;
  MOV EAX,posXd             ;Fixe nouvelle borne suprieure de la cellule 2.
  DEC EAX                   ;
  MOV [ESI+8],EAX           ;
  MOV [ESI],EDI
 JMP @SR_T_L_M_R_E_AM7

@SR_T_L_M_R_E_AM9:
 MOV ESI,cellule_courante
 MOV cellule_pass,ESI
 MOV EAX,[ESI]             ;EAX=offset cellule suivante
 MOV cellule_courante,EAX
JMP @SR_T_L_M_R_E_AM6

@SR_T_L_M_R_E_AM7:


 POP ES
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 40
ENDP

TRACE_LIGNE_MAPPE_RAM_ECRAN_AVECMASQUE MACRO posy,posxd,posxf,px1t,py1t,px2t,py2t,texture,ecranz,masql
 PUSH DWORD PTR posy
 PUSH DWORD PTR posxd
 PUSH DWORD PTR posxf
 PUSH DWORD PTR px1t
 PUSH DWORD PTR py1t
 PUSH DWORD PTR px2t
 PUSH DWORD PTR py2t
 PUSH DWORD PTR texture
 PUSH DWORD PTR ecranz
 PUSH DWORD PTR masql
 CALL SR_TRACE_LIGNE_MAPPE_RAM_ECRAN_AVECMASQUE
ENDM


;*****************************************************************************
;           Crer un masque graphique et l'initialise
;*****************************************************************************
;  PARAMETRE:  ecran   (dword) : pointeur 32 sur ecran 
;  SORTIE   :  EAX=pointeur32 sur masque cr         
;****************************************************************************
;  REMARQUE :  necessite fonction HIMEM.FNC 
;****************************************************************************

;Parametre passer  la fonction
 ecranz=[BP+4]        ;

SR_CREATE_MASQUE PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS 
  XOR AX,AX
  MOV DS,AX
  MOV EDI,ecranz
  MOV EAX,EDI.[largeur_ecran]
  MOV EBX,EDI.[hauteur_ecran]
  MUL EBX
  SHR EAX,10
  INC EAX
  PUSH AX
  CALL SR_ALLOUE_EMB
 POP DS
 POP BP
RETN 4
ENDP

CREATE_MASQUE MACRO ecranz
 PUSH DWORD PTR ecranz
 CALL SR_CREATE_MASQUE
ENDM 


;*****************************************************************************
;                        Initialise le masque graphique
;*****************************************************************************
;  PARAMETRE:  maskl   (dword) : pointeur 32 sur masque
;              ecran   (dword) : pointeur 32 sur ecran 
;****************************************************************************

;Variable locale
 TEMP_buffer=20
 TailleFenetre=[BP+2]
 OfsPmin      =[BP+6]
 LongueurL    =[BP+10]
 NBoctetPP    =[BP+14]
 GranulP      =[BP+18]

;Parametre passer  la fonction
 maskl=[BP+8+TEMP_buffer]         ;
 ecranz=[BP+4+TEMP_buffer]        ;

SR_INIT_MASQUE PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH EDI
 PUSH ESI
 PUSH DS
 PUSH ES
 PUSH ECX
 PUSH EBX

 XOR AX,AX
 MOV DS,AX
 MOV ES,AX

 MOV ESI,ecranz
 MOV EDI,maskl
 MOV EBX,ESI.[Y_origine]
 NEG EBX

 MOV ECX,ESI.[hauteur_ecran]

 @SR_I_M0:
 PUSH ECX
  CMP EBX,ESI.[Ymin]
  JL @SR_I_M1
  CMP EBX,ESI.[Ymax]
  JG @SR_I_M1
   MOV EAX,EDI
   ADD EAX,24
   MOV [EDI],EAX
   XOR EAX,EAX
   MOV [EDI+20],EAX
   MOV EAX,EDI
   ADD EAX,20
   MOV [EDI+8],EAX
   MOV EAX,ESI.[Xmin]
   MOV [EDI+12],EAX
   MOV EAX,ESI.[Xmax]
   MOV [EDI+16],EAX
   MOV EAX,EDI
   ADD EAX,8
   MOV [EDI+4],EAX
  JMP @SR_I_M2
  @SR_I_M1:
   MOV EAX,EDI
   ADD EAX,12
   MOV [EDI],EAX
   SUB EAX,4
   MOV [EDI+4],EAX
   XOR EAX,EAX
   MOV [EDI+8],EAX
  @SR_I_M2:

  ADD EDI,ESI.[largeur_ecran]
  INC EBX

 POP ECX
 LOOPD @SR_I_M0

 MOV EAX,ESI.[Attribut_ecran]  ;Test si il s'agit d'un ecran en mmoire video
 TEST EAX,1                    ;Si oui rajoute une cellule pour toute les lignes
 JNZ @SR_I_M3                  ; contenant un sault de page entre Ymin et Ymax.

  MOV ECX,ESI.[Ymax]           ;
  SUB ECX,ESI.[Ymin]           ;ECX=nombre le ligne  traiter
  INC ECX                      ;

  MOV EBX,ESI.[Attribut_ecran]      ; Fixe nombre oct/pix
  SHR EBX,2                         ;
  AND EBX,11b                       ;
  MOV NBoctetPP,EBX                 ;

  MOV AX,@DATA                      ;
  MOV DS,AX                         ;Calcul taille fenetre en pixel
  MOV AX,Mode_information.WinSize   ; et granularit en pixel
  AND EAX,0FFFFH                    ;
  SHL EAX,10                        ;
  XOR EDX,EDX                       ;
  DIV DWORD PTR NBoctetPP           ;
  MOV TailleFenetre,EAX             ;
  MOV AX,Mode_information.WinGranularity   ; et granularit en pixel
  AND EAX,0FFFFH                           ;
  SHL EAX,10                               ;
  XOR EDX,EDX                              ;
  DIV DWORD PTR NBoctetPP                  ;
  MOV GranulP,EAX                          ;

  XOR AX,AX                         ;
  MOV DS,AX                         ;

  MOV EAX,ESI.[Xmax]                ;Calcul longueur d'une ligne en pixel
  SUB EAX,ESI.[Xmin]                ;
  MOV LongueurL,EAX                 ;

  MOV EAX,ESI.[ADD32_ecran]         ;Fixe ofset en pixel du point Ymin,Xmin
  XOR EDX,EDX                       ;
  DIV DWORD PTR NBoctetPP           ;
  MOV ofsPmin,EAX                   ;
  MOV EAX,ESI.[Hauteur_ecran]       ;
  SUB EAX,ESI.[Y_origine]           ;
  DEC EAX                           ;
  SUB EAX,ESI.[Ymin]                ;
  MUL ESI.[Largeur_ecran]           ;
  ADD EAX,ESI.[Xmin]
  ADD EAX,ESI.[X_origine]
  ADD OfsPmin,EAX                   ;

  MOV EDI,Maskl                     ;EDI pointe sur entr correspondante
  MOV EAX,ESI.[Y_origine]           ; Ymin,Xmin
  ADD EAX,ESI.[Ymin]                ;
  MUL ESI.[Largeur_ecran]           ;
  ADD EDI,EAX                       ;


 @SR_I_M4:
  MOV EAX,OfsPmin                   ;Calcul la fenetre
  XOR EDX,EDX                       ;
  DIV DWORD PTR granulp             ;EAX=fenetre EDX=offset en pix dans fenetre
  ADD EDX,LongueurL
  CMP EDX,TailleFenetre             ;Test si sault de page
  JB @SR_I_M5                       ;
   SUB EDX,LongueurL
   MOV EBX,TailleFenetre
   SUB EBX,EDX
   ADD EBX,[EDI+12]

   MOV EAX,[EDI+16]
   MOV [EDI+28],EAX
   MOV [EDI+24],EBX
   DEC EBX
   MOV [EDI+16],EBX
   XOR EAX,EAX
   MOV [EDI+32],EAX

   MOV EAX,EDI
   ADD EAX,32
   MOV [EDI+20],EAX
   ADD EAX,4
   MOV [EDI],EAX

  @SR_I_M5:
  ;Fixe EDI sur prochaine entr dans masque et ofsPmin sur pos correspondante
  MOV EAX,ESI.[Largeur_ecran]
  ADD EDI,EAX
  SUB ofsPmin,EAX
 DEC ECX
 JECXZ @SR_I_M3
 JMP @SR_I_M4

 @SR_I_M3:

 POP EBX
 POP ECX
 POP ES
 POP DS
 POP ESI
 POP EDI
 POP BP
 ADD SP,TEMP_buffer
RETN 8
ENDP

INIT_MASQUE MACRO masql,ecranz
 PUSH DWORD PTR masql
 PUSH DWORD PTR ecranz
 CALL SR_INIT_MASQUE
ENDM 


;*****************************************************************************
;Trace un polygone a n cot mapp d'une texture sur un ecran en utilisant un masque
;*****************************************************************************
;  PARAMETRE:  poly                    : pointeur 32 polygone   (DWORD)
;              Texturez,Ecranz,masque  : Texture et ecran       (DWORD)
;  REMARQUE:   le nombre de couleur utilis dpend de la fonction trace ligne
;              utilise.
;****************************************************************************

Polygone STRUC
 PAttribut  DD 0
 PTab_P3d   DD 0
 PTab_P2d   DD 0
 Ptexture   DD 0
 Pnormale   DD 0
 PNb_Points DD 0
 PNp1       DD 0
 P1Tx       DD 0
 P1Ty       DD 0
 PNp2       DD 0
 P2Tx       DD 0
 P2Ty       DD 0
 PNp3       DD 0
 P3Tx       DD 0
 P3Ty       DD 0
ENDS

Ligne_mappe STRUC
 pos_Y2T DD 0
 pos_X2T DD 0
 pos_Y1T DD 0
 pos_X1T DD 0
 pos_X2 DD 0
 pos_X1 DD 0
ENDS

;Variable locales
 TEMP_buffer=156
 TotalPoint =[BP+2]
 PointActu  =[BP+6]
 PointPlus  =[BP+10]
 PosYmaxi   =[BP+14]
 PosYmini   =[BP+18]
 PosX       =[BP+22]
 PosY       =[BP+26]
 PosTx      =[BP+30]
 PosTy      =[BP+34]
 DeltaY     =[BP+38]
 IncPosX    =[BP+42]
 DecPosX    =[BP+46]
 CoeffPosX  =[BP+50]
 IncFacPosX =[BP+54]
 IncPosY    =[BP+58]
 IncPosTX   =[BP+62]
 DecPosTX   =[BP+66]
 CoeffPosTX =[BP+70]
 IncFacPosTX=[BP+74]
 IncPosTY   =[BP+78]
 DecPosTY   =[BP+82]
 CoeffPosTY =[BP+86]
 IncFacPosTY=[BP+90]
 PosBuffer  =[BP+94]
 TailleBuffer =[BP+98]
 MaxOuMin     =[BP+102]
 NumPointActu =[BP+106]
 NumPointPlus =[BP+110]
 RognageHaut=[BP+114]
 RognageBas=[BP+118]
 texturez=[BP+122]
 Pos1Y3D=[BP+126]
 Pos2Y3D=[BP+130]
 K1=[BP+134]
 K2=[BP+138]
 deltaZ=[BP+142]
 Z0=[BP+146]
 K3=[BP+150]
 diffZ=[BP+154]

;Parametre passer  la fonction
 poly=[BP+16+TEMP_buffer]      ;Polygone  tracer
 ecranz=[BP+12+TEMP_buffer]     ;Ecran utilis
 maskz=[BP+8+TEMP_buffer]      ;mask utilis
 focusz=[BP+4+TEMP_buffer]      ;mask utilis

SR_TRACE_POLYGONE_MAPPE_AVECMASQUE PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH EDI
 PUSH ESI
 PUSH DS
 PUSH ES
 PUSH ECX
 PUSH EBX

 XOR AX,AX
 MOV DS,AX
 MOV ES,AX

 MOV ESI,poly              ; ESI pointe sur polygone
 MOV EAX,ESI.[Ptexture]
 MOV texturez,EAX
 MOV ECX,ESI.[PNB_points]  ; ECX=Nombre de point du poly
 MOV TotalPoint,ECX        ; (au minimum 3)

 ;Cherche posYmini et PosYmaxi
 MOV EDI,ESI.[Ptab_P2D]    ; EDI pointe sur tableau de points
 MOV EAX,ESI.[PNP1]        ; EAX=numro point 1
 MOV EBX,12                ;
 MUL EBX                   ; 
 MOV EBX,EAX               ; EBX+EDI=offset point1
 MOV EAX,DS:[EDI+EBX+4]    ; EAX=Y point 1
 MOV PosYmini,EAX          ; PosYmini = Y point 1
 MOV PosYmaxi,EAX          ; PosYmaxi = Y point 1

 DEC ECX
 @SR_T_P_M0:                 ;Recherche posYmaxi et PosYmini
  ADD ESI,12
  MOV EAX,ESI.[PNP1]
  MOV EBX,12
  MUL EBX
  MOV EBX,EAX
  MOV EAX,DS:[EDI+EBX+4]
  CMP EAX,PosYmini
  JGE @SR_T_P_M1
   MOV PosYmini,EAX
  @SR_T_P_M1:
  CMP EAX,PosYmaxi
  JLE @SR_T_P_M2
   MOV PosYmaxi,EAX
  @SR_T_P_M2:
 LOOPD @SR_T_P_M0


;PosYmaxi et PosYmini sont fixs les rectifis si ncessaire
; Rserve un buffer de taille=taille(ligne_mappe)*(Ymax-Ymin+1)
; SP=SP-TailleBuffer
; Premire entre buffer=SS:SP
; 2em                   =SS:SP+taille(ligne_mappe)
; X                     =SS:SP+X*taille(ligne_mappe)
; posY                  =SS:SP+(posY-ecran.Ymin]*taille(ligne_mappe)
;                       ou PosBuffer+(posY-ecran.Ymin]*taille(ligne_mappe)
 MOV EDI,ecranz
 MOV EAX,EDI.[Ymin]   ;Rectifie PosYmini et PosYmaxi
 CMP PosYmini,EAX
 JGE @SR_T_P_M26
  MOV PosYmini,EAX
 @SR_T_P_M26:
 MOV EAX,EDI.[Ymax]
 CMP PosYmaxi,EAX
 JLE @SR_T_P_M27
  MOV PosYmaxi,EAX
 @SR_T_P_M27:
 MOV EAX,PosYmaxi
 CMP EAX,PosYmini
 JG @SR_T_P_M32
  JMP @SR_T_P_M33
 @SR_T_P_M32:
 MOV EAX,EDI.[Ymax]
 SUB EAX,EDI.[Ymin]
 INC EAX
 MOV EBX,size Ligne_mappe
 MUL EBX               ;EBX=taille du buffer
 MOV TailleBuffer,EAX  ;
 SUB SP,TailleBuffer   ;
 MOV AX,SS             ;
 AND EAX,0FFFFH        ;
 SHL EAX,4             ;
 MOV BX,SP             ;
 AND EBX,0FFFFH        ;
 ADD EAX,EBX           ;
 MOV PosBuffer,EAX     ;PosBuffer=pointeur32 sur buffer

 MOV ESI,poly              
 MOV ECX,ESI.[PNb_Points]  ;ECX=Nombre de lignes du poly (nombre de points)
 MOV EAX,ECX
 DEC EAX
 MOV EBX,12
 MUL EBX
 MOV EBX,EAX
 MOV EAX,DS:ESI.[PNp1+EBX]
 MOV PointActu,EAX               ;PointActu=Dernier point (numero dans tab)
 MOV EAX,ESI.[PNp1]
 MOV PointPlus,EAX               ;PointPlus=Premier point (numero dans tab)
 MOV DWORD PTR [NumPointPlus],0
 MOV EAX,TotalPoint
 DEC EAX
 MOV DWORD PTR [NumPointActu],EAX

 @SR_T_P_M3:                     ;ESI pointe sur poly
  MOV EDI,ESI.[Ptab_P2d]         ;PointActu=numro point 1
  MOV EAX,PointActu              ;PointPlus=numro point 2
  MOV EBX,12                     ;[PointActu+4]=Point 1 texture (x,y)
  MUL EBX                        ;[PointPlus+4]=Point 2 texture (x,y)
  ADD EDI,EAX                    ;EDI Pointe sur le point 1

;dpart des modifs

  ;Fixe PosX et PosY et Pos1Y3D et deltaZ=-pos Z
  MOV EAX,[EDI]
  MOV PosX,EAX
  MOV EAX,[EDI+4]
  MOV PosY,EAX
  MOV EAX,[EDI+8]    ;fixe Z0
  MOV Z0,EAX
  MOV EAX,[EDI+8]   ;calcul Pos1Y3d=PosY*(f+z)/f
  ADD EAX,focusz
  IMUL DWORD PTR [EDI+4]
  IDIV DWORD PTR focusz
  MOV Pos1Y3D,EAX


  ;Fixe PosTx et PosTy Correspondant
   MOV EAX,NumPointActu
   MOV EBX,12
   MUL EBX
   MOV EBX,EAX
   MOV EAX,DS:ESI.[PNp1+EBX+4]
   MOV PosTx,EAX
   MOV EAX,DS:ESI.[PNp1+EBX+8]
   MOV PosTy,EAX

  ;Calcul DeltaY=Point2_Y - Point1_Y et IncPosY fixe Pos2Y3D et calcul deltaZ
  MOV DWORD PTR [MaxOuMin],0
  MOV DWORD PTR [IncPosY],1
  MOV EAX,PointPlus
  MOV EBX,12       
  MUL EBX          
  MOV EDI,ESI.[Ptab_P2d]         
  ADD EDI,EAX                    ;EDI Pointe sur le point 2


 ;coupure 1 pour calculer k1,k2,deltaz,pos2Y3D
  MOV EAX,[EDI+8]                ;calcul Pos2Y3d=PosY*(f+z)/f
  ADD EAX,focusz
  IMUL DWORD PTR [EDI+4]
  IDIV DWORD PTR focusz
  MOV Pos2Y3D,EAX
  MOV EAX,[EDI+8]
  MOV deltaZ,EAX                 ;DeltaZ =z2-z0
  MOV EAX,Z0
  SUB deltaZ,EAX
  MOV EAX,deltaZ
  CMP EAX,0
  JNS @not_0
   NEG EAX
  @not_0:
  MOV K3,EAX

 ;calcul k1=Z0*deltay-deltaZ*y0 et K2=focus*deltay 
  MOV EAX,focusz
  MOV EBX,Pos2Y3D
  SUB EBX,Pos1Y3D
  IMUL EBX
  MOV K2,EAX

  MOV EAX,Z0
  IMUL EBX
  MOV K1,EAX
  MOV EAX,Pos1Y3D
  IMUL DWORD PTR deltaZ
  SUB K1,EAX

 
 ;suite 1
  MOV EAX,[EDI+4]
  SUB EAX,PosY
  JNS @SR_T_P_M5
   MOV DWORD PTR [MaxOuMin],1
   NEG EAX
   NEG DWORD PTR [IncPosY]
  @SR_T_P_M5:
  MOV DeltaY,EAX
  CMP EAX,0
  JNE @SR_T_P_M22
   JMP @SR_T_P_M23
  @SR_T_P_M22:

  ;Calcul IncPosX,DecPosX,CoeffPosX,IncFacPosX
   MOV DWORD PTR [DECPosX],80000000H
   MOV DWORD PTR [IncFacPosX],1
   MOV EAX,[EDI]
   SUB EAX,PosX
   JNS @SR_T_P_M6
    NEG DWORD PTR [IncFacPosX]
   @SR_T_P_M6:
   CDQ
   IDIV DWORD PTR [DeltaY]
   MOV IncPosX,EAX
   CMP EDX,0
   JNS @SR_T_P_M7
    NEG EDX
   @SR_T_P_M7:
   XOR EAX,EAX
   DIV DWORD PTR [DeltaY]
   MOV CoeffPosX,EAX

  ;Calcul IncPosTX,DecPosTX,CoeffPosTX,IncFacPosTX
   MOV DWORD PTR [DECPosTX],80000000H
   MOV DWORD PTR [IncFacPosTX],1
   MOV EAX,NumPointPlus
   MOV EBX,12
   MUL EBX
   MOV EBX,EAX
   MOV EAX,DS:ESI.[PNp1+EBX+4]
   SUB EAX,PosTx
   JNS @SR_T_P_M8
    NEG DWORD PTR [IncFacPosTX]
   @SR_T_P_M8:
   CDQ
   MOV EBX,DeltaY
   ADD EBX,K3
   IDIV EBX
   MOV IncPosTX,EAX
   CMP EDX,0
   JNS @SR_T_P_M9
    NEG EDX
   @SR_T_P_M9:
   XOR EAX,EAX
   MOV EBX,DeltaY
   ADD EBX,K3
   DIV EBX
   MOV CoeffPosTX,EAX

  ;Calcul IncPosTY,DecPosTY,CoeffPosTY,IncFacPosTY
   MOV DWORD PTR [DECPosTY],80000000H
   MOV DWORD PTR [IncFacPosTY],1
   MOV EAX,NumPointPlus
   MOV EBX,12
   MUL EBX
   MOV EBX,EAX
   MOV EAX,DS:ESI.[PNp1+EBX+8]
   SUB EAX,PosTy
   JNS @SR_T_P_M10
    NEG DWORD PTR [IncFacPosTY]
   @SR_T_P_M10:
   CDQ
   MOV EBX,DeltaY
   ADD EBX,K3
   IDIV EBX
   MOV IncPosTY,EAX
   CMP EDX,0
   JNS @SR_T_P_M11
    NEG EDX
   @SR_T_P_M11:
   XOR EAX,EAX
   MOV EBX,DeltaY
   ADD EBX,K3
   DIV EBX
   MOV CoeffPosTY,EAX

  ;Effectue un cliping verticale de la ligne sur l'ecran
   MOV DWORD PTR RognageBas,0
   MOV EDI,ecranz
   MOV EAX,PosY
   CMP EAX,EDI.[Ymin]
   JGE @SR_T_P_M24
    MOV EAX,EDI.[Ymin]
    SUB EAX,PosY
    MOV RognageBas,EAX
   @SR_T_P_M24:
   MOV EAX,PosY
   CMP EAX,EDI.[Ymax]
   JLE @SR_T_P_M25
    SUB EAX,EDI.[Ymax]
    MOV RognageBas,EAX
   @SR_T_P_M25:
  ;Rectifie les position Pos et PosT
  ;Rectifie les variable DecPosT et DecPosX
  ;Rectifie DeltaY
   MOV EAX,CoeffPosX             ;Rectifie PosX
   MUL DWORD PTR [RognageBas] 
   ADD DecPosX,EAX                
   ADC EDX,0
   MOV EAX,EDX
   IMUL DWORD PTR IncFacPosX           
   ADD PosX,EAX                    
   MOV EAX,IncPosX
   IMUL DWORD PTR [RognageBas] 
   ADD PosX,EAX

   MOV EAX,CoeffPosTX             ;Rectifie PosTX
   MUL DWORD PTR [RognageBas] 
   ADD DecPosTX,EAX                
   ADC EDX,0
   MOV EAX,EDX
   IMUL DWORD PTR IncFacPosTX           
   ADD PosTX,EAX                    
   MOV EAX,IncPosTX
   IMUL DWORD PTR [RognageBas] 
   ADD PosTX,EAX

   MOV EAX,CoeffPosTY             ;Rectifie PosTY
   MUL DWORD PTR [RognageBas] 
   ADD DecPosTY,EAX                
   ADC EDX,0
   MOV EAX,EDX
   IMUL DWORD PTR IncFacPosTY           
   ADD PosTY,EAX                    
   MOV EAX,IncPosTY
   IMUL DWORD PTR [RognageBas] 
   ADD PosTY,EAX

   MOV EAX,IncPosY                ;Rectifie PosY
   IMUL DWORD PTR [RognageBas] 
   ADD PosY,EAX

   MOV EAX,RognageBas             ;Rectifie DeltaY
   SUB DeltaY,EAX

  ;Parcour cette ligne
   PUSH ECX
   MOV ECX,DeltaY
   CMP ECX,0
   JG @SR_T_P_M12
    JMP @SR_T_P_M20
   @SR_T_P_M12:
    ;Calcul la position dans le buffer=PosBuffer+(posY-ecran.Ymin]*taille(ligne_mappe)
     MOV EDI,ecranz
     MOV EAX,PosY
     CMP EAX,EDI.[Ymin]
     JGE @SR_T_P_M28
      JMP @SR_T_P_M20
     @SR_T_P_M28:
     CMP EAX,EDI.[Ymax]
     JLE @SR_T_P_M29
      JMP @SR_T_P_M20
     @SR_T_P_M29:
     SUB EAX,EDI.[Ymin]
     MOV EBX,size Ligne_Mappe
     MUL EBX
     ADD EAX,PosBuffer
     MOV EDI,EAX              ;EDI point sur la bonne entre dans le buffer
     CMP DWORD PTR [MaxOuMin],0
     JNE @SR_T_P_M17          ;Fixe les pos min (Pos_X1,Pos_X1T,Pos_Y1T)
      MOV EAX,PosX
      MOV EDI.[Pos_X1],EAX
      MOV EAX,PosTX
      MOV EDI.[Pos_X1T],EAX
      MOV EAX,PosTY
      MOV EDI.[Pos_Y1T],EAX
     JMP @SR_T_P_M16
     @SR_T_P_M17:
      MOV EAX,PosX
      MOV EDI.[Pos_X2],EAX
      MOV EAX,PosTX
      MOV EDI.[Pos_X2T],EAX
      MOV EAX,PosTY
      MOV EDI.[Pos_Y2T],EAX
    @SR_T_P_M16:

    ;Traite PosY
    MOV EAX,IncPosY
    ADD PosY,EAX

    ;Traite PosX
    MOV EAX,IncPosX
    ADD PosX,EAX
    MOV EAX,CoeffPosX
    ADD DecPosX,EAX
    JNC @SR_T_P_M13
     MOV EAX,IncFacPosX
     ADD PosX,EAX
    @SR_T_P_M13:

    ;Traite PosTX
    MOV EAX,IncPosTX
    ADD PosTX,EAX
    MOV EAX,CoeffPosTX
    ADD DecPosTX,EAX
    JNC @SR_T_P_M14
     MOV EAX,IncFacPosTX
     ADD PosTX,EAX
    @SR_T_P_M14:

    ;Traite PosTY
    MOV EAX,IncPosTY
    ADD PosTY,EAX
    MOV EAX,CoeffPosTY
    ADD DecPosTY,EAX
    JNC @SR_T_P_M15
     MOV EAX,IncFacPosTY
     ADD PosTY,EAX
    @SR_T_P_M15:

    ;Correction de la posT par Z
    ;calcul diffZ

     MOV EBX,PosY

     MOV EAX,deltaZ
     IMUL EBX
     SUB EAX,K2
     MOV DiffZ,EAX

     MOV EAX,deltaZ
     IMUL EBX
     ADD EAX,K1
     MOV EBX,FocusZ
     NEG EBX
     IMUL EBX
     IDIV Dword PTR DiffZ   ;EAX=Z
     SUB EAX,Z0
     MOV DiffZ,EAX
     ADD Z0,EAX


   PUSH ECX
    CMP DWORD PTR DiffZ,0
    JE @ECX0
    MOV ECX,DiffZ
    CMP ECX,0
    JNS @NoTECX0
     NEG ECX
    @NoTECX0:
     ;Traite PosTX
     MOV EAX,IncPosTX
     ADD PosTX,EAX
     MOV EAX,CoeffPosTX
     ADD DecPosTX,EAX
     JNC @SR_T_P_M140
      MOV EAX,IncFacPosTX
      ADD PosTX,EAX
     @SR_T_P_M140:

     ;Traite PosTY
     MOV EAX,IncPosTY
     ADD PosTY,EAX
     MOV EAX,CoeffPosTY
     ADD DecPosTY,EAX
     JNC @SR_T_P_M150
      MOV EAX,IncFacPosTY
      ADD PosTY,EAX
     @SR_T_P_M150:
    LOOPD @NoTECX0
   @ECX0:

   POP ECX



   DEC ECX
   JECXZ @SR_T_P_M18
   JMP @SR_T_P_M12
   @SR_T_P_M18:

   ;Dernire ligne mapp
   ;Calcul la position dans le buffer=PosBuffer+(posY-ecran.Ymin]*taille(ligne_mappe)
     MOV EDI,ecranz
     MOV EAX,PosY
     CMP EAX,EDI.[Ymin]
     JGE @SR_T_P_M30
      JMP @SR_T_P_M20
     @SR_T_P_M30:
     CMP EAX,EDI.[Ymax]
     JLE @SR_T_P_M31
      JMP @SR_T_P_M20
     @SR_T_P_M31:
     SUB EAX,EDI.[Ymin]
     MOV EBX,size Ligne_Mappe
     MUL EBX
     ADD EAX,PosBuffer
     MOV EDI,EAX              ;EDI point sur la bonne entre dans le buffer
     CMP DWORD PTR [MaxOuMin],0
     JNE @SR_T_P_M21          ;Fixe les pos min (Pos_X1,Pos_X1T,Pos_Y1T)
      MOV EAX,PosX
      MOV EDI.[Pos_X1],EAX
      MOV EAX,PosTX
      MOV EDI.[Pos_X1T],EAX
      MOV EAX,PosTY
      MOV EDI.[Pos_Y1T],EAX
     JMP @SR_T_P_M20
     @SR_T_P_M21:
      MOV EAX,PosX
      MOV EDI.[Pos_X2],EAX
      MOV EAX,PosTX
      MOV EDI.[Pos_X2T],EAX
      MOV EAX,PosTY
      MOV EDI.[Pos_Y2T],EAX
    @SR_T_P_M20:
   POP ECX

  @SR_T_P_M23:

  ;Actualise PointPlus et PointActu
  MOV EAX,PointPlus     ;PointActu=PointPlus
  MOV PointActu,EAX
  MOV EAX,TotalPoint
  SUB EAX,ECX
  INC EAX
  MOV EBX,12
  MUL EBX
  MOV ESI,Poly
  MOV EBX,EAX
  MOV EAX,DS:ESI.[PNp1+EBX]
  MOV PointPlus,EAX

  ;Actualise NumPointPlus et NumPointActu
  MOV EAX,NumPointPlus
  MOV NumPointActu,EAX
  INC DWORD PTR NumPointPlus
  DEC ECX
  JECXZ @SR_T_P_M4
 JMP @SR_T_P_M3
 @SR_T_P_M4:

 ;Dessine les ligne contenu dans le buffer
 MOV EDI,ecranZ
 MOV EAX,PosYmini
 MOV PosY,EAX
 SUB EAX,EDI.[Ymin]
 MOV EBX,size Ligne_Mappe
 MUL EBX
 ADD EAX,PosBuffer
 MOV EDI,EAX
 MOV ECX,PosYmaxi
 SUB ECX,PosYmini
 INC ECX
@SR_T_P_M34:
 push ecx
 push edi
  PUSH DWORD PTR PosY
  PUSH DWORD PTR EDI.[Pos_X1]
  PUSH DWORD PTR EDI.[Pos_X2]
  PUSH DWORD PTR EDI.[Pos_X1T]
  PUSH DWORD PTR EDI.[Pos_Y1T]
  PUSH DWORD PTR EDI.[Pos_X2T]
  PUSH DWORD PTR EDI.[Pos_Y2T]
  PUSH DWORD PTR texturez
  PUSH DWORD PTR ecranz
  PUSH DWORD PTR maskz
  CALL SR_TRACE_LIGNE_MAPPE_RAM_ECRAN_AVECMASQUE
  pop edi
  INC DWORD PTR PosY
  ADD EDI,size Ligne_mappe
  pop ecx
 loopd @SR_T_P_M34

 ADD SP,TailleBuffer
 @SR_T_P_M33:
 POP EBX
 POP ECX
 POP ES
 POP DS
 POP ESI
 POP EDI
 POP BP
 ADD SP,TEMP_buffer
RETN 16
ENDP

TRACE_POLYGONE_MAPPE_AVECMASQUE MACRO poly,ecranz,maskz,focusz
 PUSH DWORD PTR poly
 PUSH DWORD PTR ecranz
 PUSH DWORD PTR maskz
 PUSH DWORD PTR focusz
 CALL SR_TRACE_POLYGONE_MAPPE_AVECMASQUE
ENDM
