TITLE Fonction pour grer les fonction 3d


.CODE

;*****************************************************************************
;   Effectue la rotation d'un tableaux de point 3D autour de l'axe des Z X=>Y
;*****************************************************************************
;    Entree : angle de rotation (DWORD)
;             diviseur pour l'angle (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs rotation
;*****************************************************************************
;   REMARQUE: Il faut dabord lancer la fonction init_cosin_tab
;             newX = X*cos(RZ) - Y*sin(RZ)
;             newY = X*sin(RZ) + Y*cos(RZ)
;             newZ = Z
;*****************************************************************************
TEMP_buffer=24
 cosangle=[BP+2]
 sinangle=[BP+6]
 newx=[BP+10]
 newY=[BP+14]
 A180=[BP+18]
 Amult=[BP+22]


;Parametre passer  la fonction
 angle=[BP+16+TEMP_buffer]            ;angle z de rotation
 divi=[BP+12+TEMP_buffer]             ;diviseur de l'angle
 ofs32_tabd=[BP+8+TEMP_buffer]        ;ofs32 tab depart
 ofs32_taba=[BP+4+TEMP_buffer]        ;ofs32 tab arriv

SR_ROTATE_P3D_AXEZ PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

  FINIT                     ;Initialise coprocesseur

  MOV DWORD PTR a180,180
  MOV DWORD PTR amult,07FFFFFFFH

  FILD DWORD PTR divi
  FILD DWORD PTR amult      ;Charge valeur 07FFFFFFFH
  FLDPI                     ;charge valeur de pi
  FILD DWORD PTR a180       ;Charge valeur 180

  FILD DWORD PTR angle      ;Calcul sinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FDIV ST(0),ST(4)
  FSIN
  FMUL ST(0),ST(3)
  FISTP DWORD PTR SinAngle

  FILD DWORD PTR angle      ;Calcul Cosinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FDIV ST(0),ST(4)
  FCOS
  FMUL ST(0),ST(3)
  FISTP DWORD PTR CosAngle

  XOR AX,AX
  MOV DS,AX

  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX


  @SR_R_P_AZ1:
   ADD EDI,12
   ADD ESI,12

   ;newX = X*cos(RZ) - Y*sin(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newx,EAX                  ;Calcul newX
                                 ;
   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   SUB newx,EAX                  ;

   ;newY = X*sin(RZ) + Y*cos(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newy,EAX                  ;Calcul newY
                                 ;
   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   ADD newy,EAX                  ;

   MOV EAX,newX                  ;
   MOV [EDI],EAX                 ;Fixe les nouvelles valeurs
   MOV EAX,newY                  ;
   MOV [EDI+4],EAX               ;

   ;newZ=Z

   MOV EAX,[ESI+8]               ; Fixe newZ
   MOV [EDI+8],EAX               ;

  LOOPD @SR_R_P_AZ1

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 16
ENDP

ROTATE_P3D_AXEZ MACRO angle,divi,ofs32d,ofs32a
 PUSH DWORD PTR angle
 PUSH DWORD PTR divi
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_ROTATE_P3D_AXEZ
ENDM

;*****************************************************************************
;   Effectue la rotation d'un tableaux de point 3D autour de l'axe des X Y=>Z
;*****************************************************************************
;    Entree : angle de rotation (DWORD)
;             diviseur de l'angle
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs rotation
;*****************************************************************************
;   REMARQUE: Il faut dabord lancer la fonction init_cosin_tab
;             newX = X
;             newY = Y*cos(RX) - Z*sin(RX)
;             newZ = Y*sin(RX) + Z*cos(RX)
;
;*****************************************************************************

TEMP_buffer=24
 cosangle=[BP+2]
 sinangle=[BP+6]
 newy=[BP+10]
 newz=[BP+14]
 A180=[BP+18]
 Amult=[BP+22]

;Parametre passer  la fonction
 angle=[BP+16+TEMP_buffer]            ;angle z de rotation
 divi=[BP+12+TEMP_buffer]             ;diviseur
 ofs32_tabd=[BP+8+TEMP_buffer]        ;ofs32 tab depart
 ofs32_taba=[BP+4+TEMP_buffer]        ;ofs32 tab arriv

SR_ROTATE_P3D_AXEX PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

  FINIT                     ;Initialise coprocesseur

  MOV DWORD PTR a180,180
  MOV DWORD PTR amult,07FFFFFFFH

  FILD DWORD PTR divi
  FILD DWORD PTR amult      ;Charge valeur 07FFFFFFFH
  FLDPI                     ;charge valeur de pi
  FILD DWORD PTR a180       ;Charge valeur 180

  FILD DWORD PTR angle      ;Calcul sinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FDIV ST(0),ST(4)
  FSIN
  FMUL ST(0),ST(3)
  FISTP DWORD PTR SinAngle

  FILD DWORD PTR angle      ;Calcul Cosinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FDIV ST(0),ST(4)
  FCOS
  FMUL ST(0),ST(3)
  FISTP DWORD PTR CosAngle


  XOR AX,AX
  MOV DS,AX

  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX


  @SR_R_P_AX1:
   ADD EDI,12
   ADD ESI,12

   ;newZ = Y*sin(RX) + Z*cos(RX)

   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newz,EAX                  ;Calcul newZ
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   ADD newz,EAX                  ;

   ;newY = Y*cos(RX) - Z*sin(RX)

   MOV EAX,[ESI+4]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newy,EAX                  ;Calcul newY
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   SUB newy,EAX                  ;

   MOV EAX,newY                  ;
   MOV [EDI+4],EAX               ;Fixe les nouvelles valeurs
   MOV EAX,newZ                  ;
   MOV [EDI+8],EAX               ;

   ;newX=X

   MOV EAX,[ESI]                 ; Fixe newX
   MOV [EDI],EAX                 ;

  LOOPD @SR_R_P_AX1

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 16
ENDP

ROTATE_P3D_AXEX MACRO angle,divi,ofs32d,ofs32a
 PUSH DWORD PTR angle
 PUSH DWORD PTR divi
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_ROTATE_P3D_AXEX
ENDM


;*****************************************************************************
;   Effectue la rotation d'un tableaux de point 3D autour de l'axe des Y X=>Z
;*****************************************************************************
;    Entree : angle de rotation (DWORD)
;             diviseur de l'angle
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs rotation
;*****************************************************************************
;   REMARQUE: Il faut dabord lancer la fonction init_cosin_tab
;
;             newX = X*cos(RZ) - Z*sin(RZ)
;             newZ = X*sin(RZ) + Z*cos(RZ)
;             newY = Y
;*****************************************************************************

TEMP_buffer=24
 cosangle=[BP+2]
 sinangle=[BP+6]
 newx=[BP+10]
 newz=[BP+14]
 A180=[BP+18]
 Amult=[BP+22]

;Parametre passer  la fonction
 angle=[BP+16+TEMP_buffer]            ;angle z de rotation
 divi=[BP+12+TEMP_buffer]             ;diviseur
 ofs32_tabd=[BP+8+TEMP_buffer]        ;ofs32 tab depart
 ofs32_taba=[BP+4+TEMP_buffer]        ;ofs32 tab arriv

SR_ROTATE_P3D_AXEY PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

  FINIT                     ;Initialise coprocesseur

  MOV DWORD PTR a180,180
  MOV DWORD PTR amult,07FFFFFFFH

  FILD DWORD PTR divi
  FILD DWORD PTR amult      ;Charge valeur 07FFFFFFFH
  FLDPI                     ;charge valeur de pi
  FILD DWORD PTR a180       ;Charge valeur 180

  FILD DWORD PTR angle      ;Calcul sinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FDIV ST(0),ST(4)
  FSIN
  FMUL ST(0),ST(3)
  FISTP DWORD PTR SinAngle

  FILD DWORD PTR angle      ;Calcul Cosinus de l'angle
  FMUL ST(0),ST(2)
  FDIV ST(0),ST(1)
  FDIV ST(0),ST(4)
  FCOS
  FMUL ST(0),ST(3)
  FISTP DWORD PTR CosAngle

  XOR AX,AX
  MOV DS,AX

  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX


  @SR_R_P_AY1:
   ADD EDI,12
   ADD ESI,12

   ;newZ = X*sin(RZ) + Z*cos(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newz,EAX                  ;Calcul newZ
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   ADD newz,EAX                  ;

   ;newX = X*cos(RZ) - Z*sin(RZ)

   MOV EAX,[ESI]                 ;
   IMUL DWORD PTR cosangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   MOV newx,EAX                  ;Calcul newX
                                 ;
   MOV EAX,[ESI+8]               ;
   IMUL DWORD PTR sinangle       ;
   MOV EBX,7FFFFFFFH             ;
   IDIV EBX                      ;
   SUB newx,EAX                  ;

   MOV EAX,newX                  ;
   MOV [EDI],EAX                 ;Fixe les nouvelles valeurs
   MOV EAX,newZ                  ;
   MOV [EDI+8],EAX               ;

   ;newY=Y

   MOV EAX,[ESI+4]               ; Fixe newY
   MOV [EDI+4],EAX               ;

  LOOPD @SR_R_P_AY1

 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 16
ENDP

ROTATE_P3D_AXEY MACRO angle,divi,ofs32d,ofs32a
 PUSH DWORD PTR angle
 PUSH DWORD PTR divi
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_ROTATE_P3D_AXEY
ENDM


;*****************************************************************************
;   Effectue la translation d'un tableaux de point 3D suivant les axes x,y,z
;*****************************************************************************
;    Entree : transX (DWORD)
;             transY (DWORD)
;             transZ (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs translation
;*****************************************************************************
;   REMARQUE: newX = X+TX
;             newY = Y+TY
;             newZ = Z+TZ
;*****************************************************************************

;Parametre passer  la fonction
 TransX=[BP+20]           ;Translation X
 TransY=[BP+16]           ;Translation Y
 TransZ=[BP+12]           ;Translation Z
 ofs32_tabd=[BP+8]        ;ofs32 tab depart
 ofs32_taba=[BP+4]        ;ofs32 tab arriv

SR_TRANSLATE_P3D PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX
  XOR AX,AX
  MOV DS,AX
  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX

  @SR_T_P1:
   ADD EDI,12
   ADD ESI,12

   MOV EAX,[ESI]      ;
   ADD EAX,TransX     ;Traite posX
   MOV [EDI],EAX      ;

   MOV EAX,[ESI+4]    ;
   ADD EAX,TransY     ;Traite posY
   MOV [EDI+4],EAX    ;

   MOV EAX,[ESI+8]    ;
   ADD EAX,TransZ     ;Traite posZ
   MOV [EDI+8],EAX    ;
  LOOPD @SR_T_P1

 POP ECX
 POP DS
 POP BP
RETN 20
ENDP

TRANSLATE_P3D MACRO tranX,tranY,tranZ,ofs32d,ofs32a
 PUSH DWORD PTR tranX
 PUSH DWORD PTR tranY
 PUSH DWORD PTR tranZ
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_TRANSLATE_P3D
ENDM

;*****************************************************************************
;       Projette un tableaux de point pour donner une impression 3D
;*****************************************************************************
;    Entree : longueur du focus de la camera (DWORD)
;             pointeur tableau de points  traiter  (DWORD)
;             pointeur tableaux de points de sortie (DWORD)
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs projection
;*****************************************************************************
;   REMARQUE: newX = X-(Z*X)/f
;             newY = Y-(Z*Y)/f
;             newZ = Z
;*****************************************************************************

;Parametre passer  la fonction
 focusc=[BP+12]           ;Focus lentille 
 ofs32_tabd=[BP+8]        ;ofs32 tab depart
 ofs32_taba=[BP+4]        ;ofs32 tab arriv

SR_PROJETTE_P3D PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX
  XOR AX,AX
  MOV DS,AX
  MOV EDI,ofs32_taba
  MOV ESI,ofs32_tabd
  MOV EAX,[ESI]
  MOV [EDI],EAX
  MOV ECX,EAX

  @SR_P_P1:
   MOV EAX,12
   ADD EDI,EAX
   ADD ESI,EAX

  MOV EAX,focusc
  NEG EAX
  CMP DWORD PTR [ESI+8],EAX
  JLE @SR_P_P0

   MOV EAX,[ESI]          ;Traite posX
   MOV EBX,focusc         ;
   IMUL EBX               ;new x = x*focus/(focus+z)
   ADD EBX,[ESI+8]        ;
   IDIV EBX               ;
   MOV [EDI],EAX          ;

   MOV EAX,[ESI+4]        ;Traite posY
   MOV EBX,focusc         ;
   IMUL EBX               ;new y = y*focus/(focus+z)
   ADD EBX,[ESI+8]        ;
   IDIV EBX               ;
   MOV [EDI+4],EAX        ;

  JMP @SR_P_P2
  @SR_P_P0:

   MOV EAX,[ESI]          ;Traite posX
   IMUL DWORD PTR focusc
   MOV [EDI],EAX          ;

   MOV EAX,[ESI+4]        ;Traite posY
   IMUL DWORD PTR focusc
   MOV [EDI+4],EAX        ;

  @SR_P_P2:

   MOV EAX,[ESI+8]        ;Traite posZ
   MOV [EDI+8],EAX        ;
  LOOPD @SR_P_P1

 POP ECX
 POP DS
 POP BP
RETN 12
ENDP

PROJETTE_P3D MACRO focusc,ofs32d,ofs32a
 PUSH DWORD PTR focusc
 PUSH DWORD PTR ofs32d
 PUSH DWORD PTR ofs32a
 CALL SR_PROJETTE_P3D
ENDM


;*****************************************************************************
;       Fait tourner un tableau de point 3D par rapport  un axe quelconque
;*****************************************************************************
;    Entree : angle de rotation (DWORD)
;             diviseur d'angle  (DWORD)
;             Numro du point origine  (DWORD)
;             Numro du 2em point de l'axe (DWORD)
;             Tableaux de point  tourner
;             Tableau de point de sortie
;*****************************************************************************
;    Sortie : le tableaux de sortie contient les point aprs rotation
;*****************************************************************************
;   REMARQUE: la rotation s'effectue dans le sens trigo
;             le tableau de sortie doit etre diffrent du tableau d'entr
;*****************************************************************************

TEMP_buffer=16
 teta=[BP+2]
 zeta=[BP+6]
 A180=[BP+10]
 million=[BP+14]

;Parametre passer  la fonction
 angle=[BP+24+TEMP_buffer]            ;angle de rotation
 divi=[BP+20+TEMP_buffer]             ;diviseur d'angle
 P1=[BP+16+TEMP_buffer]               ;Numro du point origine
 P2=[BP+12+TEMP_buffer]               ;Numro du 2em point 
 TabE=[BP+8+TEMP_buffer]              ;Tableau de point  traiter
 TabS=[BP+4+TEMP_buffer]              ;Tableau de point de sortie

SR_ROTATE_P3D_VECTEUR PROC NEAR
 SUB SP,TEMP_buffer
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ECX

  XOR AX,AX
  MOV DS,AX
  MOV ESI,[TabE]
  MOV EAX,12
  MUL DWORD PTR P1
  ADD ESI,EAX

 ;Translate le tableau de point de -p1
  MOV EAX,DWORD PTR [ESI]
  NEG EAX
  PUSH EAX
  MOV EAX,DWORD PTR [ESI+4]
  NEG EAX
  PUSH EAX
  MOV EAX,DWORD PTR [ESI+8]
  NEG EAX
  PUSH EAX
  PUSH DWORD PTR TabE
  PUSH DWORD PTR TabS
  CALL SR_TRANSLATE_P3D

  ;Calcul TETA=tang-1(z/x)  +180 suivant signe de z 
   MOV ESI,[TabS]
   MOV EAX,12
   MUL DWORD PTR P2
   ADD ESI,EAX
   MOV DWORD PTR TETA,0
   CMP DWORD PTR [ESI+8],0
   JE @SR_R_P_V1
    FINIT                     ;initialise coprocesseur
    MOV DWORD PTR A180,180
    MOV DWORD PTR Million,1000000
    FILD DWORD PTR Million
    FLDPI                     ;charge valeur de pi
    FILD DWORD PTR A180       ;charge valeur A180
    FILD DWORD PTR [ESI+8]    ;charge valeur de Z 
    FILD DWORD PTR [ESI]      ;charge valeur de X
    FPATAN
    FMUL ST(0),ST(1)
    FMUL ST(0),ST(3)
    FDIV ST(0),ST(2)
    FISTP DWORD PTR TETA
   @SR_R_P_V1:
   CMP DWORD PTR [ESI+8],0    ;Si Z ngatif +180
   JNS @SR_R_P_V0
    ADD DWORD PTR TETA,180
   @SR_R_P_V0:

  ;Tourne le tableau de point de -TETA
   MOV EAX,DWORD PTR TETA
   NEG EAX
   PUSH EAX
   PUSH DWORD PTR 1000000
   PUSH DWORD PTR TabS
   PUSH DWORD PTR TabS
   CALL SR_ROTATE_P3D_AXEY

  ;Calcul ZETA=tang-1(y/x) +180  suivant signe de y
   MOV ESI,[TabS]
   MOV EAX,12
   MUL DWORD PTR P2
   ADD ESI,EAX
   MOV DWORD PTR ZETA,0
   CMP DWORD PTR [ESI+4],0
   JE @SR_R_P_V2
    FINIT                     ;initialise coprocesseur
    MOV DWORD PTR A180,180
    MOV DWORD PTR Million,1000000
    FILD DWORD PTR Million
    FLDPI                     ;charge valeur de pi
    FILD DWORD PTR A180       ;charge valeur A180
    FILD DWORD PTR [ESI+4]    ;charge valeur de Y
    FILD DWORD PTR [ESI]      ;charge valeur de X
    FPATAN
    FMUL ST(0),ST(1)
    FMUL ST(0),ST(3)
    FDIV ST(0),ST(2)
    FISTP DWORD PTR ZETA
   @SR_R_P_V2:
   CMP DWORD PTR [ESI+4],0    ;Si Y ngatif +180
   JNS @SR_R_P_V3
    ADD DWORD PTR ZETA,180
   @SR_R_P_V3:

  ;Tourne le tableau de point de -ZETA
   MOV EAX,DWORD PTR ZETA
   NEG EAX
   PUSH EAX
   PUSH DWORD PTR 1000000
   PUSH DWORD PTR TabS
   PUSH DWORD PTR TabS
   CALL SR_ROTATE_P3D_AXEZ

  ;Tourne le tableau de l'angle souhait angle/divi
   PUSH DWORD PTR angle
   PUSH DWORD PTR divi
   PUSH DWORD PTR TabS
   PUSH DWORD PTR TabS
   CALL SR_ROTATE_P3D_AXEX

  ;Tourne le tableau de Zeta
   PUSH DWORD PTR ZETA
   PUSH DWORD PTR 1000000
   PUSH DWORD PTR TabS
   PUSH DWORD PTR TabS
   CALL SR_ROTATE_P3D_AXEZ

  ;Tourne le tableau de Teta    
   PUSH DWORD PTR TETA
   PUSH DWORD PTR 1000000
   PUSH DWORD PTR TabS
   PUSH DWORD PTR TabS
   CALL SR_ROTATE_P3D_AXEY


 ;Translate le tableau de point de p1
  MOV ESI,[TabE]
  MOV EAX,12
  MUL DWORD PTR P1
  ADD ESI,EAX
  PUSH DWORD PTR [ESI]
  PUSH DWORD PTR [ESI+4]
  PUSH DWORD PTR [ESI+8]
  PUSH DWORD PTR TabS
  PUSH DWORD PTR TabS
  CALL SR_TRANSLATE_P3D


 POP ECX
 POP DS
 POP BP
 ADD SP,TEMP_buffer
RETN 24
ENDP

ROTATE_P3D_VECTEUR MACRO angle,divi,p1,p2,tabE,tabS
 PUSH DWORD PTR angle
 PUSH DWORD PTR divi
 PUSH DWORD PTR p1
 PUSH DWORD PTR p2
 PUSH DWORD PTR TabE
 PUSH DWORD PTR TabS
 CALL SR_ROTATE_P3D_VECTEUR
ENDM
