TITLE fonction pour grer les images BMP

;*****************************************************************************
;                        Charge une image BMP 24 bit
;*****************************************************************************
;  PARAMETRE: Pointeur sur nom du fichier (DWORD)
;  SORTIE   : Pointeur32 sur structure ecran
;****************************************************************************
;  REMARQUE : necessite HIMEM.FNC et VESA.FNC
;****************************************************************************

BMPF STRUC
 BMPFtype    DW 0
 BMPFsize    DD 0
 BMPFreser   DD 0
 BMPFofsByte DD 0
ENDS

BMPI STRUC
 BMPIsize     DD 0
 BMPIlarg     DD 0
 BMPIhaut     DD 0
 BMPIplane    DW 0
 BMPIbitCount DW 0
 BMPIcompress DD 0
 BMPIsizeI    DD 0
 BMPIppmX     DD 0
 BMPIppmY     DD 0
 BMPIcused    DD 0
 BMPIcimp     DD 0
ENDS


;Variables locales
 BUFFERBMPtaille=640*10
 TEMP_buffer=6+size BMPF+size BMPI+BUFFERBMPtaille
 handle_fic=[BP+2]
 BMPFV=[BP+4]
 BMPIV=[BP+4+size BMPF]
 BUFFERBMP=[BP+4+size BMPF+size BMPI]
 BMPecran=[BP+4+size BMPF+size BMPI+BUFFERBMPtaille]
 Numligne=[BP+8+size BMPF+size BMPI+BUFFERBMPtaille]

;Parametre passer  la fonction
 ofs32_nom_fichier=[BP+4+TEMP_buffer]    

SR_CHARGE_IMAGE_BMP24_CONVERTVIDEO PROC NEAR
 SUB SP,TEMP_BUFFER
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ES
 PUSH EDI

 XOR AX,AX
 MOV ES,AX

;Ouvre le fichier
 MOV EAX,ofs32_nom_fichier ;
 MOV DX,AX                 ;DS:DX=seg,ofs nom du fichier
 AND DX,1111b              ;
 SHR EAX,4                 ;
 MOV DS,AX                 ;
 MOV AL,0                  ;Mode d'ouverture=lecture
 MOV AH,3DH                         
 INT 21H                            
 MOV handle_fic,AX
;Le fichier est ouvert

;Charge l'Header de l'image
  MOV AX,SS                   
  MOV DS,AX
  MOV DX,BP
  ADD DX,4
  MOV BX,handle_fic
  MOV CX,size BMPF + size BMPI
  MOV AH,3FH
  INT 21H
;Header charg

;crer la structure ecran pour recevoir l'image
 MOV AX,@DATA
 MOV DS,AX
 PUSH DWORD PTR BMPIV.[BMPIlarg]
 PUSH DWORD PTR BMPIV.[BMPIhaut]
 PUSH DWORD PTR 0
 PUSH DWORD PTR 0
 PUSH DWORD PTR 0
 PUSH DWORD PTR 0
 PUSH DWORD PTR BMPIV.[BMPIlarg]
 PUSH DWORD PTR BMPIV.[BMPIhaut]
 MOV AL,MODE_information.[BitsPerPixel]
 AND EAX,0FFH
 SHR EAX,3
 SHL EAX,2
 OR EAX,1
 PUSH DWORD PTR EAX
 CALL SR_CREATE_ECRAN_RAM
 MOV BMPecran,EAX
;L'ecran pour recevoir l'image et cr

;Charge l'image en mmoire
MOV EAX,BMPIV.[BMPIlarg]
MOV EBX,BMPIV.[BMPIhaut]
DEC EBX
MUL EBX
MOV BL,MODE_information.[BitsPerPixel]
AND EBX,0FFH
SHR EBX,3
MUL EBX

MOV EDI,BMPecran
XOR BX,BX
MOV DS,BX
MOV EDI,EDI.[ADD32_ecran]
ADD EDI,EAX

MOV ECX,BMPIV.[BMPIhaut]

@SR_C_I_B_CV0:
  PUSH ECX
  PUSH EDI

  MOV AX,SS                                   ;
  MOV DS,AX                                   ;Charge une ligne complete
  MOV DX,BP                                   ; dans le buffer temporaire. 
  ADD DX,4+size BMPF+size BMPI                ;
  MOV BX,handle_fic                           ;
  MOV ECX,BMPIV.[BMPIlarg]                    ;
  ADD ECX,BMPIV.[BMPIlarg]                    ;
  ADD ECX,BMPIV.[BMPIlarg]                    ;
  MOV AH,3FH                                  ;
  INT 21H                                     ;

  POP EDI
  PUSH EDI
  MOV ECX,BMPIV.[BMPIlarg]
  MOV AX,SS
  AND EAX,0FFFFH
  SHL EAX,4
  ADD EAX,4+size BMPF+size BMPI
  AND EBP,0FFFFH
  ADD EAX,EBP
  MOV ESI,EAX
  XOR AX,AX
  MOV DS,AX
  @SR_C_I_B_CV1:
   MOV AX,[ESI]
   SHR AX,3
   AND AX,011111b
   MOV BX,[ESI+1]
   SHR BX,2
   SHL BX,5
   AND BX,011111100000b
   MOV DX,[ESI+2]
   SHR DX,3
   SHL DX,11
   AND DX,01111100000000000b
   OR AX,BX
   OR AX,DX
   MOV [EDI],AX
   ADD EDI,2
   ADD ESI,3
  LOOPD @SR_C_I_B_CV1

  POP EDI
  PUSH DS
  MOV AX,@DATA
  MOV DS,AX
  MOV EAX,BMPIV.[BMPIlarg]
  MOV BL,MODE_information.[BitsPerPixel]
  AND EBX,0FFH
  SHR EBX,3
  MUL EBX
  SUB EDI,EAX
  POP DS

  POP ECX
  DEC ECX
 JECXZ @SR_C_I_B_CV2
JMP @SR_C_I_B_CV0
 @SR_C_I_B_CV2:

 MOV BX,Handle_fic              ; Ferme le fichier
 MOV AH,3EH                      
 INT 21H                         

 MOV EAX,BMPecran

 POP EDI
 POP ES
 POP DS
 POP BP
 ADD SP,TEMP_BUFFER
 RETN 4
ENDP


CHARGE_IMAGE_BMP24_CONVERTVIDEO MACRO nomfichier
LOCAL nomf
.DATA
 nomf DB nomfichier,0
.CODE
 MOV EAX,@DATA
 AND EAX,0FFFFH
 SHL EAX,4
 ADD EAX,offset nomf
 PUSH EAX
 CALL SR_CHARGE_IMAGE_BMP24_CONVERTVIDEO
ENDM
