TITLE fonction pour grer des objets 3D

;Structure d'un point 3D
POINT3d STRUC
 X DD 0
 Y DD 0
 Z DD 0
ENDS

;Structure d'un polygone
Polygone STRUC
 PAttribut  DD 0
 PTab_P3d   DD 0
 PTab_P2d   DD 0
 Ptexture   DD 0
 Pnormale   DD 0
 PNb_Points DD 0
 PNp1       DD 0
 P1Tx       DD 0
 P1Ty       DD 0
 PNp2       DD 0
 P2Tx       DD 0
 P2Ty       DD 0
 PNp3       DD 0
 P3Tx       DD 0
 P3Ty       DD 0
ENDS

Objet3D STRUC
 Objet3D_NbFrm DD 0       ;Nombre de forme dans l'objet
ENDS                      ;Pointeur sur les formes

;Structure d'une forme 3D
Forme3D STRUC
 Forme3D_NbPoly   DD 0    ;Attribut de la forme
 Forme3D_TabP3D   DD 0    ;Pointeur sur tableau de point de la forme
 Forme3D_TabP2D   DD 0    ;Pointeur sur tableau de point de la forme
ENDS                      ;Polygones de l'objet 

.CODE
;*****************************************************************************
;                        Charge un objet3D.obj
;*****************************************************************************
;  PARAMETRE: Pointeur sur nom du fichier (DWORD)
;  SORTIE   : Pointeur32 sur structure objet
;****************************************************************************
;  REMARQUE : necessite HIMEM.FNC et BMP.FNC
;****************************************************************************


;Variables locales
 BUFFERligne=256
 TEMP_buffer=26+Bufferligne
 ofsTexte=[BP+2]
 handle_fic=[BP+6]
 ReadBuffer=[BP+8]
 NBpoint=[BP+8+Bufferligne]
 NBpoly=[BP+12+Bufferligne]
 handleMem=[BP+16+Bufferligne]
 NumFrm=[BP+20+Bufferligne]
 NombreFrm=[BP+24+Bufferligne]

;Parametre passer  la fonction
 ofs32_nom_fichier=[BP+4+TEMP_buffer]    
SR_CHARGE_OBJET3D PROC NEAR
 SUB SP,TEMP_BUFFER
 PUSH BP
 MOV BP,SP
 PUSH DS
 PUSH ES

;Ouvre le fichier
 MOV EAX,ofs32_nom_fichier ;
 MOV DX,AX                 ;DS:DX=seg,ofs nom du fichier
 AND DX,1111b              ;
 SHR EAX,4                 ;
 MOV DS,AX                 ;
 MOV AL,0                  ;Mode d'ouverture=lecture
 MOV AH,3DH                         
 INT 21H                            
 MOV handle_fic,AX
;Le fichier est ouvert
  MOV DWORD PTR NumFrm,0

  MOV AX,SS                                   ;DS=SS
  MOV DS,AX                                   ;
  XOR AX,AX
  MOV ES,AX

 ;recherche mot clef (.xxxx)
  @SR_C_O_Cherche_prochain_mot_clef:
  MOV DX,BP                                   ; dans le buffer temporaire.
  ADD DX,8                                    ;
  MOV BX,handle_fic                           ;
  CALL SR_CHARGE_OBJET_0

  CMP DWORD PTR [ReadBuffer+1],'INIF'         ;Test si mot clef FINI
  JNE @SR_C_O_PASfini
   JMP @SR_C_O_fini
  @SR_C_O_PASfini:

  CMP DWORD PTR [ReadBuffer+1],'ENEG'         ;Test si mot clef GENE
  JNE @SR_C_O_notGene                         ;description gnrale du fichier

   MOV BX,handle_fic                          ;
   MOV DX,BP                                  ;Lit le nombre de forme
   ADD DX,8                                   ;
   CALL SR_CHARGE_OBJET_1                     ;
   MOV DX,BP                                  ;
   ADD DX,8                                   ;
   CALL SR_CHARGE_OBJET_2                     ;
   MOV NombreFrm,EAX
   SHL EAX,2
   ADD EAX,size Objet3D
   SHR EAX,10                                 ; alloue la mmoire necessaire
   INC AX                                     ;
   PUSH AX                                    ;
   CALL SR_ALLOUE_EMB                         ;
   MOV HandleMem,EAX                          ;
   MOV EDI,HandleMem
   MOV EAX,NombreFrm
   MOV ES:[EDI],EAX

  JMP @SR_C_O_Cherche_prochain_mot_clef
  @SR_C_O_notGene:
  CMP DWORD PTR [ReadBuffer+1],'MRFN'         ;Test si mot clef Nfrm
  JNE @SR_C_O_Cherche_prochain_mot_clef       ;Nouvelle forme
   XOR AX,AX
   MOV ES,AX
   MOV BX,handle_fic                           
   MOV DX,BP
   ADD DX,8                                   
   CALL SR_CHARGE_OBJET_3
   MOV EDI,EAX
   MOV EAX,NumFrm
   MOV EBX,4
   MUL EBX
   ADD EAX,HandleMem
   ADD EAX,size Objet3D
   XCHG EAX,EDI
   MOV ES:[EDI],EAX
   INC DWORD PTR NumFrm
  JMP @SR_C_O_Cherche_prochain_mot_clef
 @SR_C_O_fini:

 MOV BX,Handle_fic              ; Ferme le fichier
 MOV AH,3EH                      
 INT 21H                         
 MOV EAX,HandleMem

 POP ES
 POP DS
 POP BP
 ADD SP,TEMP_BUFFER
 RETN 4
ENDP


;Sous fonction necessaire
;sous fonction 0: recherche un (le prochain) mot clef
;Parametre DS:DX=offset buffer
;          BX=handle fichier
SR_CHARGE_OBJET_0 PROC NEAR
 @SR_C_O_cherche_mot_clef:                    
  PUSH DX
  CALL SR_CHARGE_OBJET_1
  POP DX
  MOV SI,DX
  CMP byte ptr DS:[SI],'.'
 JNE @SR_C_O_cherche_mot_clef
RETN
ENDP

;Sous fonction necessaire
;sous fonction 1: lit une ligne jusqu'a un 'CR' 
;Parametre DS:DX=offset buffer
;          BX=handle fichier
SR_CHARGE_OBJET_1 PROC NEAR
PUSH EDI
PUSH ES
 @SR_C_O_S1:
  MOV ECX,1                                   
  MOV AH,3FH
  INT 21H                                     
  MOV SI,DX
  INC DX
  CMP byte PTR DS:[SI],10
  JNE @SR_C_O_S1
 @SR_C_O_S2:
POP ES
POP EDI
RETN
ENDP

;sous fonction 2: renvoie la valeur en EAX de la chaine 
;Parametre DS:DX=offset buffer
;Sortie EAX=valeur de la chaine
SR_CHARGE_OBJET_2 PROC NEAR
PUSH ECX
PUSH EBX
  XOR EAX,EAX
  MOV SI,DX

  @S_C_O_S21:
   MOV CL,DS:[SI]
   INC SI
   SUB CL,48
   CMP CL,10
   JA @S_C_O_S20
   MOV EBX,10
   MUL EBX
   AND ECX,0FFH
   ADD EAX,ECX
  JMP @S_C_O_S21
 @S_C_O_S20:

  MOV DX,SI
POP EBX
POP ECX
RETN
ENDP

;sous fonction 3: charge une forme et renvoie en EAX un pointeur
;Parametre DS:DX=offset buffer
;Sortie EAX=Pointeur sur forme
temp_buffer=24
HandlePoint3D=[BP+2]
HandlePoint2D=[BP+6]
NombrePoint=[BP+10]
NombrePolygone=[BP+14]
HandleForme=[BP+18]
TextureActive=[BP+22]

SR_CHARGE_OBJET_3 PROC NEAR
 SUB SP,TEMP_BUFFER
 PUSH BP
 MOV BP,SP
 PUSH ECX

   PUSH DX                                    ;
   CALL SR_CHARGE_OBJET_0                     ;
   POP DX                                     ;

 ;Charge les points
   PUSH DX                                    ;
   CALL SR_CHARGE_OBJET_1                     ;
   POP DX                                     ;

   PUSH DX                                    ;
   CALL SR_CHARGE_OBJET_2                     ;
   POP DX                                     ;EAX=nombre de points
   MOV NombrePoint,EAX                        ;

   PUSH DX                                    ;
   PUSH BX                                    ;
   INC EAX                                    ;Alloue la mmoire pour les points
   MOV EBX,size Point3D                       ;
   MUL EBX                                    ;
   PUSH EAX                                   ;
   SHR EAX,9                                  ;
   INC AX                                     ;
   PUSH AX                                    ;
   CALL SR_ALLOUE_EMB                         ;
   MOV HandlePoint3D,EAX                      ;
   POP EBX                                    ;
   ADD EAX,EBX                                ;
   MOV HandlePoint2D,EAX                      ;
   POP BX                                     ;
   POP DX                                     ;

   MOV EDI,HandlePoint3D                      ;
   MOV EAX,NombrePoint                        ;
   MOV ES:[EDI],EAX                           ;
   MOV EDI,HandlePoint2D                      ;
   MOV ES:[EDI],EAX                           ;
   ADD EDI,Size Point3D

   MOV ECX,NombrePoint
   @SR_C_O_F0:
   PUSH ECX
   PUSH DX

    PUSH DX                                    ;
    CALL SR_CHARGE_OBJET_1                     ;
    POP DX                                     ;

    CALL SR_CHARGE_OBJET_2                     ;EAX=Point3D X
    MOV ES:[EDI.X],EAX

    CALL SR_CHARGE_OBJET_2                     ;EAX=Point3D Y
    MOV ES:[EDI.Y],EAX

    CALL SR_CHARGE_OBJET_2                     ;EAX=Point3D Z
    MOV ES:[EDI.Z],EAX

    ADD EDI,Size Point3D                       

   POP DX
   POP ECX
   LOOPD @SR_C_O_F0                            ;Les point sont chargs

   PUSH DX                                    ;
   CALL SR_CHARGE_OBJET_0                     ;
   POP DX                                     ;

 ;Charge les polygones
   PUSH DX                                    ;
   CALL SR_CHARGE_OBJET_1                     ;
   POP DX                                     ;

   PUSH DX                                    ;
   CALL SR_CHARGE_OBJET_2                     ;
   POP DX                                     ;EAX=nombre de polygones
   MOV NombrePolygone,EAX                     ;
   ADD EAX,7*size Point3D+size Forme3D        ;

   PUSH DX                                    ;Alloue la mmoire necessaire
   PUSH BX                                    ;
    SHR EAX,10                                ;
    INC AX                                    ;
    PUSH AX                                   ;
    CALL SR_ALLOUE_EMB                        ;
    MOV HandleForme,EAX                       ;
   POP BX                                     ;
   POP DX                                     ;

   MOV EDI,HandleForme                        ;Fixe les variables de la forme
   MOV EAX,HandlePoint3D                      ;
   MOV ES:[EDI.Forme3D_TabP3D],EAX            ;
   MOV EAX,HandlePoint2D                      ;
   MOV ES:[EDI.Forme3D_TabP2D],EAX            ;
   MOV EAX,NombrePolygone                     ;
   MOV ES:[EDI.Forme3D_NBpoly],EAX            ;
   ADD EDI,Size Forme3D                       ;


   @SR_C_O_F1:

   PUSH DX                                    ;Vas au polygone (ou texture)
   CALL SR_CHARGE_OBJET_0                     ; suivant.
   POP DX                                     ;
   MOV SI,DX

   CMP DWORD PTR DS:[SI+1],'YLOP'             ;Test si poly ou texture
   JNE @SR_C_O_F2                             ;Charge polygone
    PUSH DX
    PUSH DX                                   ;
    CALL SR_CHARGE_OBJET_1                    ;Lit variable du polygone
    POP DX                                    
    CALL SR_CHARGE_OBJET_2                    ;Fixe attibut polygone
    MOV ES:[EDI.Pattribut],EAX
    MOV EAX,HandlePoint3D                     ;Fixe TabP3d polygone
    MOV ES:[EDI.Ptab_P3D],EAX
    MOV EAX,HandlePoint2D                     ;Fixe TabP2d polygone
    MOV ES:[EDI.Ptab_P2D],EAX
    MOV EAX,TextureActive                     ;Fixe Texture polygone
    MOV ES:[EDI.Ptexture],EAX
    CALL SR_CHARGE_OBJET_2                    ;Fixe normale polygone
    MOV ES:[EDI.Pnormale],EAX
    CALL SR_CHARGE_OBJET_2                    ;Fixe nombre de point polygone
    MOV ES:[EDI.PNb_points],EAX
    ADD EDI,24
    MOV ECX,EAX                               ;Lit et fixe les points
    @SR_C_O_F5:                               
     CALL SR_CHARGE_OBJET_2                   ;Lit numero du point
     MOV ES:[EDI.X],EAX
     CALL SR_CHARGE_OBJET_2                   ;Lit coordon X de la texture
     MOV ES:[EDI.Y],EAX
     CALL SR_CHARGE_OBJET_2                   ;Lit coordon Y de la texture
     MOV ES:[EDI.Z],EAX
     ADD EDI,size Point3D
    LOOPD @SR_C_O_F5
    POP DX
    DEC DWORD PTR NombrePolygone
    CMP DWORD PTR NombrePolygone,0
   JE @SR_C_O_F3
   @SR_C_O_F2:                                
   CMP DWORD PTR DS:[SI+1],'TXET'             ;Test si texture
   JNE @SR_C_O_F3                             
    PUSH DX                                   ;Charge texture
    PUSH BX
    PUSH EDI

    PUSH DX                                    ;
    CALL SR_CHARGE_OBJET_1                     ;Lit non du fichier
    POP DX                                     ;ajout 0 a la fin du nom
    MOV SI,DX
    @SR_C_O_F4:
     INC SI
     MOV EAX,DWORD PTR DS:[SI]
     OR EAX,20202000H
     CMP EAX,'pmb.'
    JNE @SR_C_O_F4
     MOV BYTE PTR DS:[SI+4],0
     MOV AX,DS
     AND EAX,0FFFFH
     SHL EAX,4
     AND EDX,0FFFFH
     ADD EAX,EDX
     PUSH EAX
     CALL SR_CHARGE_IMAGE_BMP24_CONVERTVIDEO
     MOV TextureActive,EAX

    POP EDI
    POP BX
    POP DX
   JMP @SR_C_O_F1
   @SR_C_O_F3:
   MOV EAX,HandleForme

 POP ECX
 POP BP
 ADD SP,TEMP_BUFFER
 RETN
ENDP



CHARGE_OBJET3D MACRO nomfichier
LOCAL nomf
.DATA
 nomf DB nomfichier,0
.CODE
 MOV EAX,@DATA
 AND EAX,0FFFFH
 SHL EAX,4
 ADD EAX,offset nomf
 PUSH EAX
 CALL SR_CHARGE_OBJET3D
ENDM



;*****************************************************************************
;                        Affiche un objet3D
;*****************************************************************************
;  PARAMETRE: Handle de l'objet,structure ecran,masque d'ecran
;****************************************************************************
;  REMARQUE : necessite une fonction TRACE_POLYGONE_MAPPE_AVECMASQUE x,x,x
;****************************************************************************

;Parametre passer  la fonction
 obj3D=[BP+12]    
 ecranz=[BP+8]    
 maskz=[BP+4]    

SR_AFFICHE_OBJET3D PROC NEAR
 PUSH BP
 MOV BP,SP
 PUSH DS
  XOR AX,AX
  MOV DS,AX

  MOV ESI,obj3D
  MOV ECX,[ESI.Objet3D_NbFrm]
  ADD ESI,size Objet3D
  @SR_A_O0:
  PUSH ECX
  PUSH ESI
  MOV EDI,[ESI]
  MOV ECX,[EDI.Forme3D_NbPoly]
  ADD EDI,size Forme3D

   @SR_A_O1:
   PUSH ECX
   PUSH EDI
    PUSH EDI
    PUSH DWORD PTR ecranz
    PUSH DWORD PTR maskz
    CALL SR_TRACE_POLYGONE_MAPPE_AVECMASQUE
   POP EDI
    MOV EAX,[EDI.PNB_points]
    MOV EBX,size Point3D
    MUL EBX
    ADD EAX,24
    ADD EDI,EAX
   POP ECX
   LOOPD @SR_A_O1

  POP ESI
  ADD ESI,4
  POP ECX
  LOOPD @SR_A_O0 

 POP DS
 POP BP
 RETN 12
ENDP


AFFICHE_OBJET3D MACRO obje,ecr,mask
 PUSH DWORD PTR obje
 PUSH DWORD PTR ecr
 PUSH DWORD PTR mask
 CALL SR_AFFICHE_OBJET3D
ENDM
