DROITE  =1
GAUCHE  =0
HAUT    =0
BAS     =1
YES     =1
NO      =0
OUI     =1
NON     =0
CACHE   =2
PROTEGE =1
SYSTEM  =4
DEBFICH =0
POSACTU =1
FINFICH =2
LECTURE =0
ARCHIVE =2
ECRITURE=1


;MACROS-GENERALES (Mode 32 bits).

;********************************************
;***   PLUSIEURS MACROS A USAGE GENERALES ***
;********************************************

;**Debut du segment data***
VAR MACRO
.DATA
 DTA      DB 21 DUP(?)
 ATTRIBUT DB 0
 HEURE    DB 2 DUP(?)
 DATE     DB 2 DUP(?)
 TAILLE   DD 0
 NOM      DB 13 DUP (?)

ENDM

;**Debut d'un programme***

DEBUT MACRO
.CODE       
START: MOV  AX,@DATA
       MOV  DS,AX
       MOV  BX,SS      ;Calculer l'intervalle entre le PSP et la pile
       MOV  AX,ES                                     ;en paragraphes
       SUB  BX,AX

       MOV  AX,SP                      ;Calculer l'tat de la pile en
       ADD  AX,15                                     ;en paragraphes
       MOV  CL,4
       SHR  AX,CL                       ;Contenu, longueur de la pile

       ADD  BX,AX                           ;Ajouter les deux valeurs

       MOV  AH,4AH                   ;Seule cette mmoire doit rester
       INT  21H                                             ;rserve

       MOV AH,1AH                     ;Initialise l'adresse de la dta.
       LEA DX,DTA
       INT 21H

ENDM

FIN MACRO
FINISH: 
 MOV AH,4CH
 INT 21H
 END START
ENDM




;**Fixe le mode video courant.**

MODE MACRO EC
  MOV  AL,EC
  MOV  AH,00
  INT  10H
ENDM

;**Sauve le mode video courant.**

SAVE_MODE MACRO HMODE
  MOV AH,0FH
  INT 10H
  MOV HMODE,AL
ENDM
 
;**Retour au dos avec code d'erreur.**

EXIT_DOS MACRO ERREUR
 MOV AL,ERREUR
 JMP FINISH 
ENDM

;**Dbut de declaration des routines.**
ROUTINES MACRO
 JMP FINISH
ENDM

;*******************
;**  Macro text  ***
;*******************

GOTO MACRO  POSX,POSY
  MOV AH,0FH
  INT 10H
  MOV DL,POSX
  MOV DH,POSY
  MOV AH,02
  INT 10H
ENDM

ECRIT MACRO TEXT
  LEA DX,TEXT
  MOV AH,09
  INT 21H
ENDM

TEXT_PAGE MACRO PAGE
  MOV AH,5
  MOV AL,PAGE
  INT 10H
ENDM


;*******************************
;** Macro pour les fichiers. ***    
;*******************************

INFO_FILE MACRO NOM,ATRIB
 MOV DX,OFFSET NOM
 MOV CX,ATRIB
 MOV AH,4EH
 INT 21H
ENDM

MAKE_FILE MACRO NOM,HANDLE,TYPE
  MOV DX,OFFSET NOM
  MOV CX,TYPE
  MOV AH,03CH
  INT 21H
  MOV [HANDLE],AX
ENDM

OPEN_FILE MACRO NOM,HANDLE,TYPE
  MOV DX,OFFSET NOM
  MOV AL,TYPE
  MOV AH,03dH
  INT 21H
  MOV [HANDLE],AX
ENDM

CLOSE_FILE MACRO HANDLE
  MOV BX,HANDLE
  MOV AH,03EH
  INT 21H
ENDM

READ_FILE MACRO HANDLE,NBOCTETS,SEGMENT,OF
  MOV BX,HANDLE
  MOV CX,NBOCTETS
  PUSH DS
  MOV AX,SEG SEGMENT
  MOV DS,AX
  MOV DX,OF
  MOV AH,03FH
  INT 21H
  POP DS
ENDM

WRITE_FILE MACRO HANDLE,NBOCTETS,SEGMENT,OF
  MOV BX,HANDLE
  MOV CX,NBOCTETS
  PUSH DS
  MOV AX,SEG SEGMENT
  MOV DS,AX
  MOV DX,OFFSET OF
  MOV AH,040H
  INT 21H
  POP DS
ENDM

MOVE_POINTEUR MACRO HANDLE,POS,BA
  MOV BX,HANDLE
  MOV ECX,POS
  PUSH ECX
  SAR ECX,16
  POP EDX
  MOV AL,BA
  MOV AH,042H
  INT 21H
ENDM

;*********************************
;*** Macro d'accs a la memoire **
;*********************************

COPY_bytes MACRO SEGdepart,SEGarrive,NBoctets
  CLI
  PUSH DS
  MOV CX,NBoctets
  MOV AX,SEGarrive
  MOV ES,AX
  MOV AX,SEGdepart
  MOV DS,AX
  XOR DI,DI
  XOR SI,SI
  CLD
  REP MOVSB
  POP DS
  STI
ENDM

COPY_words MACRO SEGdepart,SEGarrive,NBoctets
  CLI
  PUSH DS
  MOV CX,NBoctets
  MOV AX,SEGarrive
  MOV ES,AX
  MOV AX,SEGdepart
  MOV DS,AX
  XOR DI,DI
  XOR SI,SI
  CLD
  REP MOVSW
  POP DS
  STI
ENDM

COPY_dwords MACRO SEGdepart,SEGarrive,NBoctets
  CLI
  PUSH DS
  MOV CX,NBoctets
  MOV AX,SEGarrive
  MOV ES,AX
  MOV AX,SEGdepart
  MOV DS,AX
  XOR DI,DI
  XOR SI,SI
  CLD
  REP MOVSD
  POP DS
  STI
ENDM

GET_mem MACRO VAR,TAILLE
  MOV EBX,TAILLE 
  SHR EBX,4
  INC EBX
  MOV AH,048H
  INT 21H
  MOV VAR,AX
ENDM

FREE_mem MACRO VAR
  MOV ES,VAR
  MOV AH,049H
  INT 21H
ENDM

FILL_bytes MACRO SEGM,OFF,NOMBRE,BYTE
  CLI
  MOV AX,SEGM
  MOV ES,AX
  MOV DI,OFF
  MOV CX,NOMBRE
  MOV AL,BYTE
  CLD
  REP STOSB
  STI
ENDM

FILL_words MACRO SEGM,OFF,NOMBRE,WORD
  CLI
  MOV AX,SEGM
  MOV ES,AX
  MOV DI,OFF
  MOV CX,NOMBRE
  MOV AX,WORD
  CLD
  REP STOSW
  STI
ENDM

FILL_dwords MACRO SEGM,OFF,NOMBRE,DWORD
  CLI
  MOV AX,SEGM
  MOV ES,AX
  MOV DI,OFF
  MOV CX,NOMBRE
  MOV EAX,DWORD
  CLD
  REP STOSD
  STI
ENDM

PAUSE MACRO TEMP
 MOV ECX,TEMP
 MOV DX,CX
 SHR ECX,16
 MOV AH,86H
 INT 15H
ENDM

OUTB MACRO PORT,VAL
 MOV DX,PORT
 MOV AL,VAL
 OUT DX,AL
ENDM

INB MACRO PORT
 MOV DX,PORT
 IN AL,DX
ENDM
