

;********************************************
;*** Routines pour l'affichage de sprites ***
;***  dans le mode VGA 320*200/256c.      ***
;********************************************
EMS  =1
NOEMS=0


SPRITES_ROUTINES MACRO

 
 SPR_MEM_DECODE:
   CLI
   CLD
   LODSW 
   CMP AX,0
   JE FIN_DECODE
   ADD DI,AX
   LODSW
   MOV CX,AX
   REP MOVSB
   JMP SPR_MEM_DECODE
  FIN_DECODE:
  STI
 RET

 AFFICHE_SPRITE: 
  PUSH DS
  PUSH DX
  MOV DS,AX
  
  XOR SI,SI                 
  CLD
  LODSW                      ;Lit le nombre de sprite pour ce handle
  CMP BX,AX                  ;Si le numero demander est plus grand 
  JAE FIN_AFFICHE_spr        ;que le nombre maximal de sprites alors on sort.

  MOV AX,4
  MUL BX
  ADD SI,AX
  


  CLD
  LODSW
  PUSH AX
  LODSW
  MOV BX,DS
  ADD AX,BX
  MOV DS,AX
  POP SI
  
  LODSW

  LODSW
  MOV BX,2
  MUL BX
  ADD SI,AX

  
  LODSW
  MOV BL,2
  DIV BL
  SUB CX,AX
  
  LODSW
  MOV BL,2
  DIV BL
  POP DX
  SUB DX,AX



  MOV DI,CX
  MOV AX,DX
  MOV BX,20
  MUL BX 
  MOV BX,ES
  ADD AX,BX
  MOV ES,AX

  CALL SPR_MEM_DECODE
 
  FIN_AFFICHE_SPR:
  POP DS
 RET

 LOADSPRITE:  
  JMP suiteloadsprite
  si_ DW 0
  DX_  DW 0

suiteloadsprite:
  MOV DX_,DX
  XOR CX,CX
  MOV AH,4EH
  INT 21H

  MOV EBX,TAILLE
  MOV EAX,EBX
  SHR EAX,16
  ADD EBX,EAX
  PUSH EBX                 ;Empile la taille du fichier.
  SHR EBX,4
  MOV AH,048H
  INT 21H
  MOV SI,SI_
  MOV WORD PTR DS:[SI],AX

  MOV DX,DX_
  MOV AL,0
  MOV AH,03DH
  INT 21H
  POP EBX               ;Depile la taille du fichier.
  PUSH AX               ;Empile le handle du fichier ouvert.
  PUSH DS               ;Empile DS.
  
  MOV CX,BX
  PUSH BX               ;Empile l'octet de poid faible. 
  SHR EBX,16
  PUSH BX               ;Empile l'octet de poid fort de la taille.
  MOV BX,AX
  
  MOV SI,SI_
  MOV AX,WORD PTR DS:[SI]
  
  MOV DS,AX
  MOV DX,0
  MOV AH,03FH
  INT 21H
  POP CX                ;Depile l'octet de poid fort de la taille.
  POP DX                ;Depile l'octet de poid faible de la taille.
  CMP CX,0
  JZ FINloadsprite


 LOADsprite01:  
  PUSH CX
  
  MOV CX,0FFFFH
  MOV AH,03FH
  INT 21H
  MOV AX,DS
  ADD AX,4096
  MOV DS,AX
  DEC DX
  POP CX
  LOOP LOADsprite01

 FINloadsprite:  
  
  POP DS
  POP BX                ;Depile le handle du fichier a fermer.
  MOV AH,03EH
  INT 21H               ;Ferme le fichier.
 RET

ENDM

DECODE_SPRITE MACRO  SEGdep,OFFdep,SEGarr,OFFarr
  PUSH DS
  MOV AX,SEGdep
  MOV SI,OFFdep
  MOV BX,SEGarr
  MOV DI,OFFARR
  MOV DS,AX
  MOV ES,BX
  CALL SPR_MEM_DECODE
  POP DS
ENDM

LOAD_SPRITE MACRO NOMfich,Handle
  LEA DX,NOMfich
  MOV CS:[SI_],OFFSET Handle
  CALL LOADsprite
ENDM


PUT_SPRITE MACRO NOM,NUMERO,X,Y,PAGE
  MOV AX,PAGE
  MOV ES,AX
  MOV AX,NOM
  MOV BX,NUMERO
  MOV CX,X
  MOV DX,Y
  CALL AFFICHE_SPRITE 
ENDM




  




