VIDEOSEG=0A000H

;****************************************
;*** MACRO POUR LE MODE 320*200 256c  ***
;****************************************

LOAD_IMG MACRO NOMIMG,ADRESS
  LEA DX,NOMIMG 
  MOV AX,ADRESS
  MOV ES,AX
  CALL STARTloadimg
ENDM

LOAD_PCX MACRO NOMIMG,ADRESS 
 LEA DX,NOMIMG
 MOV AX,ADRESS
 MOV ES,AX
 CALL START_PCX
ENDM

LOAD_PALETTE MACRO NOMIMG
  LEA DX,NOMIMG
  CALL STARTpalette
ENDM

IMAGES_ROUTINES MACRO  
VARloadimg DW 0,0
           DB 0,0

STARTloadimg:
  CLI
  CLD
  MOV AX,3D00H       ;Ouvre le fichier en lecture.
  INT 21H
  JC  FINloadimg                 ;Erreur on s'en va.
  MOV WORD PTR [VARloadimg],AX   ;Sauve le handle.

  MOV BX,1000H                   ;Reserve une memoire tampon,
  MOV AH,48H                     ;de 64K.
  INT 21H
  JC  FINloadimg
  MOV WORD PTR [VARloadimg+2],AX ;Sauve l'adresse de la memoire tampon.

  PUSH DS                        ;Charge le fichier dans la 
  MOV CX,65535                   ;memoire tampon.
  MOV BX,WORD PTR [VARloadimg]
  MOV AX,WORD PTR [VARloadimg+2]
  MOV DS,AX
  MOV DX,0
  MOV AH,3FH
  INT 21H

  MOV AX,WORD PTR [VARloadimg+2]
  MOV DS,AX
  MOV SI,770
  XOR DI,DI
  

BOUCLE1loadimg:            ;Regarde si le code est un code de
  LODSB                    ;repetition.
  CMP AL,BYTE PTR DS:[0]
  JE  REPET16bit
  CMP AL,BYTE PTR DS:[1]
  JE  REPET8bit            ;si non affiche le code.
  CMP DI,64000 
  JAE FIN2loadimg
  STOSB
JMP BOUCLE1loadimg

REPET16bit:                ;Lit le code de repetition, pour 
  LODSB                    ;une repetition de 256 a 65536.
  PUSH AX
  LODSB
  MOV CH,AL
  LODSB
  MOV CL,AL
 JMP AFFICHrepet

REPET8bit:                 ;lit le code est le nombre de repetition,
  LODSB                    ;de moins de 256.
  PUSH AX
  LODSB
  MOV CL,AL
  MOV CH,0
 JMP AFFICHrepet

AFFICHrepet:                ;Affiche un octet de repetition.
  POP AX
  REP STOSB
JMP BOUCLE1loadimg


FIN2loadimg:  
  POP DS                       ;Libere la memoire tampon.
  MOV AX,WORD PTR[VARloadimg+2]
  MOV ES,AX
  MOV AH,49H
  INT 21H

FINloadimg:
  MOV AH,3EH                  ;Ferme le fichier.
  MOV BX,WORD PTR [VARloadimg]
  INT 21H
  STI
RET

;************************************
;*** Charge la Palette d'une image **
;************************************


STARTpalette:
 JMP PALETTEsuite
VARpalette DW 0,0

PALETTEsuite:
  CLI
  MOV AX,3D00H                   ;Ouvre le fichier en lecture. 
  INT 21H
  JC  FINpalette                 ;Erreur on s'en va.
  MOV WORD PTR [VARpalette],AX   ;Sauve le handle.

  MOV BX,48                      ;Reserve une memoire tampon,
  MOV AH,48H                     ;de 768 bytes.
  INT 21H
  JC  FINloadimg
  MOV WORD PTR [VARpalette+2],AX ;Sauve l'adresse de la memoire tampon.
   

  MOV CX,0
  MOV DX,2
  MOV BX,WORD PTR [VARpalette]    ;Deplace le pointeur a la
  MOV AX,4200H                    ;position de la palette dans 
  INT 21H                         ;le fichier.
  
  MOV AX,WORD PTR [VARpalette+2]
  PUSH DS
  MOV DS,AX
  MOV DX,0
  MOV BX,WORD PTR [VARpalette]    ;Transfert dans la memoire tampon.
  MOV CX,768
  MOV AH,3FH
  INT 21H

  
  MOV DX,3C7H
  MOV AL,1
  OUT DX,AL
  MOV DX,03C8H
  MOV AL,0
  OUT DX,AL
 
  
  
  MOV DX,03C9H
  MOV AX,WORD PTR[VARpalette+2]
  MOV DS,AX
  MOV SI,0
  MOV CX,768
  REP OUTSB
  POP DS
  
  
  
  MOV AX,WORD PTR [VARpalette+2] ;Libere la memoire tampon.
  MOV ES,AX
  MOV AH,49H
  INT 21H
 

FINpalette:
  MOV AH,3EH                  ;Ferme le fichier.
  MOV BX,WORD PTR [VARpalette]
  INT 21H
  STI
RET

FAISCEAU:
  MOV DX,03DAH

sp3:  in    al,dx
       test  al,8
       jne   sp3

sp4:  in    al,dx
       test  al,8
       je    sp4
RET

PCXhandle DW 0

START_PCX: 
 PUSH DS
 MOV AX,3D00H
 INT 21H
 JC FIN_LOAD_PCX
 MOV CS:PCXhandle,AX    ;ouvre le fichier;

 MOV AH,48H
 MOV BX,1000H           ;Reserve 65535 octets.
 INT 21H
 MOV DS,AX
 
 MOV AX,4200H            ;Deplace le pointeur a la fin du header.
 MOV CX,0
 MOV DX,128
 MOV BX,CS:PCXhandle
 INT 21H
 
 
 XOR DX,DX
 MOV AH,3FH                    
 MOV CX,0FFFFH           ;Lit dans le fichier;
 MOV BX,CS:PCXhandle
 INT 21H



 ;Debut du decodage.

 XOR SI,SI
 XOR DI,DI
 CLD

DEBUT_DECODE_PCX: 
 
 LODSB
 CMP AL,192
 JA PCX_PAQUET
 STOSB
 CMP DI,64000
  JAE FIN_DECODE_PCX
  JMP DEBUT_DECODE_PCX

PCX_PAQUET:
 SUB AL,192
 AND AX,255
 MOV CX,AX
 LODSB
 REP STOSB
 CMP DI,64000
  JAE FIN_DECODE_PCX
  JMP DEBUT_DECODE_PCX
 
FIN_DECODE_PCX:
                            
                            
 MOV AX,DS                           
 MOV ES,AX
 MOV AH,49H
 INT 21H                    ;libere la memoire tampon.


 MOV AH,3EH                 ;Ferme le fichier.
 MOV BX,CS:PCXhandle
 INT 21H

FIN_LOAD_PCX:
 POP DS
RET
ENDM

;***********************************
;** Definit le RVB d'une couleur ***
;***********************************

PALETTE MACRO COLOR,ROUGE,VERT,BLEU
  MOV DX,3C7H
  MOV AL,1
  OUT DX,AL
  
  MOV DX,03C8H
  MOV AL,COLOR
  OUT DX,AL
  
  MOV DX,03C9H
  MOV AL,ROUGE
  OUT DX,AL
  MOV AL,VERT
  OUT DX,AL
  MOV AL,BLEU
  OUT DX,AL
ENDM

;************************************
;*** Attend le retour du faisceau ***
;*** de l'ecran.                  ***
;************************************

WAIT_FAISCEAU MACRO
 CALL FAISCEAU
ENDM

PUT_PIX MACRO PAGE,X,Y,COL
 MOV AX,Y
 MOV BX,20
 MUL BX
 ADD AX,PAGE
 MOV ES,AX
 MOV DI,X
 MOV AL,COL
 MOV ES:DI,AL
ENDM

GET_PIX MACRO PAGE,X,Y
 MOV AX,Y
 MOV BX,20        
 MUL BX
 ADD AX,PAGE
 MOV ES,AX
 MOV DI,X
 MOV AL,ES:DI
ENDM
 
ECRAN_OFF MACRO
 OUTB 3c4h,01
 INB 3c5h
 OR AL,00100000b
 OUTB 3c5h,al
ENDM

ECRAN_ON MACRO
 OUTB 3c4h,01
 INB 3c5h
 and AL,11011111b
 OUTB 3c5h,al
ENDM

