;****************
;MACROS GENERALES
;****************
IFDEF MACROGENE          ;vite une erreur si le fichier
ELSE                     ;et implment plusieur fois,
                         ;en ne l'implmentant que la premiere fois.
MACROGENE=0

EXTRN VIDEO_SEG:WORD

;******************************
;Dbut du segment de donne et
;alignement des variables
;suivant le processeur.
;******************************

    VAR MACRO
     .DATA             ;Segment de donne
     IFDEF ALIGNE16    ;aligne les donnes suivant le type de processeur choisit.
      ALIGN WORD
     ENDIF
     IFDEF ALIGNE32
      ALIGN DWORD
     ENDIF
                       
     HMOUSEX DW 0      ;
     HMOUSEY DW 0      ;Variable ncessaire pour effacer la souris
     HMOUSEXP DW 0     ;
     HMOUSEYP DW 0     ;

SIN DW 127,129,131,133,135,138,140,142,144,146,149,151,153,155,157,159,162
    DW 164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196
    DW 198,199,201,203,205,206,208,210,211,213,215,216 
    DW 218,219,221,222,224,225,227,228,229,231,232,233,234,235,236,238
    DW 239,240,241,242,243,243,244,245,246,247,247,248,249
    DW 249,250,250,251,251,252,252,252,253,253,253,253,253,253,253,253 
    DW 253,253,253,253,253,253,253,252,252,252,251,251,250,250,249,249,248
    DW 247,247,246,245,244,243,243,242,241,240,239,238,236,235,234,233,232
    DW 231,229,228,227,225,224,222,221,219,218,216 
    DW 215,213,211,210,208,206,205,203,201,199,198,196,194,192,190,188,186
    DW 184,182,180,178,176,174,172,170,168,166,164,162,159,157,155,153,151
    DW 149,146,144,142,140,138,135,133,131,129,127 
    DW 124,122,120,118,115,113,111,109,107,104,102,100,98,96,94,92,89,87,85
    DW 83,81,79,77,75,73,71,69,67,65,63,61,59,57,55,54,52,50,48,47,45,43,42
    DW 40,38,37                                  
    DW 35,34,32,31,29,28,26,25,24,22,21,20,19,18,17,15,14,13,12,11,10,10,9,8
    DW 7,6,6,5,4,4,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0                                                                     
    DW 0,0,0,0,0,0,0,1,1,1,2,2,3,3,4,4,5,6,6,7,8,9,10,10,11,12,13,14,15,17
    DW 18,19,20,21,22,24,25,26,28,29,31,32,34,35,37                                                                    
    DW 38,40,42,43,45,47,48,50,52,54,55,57,59,61,63,65,67,69,71,73,75,77
    DW 79,81,83,85,87,89,91,94,96,98,100,102,104,107,109,111,113,115,118
    DW 120,122,124                                    

    ENDM



;*************************
;Dbut et fin du programme
;*************************

    DEBUT MACRO
     .CODE          ;Segment de code.
     START:         ;point d'entre du programme
     MOV AX,@DATA
     MOV DS,AX      ;Fixe DS.

     ;libre la mmoire non utilis par le programme

     MOV  BX,SS      ;Calculer l'intervalle entre le PSP et la pile
     MOV  AX,ES                                     ;en paragraphes
     SUB  BX,AX

     MOV  AX,SP                      ;Calculer l'tat de la pile en
     ADD  AX,15                                     ;en paragraphes
     MOV  CL,4
     SHR  AX,CL                       ;Contenu, longueur de la pile

     ADD  BX,AX                           ;Ajouter les deux valeurs

     MOV  AH,4AH                   ;Seule cette mmoire doit rester
     INT  21H                                             ;rserve
    ENDM

    FIN MACRO
     MOV AX,4C00H   ;Retourne au systme d'exploitation.
     INT 21H
     END START      ;informe le compilateur que le code se termine ici,
    ENDM            ;et que la premier instrucion  executer se trouve
                    ; l'adresse point par le label START.


;*******************************
;Affiche le curseur de la souris
;*******************************
    AFFICHE_MOUSE MACRO
     PUSHA
      CLI

      MOV AX,HMOUSEX
      MOV BX,HMOUSEY
      MOV HMOUSEXP,AX
      MOV HMOUSEYP,BX

      MOV CX,MOUSEX
      MOV DX,MOUSEY
      
      MOV HMOUSEX,CX
      MOV HMOUSEY,DX


      ADD CX,5
      LIGNE MOUSEX,MOUSEY,CX,DX,23
      ADD DX,5
      LIGNE MOUSEX,MOUSEY,CX,DX,23
      SUB CX,5
      LIGNE MOUSEX,MOUSEY,CX,DX,23
      
      STI
     POPA
    ENDM

;*******************************
;Efface le curseur de la souris
;*******************************
    EFFACE_MOUSE MACRO
     LOCAL @B0,@B1,@B2,@B3,@B4,@B5,@B6

     PUSHA
     PUSH ES
     PUSH DS

      MOV AX,HMOUSEYP               ;
      MOV BX,5                      ;
      MUL BX                        ;Fixe ES:DI
      ADD AX,VIDEO_SEG              ;
      MOV ES,AX                     ;
      MOV DI,HMOUSEXP               ;
      SHR DI,2                      ;

      
      MOV SI,HMOUSEXP               ;
      MOV AX,HMOUSEYP               ;Fixe DS:SI
      MOV BX,20                     ; 
      MUL BX                        ;
      ADD AX,FOND                   ;
      MOV DS,AX                     ;

      PUSH DS                       ;
       MOV AX,@DATA                 ;Traite le plan de bit 0
       MOV DS,AX                    ;
                                    ;
       MOV DX,3C4H                  ;
       MOV AL,2                     ;
       OUT DX,AL                    ; 
       INC DX                       ;
                                    ;
       MOV CX,HMOUSEXP              ;
       AND CL,11b                   ;
       MOV AL,1                     ;
       SHL AL,CL                    ;
       OUT DX,AL                    ;
      POP DS                        ;
                                    ;
      MOV CX,6                      ;
      @B0:                          ;
       MOV AH,DS:[SI]               ;
       MOV ES:[DI],AH               ;
       ADD SI,4                     ;
       MOV AH,DS:[SI]               ;
       MOV ES:[DI+1],AH             ;
       ADD SI,4                     ;
       MOV AH,DS:[SI]               ;
       MOV ES:[DI+2],AH             ; 
       ADD SI,312                   ;
       ADD DI,80                    ;
      LOOP @B0                      ;
      SUB SI,1919

      PUSH DS                       ;
       MOV AX,@DATA                 ;Traite le plan de bit 1
       MOV DS,AX                    ;
                                    ;
       MOV DX,3C4H                  ;
       MOV AL,2                     ;
       OUT DX,AL                    ; 
       INC DX                       ;
                                    ;
       MOV CX,HMOUSEXP              ;
       INC CX                       ;
       MOV DI,CX                    ;
       SHR DI,2                     ;
       AND CL,11b                   ;
       MOV AL,1                     ;
       SHL AL,CL                    ;
       OUT DX,AL                    ;
      POP DS                        ;
                                    ;
      MOV CX,6                      ;
      @B1:                          ;
       MOV AH,DS:[SI]               ;
       MOV ES:[DI],AH               ;
       ADD SI,4                     ;
       MOV AH,DS:[SI]               ;
       MOV ES:[DI+1],AH             ;
       ADD SI,4                     ;
       MOV AH,DS:[SI]               ;
       MOV ES:[DI+2],AH             ; 
       ADD SI,312                   ;
       ADD DI,80                    ;
      LOOP @B1                      ;
      SUB SI,1919

      PUSH DS                       ;
       MOV AX,@DATA                 ;Traite le plan de bit 2
       MOV DS,AX                    ;
                                    ;
       MOV DX,3C4H                  ;
       MOV AL,2                     ;
       OUT DX,AL                    ; 
       INC DX                       ;
                                    ;
       MOV CX,HMOUSEXP              ;
       ADD CX,2                     ;
       MOV DI,CX                    ;
       SHR DI,2                     ;
       AND CL,11b                   ;
       MOV AL,1                     ;
       SHL AL,CL                    ;
       OUT DX,AL                    ;
      POP DS                        ;
                                            myndale@cairo.anu.edu.au


  A simple Pascal Joystick Unit.
}


unit Joy;

Interface

{ Define constants for use as JoystickButton and JoystickPosition parameters }
const JoystickAButton1 = $10;
      JoystickAButton2 = $20;
      JoystickBButton1 = $40;
      JoystickBButton2 = $80;
      JoystickAAxisX   = $01;
      JoystickAAxisY   = $02;
      JoystickBAxisX   = $04;
      JoystickBAxisY   = $08;

function JoystickButton(buttonnum : byte) : boolean;
function JoystickPosition(axisnum : byte) : word;

Implementation

const JOYSTICKPORT = $201;

{ Button returns true is button is pressed }
function JoystickButton(buttonnum : byte) : boolean;
begin
  JoystickButton := (Port[JOYSTICKPORT] and buttonnum) = 0;
end;

{ Returns position value of joystick. The value returned is highly
  dependent on machine speed. Changing the setting of the computer's
  Turbo speed button will affect the value returned.
  Returns $FFFF if the joystick is not connected
}
function JoystickPosition(axisnum : byte) : word;
var count : word;
begin
  asm
    mov word ptr count, 0
    cli          { Disable interrupts so they don't interfere with timing }
    mov dx, JOYSTICKPORT   { Write dummy byte to joystick port }
    out dx, al
    @joystickloop:
    inc count              { Add one to count }
    cmp count, $FFFF       { Check for time out }
    je @done
    in al, dx              { Get joystick port value }
    and al, axisnum        { Test the appropriate bit }
    jne @joystickloop
    @done:
    sti                    { Enable interrupts again }
  end;
  JoystickPosition := count;
end;

end.



 References  


Title : Flights of Fantasy
Author : Christopher Lampton
Publishers : The Waite Group
ISBN : 1-878739-18-2

Title : DOS and BIOS Functions Quick Reference
Publishers : Que Corporation
ISBN : 0-88022-426-6
                                           EEECCCCCCC
FFFFFD