;****************
;Macros graphique
;****************

IFDEF MACROGRAPH         ;vite une erreur si le fichier
ELSE                     ;et implment plusieur fois,
                         ;en ne l'implmentant que la premiere fois.
MACROGRAPH=0

;******************************
;Fonction et variables externes
;******************************
    EXTRN SR_PRINT_CHAR:FAR
    EXTRN SR_PRINT_CHAIN:FAR
    EXTRN SR_PRINT_NOMBRE_SIGNE:FAR
    EXTRN SR_LIGNE:FAR
    EXTRN SR_ACTIVE_PAGE:FAR
    EXTRN SR_LOAD_IMG:FAR
    EXTRN SR_COPY_PAGE:FAR

    EXTRN VIDEO_SEG:WORD
    EXTRN PAGE0_SEG:WORD
    EXTRN PAGE1_SEG:WORD
    EXTRN CHAR_PTR:DWORD


;***************************
; Selectionne la page active
;***************************
    ACTIVE_PAGE MACRO PAGE
     PUSH PAGE
     CALL SR_ACTIVE_PAGE
    ENDM


;*********
;Copy page
;*********
    COPY_PAGE MACRO AD1,AD2
     PUSH AD1
     PUSH AD2
     CALL SR_COPY_PAGE
    ENDM

;*****************
; CHARGE UNE IMAGE 
;*****************
    LOAD_IMG MACRO IMAGE,VAR,RELOAD
    LOCAL IMG
    .DATA
     IMG DB IMAGE,0
    .CODE
     PUSH RELOAD
     PUSH OFFSET VAR
     PUSH OFFSET IMG
     CALL SR_LOAD_IMG
    ENDM

;*****************************
; AFFICHE UN PIXEL 
; NB:ne modifie aucun registre
;*****************************
    PIX MACRO X,Y,couleur
     PUSH AX
     PUSH BX
     PUSH CX
     PUSH DX
     PUSH DI
     PUSH ES

     MOV DX,3C4H      ;adresse le registre MAP MASK du squenceur.
     MOV AL,2
     OUT DX,AL

     MOV AX,Y         ;Calcul le segment dans la ram video.
     MOV BX,5
     MUL BX
     ADD AX,VIDEO_SEG
     MOV ES,AX        

     MOV DX,3C5H
     MOV CX,X         ;calcul le plan de bit adress.
     AND CL,3
     MOV AL,1
     SHL AL,CL
     OUT DX,AL        ;adresse le plan de bit

     MOV DI,X         ;calcul l'offset dans la ram video
     MOV CL,2
     SHR DI,CL        

     MOV AL,couleur   ;affiche le point
     MOV ES:[DI],AL   

     POP ES
     POP DI
     POP DX
     POP CX
     POP BX
     POP AX
    
    ENDM

;********************
;AFFICHE UN CARACTERE
;********************
    PRINT_CHAR MACRO X,Y,Couleur,caractere
     PUSH X
     PUSH Y
     PUSH couleur
     PUSH caractere
     CALL SR_PRINT_CHAR
    ENDM

;********************************
;AFFICHE UNE CHAINE DE CARACTERES
;********************************
    PRINT_CHAIN MACRO X,Y,COULEUR,CHAINE
     LOCAL CHAIN
     .DATA
      CHAIN DB CHAINE,0
     .CODE

     PUSH X
     PUSH Y
     PUSH COULEUR
     PUSH OFFSET CHAIN
     CALL SR_PRINT_CHAIN
    ENDM

;***********************
;AFFICHE UN NOMBRE SIGNE
;***********************
    PRINT_NOMBRE_SIGNE MACRO NB_CHIF,X,Y,couleur,NOMBRE
     PUSH NB_CHIF
     PUSH X
     PUSH Y
     PUSH COULEUR
     PUSH NOMBRE
     CALL SR_PRINT_NOMBRE_SIGNE
    ENDM

;************************************************
;Initialise les variables necessaire au graphique
;************************************************
    INIT_GRAPH MACRO
     PUSHA
     PUSH ES
      MOV AX,1130H
      MOV BH,3
      INT 10H
      MOV WORD PTR [CHAR_PTR],BP
      MOV AX,ES
      MOV WORD PTR [CHAR_PTR+2],AX
     POP ES
     POPA
    ENDM
ENDIF

;*****************
;dessine une ligne
;*****************
    LIGNE MACRO X1,Y1,X2,Y2,couleur
     PUSH X1
     PUSH Y1
     PUSH X2
     PUSH Y2
     PUSH couleur
     CALL SR_LIGNE
    ENDM

;***************************
;dessine une rectangle plein
;***************************

    RECTANGLE_PLEIN MACRO X1,Y1,X2,hauteur,couleur
     LOCAL @B

     PUSH CX
     PUSH AX

     MOV CX,hauteur

     @B:

     MOV AX,Y1
     ADD AX,CX
     PUSH X1
     PUSH AX
     PUSH X2
     PUSH AX
     PUSH couleur
     CALL SR_LIGNE

     LOOP @B

     POP AX
     POP CX
    ENDM

;*************************************************
;Efface une image de la mmoire(libre la mmoire)
;*************************************************
    UNLOAD_IMG MACRO HANDLE
     PUSH ES
     MOV AX,Handle
     MOV ES,AX
     MOV AH,49H
     INT 21H
     POP ES
    ENDM



;dessine une rectangle
;*********************
    RECTANGLE MACRO X1,Y1,X2,hauteur,couleur
     ligne x1,y1,x2,y1,couleur
     ligne x2,y1,x2,y1+hauteur,couleur
     ligne x2,y1+hauteur,x1,y1+hauteur,couleur
     ligne x1,y1+hauteur,x1,y1,couleur
    ENDM
