;*************
;Macros video
;*************
IFDEF MACROVIDEO         ;vite une erreur si le fichier
ELSE                     ;et implment plusieur fois,
                         ;en ne l'implmentant que la premiere fois.
MACROVIDEO=0

;******************************
;Fonction et variables externes
;******************************
    EXTRN Hold_vmode:byte
    EXTRN SR_MONTRE_PAGE:FAR


;*****************************
;Affiche la page video demand
;*****************************
    MONTRE_PAGE MACRO PAGE
     PUSH PAGE
     CALL SR_MONTRE_PAGE
    ENDM



;***************************
;Sauve le mode video courant
;***************************

    SAUVE_VMODE MACRO
      MOV AH,0FH
      INT 10H
      MOV Hold_vmode,AL
    ENDM

;*********************
;restore le mode video
;*********************

    RESTORE_VMODE MACRO
      MOV AH,0
      MOV AL,Hold_vmode
      INT 10H
    ENDM

;******************
;Fixe le mode video
;******************

    VMODE MACRO Mode
      MOV AH,0
      MOV AL,Mode
      INT 10H
    ENDM
;***************************************
; Attend le retour du faisceau verticale
;***************************************
    ATTEND_RETRACE MACRO
     LOCAL @WAIT1,@WAIT2

     PUSH DX

      CLI
      MOV DX,03DAH

      @WAIT1:
       IN AL,DX
       TEST AL,8     
      JZ @WAIT1

      @WAIT2:
       IN AL,DX
       TEST AL,8     
      JNZ @WAIT2
      STI

     POP DX
    ENDM

;****************************
;Passe au mode video lineaire
;****************************

    MODE_lineaire MACRO 
     MOV   DX,03CEH
     MOV   AL,05H           ;indique au controleur graphique
     OUT   DX,AL            ;que les diffrent plan de bits
     INC   DX               ;doivent tre adrss linairement.
     IN    AL,DX
     AND   AL,11101111b
     OUT   DX,AL
     DEC   DX

     MOV   AL,06H           ;Mme info dans un autre registre du cont. graphiqu.
     OUT   DX,AL
     INC   DX
     IN    AL,DX
     AND   AL,11111101b
     OUT   DX,AL            ;indique au squenceur que les plan sont 
     MOV   DX,3C4H          ;trait linairement
     MOV   AL,4
     OUT   DX,AL
     INC   DX
     IN    AL,DX
     AND   AL,11110111b
     OR    AL,4
     OUT   DX,AL
     MOV   AX,0A000h
     MOV   ES,AX
     XOR   DI,DI
     MOV   AX,DI
     MOV   CX,8000h            ;Efface 256K de la mmoire video
     REP   STOSW
     MOV   DX,3D4H             ;ignore le mode DWORD
     MOV   AL,14H              ;pour pouvoir pass le CRT en mode byte.
     OUT   DX,AL               
     INC   DX
     IN    AL,DX
     AND   AL,10111111b
     OUT   DX,AL
     DEC   DX                   ;passe le CRT en mode byte.
     MOV   AL,17H
     OUT   DX,AL
     INC   DX
     IN    AL,DX
     OR    AL,01000000b
     OUT   DX,AL
    ENDM

;*****************************
;Passe au mode video 400 ligne
;*****************************

    VMODE_400 MACRO
     MOV DX,3D4H             ;informe le CRT que les lignes ne sont plus
     MOV AL,09               ;ddoubl,et que la hauteur des cartres=0
     OUT DX,AL
     INC DX
     IN AL,DX
     AND AL,01100000b
     OUT DX,AL
    ENDM

;************************************
;Initialise le mode 320*400 lineaire
;et sauveguarde le mode video courant
;************************************
    INIT_VIDEO MACRO
     SAUVE_Vmode     ;Sauve le mode video courant
     VMODE 19        ;initialise la mode 320*200 chain4
     MODE_lineaire   ;passe au mode 320*200 lineaire
     VMODE_400       ;passe au mode 320*400 lineaire
    ENDM

ENDIF
