;*****************************
;Fonctions Gestion de la carte
;*****************************
    DOSSEG
    .MODEL LARGE
    .286

;**********
;Constantes
;**********
    DONNE=0378H     ;0278H    ;3BC
    STATUS=0379H    ;0279H    ;3BD
    CONTROL=37AH   ;027AH    ;3BE

;********************************
;Dclaration des fonctions public
;********************************
    PUBLIC SR_ECRIT_CAN
    PUBLIC SR_LIT_CAN

;***************************************
;Variables pour les fonctions graphiques
;***************************************
    .DATA


;*******************
;Dbut des fonctions
;*******************
    .CODE

;****************************
;ENVOIE UNE VALEUR A LA CARTE
;****************************
    SR_ECRIT_CAN PROC FAR
     PUSH BP
     MOV BP,SP
     PUSH DX

      MOV DX,DONNE           ;Ecrit la valeur dans le registre de donn
      MOV AL,[BP+6]
      OUT DX,AL


      MOV DX,CONTROL
      IN AL,DX               ;Remet le bit 0 de control  1
      OR AL,1
      OUT DX,AL

      MOV DX,CONTROL
      IN AL,DX
      AND AL,254             ;Met le bit 0 du registre control  0
      OUT DX,AL


     POP DX
     POP BP
    RETF 2
    ENDP

;*********************************************
;RENVOIE EN AX LA VALEUR PRESENTE SUR LA CARTE
;*********************************************

    SR_LIT_CAN PROC FAR
     PUSH DX
     PUSH BX


     MOV DX,CONTROL             ;Met le bit 1 de control  0
     IN AL,DX                  
     AND AL,255-2
     OUT DX,AL

     MOV DX,CONTROL             ;Met le bit 1 de control  1
     IN AL,DX                  
     OR AL,10b
     OUT DX,AL


     MOV DX,STATUS
     @WAIT_BUSY:
      IN AL,DX
      TEST AL,10000000b
     JZ @WAIT_BUSY              ;attend que le bit 7 de status soit  1

     MOV DX,CONTROL
     IN AL,DX
     OR AL,8                    ;Met le bit 3 de control  1
     OUT DX,AL

     MOV DX,STATUS
     IN AL,DX                   ;Lit quartet de poid faible
     SHR AL,3
     AND AL,1111b
     MOV BL,AL

     MOV DX,CONTROL
     IN AL,DX
     AND AL,255-8               ;Met le bit 3 de control  0
     OUT DX,AL


     MOV DX,STATUS
     IN AL,DX                   ;Lit quartet de poid fort
     SHL AL,1
     AND AL,11110000b
     MOV BH,AL

     XOR AH,AH
     MOV AL,BH
     OR AL,BL
     POP BX
     POP DX
    RETF
    ENDP

    END

