/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.ICamera3D;
import net.dzzd.access.IFace3D;
import net.dzzd.access.ILight3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.access.IScene;
import net.dzzd.access.IScene3D;
import net.dzzd.access.ITexture;
import net.dzzd.core.DirectInput;
import net.dzzd.core.Drawer;
import net.dzzd.core.Face3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Mesh3DOctree;
import net.dzzd.core.Point3D;
import net.dzzd.core.Render3D;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;

public final class Render3DSW
extends Render3D {
    private int renderPixelWidth;
    private int renderPixelHeight;
    private double renderPixelWidthDiv2;
    private double renderPixelHeightDiv2;
    private int[] zBuffer;
    private float[] zBufferIzMin;
    private float[] zBufferIzInc;
    private int[] zBufferO;
    private int[] zBufferP;
    private int[] zBufferF;
    private int nbRenderedFace;
    private int nbRenderedMesh;
    private int[] vLinesBufferMin;
    private double[] vLinesBufferMinX;
    private double[] vLinesBufferMinIncX;
    private double[] vLinesBufferMinIz;
    private double[] vLinesBufferMinIncIz;
    private int[] vLinesBufferMax;
    private double[] vLinesBufferMaxX;
    private double[] vLinesBufferMaxIncX;
    private double[] vLinesBufferMaxIz;
    private double[] vLinesBufferMaxIncIz;
    private int hLinesBufferMin;
    private int hLinesBufferMax;
    private int zBufferMode;
    private boolean zBufferOcclusionTest;
    private double noFaceZ;
    private double noFaceIZ;
    private double noFaceX1;
    private int noFaceY1;
    private double noFaceX2;
    private int noFaceY2;
    static final int ZB_WRITE = 1;
    static final int ZB_ALPHA = 2;
    static final int ZB_TEST = 4;
    Drawer drawer;
    int lastRenderBackgroundOffset;
    int firstRenderBackgroundOffset;
    Face3D firstAlphaFace;
    Face3D lastAlphaFace;
    private CompiledMesh firstMeshToRender;
    private CompiledMesh[] compiledMeshes;
    private CompiledMaterial[] compiledMaterials;
    double iZTest;

    public Render3DSW() {
        this.directInput = new DirectInput(this.canvas);
        this.drawer = new Drawer();
        this.initCompiledBuffers();
    }

    private final void initCompiledBuffers() {
        this.compiledMeshes = new CompiledMesh[65536];
        this.compiledMaterials = new CompiledMaterial[1024];
        this.firstMeshToRender = null;
        this.firstRenderBackgroundOffset = -1;
        this.resetBuffers();
    }

    public final void clearScene(IScene iScene) {
        super.clearScene(iScene);
        this.initCompiledBuffers();
    }

    protected final void disposeMesh3D(IMesh3D iMesh3D) {
        int n = iMesh3D.getId();
        CompiledMesh compiledMesh = this.compiledMeshes[n + 1];
        do {
            this.compiledMeshes[n++] = compiledMesh;
        } while ((compiledMesh = this.compiledMeshes[n + 1]) != null);
    }

    protected final void disposeCamera3D(ICamera3D iCamera3D) {
    }

    protected final void disposeLight3D(ILight3D iLight3D) {
    }

    protected final void disposeTexture(ITexture iTexture) {
    }

    protected final void disposeMaterial(IMaterial iMaterial) {
        int n = iMaterial.getId();
        CompiledMaterial compiledMaterial = this.compiledMaterials[n + 1];
        do {
            this.compiledMaterials[n++] = compiledMaterial;
        } while ((compiledMaterial = this.compiledMaterials[n + 1]) != null);
    }

    protected final void compileMesh3D(IMesh3D iMesh3D) {
        super.compileMesh3D(iMesh3D);
        this.compiledMeshes[iMesh3D.getId()] = new CompiledMesh((Mesh3D)iMesh3D);
    }

    protected final void compileMaterial(IMaterial iMaterial) {
        CompiledMaterial compiledMaterial;
        super.compileMaterial(iMaterial);
        this.compiledMaterials[iMaterial.getId()] = compiledMaterial = new CompiledMaterial((Material)iMaterial);
    }

    public final void setSize(int n, int n2, int n3) {
        super.setSize(n, n2, n3);
        this.renderPixelWidth = this.viewPixelWidth;
        this.renderPixelHeight = this.viewPixelHeight;
        if ((this.antialias & 2) != 0) {
            this.renderPixelWidth <<= 1;
        }
        if ((this.antialias & 4) != 0) {
            this.renderPixelHeight <<= 1;
        }
        this.minXValue = 0;
        this.maxXValue = this.renderPixelWidth;
        this.minYValue = 0;
        this.maxYValue = this.renderPixelHeight - 1;
        this.renderPixelWidthDiv2 = this.renderPixelWidth >> 1;
        this.renderPixelHeightDiv2 = this.renderPixelHeight >> 1;
        this.initBuffers();
        this.resetBuffers();
    }

    private final void renderFrameCoherence(IScene3D iScene3D) {
        this.zBufferOcclusionTest = false;
        CompiledMesh compiledMesh = this.getFirstMeshToRender();
        while (compiledMesh != null) {
            Mesh3D mesh3D = compiledMesh.mesh;
            if (mesh3D.isVisible()) {
                if ((mesh3D.renderMode & 1) != 0) {
                    this.prepareMesh3DLocalLight3DBuffer(iScene3D, mesh3D);
                }
                if (mesh3D.getMesh3DViewGenerator() == null) {
                    this.setCurrentMesh3D(mesh3D);
                    CompiledFace compiledFace = compiledMesh.firstFaceToRender;
                    while (compiledFace != null) {
                        this.setFaces3DToZBuffer(mesh3D.getFaces3D(), compiledFace.face.id);
                        compiledFace.lastZbufferImage = this.numImage;
                        compiledFace = compiledFace.nextFaceToRender;
                    }
                }
            }
            compiledMesh = this.getNextMeshToRender(compiledMesh);
        }
        this.zBufferOcclusionTest = true;
    }

    protected final void startFrame(IScene3D iScene3D) {
        this.drawer.setRender3DSW(this);
        this.resetBuffers();
        this.zBufferMode = 1;
        this.firstAlphaFace = null;
        this.lastAlphaFace = null;
        this.renderFrameCoherence(iScene3D);
    }

    protected final void renderFrame(IScene3D iScene3D) {
        super.renderFrame(iScene3D);
    }

    protected final void endFrame(IScene3D iScene3D) {
        if (!this.isPixelUpdateEnabled) {
            return;
        }
        this.prepareFaceBuffer(iScene3D);
        if (iScene3D.isBackgroundEnabled()) {
            this.renderBackground(iScene3D);
        }
        this.drawMesh3D(iScene3D);
        this.drawer.antialiasPixels();
        if (this.isScreenUpdateEnabled) {
            this.drawer.drawPixelsOnCanvas(this.canvas);
        }
    }

    private final void initBuffers() {
        this.zBuffer = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferIzMin = new float[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferIzInc = new float[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferO = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferP = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.zBufferF = new int[this.renderPixelHeight * this.renderPixelWidth];
        this.vLinesBufferMin = new int[this.renderPixelHeight];
        this.vLinesBufferMinX = new double[this.renderPixelHeight];
        this.vLinesBufferMinIncX = new double[this.renderPixelHeight];
        this.vLinesBufferMinIz = new double[this.renderPixelHeight];
        this.vLinesBufferMinIncIz = new double[this.renderPixelHeight];
        this.vLinesBufferMax = new int[this.renderPixelHeight];
        this.vLinesBufferMaxX = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIncX = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIz = new double[this.renderPixelHeight];
        this.vLinesBufferMaxIncIz = new double[this.renderPixelHeight];
        this.drawer.setBuffers(this, this.zBuffer, this.zBufferF);
    }

    private final void resetBuffers() {
        int n = 0;
        for (int i = 0; i < this.renderPixelHeight; ++i) {
            this.zBuffer[n] = this.renderPixelWidth;
            this.zBufferIzMin[n] = (float)this.iZMax;
            this.zBufferIzInc[n] = 0.0f;
            this.zBufferO[n] = -1;
            this.zBufferP[n] = -1;
            n += this.renderPixelWidth;
        }
    }

    public final void setAntialiasLevel(int n) {
        if (n == this.antialias) {
            return;
        }
        this.firstMeshToRender = null;
        this.firstRenderBackgroundOffset = -1;
        super.setAntialiasLevel(n);
    }

    protected final void renderBackground(IScene3D iScene3D) {
        if (this.firstRenderBackgroundOffset == -1) {
            return;
        }
        this.drawer.drawBackground(this.firstRenderBackgroundOffset, this.lastRenderBackgroundOffset, iScene3D.getBackgroundColor());
    }

    protected final void setMesh3DToZBuffer(IMesh3D iMesh3D) {
        this.setFaces3DToZBuffer(iMesh3D.getFaces3D(), -1);
    }

    protected final void setMesh3DOctreeToZBuffer(IMesh3DOctree iMesh3DOctree) {
        this.setFaces3DToZBuffer(iMesh3DOctree.getFaces3D(), -1);
    }

    protected final int isSphereVisible(double d, double d2, double d3, double d4) {
        int n = super.isSphereVisible(d, d2, d3, d4);
        if (!this.zBufferOcclusionTest || n == 0) {
            return n;
        }
        n = this.isSphereVisibleInZBuffer(d, d2, d3, d4);
        return n;
    }

    private final int isSphereVisibleInZBuffer(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5 = this.ox + this.axx * d + this.ayx * d2 + this.azx * d3;
        double d6 = this.oy + this.axy * d + this.ayy * d2 + this.azy * d3;
        double d7 = this.oz + this.axz * d + this.ayz * d2 + this.azz * d3;
        if (d5 * d5 + d6 * d6 + d7 * d7 <= d4 * d4) {
            return 1;
        }
        double d8 = d7 - d4;
        if (d8 <= this.zMin) {
            return 1;
        }
        double d9 = d7 + d4;
        double d10 = 1.0 / d7;
        double d11 = 1.0 / d8;
        double d12 = 1.0 / d9;
        double d13 = d4 * this.screenZoomXFocus * d11;
        double d14 = d4 * this.screenZoomYFocus * d11;
        if (d13 > this.renderPixelWidthDiv2 && d14 > this.renderPixelHeightDiv2) {
            return 1;
        }
        int n4 = (int)((d5 - d4) * this.screenZoomXFocus * d11 + this.renderPixelWidthDiv2);
        int n5 = (int)((d5 + d4) * this.screenZoomXFocus * d11 + this.renderPixelWidthDiv2);
        int n6 = (int)((d5 - d4) * this.screenZoomXFocus * d12 + this.renderPixelWidthDiv2);
        int n7 = (int)((d5 + d4) * this.screenZoomXFocus * d12 + this.renderPixelWidthDiv2);
        int n8 = (int)((d6 - d4) * this.screenZoomXFocus * d11 + this.renderPixelHeightDiv2);
        int n9 = (int)((d6 + d4) * this.screenZoomXFocus * d11 + this.renderPixelHeightDiv2);
        int n10 = (int)((d6 - d4) * this.screenZoomXFocus * d12 + this.renderPixelHeightDiv2);
        int n11 = (int)((d6 + d4) * this.screenZoomXFocus * d12 + this.renderPixelHeightDiv2);
        int n12 = n4;
        if (n5 < n12) {
            n12 = n5;
        }
        if (n6 < n12) {
            n12 = n6;
        }
        if (n7 < n12) {
            n12 = n7;
        }
        if (n5 > (n3 = n4)) {
            n3 = n5;
        }
        if (n6 > n3) {
            n3 = n6;
        }
        if (n7 > n3) {
            n3 = n7;
        }
        if (n9 < (n2 = n8)) {
            n2 = n9;
        }
        if (n10 < n2) {
            n2 = n10;
        }
        if (n11 < n2) {
            n2 = n11;
        }
        if (n9 > (n = n8)) {
            n = n9;
        }
        if (n10 > n) {
            n = n10;
        }
        if (n11 > n) {
            n = n11;
        }
        if (this.minXValue > n3) {
            return 0;
        }
        if (this.maxXValue < n12) {
            return 0;
        }
        if (this.minYValue > n) {
            return 0;
        }
        if (this.maxYValue < n2) {
            return 0;
        }
        if (this.minXValue > n12) {
            n12 = this.minXValue;
        }
        if (this.maxXValue < n3) {
            n3 = this.maxXValue;
        }
        if (this.minYValue > n2) {
            n2 = this.minYValue;
        }
        if (this.maxYValue < n) {
            n = this.maxYValue;
        }
        return this.isSquareVisibleInZBuffer(n12, n2, n3, n, d11);
    }

    private final int isSquareVisibleInZBuffer(int n, int n2, int n3, int n4, double d) {
        this.hLinesBufferMin = n2;
        this.hLinesBufferMax = n4;
        this.vLinesBufferMin[n2] = n4;
        this.vLinesBufferMinX[n2] = n;
        this.vLinesBufferMinIncX[n2] = 0.0;
        this.vLinesBufferMinIz[n2] = d;
        this.vLinesBufferMinIncIz[n2] = 0.0;
        this.vLinesBufferMax[n2] = n4;
        this.vLinesBufferMaxX[n2] = n3;
        this.vLinesBufferMaxIncX[n2] = 0.0;
        this.vLinesBufferMaxIz[n2] = d;
        this.vLinesBufferMaxIncIz[n2] = 0.0;
        this.iZTest = d;
        int n5 = this.zBufferMode;
        this.zBufferMode = 4;
        int n6 = this.pasteHLine(null);
        this.zBufferMode = n5;
        return n6;
    }

    private final CompiledFace getCompiledFace(int n, int n2) {
        return this.compiledMeshes[n].compiledFaces[n2];
    }

    protected final int setFaces3DToZBuffer(IFace3D[] iFace3DArray, int n) {
        int n2 = 0;
        Face3D[] face3DArray = (Face3D[])iFace3DArray;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = face3DArray.length;
        int n4 = 0;
        if (n >= 0) {
            n4 = n;
            n3 = n + 1;
        }
        while (n4 < n3) {
            block46: {
                CompiledFace compiledFace;
                Face3D face3D;
                block48: {
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    double d14;
                    double d15;
                    double d16;
                    double d17;
                    double d18;
                    double d19;
                    double d20;
                    double d21;
                    double d22;
                    block47: {
                        double d23;
                        double d24;
                        block45: {
                            face3D = face3DArray[n4];
                            if ((this.zBufferMode & 2) != 0 || face3D.material == null || face3D.material.alphaLevel == 0) break block45;
                            face3D.nextAlphaFace = null;
                            if (this.firstAlphaFace == null) {
                                this.firstAlphaFace = face3D;
                                this.lastAlphaFace = face3D;
                            } else {
                                face3D.nextAlphaFace = this.firstAlphaFace;
                                this.firstAlphaFace = face3D;
                            }
                            break block46;
                        }
                        int n5 = face3D.object.id;
                        compiledFace = this.getCompiledFace(n5, face3D.id);
                        CompiledMesh compiledMesh = this.compiledMeshes[n5];
                        if (compiledFace.lastZbufferImage == this.numImage) break block46;
                        compiledFace.lastZbufferImage = this.numImage;
                        if (compiledFace.lastRenderImage == this.numImage || (d24 = (double)face3D.pa * this.px + (double)face3D.pb * this.py + (double)face3D.pc * this.pz + (double)face3D.pd) < -0.0 || (d23 = (double)face3D.pa * (this.nx - this.px) + (double)face3D.pb * (this.ny - this.py) + (double)face3D.pc * (this.nz - this.pz)) > this.maxFaceViewAngleCos) break block46;
                        double d25 = this.maxYValue;
                        double d26 = this.minYValue;
                        double d27 = this.maxXValue;
                        double d28 = this.minXValue;
                        double d29 = this.zMax;
                        double d30 = this.zMin;
                        this.hLinesBufferMin = 0x7FFFFFFE;
                        this.hLinesBufferMax = -2147483646;
                        Point3D point3D = face3D.center;
                        double d31 = point3D.x;
                        double d32 = point3D.y;
                        double d33 = point3D.z;
                        double d34 = this.ox + this.axx * d31 + this.ayx * d32 + this.azx * d33;
                        double d35 = this.oy + this.axy * d31 + this.ayy * d32 + this.azy * d33;
                        double d36 = this.oz + this.axz * d31 + this.ayz * d32 + this.azz * d33;
                        double d37 = face3D.sphereBox;
                        double d38 = d36 - d37;
                        double d39 = d36 + d37;
                        if (d39 <= this.zMin || d38 >= this.zMax || this.RA * d34 + this.RB * d35 + this.RC * d36 >= d37 || this.LA * d34 + this.LB * d35 + this.LC * d36 >= d37 || this.UA * d34 + this.UB * d35 + this.UC * d36 >= d37 || this.DA * d34 + this.DB * d35 + this.DC * d36 >= d37) break block46;
                        int[] nArray = compiledMesh.cameraPositionEvaluated;
                        double[] dArray = compiledMesh.xs;
                        double[] dArray2 = compiledMesh.ys;
                        double[] dArray3 = compiledMesh.iz;
                        double[] dArray4 = compiledMesh.xp;
                        double[] dArray5 = compiledMesh.yp;
                        double[] dArray6 = compiledMesh.zp;
                        Vertex3D vertex3D = face3D.p0;
                        int n6 = vertex3D.id;
                        if (nArray[n6] != this.numImage) {
                            nArray[n6] = this.numImage;
                            d31 = vertex3D.x;
                            d32 = vertex3D.y;
                            d33 = vertex3D.z;
                            d22 = this.ox + this.axx * d31 + this.ayx * d32 + this.azx * d33;
                            d21 = this.oy + this.axy * d31 + this.ayy * d32 + this.azy * d33;
                            d20 = this.oz + this.axz * d31 + this.ayz * d32 + this.azz * d33;
                            d19 = 1.0 / d20;
                            d18 = d22 * this.screenZoomXFocus * d19 + this.renderPixelWidthDiv2;
                            d17 = d21 * this.screenZoomYFocus * d19 + this.renderPixelHeightDiv2;
                            if (d20 < 0.0) {
                                d18 = -d18;
                                d17 = -d17;
                            }
                            dArray[n6] = d18;
                            dArray2[n6] = d17;
                            dArray3[n6] = d19;
                            dArray6[n6] = d20;
                            dArray4[n6] = d22;
                            dArray5[n6] = d21;
                            dArray6[n6] = d20;
                        } else {
                            d18 = dArray[n6];
                            d17 = dArray2[n6];
                            d19 = dArray3[n6];
                            d22 = dArray4[n6];
                            d21 = dArray5[n6];
                            d20 = dArray6[n6];
                        }
                        vertex3D = face3D.p1;
                        n6 = vertex3D.id;
                        if (nArray[n6] != this.numImage) {
                            nArray[n6] = this.numImage;
                            d31 = vertex3D.x;
                            d32 = vertex3D.y;
                            d33 = vertex3D.z;
                            d16 = this.ox + this.axx * d31 + this.ayx * d32 + this.azx * d33;
                            d15 = this.oy + this.axy * d31 + this.ayy * d32 + this.azy * d33;
                            d14 = this.oz + this.axz * d31 + this.ayz * d32 + this.azz * d33;
                            d13 = 1.0 / d14;
                            d12 = d16 * this.screenZoomXFocus * d13 + this.renderPixelWidthDiv2;
                            d11 = d15 * this.screenZoomYFocus * d13 + this.renderPixelHeightDiv2;
                            if (d14 < 0.0) {
                                d12 = -d12;
                                d11 = -d11;
                            }
                            dArray[n6] = d12;
                            dArray2[n6] = d11;
                            dArray3[n6] = d13;
                            dArray4[n6] = d16;
                            dArray5[n6] = d15;
                            dArray6[n6] = d14;
                        } else {
                            d12 = dArray[n6];
                            d11 = dArray2[n6];
                            d13 = dArray3[n6];
                            d16 = dArray4[n6];
                            d15 = dArray5[n6];
                            d14 = dArray6[n6];
                        }
                        vertex3D = face3D.p2;
                        n6 = vertex3D.id;
                        if (nArray[n6] != this.numImage) {
                            nArray[n6] = this.numImage;
                            d31 = vertex3D.x;
                            d32 = vertex3D.y;
                            d33 = vertex3D.z;
                            d10 = this.ox + this.axx * d31 + this.ayx * d32 + this.azx * d33;
                            d9 = this.oy + this.axy * d31 + this.ayy * d32 + this.azy * d33;
                            d8 = this.oz + this.axz * d31 + this.ayz * d32 + this.azz * d33;
                            d7 = 1.0 / d8;
                            d6 = d10 * this.screenZoomXFocus * d7 + this.renderPixelWidthDiv2;
                            d5 = d9 * this.screenZoomYFocus * d7 + this.renderPixelHeightDiv2;
                            if (d8 < 0.0) {
                                d6 = -d6;
                                d5 = -d5;
                            }
                            dArray[n6] = d6;
                            dArray2[n6] = d5;
                            dArray3[n6] = d7;
                            dArray4[n6] = d10;
                            dArray5[n6] = d9;
                            dArray6[n6] = d8;
                        } else {
                            d6 = dArray[n6];
                            d5 = dArray2[n6];
                            d7 = dArray3[n6];
                            d10 = dArray4[n6];
                            d9 = dArray5[n6];
                            d8 = dArray6[n6];
                        }
                        if (d20 > d30) {
                            d30 = d20;
                        }
                        if (d20 < d29) {
                            d29 = d20;
                        }
                        if (d14 > d30) {
                            d30 = d14;
                        }
                        if (d14 < d29) {
                            d29 = d14;
                        }
                        if (d8 > d30) {
                            d30 = d8;
                        }
                        if (d8 < d29) {
                            d29 = d8;
                        }
                        if (d30 <= this.zMin || d29 >= this.zMax) break block46;
                        if (d17 < d25) {
                            d25 = d17;
                        }
                        if (d17 > d26) {
                            d26 = d17;
                        }
                        if (d11 < d25) {
                            d25 = d11;
                        }
                        if (d11 > d26) {
                            d26 = d11;
                        }
                        if (d5 < d25) {
                            d25 = d5;
                        }
                        if (d5 > d26) {
                            d26 = d5;
                        }
                        if (d26 <= (double)this.minYValue || d25 >= (double)this.maxYValue || d26 <= d25 + 5.0E-4) break block46;
                        if (d18 < d27) {
                            d27 = d18;
                        }
                        if (d18 > d28) {
                            d28 = d18;
                        }
                        if (d12 < d27) {
                            d27 = d12;
                        }
                        if (d12 > d28) {
                            d28 = d12;
                        }
                        if (d6 < d27) {
                            d27 = d6;
                        }
                        if (d6 > d28) {
                            d28 = d6;
                        }
                        if (d28 <= (double)this.minXValue || d27 >= (double)this.maxXValue || d28 <= d27 + 5.0E-4) break block46;
                        if (!(d29 >= this.zMin)) break block47;
                        this.setHLigne(d18, d17, d19, d12, d11, d13);
                        this.setHLigne(d12, d11, d13, d6, d5, d7);
                        this.setHLigne(d6, d5, d7, d18, d17, d19);
                        break block48;
                    }
                    boolean bl = false;
                    Vertex3D vertex3D = face3D.p0;
                    Vertex3D vertex3D2 = face3D.p1;
                    double d40 = d18;
                    double d41 = d17;
                    double d42 = d19;
                    double d43 = d22;
                    double d44 = d21;
                    double d45 = d20;
                    double d46 = d12;
                    double d47 = d11;
                    double d48 = d13;
                    double d49 = d16;
                    double d50 = d15;
                    double d51 = d14;
                    for (int i = 0; i < 3; ++i) {
                        double d52;
                        double d53;
                        double d54;
                        double d55;
                        double d56;
                        double d57;
                        if (d45 >= this.zMin && d51 >= this.zMin) {
                            this.setHLigne(d40, d41, d42, d46, d47, d48);
                        } else if (d45 < this.zMin && d51 >= this.zMin) {
                            d57 = d49 - d43;
                            d56 = d50 - d44;
                            d55 = d51 - d45;
                            d54 = 1.0 / d55;
                            d53 = (this.zMin - d45) * d57 * d54 + d43;
                            d52 = (this.zMin - d45) * d56 * d54 + d44;
                            d = d53 * this.screenZoomXFocus * this.iZMin + this.renderPixelWidthDiv2;
                            d2 = d52 * this.screenZoomYFocus * this.iZMin + this.renderPixelHeightDiv2;
                            this.setHLigne(d, d2, this.iZMin, d46, d47, d48);
                            bl = true;
                        } else if (d51 < this.zMin && d45 >= this.zMin) {
                            d57 = d43 - d49;
                            d56 = d44 - d50;
                            d55 = d45 - d51;
                            d54 = 1.0 / d55;
                            d53 = (this.zMin - d51) * d57 * d54 + d49;
                            d52 = (this.zMin - d51) * d56 * d54 + d50;
                            d3 = d53 * this.screenZoomXFocus * this.iZMin + this.renderPixelWidthDiv2;
                            d4 = d52 * this.screenZoomYFocus * this.iZMin + this.renderPixelHeightDiv2;
                            this.setHLigne(d40, d41, d42, d3, d4, this.iZMin);
                            bl = true;
                        }
                        vertex3D = vertex3D2;
                        d40 = d46;
                        d41 = d47;
                        d42 = d48;
                        d43 = d49;
                        d44 = d50;
                        d45 = d51;
                        if (i == 0) {
                            vertex3D2 = face3D.p2;
                            d46 = d6;
                            d47 = d5;
                            d48 = d7;
                            d49 = d10;
                            d50 = d9;
                            d51 = d8;
                            continue;
                        }
                        vertex3D2 = face3D.p0;
                        d46 = d18;
                        d47 = d17;
                        d48 = d19;
                        d49 = d22;
                        d50 = d21;
                        d51 = d20;
                    }
                    if (!bl) break block46;
                    this.setHLigne(d3, d4, this.iZMin, d, d2, this.iZMin);
                }
                if (this.hLinesBufferMax > this.hLinesBufferMin) {
                    compiledFace.lastRenderOffset = -1;
                    compiledFace.firstRenderOffset = -1;
                    compiledFace.computeScreenSpace(this);
                    if (this.pasteHLine(compiledFace) != 0) {
                        n2 = 1;
                    }
                    if ((this.zBufferMode & 2) != 0 && compiledFace.firstRenderOffset != -1) {
                        this.drawer.setMesh3D(face3D.object);
                        if ((face3D.object.renderMode & 1) != 0) {
                            this.prepareMesh3DLocalLight3DBuffer(face3D.object.getScene3D(), face3D.object);
                        }
                        this.drawer.drawFace3D(this.compiledMeshes[face3D.object.id], this.compiledMeshes[face3D.object.id].compiledFaces[face3D.id], true);
                    }
                }
            }
            ++n4;
        }
        return n2;
    }

    private final void setHLigne(double d, double d2, double d3, double d4, double d5, double d6) {
        int n;
        int n2;
        boolean bl = true;
        if (d2 > d5) {
            bl = false;
            double d7 = d;
            double d8 = d2;
            double d9 = d3;
            d = d4;
            d2 = d5;
            d3 = d6;
            d4 = d7;
            d5 = d8;
            d6 = d9;
        }
        if (d2 > (double)this.maxYValue) {
            return;
        }
        if (d5 < (double)this.minYValue) {
            return;
        }
        if (d5 - d2 == 0.0) {
            return;
        }
        double d10 = 1.0 / (d5 - d2);
        double d11 = (d4 - d) * d10;
        double d12 = d - d11 * d2;
        double d13 = (d6 - d3) * d10;
        double d14 = d3 - d13 * d2;
        if (d2 < (double)this.minYValue) {
            d = d11 * (double)this.minYValue + d12;
            d3 = d13 * (double)this.minYValue + d14;
            d2 = this.minYValue;
        }
        if (d5 > (double)this.maxYValue) {
            d4 = d11 * (double)this.maxYValue + d12;
            d6 = d13 * (double)this.maxYValue + d14;
            d5 = this.maxYValue;
        }
        if ((n2 = (int)d2) == (n = (int)d5)) {
            return;
        }
        if (n > this.hLinesBufferMax) {
            this.hLinesBufferMax = n;
        }
        if (n2 < this.hLinesBufferMin) {
            this.hLinesBufferMin = n2;
        }
        if (bl) {
            this.vLinesBufferMin[n2] = n;
            this.vLinesBufferMinX[n2] = d;
            this.vLinesBufferMinIncX[n2] = d11;
            this.vLinesBufferMinIz[n2] = d3;
            this.vLinesBufferMinIncIz[n2] = d13;
        } else {
            this.vLinesBufferMax[n2] = n;
            this.vLinesBufferMaxX[n2] = d;
            this.vLinesBufferMaxIncX[n2] = d11;
            this.vLinesBufferMaxIz[n2] = d3;
            this.vLinesBufferMaxIncIz[n2] = d13;
        }
    }

    private double getFaceIzAt(int n, int n2, double d, double d2) {
        if (n == -1) {
            return this.iZMax;
        }
        if (n == -2) {
            return this.iZTest;
        }
        double d3 = d - this.renderPixelWidthDiv2;
        double d4 = d2 - this.renderPixelHeightDiv2;
        CompiledFace compiledFace = this.compiledMeshes[n].compiledFaces[n2];
        double d5 = compiledFace.iZA;
        double d6 = compiledFace.iZB;
        double d7 = compiledFace.iZC;
        double d8 = (d3 *= this.iZoomX) * d5 + (d4 *= this.iZoomY) * d6 + d7;
        if (n2 == 4) {
            // empty if block
        }
        return d8;
    }

    private double getFaceIzX(int n, int n2, int n3, int n4, double d) {
        double d2 = d - this.renderPixelHeightDiv2;
        d2 *= this.iZoomY;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.iZTest;
        if (n != -2) {
            CompiledFace compiledFace = this.compiledMeshes[n].compiledFaces[n2];
            d3 = compiledFace.iZA;
            d4 = compiledFace.iZB;
            d5 = compiledFace.iZC;
        }
        double d6 = d4 * d2 + d5;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = this.iZMax;
        if (n3 != -1) {
            CompiledFace compiledFace = this.compiledMeshes[n3].compiledFaces[n4];
            d7 = compiledFace.iZA;
            d8 = compiledFace.iZB;
            d9 = compiledFace.iZC;
        }
        double d10 = d8 * d2 + d9;
        double d11 = (d10 - d6) / (d3 - d7);
        return d11 / this.iZoomX + this.renderPixelWidthDiv2;
    }

    private final int pasteHLine(CompiledFace compiledFace) {
        int n = -2;
        int n2 = -2;
        if (compiledFace != null) {
            n = this.cMesh3D.id;
            n2 = compiledFace.face.id;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.hLinesBufferMin * this.renderPixelWidth;
        int n6 = this.vLinesBufferMin[this.hLinesBufferMin];
        double d3 = this.vLinesBufferMinX[this.hLinesBufferMin];
        double d4 = this.vLinesBufferMinIncX[this.hLinesBufferMin];
        double d5 = this.vLinesBufferMinIz[this.hLinesBufferMin];
        double d6 = this.vLinesBufferMinIncIz[this.hLinesBufferMin];
        int n7 = this.vLinesBufferMax[this.hLinesBufferMin];
        double d7 = this.vLinesBufferMaxX[this.hLinesBufferMin];
        double d8 = this.vLinesBufferMaxIncX[this.hLinesBufferMin];
        double d9 = this.vLinesBufferMaxIz[this.hLinesBufferMin];
        double d10 = this.vLinesBufferMaxIncIz[this.hLinesBufferMin];
        double d11 = d3;
        double d12 = d7;
        double d13 = d5;
        double d14 = d9;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.hLinesBufferMin;
        while (n10 < this.hLinesBufferMax) {
            block42: {
                if (n10 != this.hLinesBufferMin) {
                    n5 += this.renderPixelWidth;
                    d11 = d3 + d4 * (double)n8;
                    d12 = d7 + d8 * (double)n9;
                    d13 = d5 + d6 * (double)n8;
                    d14 = d9 + d10 * (double)n9;
                    if (n10 == n6) {
                        n6 = this.vLinesBufferMin[n10];
                        d3 = this.vLinesBufferMinX[n10];
                        d4 = this.vLinesBufferMinIncX[n10];
                        d5 = this.vLinesBufferMinIz[n10];
                        d6 = this.vLinesBufferMinIncIz[n10];
                        n8 = 0;
                        d11 = d3;
                        d13 = d5;
                    }
                    if (n10 == n7) {
                        n7 = this.vLinesBufferMax[n10];
                        d7 = this.vLinesBufferMaxX[n10];
                        d8 = this.vLinesBufferMaxIncX[n10];
                        d9 = this.vLinesBufferMaxIz[n10];
                        d10 = this.vLinesBufferMaxIncIz[n10];
                        n9 = 0;
                        d12 = d7;
                        d14 = d9;
                    }
                }
                double d15 = d11;
                double d16 = d12;
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = d16 - d15;
                if (d15 >= (double)this.maxXValue) {
                    if (d4 >= 0.0) {
                        return 0;
                    }
                } else {
                    if (d15 < (double)this.minXValue) {
                        d17 = (double)this.minXValue - d15;
                        d15 = this.minXValue;
                    }
                    if (d16 <= (double)this.minXValue) {
                        if (d8 <= 0.0) {
                            return 0;
                        }
                    } else {
                        int n11;
                        int n12;
                        if (d16 > (double)this.maxXValue) {
                            d18 = d16 - (double)this.maxXValue;
                            d16 = this.maxXValue;
                        }
                        if ((n12 = (int)d16) > (n11 = (int)d15)) {
                            int n13;
                            double d20;
                            double d21;
                            double d22 = d13;
                            double d23 = d14;
                            double d24 = (d23 - d22) / d19;
                            d22 += d24 * d17;
                            d23 -= d24 * d18;
                            if (d24 >= 0.0) {
                                d21 = d22;
                                d20 = d23;
                            } else {
                                d21 = d23;
                                d20 = d22;
                            }
                            boolean bl = false;
                            int n14 = 0;
                            int n15 = this.zBuffer[n5] & 0xFFFF;
                            while (n11 >= n15) {
                                n14 = n15;
                                n15 = this.zBuffer[n5 + n15] & 0xFFFF;
                            }
                            int n16 = n14;
                            while (n12 > (n13 = n16) && n13 < this.renderPixelWidth) {
                                double d25;
                                double d26;
                                double d27;
                                boolean bl2;
                                int n17 = n5 + n13;
                                n16 = this.zBuffer[n17] & 0xFFFF;
                                int n18 = this.zBufferO[n17];
                                int n19 = this.zBufferP[n17];
                                double d28 = this.zBufferIzMin[n17];
                                double d29 = this.zBufferIzInc[n17];
                                double d30 = d28 + d29 * (double)(n16 - n13);
                                double d31 = d28;
                                double d32 = d30;
                                if (d29 >= 0.0) {
                                    d31 = d28;
                                    d32 = d30;
                                } else {
                                    d31 = d30;
                                    d32 = d28;
                                }
                                boolean bl3 = d21 > d32;
                                boolean bl4 = bl2 = d20 < d31;
                                if (!bl) {
                                    d27 = Math.min((double)n16, d16);
                                    d26 = Math.max((double)n13, d15);
                                    if (this.getFaceIzAt(n, n2, d26 + 0.5, n10) >= this.getFaceIzAt(n18, n19, d26 + 0.5, n10)) {
                                        d = d26;
                                        bl = true;
                                    } else if (this.getFaceIzAt(n, n2, d27, n10) > this.getFaceIzAt(n18, n19, d27, n10) && (d25 = this.getFaceIzX(n, n2, n18, n19, n10)) >= d26 && d25 < d27) {
                                        d = d25;
                                        bl = true;
                                    }
                                    if (!bl) continue;
                                    if ((this.zBufferMode & 4) != 0) {
                                        return 1;
                                    }
                                    n3 = (int)d;
                                    n4 = n13;
                                }
                                d27 = Math.min((double)n16, d16);
                                d26 = Math.max((double)n13, d);
                                if (this.getFaceIzAt(n, n2, d26 + 0.5, n10) < this.getFaceIzAt(n18, n19, d26 + 0.5, n10)) {
                                    d2 = d26;
                                    bl = false;
                                } else if (this.getFaceIzAt(n, n2, d27, n10) < this.getFaceIzAt(n18, n19, d27, n10)) {
                                    d25 = this.getFaceIzX(n, n2, n18, n19, n10);
                                    if (d25 >= d26) {
                                        if (d25 <= d27) {
                                            d2 = d25;
                                            bl = false;
                                        } else {
                                            d2 = d27;
                                            bl = false;
                                        }
                                    } else {
                                        d2 = d26;
                                        bl = false;
                                    }
                                }
                                if (bl && n12 <= n16) {
                                    d2 = d16;
                                    bl = false;
                                }
                                if (bl || d != d2) {
                                    int n20;
                                    int n21;
                                    if (bl) continue;
                                    int n22 = (int)(d * 65536.0) >> 8 & 0xFF;
                                    int n23 = (int)(d2 * 65536.0) >> 8 & 0xFF;
                                    int n24 = (int)d2;
                                    if (n24 == n3) {
                                        bl = false;
                                        continue;
                                    }
                                    if ((this.zBufferMode & 1) != 0 || (this.zBufferMode & 2) != 0) {
                                        if (n3 != n4) {
                                            n21 = this.zBuffer[n5 + n4] >> 16 & 0xFF;
                                            this.zBuffer[n5 + n4] = n3 | n21 << 16;
                                        }
                                        n21 = n5 + n13;
                                        int n25 = this.zBufferO[n21];
                                        n20 = this.zBufferP[n21];
                                        int n26 = n5 + n3;
                                        this.zBufferO[n26] = this.cMesh3D.id;
                                        this.zBufferP[n26] = compiledFace.face.id;
                                        this.zBuffer[n26] = n24 | n22 << 16;
                                        this.zBufferIzMin[n26] = (float)(d22 + d24 * (double)(n3 - n11));
                                        this.zBufferIzInc[n26] = (float)d24;
                                        if (n24 != n16) {
                                            int n27 = n5 + n24;
                                            this.zBuffer[n27] = n16 | n23 << 16;
                                            this.zBufferO[n27] = n25;
                                            this.zBufferP[n27] = n20;
                                            this.zBufferIzMin[n27] = (float)(d28 + d29 * (double)(n24 - n13));
                                            this.zBufferIzInc[n27] = (float)d29;
                                        }
                                    }
                                    if ((this.zBufferMode & 2) != 0 && n24 != n3) {
                                        if (compiledFace.lastRenderImage != this.numImage) {
                                            compiledFace.lastRenderImage = this.numImage;
                                            compiledFace.lastRenderOffset = compiledFace.firstRenderOffset = n3 | n10 << 16 & 0xFFFF0000;
                                        } else {
                                            n21 = compiledFace.lastRenderOffset;
                                            int n28 = n21 >> 16 & 0xFFFF;
                                            n20 = (n21 &= 0xFFFF) + n28 * this.renderPixelWidth;
                                            this.zBufferF[n20] = n3 | n10 << 16 & 0xFFFF0000;
                                            compiledFace.lastRenderOffset = n3 | n10 << 16 & 0xFFFF0000;
                                        }
                                    }
                                    n16 = n24;
                                    continue;
                                }
                                break block42;
                            }
                            if (bl) {
                                Log.log("erreur");
                            }
                        }
                    }
                }
            }
            ++n10;
            ++n8;
            ++n9;
        }
        return 0;
    }

    private final void prepareFaceBuffer(IScene3D iScene3D) {
        int n;
        int n2;
        int n3;
        CompiledMesh compiledMesh = null;
        CompiledFace compiledFace = null;
        this.firstRenderBackgroundOffset = -1;
        this.firstMeshToRender = null;
        this.nbRenderedFace = 0;
        this.nbRenderedMesh = 0;
        int n4 = -1;
        int n5 = -1;
        for (n3 = 0; n3 < this.renderPixelHeight; ++n3) {
            n2 = 0;
            n = n3 * this.renderPixelWidth;
            while (n2 != this.renderPixelWidth) {
                int n6;
                int n7;
                int n8;
                int n9 = n + n2;
                int n10 = this.zBuffer[n9] & 0xFFFF;
                int n11 = this.zBufferO[n9];
                if (n11 != -1) {
                    if (n11 != n4) {
                        compiledMesh = this.compiledMeshes[n11];
                        n4 = n11;
                        n5 = -1;
                    }
                    if (compiledMesh.lastRenderImage != this.numImage) {
                        compiledMesh.lastRenderImage = this.numImage;
                        compiledMesh.nbRenderFace = 0;
                        compiledMesh.firstFaceToRender = null;
                        compiledMesh.nextMeshToRender = this.firstMeshToRender;
                        this.firstMeshToRender = compiledMesh;
                        ++this.nbRenderedMesh;
                    }
                    if ((n8 = this.zBufferP[n9]) != n5) {
                        compiledFace = compiledMesh.compiledFaces[n8];
                        n5 = n8;
                    }
                    if (compiledFace.lastRenderImage != this.numImage) {
                        compiledFace.lastRenderImage = this.numImage;
                        compiledFace.nextFaceToRender = compiledMesh.firstFaceToRender;
                        compiledMesh.firstFaceToRender = compiledFace;
                        ++compiledMesh.nbRenderFace;
                        compiledFace.lastRenderOffset = compiledFace.firstRenderOffset = n2 | n3 << 16 & 0xFFFF0000;
                        ++this.nbRenderedFace;
                    } else {
                        n7 = compiledFace.lastRenderOffset;
                        n6 = n7 >> 16 & 0xFFFF;
                        int n12 = (n7 &= 0xFFFF) + n6 * this.renderPixelWidth;
                        this.zBufferF[n12] = n2 | n3 << 16 & 0xFFFF0000;
                        compiledFace.lastRenderOffset = n2 | n3 << 16 & 0xFFFF0000;
                    }
                } else if (this.firstRenderBackgroundOffset == -1) {
                    this.lastRenderBackgroundOffset = this.firstRenderBackgroundOffset = n2 | n3 << 16 & 0xFFFF0000;
                } else {
                    n8 = this.lastRenderBackgroundOffset;
                    n7 = n8 >> 16 & 0xFFFF;
                    n6 = (n8 &= 0xFFFF) + n7 * this.renderPixelWidth;
                    this.zBufferF[n6] = n2 | n3 << 16 & 0xFFFF0000;
                    this.lastRenderBackgroundOffset = n2 | n3 << 16 & 0xFFFF0000;
                }
                n2 = n10;
            }
        }
        n3 = this.lastRenderBackgroundOffset;
        n2 = n3 >> 16 & 0xFFFF;
        n = (n3 &= 0xFFFF) + n2 * this.renderPixelWidth;
        this.zBufferF[n] = this.renderPixelWidth - 1 | this.renderPixelHeight - 1 << 16 & 0xFFFF0000;
        this.lastRenderBackgroundOffset = this.renderPixelWidth - 1 | this.renderPixelHeight - 1 << 16 & 0xFFFF0000;
    }

    private final CompiledMesh getFirstMeshToRender() {
        return this.firstMeshToRender;
    }

    private final CompiledMesh getNextMeshToRender(CompiledMesh compiledMesh) {
        return compiledMesh.nextMeshToRender;
    }

    private final void drawMesh3D(IScene3D iScene3D) {
        Serializable serializable;
        CompiledMesh compiledMesh = this.getFirstMeshToRender();
        this.zBufferMode = 1;
        while (compiledMesh != null) {
            serializable = compiledMesh.mesh;
            if ((serializable.renderMode & 1) != 0) {
                this.prepareMesh3DLocalLight3DBuffer(iScene3D, (Mesh3D)serializable);
            }
            this.drawer.setMesh3D((Mesh3D)serializable);
            CompiledFace compiledFace = compiledMesh.firstFaceToRender;
            while (compiledFace != null) {
                this.drawer.drawFace3D(compiledMesh, compiledFace, false);
                compiledFace = compiledFace.nextFaceToRender;
            }
            compiledMesh = this.getNextMeshToRender(compiledMesh);
        }
        this.zBufferMode = 2;
        serializable = this.firstAlphaFace;
        while (serializable != null) {
            this.setCurrentMesh3D(((Face3D)serializable).object);
            this.setFaces3DToZBuffer(((Face3D)serializable).object.faces3D, ((Face3D)serializable).id);
            serializable = ((Face3D)serializable).nextAlphaFace;
        }
    }

    public final String getImplementationName() {
        return "SOFT";
    }

    public final int getRenderedMesh3DIdAt(int n, int n2) {
        if ((this.antialias & 2) != 0) {
            n *= 2;
        }
        if ((this.antialias & 4) != 0) {
            n2 *= 2;
        }
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                n3 = this.zBufferO[n7];
                break;
            }
            n4 = n10;
        }
        return n3;
    }

    public final int getRenderedFace3DIdAt(int n, int n2) {
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                n3 = this.zBufferP[n7];
                break;
            }
            n4 = n10;
        }
        return n3;
    }

    public final double getZAt(int n, int n2) {
        double d = 0.0;
        n2 = this.renderPixelHeight - n2 - 1;
        int n3 = -1;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.renderPixelWidth) {
            n = this.renderPixelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.renderPixelHeight) {
            n2 = this.renderPixelHeight - 1;
        }
        int n4 = 0;
        int n5 = n2 * this.renderPixelWidth;
        int n6 = n5 + n;
        while (n4 != this.renderPixelWidth) {
            int n7;
            int n8 = n7 = n5 + n4;
            int n9 = this.zBuffer[n8] & 0xFFFF;
            this.zBuffer[n8] = n9;
            int n10 = n9;
            int n11 = n5 + n10;
            if (n6 >= n7 && n6 < n11) {
                int n12 = this.zBufferO[n7];
                int n13 = this.zBufferP[n7];
                if (n12 == -1) {
                    d = this.zMax;
                    break;
                }
                double d2 = this.zBufferIzMin[n7];
                double d3 = this.zBufferIzInc[n7];
                double d4 = d2 + d3 * (double)(n - n4);
                d = 1.0 / d4;
                break;
            }
            n4 = n10;
        }
        return d;
    }

    class CompiledMaterial {
        private static final int MAT_SIZE = 1024;
        Material material;
        int[] specularLightMap;

        CompiledMaterial(Material material) {
            this.material = material;
            this.specularLightMap = new int[1024];
            this.initSpecularLightMap();
        }

        public void initSpecularLightMap() {
            for (int i = 0; i < 1024; ++i) {
                int n = Math.min(i - 512, 256);
                double d = 1.0 * (double)n / 256.0;
                if (d < 0.0) {
                    d = 0.0;
                }
                if (d > 1.0) {
                    d = 1.0;
                }
                int n2 = (int)(d * 255.0);
                if ((n2 += this.material.selfIlluminationLevel * 255 / 100) > 255) {
                    n2 = 255;
                }
                if (this.material.specularLevel != 0) {
                    double d2 = (this.material.specularColor & 0xFF0000) >> 16;
                    double d3 = (this.material.specularColor & 0xFF00) >> 8;
                    double d4 = this.material.specularColor & 0xFF;
                    int n3 = (int)(Math.pow(d, this.material.specularPower) * (double)this.material.specularLevel);
                    int n4 = (int)(d2 *= (double)n3 / 256.0);
                    int n5 = (int)(d3 *= (double)n3 / 256.0);
                    int n6 = (int)(d4 *= (double)n3 / 256.0);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    this.specularLightMap[i] = n2 << 24 | (n4 << 16 | n5 << 8 | n6) & 0xFEFEFE;
                    continue;
                }
                this.specularLightMap[i] = n2 << 24;
            }
        }
    }

    class CompiledMesh {
        Mesh3D mesh;
        CompiledMesh nextMeshToRender;
        int lastRenderImage;
        int nbRenderFace;
        int[] cameraPositionEvaluated;
        double[] xs;
        double[] ys;
        double[] iz;
        double[] xp;
        double[] yp;
        double[] zp;
        CompiledFace[] compiledFaces;
        CompiledFace firstFaceToRender;
        CompiledMesh3DOctree[] compiledMesh3DOctrees;

        CompiledMesh(Mesh3D mesh3D) {
            int n;
            this.mesh = mesh3D;
            this.nextMeshToRender = null;
            this.nbRenderFace = 0;
            this.lastRenderImage = -1;
            int n2 = mesh3D.getNbVertex3D();
            this.compiledFaces = new CompiledFace[mesh3D.getNbFace3D()];
            this.cameraPositionEvaluated = new int[n2];
            this.xs = new double[n2];
            this.ys = new double[n2];
            this.iz = new double[n2];
            this.xp = new double[n2];
            this.yp = new double[n2];
            this.zp = new double[n2];
            this.compiledMesh3DOctrees = null;
            for (n = 0; n < mesh3D.getNbFace3D(); ++n) {
                this.compiledFaces[n] = new CompiledFace((Face3D)mesh3D.getFace3D(n));
            }
            if (mesh3D.getMesh3DOctree() != null) {
                n = 1 + mesh3D.octree.getNbChildren(true);
                this.compiledMesh3DOctrees = new CompiledMesh3DOctree[n];
                IMesh3DOctree[] iMesh3DOctreeArray = mesh3D.octree.getMesh3DOctreeArray(new Mesh3DOctree[n]);
                for (int i = 0; i < n; ++i) {
                    this.compiledMesh3DOctrees[i] = new CompiledMesh3DOctree((Mesh3DOctree)iMesh3DOctreeArray[i]);
                }
            }
        }
    }

    class CompiledMesh3DOctree {
        int lastVisibleImage;
        Mesh3DOctree tree;

        CompiledMesh3DOctree(Mesh3DOctree mesh3DOctree) {
            this.tree = mesh3DOctree;
            this.lastVisibleImage = -1;
        }
    }

    class CompiledFace {
        Face3D face;
        CompiledFace nextFaceToRender;
        CompiledMaterial compiledMaterial;
        int lastRenderImage;
        int firstRenderOffset;
        int lastRenderOffset;
        int lastZbufferImage;
        float p0tx;
        float p0ty;
        float p0tz;
        float p1tx;
        float p1ty;
        float p1tz;
        float p2tx;
        float p2ty;
        float p2tz;
        float p0bx;
        float p0by;
        float p0bz;
        float p1bx;
        float p1by;
        float p1bz;
        float p2bx;
        float p2by;
        float p2bz;
        double iZA;
        double iZB;
        double iZC;

        CompiledFace(Face3D face3D) {
            this.face = face3D;
            this.nextFaceToRender = null;
            this.lastRenderImage = -1;
            this.firstRenderOffset = -1;
            this.lastRenderOffset = -1;
            this.lastZbufferImage = -1;
            this.computeTBN();
            this.compiledMaterial = face3D.material != null ? Render3DSW.this.compiledMaterials[face3D.material.id] : Render3DSW.this.compiledMaterials[0];
        }

        public void computeScreenSpace(Render3D render3D) {
            double d = this.face.p0.x;
            double d2 = this.face.p0.y;
            double d3 = this.face.p0.z;
            double d4 = (double)this.face.pa + d;
            double d5 = (double)this.face.pb + d2;
            double d6 = (double)this.face.pc + d3;
            double d7 = Render3DSW.this.ox + render3D.axx * d + render3D.ayx * d2 + render3D.azx * d3;
            double d8 = Render3DSW.this.oy + render3D.axy * d + render3D.ayy * d2 + render3D.azy * d3;
            double d9 = Render3DSW.this.oz + render3D.axz * d + render3D.ayz * d2 + render3D.azz * d3;
            double d10 = Render3DSW.this.ox + render3D.axx * d4 + render3D.ayx * d5 + render3D.azx * d6;
            double d11 = Render3DSW.this.oy + render3D.axy * d4 + render3D.ayy * d5 + render3D.azy * d6;
            double d12 = Render3DSW.this.oz + render3D.axz * d4 + render3D.ayz * d5 + render3D.azz * d6;
            double d13 = d10 - d7;
            double d14 = d11 - d8;
            double d15 = d12 - d9;
            double d16 = -(d13 * d7 + d14 * d8 + d15 * d9);
            double d17 = 1.0 / d16;
            double d18 = d17 * Render3DSW.this.iFocus;
            this.iZA = -d13 * d18;
            this.iZB = -d14 * d18;
            this.iZC = -d15 * d17;
        }

        void computeTBN() {
            double d = this.face.u1 - this.face.u0;
            double d2 = this.face.v1 - this.face.v0;
            double d3 = this.face.u2 - this.face.u0;
            double d4 = this.face.v2 - this.face.v0;
            Point3D point3D = new Point3D();
            point3D.copy(this.face.p1);
            point3D.sub(this.face.p0);
            point3D.mul(-d4);
            Point3D point3D2 = new Point3D();
            point3D2.copy(this.face.p2);
            point3D2.sub(this.face.p0);
            point3D2.mul(-d2);
            point3D.sub(point3D2);
            point3D.normalize();
            this.p0tx = (float)point3D.x;
            this.p0ty = (float)point3D.y;
            this.p0tz = (float)point3D.z;
            this.p1tx = (float)point3D.x;
            this.p1ty = (float)point3D.y;
            this.p1tz = (float)point3D.z;
            this.p2tx = (float)point3D.x;
            this.p2ty = (float)point3D.y;
            this.p2tz = (float)point3D.z;
            Point3D point3D3 = new Point3D();
            point3D3.copy(this.face.p1);
            point3D3.sub(this.face.p0);
            point3D3.mul(d3);
            Point3D point3D4 = new Point3D();
            point3D4.copy(this.face.p2);
            point3D4.sub(this.face.p0);
            point3D4.mul(d);
            point3D3.sub(point3D4);
            point3D3.normalize();
            this.p0bx = (float)point3D3.x;
            this.p0by = (float)point3D3.y;
            this.p0bz = (float)point3D3.z;
            this.p1bx = (float)point3D3.x;
            this.p1by = (float)point3D3.y;
            this.p1bz = (float)point3D3.z;
            this.p2bx = (float)point3D3.x;
            this.p2by = (float)point3D3.y;
            this.p2bz = (float)point3D3.z;
        }
    }
}

