/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.extension.jogl;

import com.sun.opengl.impl.NativeLibLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.dzzd.access.IProgressListener;
import net.dzzd.extension.loader.IExtension;
import net.dzzd.extension.loader.IExtensionLoader;

public class JOGLLoader
implements IExtension {
    private static final NativeLibInfo[] allNativeLibInfo = new NativeLibInfo[]{new NativeLibInfo("win", "x86", "windows-i586", "", ".dll"), new NativeLibInfo("win", "amd64", "windows-amd64", "", ".dll"), new NativeLibInfo("win", "x86_64", "windows-amd64", "", ".dll"), new NativeLibInfo("mac", "ppc", "macosx-ppc", "lib", ".jnilib"), new NativeLibInfo("mac", "i386", "macosx-universal", "lib", ".jnilib"), new NativeLibInfo("linux", "i386", "linux-i586", "lib", ".so"), new NativeLibInfo("linux", "x86", "linux-i586", "lib", ".so"), new NativeLibInfo("linux", "amd64", "linux-amd64", "lib", ".so"), new NativeLibInfo("linux", "x86_64", "linux-amd64", "lib", ".so"), new NativeLibInfo("sunos", "sparc", "solaris-sparc", "lib", ".so"), new NativeLibInfo("sunos", "sparcv9", "solaris-sparcv9", "lib", ".so"), new NativeLibInfo("sunos", "x86", "solaris-i586", "lib", ".so"), new NativeLibInfo("sunos", "amd64", "solaris-amd64", "lib", ".so"), new NativeLibInfo("sunos", "x86_64", "solaris-amd64", "lib", ".so")};
    private NativeLibInfo nativeLibInfo;
    private String[] nativeLibNames;
    private boolean joglLoaded = false;
    private boolean haveJOAL = false;

    public void load(String string, String string2, IProgressListener iProgressListener, IExtensionLoader iExtensionLoader) throws Exception {
        String[] stringArray;
        iProgressListener.setProgress(0);
        iProgressListener.setFinished(false);
        iProgressListener.setError(false);
        URL uRL = null;
        String string3 = null;
        try {
            uRL = new URL(string);
            string3 = System.getProperty("user.home") + File.separator + string2;
        }
        catch (Exception exception) {
            iProgressListener.setProgress(100);
            iProgressListener.setFinished(true);
            iProgressListener.setError(true);
            throw new Exception("JOGLLoader: Invalid parameter: " + exception.toString());
        }
        iExtensionLoader.loadJar(string2, string, "jogl.jar", iProgressListener);
        iExtensionLoader.loadJar(string2, string, "gluegen-rt.jar", iProgressListener);
        String string4 = System.getProperty("os.name");
        String string5 = System.getProperty("os.arch");
        if (!this.checkOSAndArch(string4, string5)) {
            iProgressListener.setProgress(100);
            iProgressListener.setFinished(true);
            iProgressListener.setError(true);
            throw new Exception("Init JOGL failed : Unsupported os / arch ( " + string4 + " / " + string5 + " )");
        }
        File file = new File(string3);
        if (!file.exists() && !file.mkdirs()) {
            iProgressListener.setProgress(100);
            iProgressListener.setFinished(true);
            iProgressListener.setError(true);
            throw new Exception("Cannot create install directory: " + string3);
        }
        try {
            stringArray = Class.forName("net.java.games.joal.AL", false, this.getClass().getClassLoader());
            this.haveJOAL = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = new String[]{this.nativeLibInfo.formatNativeJarName("jogl-natives-{0}.jar"), this.nativeLibInfo.formatNativeJarName("gluegen-rt-natives-{0}.jar"), this.haveJOAL ? this.nativeLibInfo.formatNativeJarName("joal-natives-{0}.jar") : null};
        for (int i = 0; i < stringArray.length; ++i) {
            String string6 = stringArray[i];
            if (string6 == null) continue;
            String string7 = uRL.toExternalForm() + string6;
            URL uRL2 = new URL(string7);
            URLConnection uRLConnection = uRL2.openConnection();
            File file2 = new File(file, string6);
            this.saveNativesJarLocally(file2, uRLConnection);
            JarFile jarFile = new JarFile(file2);
            if (!this.findNativeEntries(jarFile)) {
                iProgressListener.setProgress(100);
                iProgressListener.setFinished(true);
                iProgressListener.setError(true);
                throw new Exception("Native libraries not found in jar file");
            }
            byte[] byArray = new byte[8192];
            for (int j = 0; j < this.nativeLibNames.length; ++j) {
                if (this.installFile(file, jarFile, this.nativeLibNames[j], byArray)) continue;
                iProgressListener.setProgress(100);
                iProgressListener.setFinished(true);
                iProgressListener.setError(true);
                throw new Exception("Cannot install file " + jarFile.toString() + " in: " + file);
            }
            jarFile.close();
            file2.delete();
        }
        this.loadNatives(file);
        this.joglLoaded = true;
        iProgressListener.setProgress(100);
        iProgressListener.setFinished(true);
        iProgressListener.setError(false);
    }

    private boolean checkOSAndArch(String string, String string2) {
        for (int i = 0; i < allNativeLibInfo.length; ++i) {
            NativeLibInfo nativeLibInfo = allNativeLibInfo[i];
            if (!nativeLibInfo.matchesOSAndArch(string, string2)) continue;
            this.nativeLibInfo = nativeLibInfo;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNativesJarLocally(File file, URLConnection uRLConnection) throws Exception {
        IOException iOException3;
        InputStream inputStream;
        block12: {
            BufferedOutputStream bufferedOutputStream = null;
            inputStream = null;
            try {
                int n;
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n2 = uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[1024];
                int n3 = 0;
                while ((n = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                    int n4 = 100 * (n3 += n) / n2;
                }
                bufferedOutputStream.close();
                inputStream.close();
                Object var11_10 = null;
                if (bufferedOutputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var11_11 = null;
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                bufferedOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {}
        }
    }

    private boolean findNativeEntries(JarFile jarFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!this.nativeLibInfo.matchesNativeLib(jarEntry.getName())) continue;
            arrayList.add(jarEntry.getName());
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        this.nativeLibNames = arrayList.toArray(new String[0]);
        return true;
    }

    private boolean installFile(File file, JarFile jarFile, String string, byte[] byArray) {
        try {
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) {
                return false;
            }
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n = (int)jarEntry.getSize();
            BufferedOutputStream bufferedOutputStream = null;
            File file2 = new File(file, string);
            boolean bl = false;
            try {
                bl = file2.exists();
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            }
            catch (Exception exception) {
                return bl;
            }
            try {
                int n2;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file2.delete();
                return false;
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            inputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void loadNatives(File file) {
        block16: {
            NativeLibLoader.disableLoading();
            com.sun.gluegen.runtime.NativeLibLoader.disableLoading();
            this.loadLibrary(file, "gluegen-rt");
            Class<?> clazz = null;
            if (this.nativeLibInfo.mayNeedDRIHack()) {
                try {
                    clazz = Class.forName("com.sun.opengl.impl.x11.DRIHack");
                    clazz.getMethod("begin", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.loadLibrary(file, "jogl");
            if (this.nativeLibInfo.mayNeedDRIHack()) {
                try {
                    clazz.getMethod("end", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!this.nativeLibInfo.isMacOS()) {
                try {
                    System.loadLibrary("jawt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (unsatisfiedLinkError.getMessage().indexOf("already loaded") != -1) break block16;
                    throw unsatisfiedLinkError;
                }
            }
        }
        this.loadLibrary(file, "jogl_awt");
        if (this.haveJOAL) {
            Object object;
            try {
                object = Class.forName("net.java.games.joal.impl.NativeLibLoader");
                ((Class)object).getMethod("disableLoading", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = System.getProperty("java.library.path");
            String string = file.getAbsolutePath();
            boolean bl = false;
            if (object == null) {
                object = string;
                bl = true;
            } else if (((String)object).indexOf(string) < 0) {
                object = (String)object + File.pathSeparator + string;
                bl = true;
            }
            if (bl) {
                System.setProperty("java.library.path", (String)object);
            }
            this.loadLibrary(file, "joal_native");
        }
    }

    private void loadLibrary(File file, String string) {
        String string2 = this.nativeLibInfo.getNativeLibName(string);
        try {
            System.load(new File(file, string2).getPath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            throw unsatisfiedLinkError;
        }
    }

    private static class NativeLibInfo {
        private String osName;
        private String osArch;
        private String osNameAndArchPair;
        private String nativePrefix;
        private String nativeSuffix;

        public NativeLibInfo(String string, String string2, String string3, String string4, String string5) {
            this.osName = string;
            this.osArch = string2;
            this.osNameAndArchPair = string3;
            this.nativePrefix = string4;
            this.nativeSuffix = string5;
        }

        public boolean matchesOSAndArch(String string, String string2) {
            return string.toLowerCase().startsWith(this.osName) && (this.osArch == null || string2.toLowerCase().equals(this.osArch));
        }

        public boolean matchesNativeLib(String string) {
            return string.toLowerCase().endsWith(this.nativeSuffix);
        }

        public String formatNativeJarName(String string) {
            return MessageFormat.format(string, this.osNameAndArchPair);
        }

        public String getNativeLibName(String string) {
            return this.nativePrefix + string + this.nativeSuffix;
        }

        public boolean isMacOS() {
            return this.osName.equals("mac");
        }

        public boolean mayNeedDRIHack() {
            return !this.isMacOS() && !this.osName.equals("win");
        }
    }
}

